/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_X86_CPU_DEVICE_ID
#define _ASM_X86_CPU_DEVICE_ID


#define VFM_MODEL_BIT	0
#define VFM_FAMILY_BIT	8
#define VFM_VENDOR_BIT	16
#define VFM_RSVD_BIT	24

#define	VFM_MODEL_MASK	GENMASK(VFM_FAMILY_BIT - 1, VFM_MODEL_BIT)
#define	VFM_FAMILY_MASK	GENMASK(VFM_VENDOR_BIT - 1, VFM_FAMILY_BIT)
#define	VFM_VENDOR_MASK	GENMASK(VFM_RSVD_BIT - 1, VFM_VENDOR_BIT)

#define VFM_MODEL(vfm)	(((vfm) & VFM_MODEL_MASK) >> VFM_MODEL_BIT)
#define VFM_FAMILY(vfm)	(((vfm) & VFM_FAMILY_MASK) >> VFM_FAMILY_BIT)
#define VFM_VENDOR(vfm)	(((vfm) & VFM_VENDOR_MASK) >> VFM_VENDOR_BIT)

#define	VFM_MAKE(_vendor, _family, _model) (	\
	((_model) << VFM_MODEL_BIT) |		\
	((_family) << VFM_FAMILY_BIT) |		\
	((_vendor) << VFM_VENDOR_BIT)		\
)


#include <linux/mod_devicetable.h>

#include <asm/intel-family.h>

#include <asm/processor.h>


#define X86_CENTAUR_FAM6_C7_A		0xa
#define X86_CENTAUR_FAM6_C7_D		0xd
#define X86_CENTAUR_FAM6_NANO		0xf


#define X86_CPU_ID_FLAG_ENTRY_VALID	BIT(0)

#define X86_STEPPINGS(mins, maxs)    GENMASK(maxs, mins)

#define X86_MATCH_VENDOR_FAM_MODEL_STEPPINGS_FEATURE(_vendor, _family, _model, \
						    _steppings, _feature, _data) { \
	.vendor		= X86_VENDOR_##_vendor,				\
	.family		= _family,					\
	.model		= _model,					\
	.steppings	= _steppings,					\
	.feature	= _feature,					\
	.flags		= X86_CPU_ID_FLAG_ENTRY_VALID,			\
	.driver_data	= (unsigned long) _data				\
}

#define X86_MATCH_VENDORID_FAM_MODEL_STEPPINGS_FEATURE(_vendor, _family, _model, \
						    _steppings, _feature, _data) { \
	.vendor		= _vendor,					\
	.family		= _family,					\
	.model		= _model,					\
	.steppings	= _steppings,					\
	.feature	= _feature,					\
	.flags		= X86_CPU_ID_FLAG_ENTRY_VALID,			\
	.driver_data	= (unsigned long) _data				\
}


#define X86_MATCH_VENDOR_FAM_MODEL_FEATURE(vendor, family, model, feature, data) \
	X86_MATCH_VENDOR_FAM_MODEL_STEPPINGS_FEATURE(vendor, family, model, \
						X86_STEPPING_ANY, feature, data)


#define X86_MATCH_VENDOR_FAM_FEATURE(vendor, family, feature, data)	\
	X86_MATCH_VENDOR_FAM_MODEL_FEATURE(vendor, family,		\
					   X86_MODEL_ANY, feature, data)


#define X86_MATCH_VENDOR_FEATURE(vendor, feature, data)			\
	X86_MATCH_VENDOR_FAM_FEATURE(vendor, X86_FAMILY_ANY, feature, data)


#define X86_MATCH_FEATURE(feature, data)				\
	X86_MATCH_VENDOR_FEATURE(ANY, feature, data)


#define X86_MATCH_VENDOR_FAM_MODEL(vendor, family, model, data)		\
	X86_MATCH_VENDOR_FAM_MODEL_FEATURE(vendor, family, model,	\
					   X86_FEATURE_ANY, data)


#define X86_MATCH_VENDOR_FAM(vendor, family, data)			\
	X86_MATCH_VENDOR_FAM_MODEL(vendor, family, X86_MODEL_ANY, data)


#define X86_MATCH_VFM(vfm, data)			\
	X86_MATCH_VENDORID_FAM_MODEL_STEPPINGS_FEATURE(	\
		VFM_VENDOR(vfm),			\
		VFM_FAMILY(vfm),			\
		VFM_MODEL(vfm),				\
		X86_STEPPING_ANY, X86_FEATURE_ANY, data)


#define X86_MATCH_VFM_STEPPINGS(vfm, steppings, data)	\
	X86_MATCH_VENDORID_FAM_MODEL_STEPPINGS_FEATURE(	\
		VFM_VENDOR(vfm),			\
		VFM_FAMILY(vfm),			\
		VFM_MODEL(vfm),				\
		steppings, X86_FEATURE_ANY, data)


#define X86_MATCH_VFM_FEATURE(vfm, feature, data)	\
	X86_MATCH_VENDORID_FAM_MODEL_STEPPINGS_FEATURE(	\
		VFM_VENDOR(vfm),			\
		VFM_FAMILY(vfm),			\
		VFM_MODEL(vfm),				\
		X86_STEPPING_ANY, feature, data)



struct x86_cpu_desc {
	u8	x86_family;
	u8	x86_vendor;
	u8	x86_model;
	u8	x86_stepping;
	u32	x86_microcode_rev;
};

#define INTEL_CPU_DESC(vfm, stepping, revision) {		\
	.x86_family		= VFM_FAMILY(vfm),		\
	.x86_vendor		= VFM_VENDOR(vfm),		\
	.x86_model		= VFM_MODEL(vfm),		\
	.x86_stepping		= (stepping),			\
	.x86_microcode_rev	= (revision),			\
}

#define AMD_CPU_DESC(fam, model, stepping, revision) {		\
	.x86_family		= (fam),			\
	.x86_vendor		= X86_VENDOR_AMD,		\
	.x86_model		= (model),			\
	.x86_stepping		= (stepping),			\
	.x86_microcode_rev	= (revision),			\
}

extern const struct x86_cpu_id *x86_match_cpu(const struct x86_cpu_id *match);
extern bool x86_cpu_has_min_microcode_rev(const struct x86_cpu_desc *table);

#endif 
