/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_X86_FPU_SCHED_H
#define _ASM_X86_FPU_SCHED_H

#include <linux/sched.h>

#include <asm/cpufeature.h>
#include <asm/fpu/types.h>

#include <asm/trace/fpu.h>

extern void save_fpregs_to_fpstate(struct fpu *fpu);
extern void fpu__drop(struct fpu *fpu);
extern int  fpu_clone(struct task_struct *dst, unsigned long clone_flags, bool minimal,
		      unsigned long shstk_addr);
extern void fpu_flush_thread(void);


static inline void switch_fpu_prepare(struct task_struct *old, int cpu)
{
	if (cpu_feature_enabled(X86_FEATURE_FPU) &&
	    !(old->flags & (PF_KTHREAD | PF_USER_WORKER))) {
		struct fpu *old_fpu = &old->thread.fpu;

		save_fpregs_to_fpstate(old_fpu);
		
		old_fpu->last_cpu = cpu;

		trace_x86_fpu_regs_deactivated(old_fpu);
	}
}


static inline void switch_fpu_finish(struct task_struct *new)
{
	if (cpu_feature_enabled(X86_FEATURE_FPU))
		set_tsk_thread_flag(new, TIF_NEED_FPU_LOAD);
}

#endif 
