/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_X86_TRAPNR_H
#define _ASM_X86_TRAPNR_H


#define EVENT_TYPE_EXTINT	0	// External interrupt
#define EVENT_TYPE_RESERVED	1
#define EVENT_TYPE_NMI		2	// NMI
#define EVENT_TYPE_HWEXC	3	// Hardware originated traps, exceptions
#define EVENT_TYPE_SWINT	4	// INT n
#define EVENT_TYPE_PRIV_SWEXC	5	// INT1
#define EVENT_TYPE_SWEXC	6	// INTO, INT3
#define EVENT_TYPE_OTHER	7	// FRED SYSCALL/SYSENTER, VT-x MTF



#define X86_TRAP_DE		 0	
#define X86_TRAP_DB		 1	
#define X86_TRAP_NMI		 2	
#define X86_TRAP_BP		 3	
#define X86_TRAP_OF		 4	
#define X86_TRAP_BR		 5	
#define X86_TRAP_UD		 6	
#define X86_TRAP_NM		 7	
#define X86_TRAP_DF		 8	
#define X86_TRAP_OLD_MF		 9	
#define X86_TRAP_TS		10	
#define X86_TRAP_NP		11	
#define X86_TRAP_SS		12	
#define X86_TRAP_GP		13	
#define X86_TRAP_PF		14	
#define X86_TRAP_SPURIOUS	15	
#define X86_TRAP_MF		16	
#define X86_TRAP_AC		17	
#define X86_TRAP_MC		18	
#define X86_TRAP_XF		19	
#define X86_TRAP_VE		20	
#define X86_TRAP_CP		21	
#define X86_TRAP_VC		29	
#define X86_TRAP_IRET		32	

#endif
