/* SPDX-License-Identifier: GPL-2.0 */

#ifndef __ASM_VDSO_GETRANDOM_H
#define __ASM_VDSO_GETRANDOM_H

#ifndef __ASSEMBLY__

#include <asm/unistd.h>


static __always_inline ssize_t getrandom_syscall(void *buffer, size_t len, unsigned int flags)
{
	long ret;

	asm ("syscall" : "=a" (ret) :
	     "0" (__NR_getrandom), "D" (buffer), "S" (len), "d" (flags) :
	     "rcx", "r11", "memory");

	return ret;
}

extern struct vdso_rng_data vdso_rng_data
	__attribute__((visibility("hidden")));

static __always_inline const struct vdso_rng_data *__arch_get_vdso_rng_data(void)
{
	if (IS_ENABLED(CONFIG_TIME_NS) && __arch_get_vdso_data()->clock_mode == VDSO_CLOCKMODE_TIMENS)
		return (void *)&vdso_rng_data + ((void *)&timens_page - (void *)__arch_get_vdso_data());
	return &vdso_rng_data;
}

#endif 

#endif 
