/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_X86_VMXFEATURES_H
#define _ASM_X86_VMXFEATURES_H


#define NVMXINTS			5 




#define VMX_FEATURE_INTR_EXITING	( 0*32+  0) 
#define VMX_FEATURE_NMI_EXITING		( 0*32+  3) 
#define VMX_FEATURE_VIRTUAL_NMIS	( 0*32+  5) 
#define VMX_FEATURE_PREEMPTION_TIMER	( 0*32+  6) 
#define VMX_FEATURE_POSTED_INTR		( 0*32+  7) 


#define VMX_FEATURE_INVVPID		( 0*32+ 16) 
#define VMX_FEATURE_EPT_EXECUTE_ONLY	( 0*32+ 17) 
#define VMX_FEATURE_EPT_AD		( 0*32+ 18) 
#define VMX_FEATURE_EPT_1GB		( 0*32+ 19) 
#define VMX_FEATURE_EPT_5LEVEL		( 0*32+ 20) 


#define VMX_FEATURE_FLEXPRIORITY	( 0*32+ 24) 
#define VMX_FEATURE_APICV	        ( 0*32+ 25) 


#define VMX_FEATURE_EPTP_SWITCHING	( 0*32+ 28) 


#define VMX_FEATURE_INTR_WINDOW_EXITING ( 1*32+  2) 
#define VMX_FEATURE_USE_TSC_OFFSETTING	( 1*32+  3) 
#define VMX_FEATURE_HLT_EXITING		( 1*32+  7) 
#define VMX_FEATURE_INVLPG_EXITING	( 1*32+  9) 
#define VMX_FEATURE_MWAIT_EXITING	( 1*32+ 10) 
#define VMX_FEATURE_RDPMC_EXITING	( 1*32+ 11) 
#define VMX_FEATURE_RDTSC_EXITING	( 1*32+ 12) 
#define VMX_FEATURE_CR3_LOAD_EXITING	( 1*32+ 15) 
#define VMX_FEATURE_CR3_STORE_EXITING	( 1*32+ 16) 
#define VMX_FEATURE_TERTIARY_CONTROLS	( 1*32+ 17) 
#define VMX_FEATURE_CR8_LOAD_EXITING	( 1*32+ 19) 
#define VMX_FEATURE_CR8_STORE_EXITING	( 1*32+ 20) 
#define VMX_FEATURE_VIRTUAL_TPR		( 1*32+ 21) 
#define VMX_FEATURE_NMI_WINDOW_EXITING	( 1*32+ 22) 
#define VMX_FEATURE_MOV_DR_EXITING	( 1*32+ 23) 
#define VMX_FEATURE_UNCOND_IO_EXITING	( 1*32+ 24) 
#define VMX_FEATURE_USE_IO_BITMAPS	( 1*32+ 25) 
#define VMX_FEATURE_MONITOR_TRAP_FLAG	( 1*32+ 27) 
#define VMX_FEATURE_USE_MSR_BITMAPS	( 1*32+ 28) 
#define VMX_FEATURE_MONITOR_EXITING	( 1*32+ 29) 
#define VMX_FEATURE_PAUSE_EXITING	( 1*32+ 30) 
#define VMX_FEATURE_SEC_CONTROLS	( 1*32+ 31) 


#define VMX_FEATURE_VIRT_APIC_ACCESSES	( 2*32+  0) 
#define VMX_FEATURE_EPT			( 2*32+  1) 
#define VMX_FEATURE_DESC_EXITING	( 2*32+  2) 
#define VMX_FEATURE_RDTSCP		( 2*32+  3) 
#define VMX_FEATURE_VIRTUAL_X2APIC	( 2*32+  4) 
#define VMX_FEATURE_VPID		( 2*32+  5) 
#define VMX_FEATURE_WBINVD_EXITING	( 2*32+  6) 
#define VMX_FEATURE_UNRESTRICTED_GUEST	( 2*32+  7) 
#define VMX_FEATURE_APIC_REGISTER_VIRT	( 2*32+  8) 
#define VMX_FEATURE_VIRT_INTR_DELIVERY	( 2*32+  9) 
#define VMX_FEATURE_PAUSE_LOOP_EXITING	( 2*32+ 10) 
#define VMX_FEATURE_RDRAND_EXITING	( 2*32+ 11) 
#define VMX_FEATURE_INVPCID		( 2*32+ 12) 
#define VMX_FEATURE_VMFUNC		( 2*32+ 13) 
#define VMX_FEATURE_SHADOW_VMCS		( 2*32+ 14) 
#define VMX_FEATURE_ENCLS_EXITING	( 2*32+ 15) 
#define VMX_FEATURE_RDSEED_EXITING	( 2*32+ 16) 
#define VMX_FEATURE_PAGE_MOD_LOGGING	( 2*32+ 17) 
#define VMX_FEATURE_EPT_VIOLATION_VE	( 2*32+ 18) 
#define VMX_FEATURE_PT_CONCEAL_VMX	( 2*32+ 19) 
#define VMX_FEATURE_XSAVES		( 2*32+ 20) 
#define VMX_FEATURE_MODE_BASED_EPT_EXEC	( 2*32+ 22) 
#define VMX_FEATURE_PT_USE_GPA		( 2*32+ 24) 
#define VMX_FEATURE_TSC_SCALING		( 2*32+ 25) 
#define VMX_FEATURE_USR_WAIT_PAUSE	( 2*32+ 26) 
#define VMX_FEATURE_ENCLV_EXITING	( 2*32+ 28) 
#define VMX_FEATURE_BUS_LOCK_DETECTION	( 2*32+ 30) 
#define VMX_FEATURE_NOTIFY_VM_EXITING	( 2*32+ 31) 


#define VMX_FEATURE_IPI_VIRT		( 3*32+  4) 
#endif 
