/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_GENERIC_DIV64_H
#define _ASM_GENERIC_DIV64_H


#include <linux/types.h>
#include <linux/compiler.h>

#if BITS_PER_LONG == 64


# define do_div(n,base) ({					\
	uint32_t __base = (base);				\
	uint32_t __rem;						\
	__rem = ((uint64_t)(n)) % __base;			\
	(n) = ((uint64_t)(n)) / __base;				\
	__rem;							\
 })

#elif BITS_PER_LONG == 32

#include <linux/log2.h>



#define __div64_const32(n, ___b)					\
({									\
									\
	uint64_t ___res, ___x, ___t, ___m, ___n = (n);			\
	uint32_t ___p;							\
	bool ___bias = false;						\
									\
						\
	___p = 1 << ilog2(___b);					\
									\
				\
	___m = (~0ULL / ___b) * ___p;					\
	___m += (((~0ULL % ___b + 1) * ___p) + ___b - 1) / ___b;	\
									\
			\
	___x = ~0ULL / ___b * ___b - 1;					\
									\
			\
	___res = (___m & 0xffffffff) * (___x & 0xffffffff);		\
	___t = (___m & 0xffffffff) * (___x >> 32) + (___res >> 32);	\
	___res = (___m >> 32) * (___x >> 32) + (___t >> 32);		\
	___t = (___m >> 32) * (___x & 0xffffffff) + (___t & 0xffffffff);\
	___res = (___res + (___t >> 32)) / ___p;			\
									\
					\
	if (___res != ___x / ___b) {					\
									\
		___bias = true;						\
						\
		___m = (~0ULL / ___b) * ___p;				\
		___m += ((~0ULL % ___b + 1) * ___p) / ___b;		\
	}								\
									\
		\
	___p /= (___m & -___m);						\
	___m /= (___m & -___m);						\
									\
									\
	___res = __arch_xprod_64(___m, ___n, ___bias);			\
									\
	___res /= ___p;							\
})

#ifndef __arch_xprod_64

#ifdef CONFIG_CC_OPTIMIZE_FOR_PERFORMANCE
static __always_inline
#else
static inline
#endif
uint64_t __arch_xprod_64(const uint64_t m, uint64_t n, bool bias)
{
	uint32_t m_lo = m;
	uint32_t m_hi = m >> 32;
	uint32_t n_lo = n;
	uint32_t n_hi = n >> 32;
	uint64_t x, y;

	
	bool no_ovf = __builtin_constant_p(m) &&
		      ((m >> 32) + (m & 0xffffffff) < 0x100000000);

	if (no_ovf) {
		x = (uint64_t)m_lo * n_lo + (bias ? m : 0);
		x >>= 32;
		x += (uint64_t)m_lo * n_hi;
		x += (uint64_t)m_hi * n_lo;
		x >>= 32;
		x += (uint64_t)m_hi * n_hi;
	} else {
		x = (uint64_t)m_lo * n_lo + (bias ? m_lo : 0);
		y = (uint64_t)m_lo * n_hi + (uint32_t)(x >> 32) + (bias ? m_hi : 0);
		x = (uint64_t)m_hi * n_hi + (uint32_t)(y >> 32);
		y = (uint64_t)m_hi * n_lo + (uint32_t)y;
		x += (uint32_t)(y >> 32);
	}

	return x;
}
#endif

#ifndef __div64_32
extern uint32_t __div64_32(uint64_t *dividend, uint32_t divisor);
#endif


# define do_div(n,base) ({				\
	uint32_t __base = (base);			\
	uint32_t __rem;					\
	(void)(((typeof((n)) *)0) == ((uint64_t *)0));	\
	if (__builtin_constant_p(__base) &&		\
	    is_power_of_2(__base)) {			\
		__rem = (n) & (__base - 1);		\
		(n) >>= ilog2(__base);			\
	} else if (__builtin_constant_p(__base) &&	\
		   __base != 0) {			\
		uint32_t __res_lo, __n_lo = (n);	\
		(n) = __div64_const32(n, __base);	\
		 \
		__res_lo = (n);				\
		__rem = __n_lo - __res_lo * __base;	\
	} else if (likely(((n) >> 32) == 0)) {		\
		__rem = (uint32_t)(n) % __base;		\
		(n) = (uint32_t)(n) / __base;		\
	} else {					\
		__rem = __div64_32(&(n), __base);	\
	}						\
	__rem;						\
 })

#else 

# error do_div() does not yet support the C64

#endif 

#endif 
