/* SPDX-License-Identifier: GPL-2.0+ */

#ifndef PINCTRL_K210_FPIOA_H
#define PINCTRL_K210_FPIOA_H


#define K210_PCF_MASK		GENMASK(7, 0)
#define K210_PCF_JTAG_TCLK	0   
#define K210_PCF_JTAG_TDI	1   
#define K210_PCF_JTAG_TMS	2   
#define K210_PCF_JTAG_TDO	3   
#define K210_PCF_SPI0_D0	4   
#define K210_PCF_SPI0_D1	5   
#define K210_PCF_SPI0_D2	6   
#define K210_PCF_SPI0_D3	7   
#define K210_PCF_SPI0_D4	8   
#define K210_PCF_SPI0_D5	9   
#define K210_PCF_SPI0_D6	10  
#define K210_PCF_SPI0_D7	11  
#define K210_PCF_SPI0_SS0	12  
#define K210_PCF_SPI0_SS1	13  
#define K210_PCF_SPI0_SS2	14  
#define K210_PCF_SPI0_SS3	15  
#define K210_PCF_SPI0_ARB	16  
#define K210_PCF_SPI0_SCLK	17  
#define K210_PCF_UARTHS_RX	18  
#define K210_PCF_UARTHS_TX	19  
#define K210_PCF_RESV6		20  
#define K210_PCF_RESV7		21  
#define K210_PCF_CLK_SPI1	22  
#define K210_PCF_CLK_I2C1	23  
#define K210_PCF_GPIOHS0	24  
#define K210_PCF_GPIOHS1	25  
#define K210_PCF_GPIOHS2	26  
#define K210_PCF_GPIOHS3	27  
#define K210_PCF_GPIOHS4	28  
#define K210_PCF_GPIOHS5	29  
#define K210_PCF_GPIOHS6	30  
#define K210_PCF_GPIOHS7	31  
#define K210_PCF_GPIOHS8	32  
#define K210_PCF_GPIOHS9	33  
#define K210_PCF_GPIOHS10	34  
#define K210_PCF_GPIOHS11	35  
#define K210_PCF_GPIOHS12	36  
#define K210_PCF_GPIOHS13	37  
#define K210_PCF_GPIOHS14	38  
#define K210_PCF_GPIOHS15	39  
#define K210_PCF_GPIOHS16	40  
#define K210_PCF_GPIOHS17	41  
#define K210_PCF_GPIOHS18	42  
#define K210_PCF_GPIOHS19	43  
#define K210_PCF_GPIOHS20	44  
#define K210_PCF_GPIOHS21	45  
#define K210_PCF_GPIOHS22	46  
#define K210_PCF_GPIOHS23	47  
#define K210_PCF_GPIOHS24	48  
#define K210_PCF_GPIOHS25	49  
#define K210_PCF_GPIOHS26	50  
#define K210_PCF_GPIOHS27	51  
#define K210_PCF_GPIOHS28	52  
#define K210_PCF_GPIOHS29	53  
#define K210_PCF_GPIOHS30	54  
#define K210_PCF_GPIOHS31	55  
#define K210_PCF_GPIO0		56  
#define K210_PCF_GPIO1		57  
#define K210_PCF_GPIO2		58  
#define K210_PCF_GPIO3		59  
#define K210_PCF_GPIO4		60  
#define K210_PCF_GPIO5		61  
#define K210_PCF_GPIO6		62  
#define K210_PCF_GPIO7		63  
#define K210_PCF_UART1_RX	64  
#define K210_PCF_UART1_TX	65  
#define K210_PCF_UART2_RX	66  
#define K210_PCF_UART2_TX	67  
#define K210_PCF_UART3_RX	68  
#define K210_PCF_UART3_TX	69  
#define K210_PCF_SPI1_D0	70  
#define K210_PCF_SPI1_D1	71  
#define K210_PCF_SPI1_D2	72  
#define K210_PCF_SPI1_D3	73  
#define K210_PCF_SPI1_D4	74  
#define K210_PCF_SPI1_D5	75  
#define K210_PCF_SPI1_D6	76  
#define K210_PCF_SPI1_D7	77  
#define K210_PCF_SPI1_SS0	78  
#define K210_PCF_SPI1_SS1	79  
#define K210_PCF_SPI1_SS2	80  
#define K210_PCF_SPI1_SS3	81  
#define K210_PCF_SPI1_ARB	82  
#define K210_PCF_SPI1_SCLK	83  
#define K210_PCF_SPI2_D0	84  
#define K210_PCF_SPI2_SS	85  
#define K210_PCF_SPI2_SCLK	86  
#define K210_PCF_I2S0_MCLK	87  
#define K210_PCF_I2S0_SCLK	88  
#define K210_PCF_I2S0_WS	89  
#define K210_PCF_I2S0_IN_D0	90  
#define K210_PCF_I2S0_IN_D1	91  
#define K210_PCF_I2S0_IN_D2	92  
#define K210_PCF_I2S0_IN_D3	93  
#define K210_PCF_I2S0_OUT_D0	94  
#define K210_PCF_I2S0_OUT_D1	95  
#define K210_PCF_I2S0_OUT_D2	96  
#define K210_PCF_I2S0_OUT_D3	97  
#define K210_PCF_I2S1_MCLK	98  
#define K210_PCF_I2S1_SCLK	99  
#define K210_PCF_I2S1_WS	100 
#define K210_PCF_I2S1_IN_D0	101 
#define K210_PCF_I2S1_IN_D1	102 
#define K210_PCF_I2S1_IN_D2	103 
#define K210_PCF_I2S1_IN_D3	104 
#define K210_PCF_I2S1_OUT_D0	105 
#define K210_PCF_I2S1_OUT_D1	106 
#define K210_PCF_I2S1_OUT_D2	107 
#define K210_PCF_I2S1_OUT_D3	108 
#define K210_PCF_I2S2_MCLK	109 
#define K210_PCF_I2S2_SCLK	110 
#define K210_PCF_I2S2_WS	111 
#define K210_PCF_I2S2_IN_D0	112 
#define K210_PCF_I2S2_IN_D1	113 
#define K210_PCF_I2S2_IN_D2	114 
#define K210_PCF_I2S2_IN_D3	115 
#define K210_PCF_I2S2_OUT_D0	116 
#define K210_PCF_I2S2_OUT_D1	117 
#define K210_PCF_I2S2_OUT_D2	118 
#define K210_PCF_I2S2_OUT_D3	119 
#define K210_PCF_RESV0		120 
#define K210_PCF_RESV1		121 
#define K210_PCF_RESV2		122 
#define K210_PCF_RESV3		123 
#define K210_PCF_RESV4		124 
#define K210_PCF_RESV5		125 
#define K210_PCF_I2C0_SCLK	126 
#define K210_PCF_I2C0_SDA	127 
#define K210_PCF_I2C1_SCLK	128 
#define K210_PCF_I2C1_SDA	129 
#define K210_PCF_I2C2_SCLK	130 
#define K210_PCF_I2C2_SDA	131 
#define K210_PCF_DVP_XCLK	132 
#define K210_PCF_DVP_RST	133 
#define K210_PCF_DVP_PWDN	134 
#define K210_PCF_DVP_VSYNC	135 
#define K210_PCF_DVP_HSYNC	136 
#define K210_PCF_DVP_PCLK	137 
#define K210_PCF_DVP_D0		138 
#define K210_PCF_DVP_D1		139 
#define K210_PCF_DVP_D2		140 
#define K210_PCF_DVP_D3		141 
#define K210_PCF_DVP_D4		142 
#define K210_PCF_DVP_D5		143 
#define K210_PCF_DVP_D6		144 
#define K210_PCF_DVP_D7		145 
#define K210_PCF_SCCB_SCLK	146 
#define K210_PCF_SCCB_SDA	147 
#define K210_PCF_UART1_CTS	148 
#define K210_PCF_UART1_DSR	149 
#define K210_PCF_UART1_DCD	150 
#define K210_PCF_UART1_RI	151 
#define K210_PCF_UART1_SIR_IN	152 
#define K210_PCF_UART1_DTR	153 
#define K210_PCF_UART1_RTS	154 
#define K210_PCF_UART1_OUT2	155 
#define K210_PCF_UART1_OUT1	156 
#define K210_PCF_UART1_SIR_OUT	157 
#define K210_PCF_UART1_BAUD	158 
#define K210_PCF_UART1_RE	159 
#define K210_PCF_UART1_DE	160 
#define K210_PCF_UART1_RS485_EN	161 
#define K210_PCF_UART2_CTS	162 
#define K210_PCF_UART2_DSR	163 
#define K210_PCF_UART2_DCD	164 
#define K210_PCF_UART2_RI	165 
#define K210_PCF_UART2_SIR_IN	166 
#define K210_PCF_UART2_DTR	167 
#define K210_PCF_UART2_RTS	168 
#define K210_PCF_UART2_OUT2	169 
#define K210_PCF_UART2_OUT1	170 
#define K210_PCF_UART2_SIR_OUT	171 
#define K210_PCF_UART2_BAUD	172 
#define K210_PCF_UART2_RE	173 
#define K210_PCF_UART2_DE	174 
#define K210_PCF_UART2_RS485_EN	175 
#define K210_PCF_UART3_CTS	176 
#define K210_PCF_UART3_DSR	177 
#define K210_PCF_UART3_DCD	178 
#define K210_PCF_UART3_RI	179 
#define K210_PCF_UART3_SIR_IN	180 
#define K210_PCF_UART3_DTR	181 
#define K210_PCF_UART3_RTS	182 
#define K210_PCF_UART3_OUT2	183 
#define K210_PCF_UART3_OUT1	184 
#define K210_PCF_UART3_SIR_OUT	185 
#define K210_PCF_UART3_BAUD	186 
#define K210_PCF_UART3_RE	187 
#define K210_PCF_UART3_DE	188 
#define K210_PCF_UART3_RS485_EN	189 
#define K210_PCF_TIMER0_TOGGLE1	190 
#define K210_PCF_TIMER0_TOGGLE2	191 
#define K210_PCF_TIMER0_TOGGLE3	192 
#define K210_PCF_TIMER0_TOGGLE4	193 
#define K210_PCF_TIMER1_TOGGLE1	194 
#define K210_PCF_TIMER1_TOGGLE2	195 
#define K210_PCF_TIMER1_TOGGLE3	196 
#define K210_PCF_TIMER1_TOGGLE4	197 
#define K210_PCF_TIMER2_TOGGLE1	198 
#define K210_PCF_TIMER2_TOGGLE2	199 
#define K210_PCF_TIMER2_TOGGLE3	200 
#define K210_PCF_TIMER2_TOGGLE4	201 
#define K210_PCF_CLK_SPI2	202 
#define K210_PCF_CLK_I2C2	203 
#define K210_PCF_INTERNAL0	204 
#define K210_PCF_INTERNAL1	205 
#define K210_PCF_INTERNAL2	206 
#define K210_PCF_INTERNAL3	207 
#define K210_PCF_INTERNAL4	208 
#define K210_PCF_INTERNAL5	209 
#define K210_PCF_INTERNAL6	210 
#define K210_PCF_INTERNAL7	211 
#define K210_PCF_INTERNAL8	212 
#define K210_PCF_INTERNAL9	213 
#define K210_PCF_INTERNAL10	214 
#define K210_PCF_INTERNAL11	215 
#define K210_PCF_INTERNAL12	216 
#define K210_PCF_INTERNAL13	217 
#define K210_PCF_INTERNAL14	218 
#define K210_PCF_INTERNAL15	219 
#define K210_PCF_INTERNAL16	220 
#define K210_PCF_INTERNAL17	221 
#define K210_PCF_CONSTANT	222 
#define K210_PCF_INTERNAL18	223 
#define K210_PCF_DEBUG0		224 
#define K210_PCF_DEBUG1		225 
#define K210_PCF_DEBUG2		226 
#define K210_PCF_DEBUG3		227 
#define K210_PCF_DEBUG4		228 
#define K210_PCF_DEBUG5		229 
#define K210_PCF_DEBUG6		230 
#define K210_PCF_DEBUG7		231 
#define K210_PCF_DEBUG8		232 
#define K210_PCF_DEBUG9		233 
#define K210_PCF_DEBUG10	234 
#define K210_PCF_DEBUG11	235 
#define K210_PCF_DEBUG12	236 
#define K210_PCF_DEBUG13	237 
#define K210_PCF_DEBUG14	238 
#define K210_PCF_DEBUG15	239 
#define K210_PCF_DEBUG16	240 
#define K210_PCF_DEBUG17	241 
#define K210_PCF_DEBUG18	242 
#define K210_PCF_DEBUG19	243 
#define K210_PCF_DEBUG20	244 
#define K210_PCF_DEBUG21	245 
#define K210_PCF_DEBUG22	246 
#define K210_PCF_DEBUG23	247 
#define K210_PCF_DEBUG24	248 
#define K210_PCF_DEBUG25	249 
#define K210_PCF_DEBUG26	250 
#define K210_PCF_DEBUG27	251 
#define K210_PCF_DEBUG28	252 
#define K210_PCF_DEBUG29	253 
#define K210_PCF_DEBUG30	254 
#define K210_PCF_DEBUG31	255 

#define K210_FPIOA(pin, func)		(((pin) << 16) | (func))

#define K210_PC_POWER_3V3	0
#define K210_PC_POWER_1V8	1

#endif 
