/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef __LINUX_ACPI_DMA_H
#define __LINUX_ACPI_DMA_H

#include <linux/err.h>
#include <linux/dmaengine.h>
#include <linux/types.h>

struct device;


struct acpi_dma_spec {
	int		chan_id;
	int		slave_id;
	struct device	*dev;
};


struct acpi_dma {
	struct list_head	dma_controllers;
	struct device		*dev;
	struct dma_chan		*(*acpi_dma_xlate)
				(struct acpi_dma_spec *, struct acpi_dma *);
	void			*data;
	unsigned short		base_request_line;
	unsigned short		end_request_line;
};


struct acpi_dma_filter_info {
	dma_cap_mask_t	dma_cap;
	dma_filter_fn	filter_fn;
};

#ifdef CONFIG_DMA_ACPI

int acpi_dma_controller_register(struct device *dev,
		struct dma_chan *(*acpi_dma_xlate)
		(struct acpi_dma_spec *, struct acpi_dma *),
		void *data);
int acpi_dma_controller_free(struct device *dev);
int devm_acpi_dma_controller_register(struct device *dev,
		struct dma_chan *(*acpi_dma_xlate)
		(struct acpi_dma_spec *, struct acpi_dma *),
		void *data);

struct dma_chan *acpi_dma_request_slave_chan_by_index(struct device *dev,
						      size_t index);
struct dma_chan *acpi_dma_request_slave_chan_by_name(struct device *dev,
						     const char *name);

struct dma_chan *acpi_dma_simple_xlate(struct acpi_dma_spec *dma_spec,
				       struct acpi_dma *adma);
#else

static inline int acpi_dma_controller_register(struct device *dev,
		struct dma_chan *(*acpi_dma_xlate)
		(struct acpi_dma_spec *, struct acpi_dma *),
		void *data)
{
	return -ENODEV;
}
static inline int acpi_dma_controller_free(struct device *dev)
{
	return -ENODEV;
}
static inline int devm_acpi_dma_controller_register(struct device *dev,
		struct dma_chan *(*acpi_dma_xlate)
		(struct acpi_dma_spec *, struct acpi_dma *),
		void *data)
{
	return -ENODEV;
}

static inline struct dma_chan *acpi_dma_request_slave_chan_by_index(
		struct device *dev, size_t index)
{
	return ERR_PTR(-ENODEV);
}
static inline struct dma_chan *acpi_dma_request_slave_chan_by_name(
		struct device *dev, const char *name)
{
	return ERR_PTR(-ENODEV);
}

#define acpi_dma_simple_xlate	NULL

#endif

#define acpi_dma_request_slave_channel	acpi_dma_request_slave_chan_by_index

#endif 
