/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_BRCMPHY_H
#define _LINUX_BRCMPHY_H

#include <linux/phy.h>


#define BRCM_PSEUDO_PHY_ADDR           30

#define PHY_ID_BCM50610			0x0143bd60
#define PHY_ID_BCM50610M		0x0143bd70
#define PHY_ID_BCM5221			0x004061e0
#define PHY_ID_BCM5241			0x0143bc30
#define PHY_ID_BCMAC131			0x0143bc70
#define PHY_ID_BCM5481			0x0143bca0
#define PHY_ID_BCM5395			0x0143bcf0
#define PHY_ID_BCM53125			0x03625f20
#define PHY_ID_BCM53128			0x03625e10
#define PHY_ID_BCM54810			0x03625d00
#define PHY_ID_BCM54811			0x03625cc0
#define PHY_ID_BCM5482			0x0143bcb0
#define PHY_ID_BCM5411			0x00206070
#define PHY_ID_BCM5421			0x002060e0
#define PHY_ID_BCM54210E		0x600d84a0
#define PHY_ID_BCM5464			0x002060b0
#define PHY_ID_BCM5461			0x002060c0
#define PHY_ID_BCM54612E		0x03625e60
#define PHY_ID_BCM54616S		0x03625d10
#define PHY_ID_BCM54140			0xae025009
#define PHY_ID_BCM57780			0x03625d90
#define PHY_ID_BCM89610			0x03625cd0

#define PHY_ID_BCM72113			0x35905310
#define PHY_ID_BCM72116			0x35905350
#define PHY_ID_BCM72165			0x35905340
#define PHY_ID_BCM7250			0xae025280
#define PHY_ID_BCM7255			0xae025120
#define PHY_ID_BCM7260			0xae025190
#define PHY_ID_BCM7268			0xae025090
#define PHY_ID_BCM7271			0xae0253b0
#define PHY_ID_BCM7278			0xae0251a0
#define PHY_ID_BCM7364			0xae025260
#define PHY_ID_BCM7366			0x600d8490
#define PHY_ID_BCM7346			0x600d8650
#define PHY_ID_BCM7362			0x600d84b0
#define PHY_ID_BCM74165			0x359052c0
#define PHY_ID_BCM7425			0x600d86b0
#define PHY_ID_BCM7429			0x600d8730
#define PHY_ID_BCM7435			0x600d8750
#define PHY_ID_BCM74371			0xae0252e0
#define PHY_ID_BCM7439			0x600d8480
#define PHY_ID_BCM7439_2		0xae025080
#define PHY_ID_BCM7445			0x600d8510
#define PHY_ID_BCM7712			0x35905330

#define PHY_ID_BCM_CYGNUS		0xae025200
#define PHY_ID_BCM_OMEGA		0xae025100

#define PHY_BCM_OUI_MASK		0xfffffc00
#define PHY_BCM_OUI_1			0x00206000
#define PHY_BCM_OUI_2			0x0143bc00
#define PHY_BCM_OUI_3			0x03625c00
#define PHY_BCM_OUI_4			0x600d8400
#define PHY_BCM_OUI_5			0x03625e00
#define PHY_BCM_OUI_6			0xae025000

#define PHY_BRCM_AUTO_PWRDWN_ENABLE	0x00000001
#define PHY_BRCM_RX_REFCLK_UNUSED	0x00000002
#define PHY_BRCM_CLEAR_RGMII_MODE	0x00000004
#define PHY_BRCM_DIS_TXCRXC_NOENRGY	0x00000008
#define PHY_BRCM_EN_MASTER_MODE		0x00000010
#define PHY_BRCM_IDDQ_SUSPEND		0x00000020


#define PHY_BRCM_7XXX_REV(x)		(((x) >> 8) & 0xff)
#define PHY_BRCM_7XXX_PATCH(x)		((x) & 0xff)
#define PHY_BCM_FLAGS_VALID		0x80000000


#define MII_BCM54XX_ECR		0x10	
#define MII_BCM54XX_ECR_IM	0x1000	
#define MII_BCM54XX_ECR_IF	0x0800	
#define MII_BCM54XX_ECR_FIFOE	0x0001	

#define MII_BCM54XX_ESR		0x11	
#define MII_BCM54XX_ESR_IS	0x1000	

#define MII_BCM54XX_EXP_DATA	0x15	
#define MII_BCM54XX_EXP_SEL	0x17	
#define MII_BCM54XX_EXP_SEL_TOP	0x0d00	
#define MII_BCM54XX_EXP_SEL_SSD	0x0e00	
#define MII_BCM54XX_EXP_SEL_WOL	0x0e00	
#define MII_BCM54XX_EXP_SEL_ER	0x0f00	
#define MII_BCM54XX_EXP_SEL_ETC	0x0d00	

#define MII_BCM54XX_AUX_CTL	0x18	
#define MII_BCM54XX_ISR		0x1a	
#define MII_BCM54XX_IMR		0x1b	
#define MII_BCM54XX_INT_CRCERR	0x0001	
#define MII_BCM54XX_INT_LINK	0x0002	
#define MII_BCM54XX_INT_SPEED	0x0004	
#define MII_BCM54XX_INT_DUPLEX	0x0008	
#define MII_BCM54XX_INT_LRS	0x0010	
#define MII_BCM54XX_INT_RRS	0x0020	
#define MII_BCM54XX_INT_SSERR	0x0040	
#define MII_BCM54XX_INT_UHCD	0x0080	
#define MII_BCM54XX_INT_NHCD	0x0100	
#define MII_BCM54XX_INT_NHCDL	0x0200	
#define MII_BCM54XX_INT_ANPR	0x0400	
#define MII_BCM54XX_INT_LC	0x0800	
#define MII_BCM54XX_INT_HC	0x1000	
#define MII_BCM54XX_INT_MDIX	0x2000	
#define MII_BCM54XX_INT_PSERR	0x4000	

#define MII_BCM54XX_SHD		0x1c	
#define MII_BCM54XX_SHD_WRITE	0x8000
#define MII_BCM54XX_SHD_VAL(x)	((x & 0x1f) << 10)
#define MII_BCM54XX_SHD_DATA(x)	((x & 0x3ff) << 0)

#define MII_BCM54XX_RDB_ADDR	0x1e
#define MII_BCM54XX_RDB_DATA	0x1f


#define BCM54XX_RDB_REG0087		0x0087
#define BCM54XX_EXP_REG7E		(MII_BCM54XX_EXP_SEL_ER + 0x7E)
#define BCM54XX_ACCESS_MODE_LEGACY_EN	BIT(15)


#define MII_BCM54XX_AUXCTL_SHDWSEL_AUXCTL	0x00
#define MII_BCM54XX_AUXCTL_ACTL_TX_6DB		0x0400
#define MII_BCM54XX_AUXCTL_ACTL_SMDSP_ENA	0x0800
#define MII_BCM54XX_AUXCTL_ACTL_EXT_PKT_LEN	0x4000

#define MII_BCM54XX_AUXCTL_SHDWSEL_MISC			0x07
#define MII_BCM54XX_AUXCTL_SHDWSEL_MISC_WIRESPEED_EN	0x0010
#define MII_BCM54XX_AUXCTL_SHDWSEL_MISC_RGMII_EN	0x0080
#define MII_BCM54XX_AUXCTL_SHDWSEL_MISC_RGMII_SKEW_EN	0x0100
#define MII_BCM54XX_AUXCTL_MISC_FORCE_AMDIX		0x0200
#define MII_BCM54XX_AUXCTL_MISC_WREN			0x8000

#define MII_BCM54XX_AUXCTL_SHDWSEL_READ_SHIFT	12
#define MII_BCM54XX_AUXCTL_SHDWSEL_MASK	0x0007


#define BCM_LED_SRC_LINKSPD1	0x0
#define BCM_LED_SRC_LINKSPD2	0x1
#define BCM_LED_SRC_XMITLED	0x2
#define BCM_LED_SRC_ACTIVITYLED	0x3
#define BCM_LED_SRC_FDXLED	0x4
#define BCM_LED_SRC_SLAVE	0x5
#define BCM_LED_SRC_INTR	0x6
#define BCM_LED_SRC_QUALITY	0x7
#define BCM_LED_SRC_RCVLED	0x8
#define BCM_LED_SRC_WIRESPEED	0x9
#define BCM_LED_SRC_MULTICOLOR1	0xa
#define BCM_LED_SRC_OPENSHORT	0xb
#define BCM_LED_SRC_OFF		0xe	
#define BCM_LED_SRC_ON		0xf	
#define BCM_LED_SRC_MASK	GENMASK(3, 0)


#define BCM_EXP_MULTICOLOR		(MII_BCM54XX_EXP_SEL_ER + 0x04)
#define BCM_LED_MULTICOLOR_IN_PHASE	BIT(8)
#define BCM_LED_MULTICOLOR_LINK_ACT	0x0
#define BCM_LED_MULTICOLOR_SPEED	0x1
#define BCM_LED_MULTICOLOR_ACT_FLASH	0x2
#define BCM_LED_MULTICOLOR_FDX		0x3
#define BCM_LED_MULTICOLOR_OFF		0x4
#define BCM_LED_MULTICOLOR_ON		0x5
#define BCM_LED_MULTICOLOR_ALT		0x6
#define BCM_LED_MULTICOLOR_FLASH	0x7
#define BCM_LED_MULTICOLOR_LINK		0x8
#define BCM_LED_MULTICOLOR_ACT		0x9
#define BCM_LED_MULTICOLOR_PROGRAM	0xa




#define BCM54XX_SHD_SCR2		0x04
#define  BCM54XX_SHD_SCR2_WSPD_RTRY_DIS	0x100
#define  BCM54XX_SHD_SCR2_WSPD_RTRY_LMT_SHIFT	2
#define  BCM54XX_SHD_SCR2_WSPD_RTRY_LMT_OFFSET	2
#define  BCM54XX_SHD_SCR2_WSPD_RTRY_LMT_MASK	0x7


#define BCM54XX_SHD_SCR3		0x05
#define  BCM54XX_SHD_SCR3_DEF_CLK125	0x0001
#define  BCM54XX_SHD_SCR3_DLLAPD_DIS	0x0002
#define  BCM54XX_SHD_SCR3_TRDDAPD	0x0004
#define  BCM54XX_SHD_SCR3_RXCTXC_DIS	0x0100


#define BCM54XX_SHD_APD			0x0a
#define  BCM_APD_CLR_MASK		0xFE9F 
#define  BCM54XX_SHD_APD_EN		0x0020
#define  BCM_NO_ANEG_APD_EN		0x0060 
#define  BCM_APD_SINGLELP_EN	0x0100 

#define BCM54XX_SHD_LEDS1	0x0d	
					
#define BCM54XX_SHD_LEDS_SHIFT(led)	(4 * (led))
#define BCM54XX_SHD_LEDS1_LED3(src)	((src & 0xf) << 4)
					
#define BCM54XX_SHD_LEDS1_LED1(src)	((src & 0xf) << 0)
#define BCM54XX_SHD_LEDS2	0x0e	
#define BCM54XX_SHD_RGMII_MODE	0x0b	
#define BCM5482_SHD_SSD		0x14	
#define BCM5482_SHD_SSD_LEDM	0x0008	
#define BCM5482_SHD_SSD_EN	0x0001	


#define BCM54616S_SHD_100FX_CTRL	0x13
#define	BCM54616S_100FX_MODE		BIT(0)	


#define BCM54XX_SHD_MODE		0x1f
#define BCM54XX_SHD_INTF_SEL_MASK	GENMASK(2, 1)	
#define BCM54XX_SHD_INTF_SEL_RGMII	0x02
#define BCM54XX_SHD_INTF_SEL_SGMII	0x04
#define BCM54XX_SHD_INTF_SEL_GBIC	0x06
#define BCM54XX_SHD_MODE_1000BX		BIT(0)	


#define MII_BCM54XX_EXP_AADJ1CH0		0x001f
#define  MII_BCM54XX_EXP_AADJ1CH0_SWP_ABCD_OEN	0x0200
#define  MII_BCM54XX_EXP_AADJ1CH0_SWSEL_THPF	0x0100
#define MII_BCM54XX_EXP_AADJ1CH3		0x601f
#define  MII_BCM54XX_EXP_AADJ1CH3_ADCCKADJ	0x0002
#define MII_BCM54XX_EXP_EXP08			0x0F08
#define  MII_BCM54XX_EXP_EXP08_RJCT_2MHZ	0x0001
#define  MII_BCM54XX_EXP_EXP08_EARLY_DAC_WAKE	0x0200
#define  MII_BCM54XX_EXP_EXP08_FORCE_DAC_WAKE	0x0100
#define MII_BCM54XX_EXP_EXP75			0x0f75
#define  MII_BCM54XX_EXP_EXP75_VDACCTRL		0x003c
#define  MII_BCM54XX_EXP_EXP75_CM_OSC		0x0001
#define MII_BCM54XX_EXP_EXP96			0x0f96
#define  MII_BCM54XX_EXP_EXP96_MYST		0x0010
#define MII_BCM54XX_EXP_EXP97			0x0f97
#define  MII_BCM54XX_EXP_EXP97_MYST		0x0c0c


#define BCM54XX_TOP_MISC_IDDQ_CTRL		(MII_BCM54XX_EXP_SEL_TOP + 0x06)
#define BCM54XX_TOP_MISC_IDDQ_LP		(1 << 0)
#define BCM54XX_TOP_MISC_IDDQ_SD		(1 << 2)
#define BCM54XX_TOP_MISC_IDDQ_SR		(1 << 3)

#define BCM54XX_TOP_MISC_LED_CTL		(MII_BCM54XX_EXP_SEL_TOP + 0x0C)
#define  BCM54XX_LED4_SEL_INTR			BIT(1)


#define BCM5482_SSD_1000BX_CTL		0x00	
#define BCM5482_SSD_1000BX_CTL_PWRDOWN	0x0800	
#define BCM5482_SSD_SGMII_SLAVE		0x15	
#define BCM5482_SSD_SGMII_SLAVE_EN	0x0002	
#define BCM5482_SSD_SGMII_SLAVE_AD	0x0001	


#define MII_BCM54XX_LRECR		0x00	
#define MII_BCM54XX_LRESR		0x01	
#define MII_BCM54XX_LREPHYSID1		0x02	
#define MII_BCM54XX_LREPHYSID2		0x03	
#define MII_BCM54XX_LREANAA		0x04	
#define MII_BCM54XX_LREANAC		0x05	
#define MII_BCM54XX_LREANPT		0x06	
#define MII_BCM54XX_LRELPA		0x07	
#define MII_BCM54XX_LRELPNPM		0x08	
#define MII_BCM54XX_LRELPNPC		0x09	
#define MII_BCM54XX_LRELDSE		0x0a	
#define MII_BCM54XX_LREES		0x0f	


#define LRECR_RESET			0x8000	
#define LRECR_LOOPBACK			0x4000	
#define LRECR_LDSRES			0x2000	
#define LRECR_LDSEN			0x1000	
#define LRECR_PDOWN			0x0800	
#define LRECR_ISOLATE			0x0400	
#define LRECR_SPEED100			0x0200	
#define LRECR_SPEED10			0x0000	
#define LRECR_4PAIRS			0x0020	
#define LRECR_2PAIRS			0x0010	
#define LRECR_1PAIR			0x0000	
#define LRECR_MASTER			0x0008	
#define LRECR_SLAVE			0x0000	


#define LRESR_100_1PAIR			0x2000	
#define LRESR_100_4PAIR			0x1000	
#define LRESR_100_2PAIR			0x0800	
#define LRESR_10_2PAIR			0x0400	
#define LRESR_10_1PAIR			0x0200	
#define LRESR_ESTATEN			0x0100	
#define LRESR_RESV			0x0080	
#define LRESR_MFPS			0x0040	
#define LRESR_LDSCOMPLETE		0x0020	
#define LRESR_8023			0x0010	
#define LRESR_LDSABILITY		0x0008	
#define LRESR_LSTATUS			0x0004	
#define LRESR_JCD			0x0002	
#define LRESR_ERCAP			0x0001	


#define LREANAA_PAUSE_ASYM		0x8000	
#define LREANAA_PAUSE			0x4000	
#define LREANAA_100_1PAIR		0x0020	
#define LREANAA_100_4PAIR		0x0010	
#define LREANAA_100_2PAIR		0x0008	
#define LREANAA_10_2PAIR		0x0004	
#define LREANAA_10_1PAIR		0x0002	

#define LRE_ADVERTISE_FULL		(LREANAA_100_1PAIR | LREANAA_100_4PAIR | \
					 LREANAA_100_2PAIR | LREANAA_10_2PAIR | \
					 LREANAA_10_1PAIR)

#define LRE_ADVERTISE_ALL		LRE_ADVERTISE_FULL


#define LRELPA_PAUSE_ASYM		0x8000	
#define LRELPA_PAUSE			0x4000	
#define LRELPA_100_1PAIR		0x0020	
#define LRELPA_100_4PAIR		0x0010	
#define LRELPA_100_2PAIR		0x0008	
#define LRELPA_10_2PAIR			0x0004	
#define LRELPA_10_1PAIR			0x0002	


#define LDSE_DOWNGRADE			0x8000	
#define LDSE_MASTER			0x4000	
#define LDSE_PAIRS_MASK			0x3000	
#define LDSE_PAIRS_SHIFT		12
#define LDSE_4PAIRS			(2 << LDSE_PAIRS_SHIFT)	
#define LDSE_2PAIRS			(1 << LDSE_PAIRS_SHIFT)	
#define LDSE_1PAIR			(0 << LDSE_PAIRS_SHIFT)	
#define LDSE_CABLEN_MASK		0x0FFF	


#define BCM54810_EXP_BROADREACH_LRE_MISC_CTL	(MII_BCM54XX_EXP_SEL_ER + 0x90)
#define BCM54810_EXP_BROADREACH_LRE_MISC_CTL_EN	(1 << 0)
#define BCM54810_SHD_CLK_CTL			0x3
#define BCM54810_SHD_CLK_CTL_GTXCLK_EN		(1 << 9)


#define BCM54811_EXP_BROADREACH_LRE_OVERLAY_CTL	(MII_BCM54XX_EXP_SEL_ER + 0x9A)

#define BCM54811_EXP_BROADREACH_LRE_OVERLAY_CTL_EN		BIT(15)

#define BCM54811_EXP_BROADREACH_LRE_OVERLAY_CTL_OVERRIDE_VAL	BIT(14)

#define BCM54811_EXP_BROADREACH_LRE_OVERLAY_CTL_VAL		BIT(13)


#define BCM54612E_EXP_SPARE0		(MII_BCM54XX_EXP_SEL_ETC + 0x34)
#define BCM54612E_LED4_CLK125OUT_EN	(1 << 1)



#define BCM54XX_WOL_MAIN_CTL		(MII_BCM54XX_EXP_SEL_WOL + 0x80)
#define  BCM54XX_WOL_EN			BIT(0)
#define  BCM54XX_WOL_MODE_SINGLE_MPD	0
#define  BCM54XX_WOL_MODE_SINGLE_MPDSEC	1
#define  BCM54XX_WOL_MODE_DUAL		2
#define  BCM54XX_WOL_MODE_SHIFT		1
#define  BCM54XX_WOL_MODE_MASK		0x3
#define  BCM54XX_WOL_MP_MSB_FF_EN	BIT(3)
#define  BCM54XX_WOL_SECKEY_OPT_4B	0
#define  BCM54XX_WOL_SECKEY_OPT_6B	1
#define  BCM54XX_WOL_SECKEY_OPT_8B	2
#define  BCM54XX_WOL_SECKEY_OPT_SHIFT	4
#define  BCM54XX_WOL_SECKEY_OPT_MASK	0x3
#define  BCM54XX_WOL_L2_TYPE_CHK	BIT(6)
#define  BCM54XX_WOL_L4IPV4UDP_CHK	BIT(7)
#define  BCM54XX_WOL_L4IPV6UDP_CHK	BIT(8)
#define  BCM54XX_WOL_UDPPORT_CHK	BIT(9)
#define  BCM54XX_WOL_CRC_CHK		BIT(10)
#define  BCM54XX_WOL_SECKEY_MODE	BIT(11)
#define  BCM54XX_WOL_RST		BIT(12)
#define  BCM54XX_WOL_DIR_PKT_EN		BIT(13)
#define  BCM54XX_WOL_MASK_MODE_DA_FF	0
#define  BCM54XX_WOL_MASK_MODE_DA_MPD	1
#define  BCM54XX_WOL_MASK_MODE_DA_ONLY	2
#define  BCM54XX_WOL_MASK_MODE_MPD	3
#define  BCM54XX_WOL_MASK_MODE_SHIFT	14
#define  BCM54XX_WOL_MASK_MODE_MASK	0x3

#define BCM54XX_WOL_INNER_PROTO		(MII_BCM54XX_EXP_SEL_WOL + 0x81)
#define BCM54XX_WOL_OUTER_PROTO		(MII_BCM54XX_EXP_SEL_WOL + 0x82)
#define BCM54XX_WOL_OUTER_PROTO2	(MII_BCM54XX_EXP_SEL_WOL + 0x83)

#define BCM54XX_WOL_MPD_DATA1(x)	(MII_BCM54XX_EXP_SEL_WOL + 0x84 + (x))
#define BCM54XX_WOL_MPD_DATA2(x)	(MII_BCM54XX_EXP_SEL_WOL + 0x87 + (x))
#define BCM54XX_WOL_SEC_KEY_8B		(MII_BCM54XX_EXP_SEL_WOL + 0x8A)
#define BCM54XX_WOL_MASK(x)		(MII_BCM54XX_EXP_SEL_WOL + 0x8B + (x))
#define BCM54XX_SEC_KEY_STORE(x)	(MII_BCM54XX_EXP_SEL_WOL + 0x8E)
#define BCM54XX_WOL_SHARED_CNT		(MII_BCM54XX_EXP_SEL_WOL + 0x92)

#define BCM54XX_WOL_INT_MASK		(MII_BCM54XX_EXP_SEL_WOL + 0x93)
#define  BCM54XX_WOL_PKT1		BIT(0)
#define  BCM54XX_WOL_PKT2		BIT(1)
#define  BCM54XX_WOL_DIR		BIT(2)
#define  BCM54XX_WOL_ALL_INTRS		(BCM54XX_WOL_PKT1 | \
					 BCM54XX_WOL_PKT2 | \
					 BCM54XX_WOL_DIR)

#define BCM54XX_WOL_INT_STATUS		(MII_BCM54XX_EXP_SEL_WOL + 0x94)


#define BCM5221_AEGSR			0x1C
#define BCM5221_AEGSR_MDIX_STATUS	BIT(13)
#define BCM5221_AEGSR_MDIX_MAN_SWAP	BIT(12)
#define BCM5221_AEGSR_MDIX_DIS		BIT(11)

#define BCM5221_SHDW_AM4_EN_CLK_LPM	BIT(2)
#define BCM5221_SHDW_AM4_FORCE_LPM	BIT(1)





#define MII_BRCM_FET_INTREG		0x1a	
#define MII_BRCM_FET_IR_MASK		0x0100	
#define MII_BRCM_FET_IR_LINK_EN		0x0200	
#define MII_BRCM_FET_IR_SPEED_EN	0x0400	
#define MII_BRCM_FET_IR_DUPLEX_EN	0x0800	
#define MII_BRCM_FET_IR_ENABLE		0x4000	

#define MII_BRCM_FET_BRCMTEST		0x1f	
#define MII_BRCM_FET_BT_SRE		0x0080	




#define MII_BRCM_FET_SHDW_MISCCTRL	0x10	
#define MII_BRCM_FET_SHDW_MC_FAME	0x4000	

#define MII_BRCM_FET_SHDW_AUXMODE4	0x1a	
#define MII_BRCM_FET_SHDW_AM4_STANDBY	0x0008	
#define MII_BRCM_FET_SHDW_AM4_LED_MASK	0x0003
#define MII_BRCM_FET_SHDW_AM4_LED_MODE1 0x0001

#define MII_BRCM_FET_SHDW_AUXSTAT2	0x1b	
#define MII_BRCM_FET_SHDW_AS2_APDE	0x0020	

#define BRCM_CL45VEN_EEE_CONTROL	0x803d
#define LPI_FEATURE_EN			0x8000
#define LPI_FEATURE_EN_DIG1000X		0x4000

#define BRCM_CL45VEN_EEE_LPI_CNT	0x803f


#define MII_BRCM_CORE_BASE12	0x12
#define MII_BRCM_CORE_BASE13	0x13
#define MII_BRCM_CORE_BASE14	0x14
#define MII_BRCM_CORE_BASE1E	0x1E
#define MII_BRCM_CORE_EXPB0	0xB0
#define MII_BRCM_CORE_EXPB1	0xB1


#define BCM54XX_RDB_ECD_CTRL			0x2a0
#define BCM54XX_EXP_ECD_CTRL			(MII_BCM54XX_EXP_SEL_ER + 0xc0)

#define BCM54XX_ECD_CTRL_CABLE_TYPE_CAT3	1	
#define BCM54XX_ECD_CTRL_CABLE_TYPE_CAT5	0	
#define BCM54XX_ECD_CTRL_CABLE_TYPE_MASK	BIT(0)	
#define BCM54XX_ECD_CTRL_INVALID		BIT(3)	
#define BCM54XX_ECD_CTRL_UNIT_CM		0	
#define BCM54XX_ECD_CTRL_UNIT_M			1	
#define BCM54XX_ECD_CTRL_UNIT_MASK		BIT(10)	
#define BCM54XX_ECD_CTRL_IN_PROGRESS		BIT(11)	
#define BCM54XX_ECD_CTRL_BREAK_LINK		BIT(12)	
#define BCM54XX_ECD_CTRL_CROSS_SHORT_DIS	BIT(13)	
#define BCM54XX_ECD_CTRL_RUN			BIT(15)	

#define BCM54XX_RDB_ECD_FAULT_TYPE		0x2a1
#define BCM54XX_EXP_ECD_FAULT_TYPE		(MII_BCM54XX_EXP_SEL_ER + 0xc1)
#define BCM54XX_ECD_FAULT_TYPE_INVALID		0x0
#define BCM54XX_ECD_FAULT_TYPE_OK		0x1
#define BCM54XX_ECD_FAULT_TYPE_OPEN		0x2
#define BCM54XX_ECD_FAULT_TYPE_SAME_SHORT	0x3 
#define BCM54XX_ECD_FAULT_TYPE_CROSS_SHORT	0x4 
#define BCM54XX_ECD_FAULT_TYPE_BUSY		0x9
#define BCM54XX_ECD_FAULT_TYPE_PAIR_D_MASK	GENMASK(3, 0)
#define BCM54XX_ECD_FAULT_TYPE_PAIR_C_MASK	GENMASK(7, 4)
#define BCM54XX_ECD_FAULT_TYPE_PAIR_B_MASK	GENMASK(11, 8)
#define BCM54XX_ECD_FAULT_TYPE_PAIR_A_MASK	GENMASK(15, 12)
#define BCM54XX_ECD_PAIR_A_LENGTH_RESULTS	0x2a2
#define BCM54XX_ECD_PAIR_B_LENGTH_RESULTS	0x2a3
#define BCM54XX_ECD_PAIR_C_LENGTH_RESULTS	0x2a4
#define BCM54XX_ECD_PAIR_D_LENGTH_RESULTS	0x2a5

#define BCM54XX_RDB_ECD_PAIR_A_LENGTH_RESULTS	0x2a2
#define BCM54XX_EXP_ECD_PAIR_A_LENGTH_RESULTS	(MII_BCM54XX_EXP_SEL_ER + 0xc2)
#define BCM54XX_RDB_ECD_PAIR_B_LENGTH_RESULTS	0x2a3
#define BCM54XX_EXP_ECD_PAIR_B_LENGTH_RESULTS	(MII_BCM54XX_EXP_SEL_ER + 0xc3)
#define BCM54XX_RDB_ECD_PAIR_C_LENGTH_RESULTS	0x2a4
#define BCM54XX_EXP_ECD_PAIR_C_LENGTH_RESULTS	(MII_BCM54XX_EXP_SEL_ER + 0xc4)
#define BCM54XX_RDB_ECD_PAIR_D_LENGTH_RESULTS	0x2a5
#define BCM54XX_EXP_ECD_PAIR_D_LENGTH_RESULTS	(MII_BCM54XX_EXP_SEL_ER + 0xc5)
#define BCM54XX_ECD_LENGTH_RESULTS_INVALID	0xffff

#endif 
