/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _FS_CEPH_DEBUG_H
#define _FS_CEPH_DEBUG_H

#define pr_fmt(fmt) KBUILD_MODNAME ": " fmt

#include <linux/string.h>

#ifdef CONFIG_CEPH_LIB_PRETTYDEBUG



# if defined(DEBUG) || defined(CONFIG_DYNAMIC_DEBUG)
#  define dout(fmt, ...)						\
	pr_debug("%.*s %12.12s:%-4d : " fmt,				\
		 8 - (int)sizeof(KBUILD_MODNAME), "    ",		\
		 kbasename(__FILE__), __LINE__, ##__VA_ARGS__)
#  define doutc(client, fmt, ...)					\
	pr_debug("%.*s %12.12s:%-4d : [%pU %llu] " fmt,			\
		 8 - (int)sizeof(KBUILD_MODNAME), "    ",		\
		 kbasename(__FILE__), __LINE__,				\
		 &client->fsid, client->monc.auth->global_id,		\
		 ##__VA_ARGS__)
# else

#  define dout(fmt, ...)					\
		no_printk(KERN_DEBUG fmt, ##__VA_ARGS__)
#  define doutc(client, fmt, ...)				\
		no_printk(KERN_DEBUG "[%pU %llu] " fmt,		\
			  &client->fsid,			\
			  client->monc.auth->global_id,		\
			  ##__VA_ARGS__)
# endif

#else


# define dout(fmt, ...)	pr_debug(" " fmt, ##__VA_ARGS__)
# define doutc(client, fmt, ...)					\
	pr_debug(" [%pU %llu] %s: " fmt, &client->fsid,			\
		 client->monc.auth->global_id, __func__, ##__VA_ARGS__)

#endif

#define pr_notice_client(client, fmt, ...)				\
	pr_notice("[%pU %llu]: " fmt, &client->fsid,			\
		  client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_info_client(client, fmt, ...)				\
	pr_info("[%pU %llu]: " fmt, &client->fsid,			\
		client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_warn_client(client, fmt, ...)				\
	pr_warn("[%pU %llu]: " fmt, &client->fsid,			\
		client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_warn_once_client(client, fmt, ...)				\
	pr_warn_once("[%pU %llu]: " fmt, &client->fsid,			\
		     client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_err_client(client, fmt, ...)					\
	pr_err("[%pU %llu]: " fmt, &client->fsid,			\
	       client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_warn_ratelimited_client(client, fmt, ...)			\
	pr_warn_ratelimited("[%pU %llu]: " fmt, &client->fsid,		\
			    client->monc.auth->global_id, ##__VA_ARGS__)
#define pr_err_ratelimited_client(client, fmt, ...)			\
	pr_err_ratelimited("[%pU %llu]: " fmt, &client->fsid,		\
			   client->monc.auth->global_id, ##__VA_ARGS__)

#endif
