/* SPDX-License-Identifier: GPL-2.0 */


#ifndef DECOMPR_MM_H
#define DECOMPR_MM_H

#ifdef STATIC




#ifndef STATIC_RW_DATA
#define STATIC_RW_DATA static
#endif


#ifndef MALLOC_VISIBLE
#define MALLOC_VISIBLE static
#endif


STATIC_RW_DATA unsigned long malloc_ptr;
STATIC_RW_DATA int malloc_count;

MALLOC_VISIBLE void *malloc(int size)
{
	void *p;

	if (size < 0)
		return NULL;
	if (!malloc_ptr)
		malloc_ptr = free_mem_ptr;

	malloc_ptr = (malloc_ptr + 7) & ~7;     

	p = (void *)malloc_ptr;
	malloc_ptr += size;

	if (free_mem_end_ptr && malloc_ptr >= free_mem_end_ptr)
		return NULL;

	malloc_count++;
	return p;
}

MALLOC_VISIBLE void free(void *where)
{
	malloc_count--;
	if (!malloc_count)
		malloc_ptr = free_mem_ptr;
}

#define large_malloc(a) malloc(a)
#define large_free(a) free(a)

#define INIT

#else 



#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>



#define malloc(a) kmalloc(a, GFP_KERNEL)
#define free(a) kfree(a)

#define large_malloc(a) vmalloc(a)
#define large_free(a) vfree(a)

#define INIT __init
#define STATIC

#include <linux/init.h>

#endif 

#endif 
