/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_ERR_H
#define _LINUX_ERR_H

#include <linux/compiler.h>
#include <linux/types.h>

#include <asm/errno.h>


#define MAX_ERRNO	4095

#ifndef __ASSEMBLY__


#define IS_ERR_VALUE(x) unlikely((unsigned long)(void *)(x) >= (unsigned long)-MAX_ERRNO)


static inline void * __must_check ERR_PTR(long error)
{
	return (void *) error;
}


#define ERR_PTR_PCPU(error) ((void __percpu *)(unsigned long)ERR_PTR(error))


static inline long __must_check PTR_ERR(__force const void *ptr)
{
	return (long) ptr;
}


#define PTR_ERR_PCPU(ptr) (PTR_ERR((const void *)(__force const unsigned long)(ptr)))


static inline bool __must_check IS_ERR(__force const void *ptr)
{
	return IS_ERR_VALUE((unsigned long)ptr);
}


#define IS_ERR_PCPU(ptr) (IS_ERR((const void *)(__force const unsigned long)(ptr)))


static inline bool __must_check IS_ERR_OR_NULL(__force const void *ptr)
{
	return unlikely(!ptr) || IS_ERR_VALUE((unsigned long)ptr);
}


static inline void * __must_check ERR_CAST(__force const void *ptr)
{
	
	return (void *) ptr;
}


static inline int __must_check PTR_ERR_OR_ZERO(__force const void *ptr)
{
	if (IS_ERR(ptr))
		return PTR_ERR(ptr);
	else
		return 0;
}

#endif

#endif 
