/* SPDX-License-Identifier: GPL-2.0+ */


#ifndef _SC_PM_API_H
#define _SC_PM_API_H

#include <linux/firmware/imx/sci.h>


enum imx_sc_pm_func {
	IMX_SC_PM_FUNC_UNKNOWN = 0,
	IMX_SC_PM_FUNC_SET_SYS_POWER_MODE = 19,
	IMX_SC_PM_FUNC_SET_PARTITION_POWER_MODE = 1,
	IMX_SC_PM_FUNC_GET_SYS_POWER_MODE = 2,
	IMX_SC_PM_FUNC_SET_RESOURCE_POWER_MODE = 3,
	IMX_SC_PM_FUNC_GET_RESOURCE_POWER_MODE = 4,
	IMX_SC_PM_FUNC_REQ_LOW_POWER_MODE = 16,
	IMX_SC_PM_FUNC_SET_CPU_RESUME_ADDR = 17,
	IMX_SC_PM_FUNC_REQ_SYS_IF_POWER_MODE = 18,
	IMX_SC_PM_FUNC_SET_CLOCK_RATE = 5,
	IMX_SC_PM_FUNC_GET_CLOCK_RATE = 6,
	IMX_SC_PM_FUNC_CLOCK_ENABLE = 7,
	IMX_SC_PM_FUNC_SET_CLOCK_PARENT = 14,
	IMX_SC_PM_FUNC_GET_CLOCK_PARENT = 15,
	IMX_SC_PM_FUNC_RESET = 13,
	IMX_SC_PM_FUNC_RESET_REASON = 10,
	IMX_SC_PM_FUNC_BOOT = 8,
	IMX_SC_PM_FUNC_REBOOT = 9,
	IMX_SC_PM_FUNC_REBOOT_PARTITION = 12,
	IMX_SC_PM_FUNC_CPU_START = 11,
};


#define IMX_SC_PM_CLK_ALL		UINT8_MAX	


#define IMX_SC_PM_PW_MODE_OFF	0	
#define IMX_SC_PM_PW_MODE_STBY	1	
#define IMX_SC_PM_PW_MODE_LP	2	
#define IMX_SC_PM_PW_MODE_ON	3	


#define IMX_SC_PM_CLK_SLV_BUS	0	
#define IMX_SC_PM_CLK_MST_BUS	1	
#define IMX_SC_PM_CLK_PER	2	
#define IMX_SC_PM_CLK_PHY	3	
#define IMX_SC_PM_CLK_MISC	4	
#define IMX_SC_PM_CLK_MISC0	0	
#define IMX_SC_PM_CLK_MISC1	1	
#define IMX_SC_PM_CLK_MISC2	2	
#define IMX_SC_PM_CLK_MISC3	3	
#define IMX_SC_PM_CLK_MISC4	4	
#define IMX_SC_PM_CLK_CPU	2	
#define IMX_SC_PM_CLK_PLL	4	
#define IMX_SC_PM_CLK_BYPASS	4	


#define IMX_SC_PM_PARENT_XTAL	0	
#define IMX_SC_PM_PARENT_PLL0	1	
#define IMX_SC_PM_PARENT_PLL1	2	
#define IMX_SC_PM_PARENT_PLL2	3	
#define IMX_SC_PM_PARENT_BYPS	4	

#endif 
