/* SPDX-License-Identifier: GPL-2.0-or-later */


#ifndef _LINUX_I2C_OF_PROBER_H
#define _LINUX_I2C_OF_PROBER_H

#include <linux/kconfig.h>
#include <linux/types.h>

struct device;
struct device_node;


struct i2c_of_probe_ops {
	
	int (*enable)(struct device *dev, struct device_node *bus_node, void *data);

	
	void (*cleanup_early)(struct device *dev, void *data);

	
	void (*cleanup)(struct device *dev, void *data);
};


struct i2c_of_probe_cfg {
	const struct i2c_of_probe_ops *ops;
	const char *type;
};

#if IS_ENABLED(CONFIG_OF_DYNAMIC)

int i2c_of_probe_component(struct device *dev, const struct i2c_of_probe_cfg *cfg, void *ctx);




struct i2c_of_probe_simple_opts {
	const char *res_node_compatible;
	const char *supply_name;
	const char *gpio_name;
	unsigned int post_power_on_delay_ms;
	unsigned int post_gpio_config_delay_ms;
	bool gpio_assert_to_enable;
};

struct gpio_desc;
struct regulator;

struct i2c_of_probe_simple_ctx {
	
	const struct i2c_of_probe_simple_opts *opts;
	
	struct regulator *supply;
	struct gpio_desc *gpiod;
};

int i2c_of_probe_simple_enable(struct device *dev, struct device_node *bus_node, void *data);
void i2c_of_probe_simple_cleanup_early(struct device *dev, void *data);
void i2c_of_probe_simple_cleanup(struct device *dev, void *data);

extern struct i2c_of_probe_ops i2c_of_probe_simple_ops;

#endif 

#endif 
