/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef _ARIZONA_REGISTERS_H
#define _ARIZONA_REGISTERS_H


#define ARIZONA_SOFTWARE_RESET                   0x00
#define ARIZONA_DEVICE_REVISION                  0x01
#define ARIZONA_CTRL_IF_SPI_CFG_1                0x08
#define ARIZONA_CTRL_IF_I2C1_CFG_1               0x09
#define ARIZONA_CTRL_IF_I2C2_CFG_1               0x0A
#define ARIZONA_CTRL_IF_I2C1_CFG_2               0x0B
#define ARIZONA_CTRL_IF_I2C2_CFG_2               0x0C
#define ARIZONA_CTRL_IF_STATUS_1                 0x0D
#define ARIZONA_WRITE_SEQUENCER_CTRL_0           0x16
#define ARIZONA_WRITE_SEQUENCER_CTRL_1           0x17
#define ARIZONA_WRITE_SEQUENCER_CTRL_2           0x18
#define ARIZONA_WRITE_SEQUENCER_CTRL_3           0x19
#define ARIZONA_WRITE_SEQUENCER_PROM             0x1A
#define ARIZONA_TONE_GENERATOR_1                 0x20
#define ARIZONA_TONE_GENERATOR_2                 0x21
#define ARIZONA_TONE_GENERATOR_3                 0x22
#define ARIZONA_TONE_GENERATOR_4                 0x23
#define ARIZONA_TONE_GENERATOR_5                 0x24
#define ARIZONA_PWM_DRIVE_1                      0x30
#define ARIZONA_PWM_DRIVE_2                      0x31
#define ARIZONA_PWM_DRIVE_3                      0x32
#define ARIZONA_WAKE_CONTROL                     0x40
#define ARIZONA_SEQUENCE_CONTROL                 0x41
#define ARIZONA_SPARE_TRIGGERS                   0x42
#define ARIZONA_SAMPLE_RATE_SEQUENCE_SELECT_1    0x61
#define ARIZONA_SAMPLE_RATE_SEQUENCE_SELECT_2    0x62
#define ARIZONA_SAMPLE_RATE_SEQUENCE_SELECT_3    0x63
#define ARIZONA_SAMPLE_RATE_SEQUENCE_SELECT_4    0x64
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_1 0x66
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_2 0x67
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_3 0x68
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_4 0x69
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_5 0x6A
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_6 0x6B
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_7 0x6C
#define ARIZONA_ALWAYS_ON_TRIGGERS_SEQUENCE_SELECT_8 0x6D
#define ARIZONA_COMFORT_NOISE_GENERATOR          0x70
#define ARIZONA_HAPTICS_CONTROL_1                0x90
#define ARIZONA_HAPTICS_CONTROL_2                0x91
#define ARIZONA_HAPTICS_PHASE_1_INTENSITY        0x92
#define ARIZONA_HAPTICS_PHASE_1_DURATION         0x93
#define ARIZONA_HAPTICS_PHASE_2_INTENSITY        0x94
#define ARIZONA_HAPTICS_PHASE_2_DURATION         0x95
#define ARIZONA_HAPTICS_PHASE_3_INTENSITY        0x96
#define ARIZONA_HAPTICS_PHASE_3_DURATION         0x97
#define ARIZONA_HAPTICS_STATUS                   0x98
#define ARIZONA_CLOCK_32K_1                      0x100
#define ARIZONA_SYSTEM_CLOCK_1                   0x101
#define ARIZONA_SAMPLE_RATE_1                    0x102
#define ARIZONA_SAMPLE_RATE_2                    0x103
#define ARIZONA_SAMPLE_RATE_3                    0x104
#define ARIZONA_SAMPLE_RATE_1_STATUS             0x10A
#define ARIZONA_SAMPLE_RATE_2_STATUS             0x10B
#define ARIZONA_SAMPLE_RATE_3_STATUS             0x10C
#define ARIZONA_ASYNC_CLOCK_1                    0x112
#define ARIZONA_ASYNC_SAMPLE_RATE_1              0x113
#define ARIZONA_ASYNC_SAMPLE_RATE_2              0x114
#define ARIZONA_ASYNC_SAMPLE_RATE_1_STATUS       0x11B
#define ARIZONA_ASYNC_SAMPLE_RATE_2_STATUS       0x11C
#define ARIZONA_OUTPUT_SYSTEM_CLOCK              0x149
#define ARIZONA_OUTPUT_ASYNC_CLOCK               0x14A
#define ARIZONA_RATE_ESTIMATOR_1                 0x152
#define ARIZONA_RATE_ESTIMATOR_2                 0x153
#define ARIZONA_RATE_ESTIMATOR_3                 0x154
#define ARIZONA_RATE_ESTIMATOR_4                 0x155
#define ARIZONA_RATE_ESTIMATOR_5                 0x156
#define ARIZONA_DYNAMIC_FREQUENCY_SCALING_1      0x161
#define ARIZONA_FLL1_CONTROL_1                   0x171
#define ARIZONA_FLL1_CONTROL_2                   0x172
#define ARIZONA_FLL1_CONTROL_3                   0x173
#define ARIZONA_FLL1_CONTROL_4                   0x174
#define ARIZONA_FLL1_CONTROL_5                   0x175
#define ARIZONA_FLL1_CONTROL_6                   0x176
#define ARIZONA_FLL1_LOOP_FILTER_TEST_1          0x177
#define ARIZONA_FLL1_NCO_TEST_0                  0x178
#define ARIZONA_FLL1_CONTROL_7                   0x179
#define ARIZONA_FLL1_SYNCHRONISER_1              0x181
#define ARIZONA_FLL1_SYNCHRONISER_2              0x182
#define ARIZONA_FLL1_SYNCHRONISER_3              0x183
#define ARIZONA_FLL1_SYNCHRONISER_4              0x184
#define ARIZONA_FLL1_SYNCHRONISER_5              0x185
#define ARIZONA_FLL1_SYNCHRONISER_6              0x186
#define ARIZONA_FLL1_SYNCHRONISER_7              0x187
#define ARIZONA_FLL1_SPREAD_SPECTRUM             0x189
#define ARIZONA_FLL1_GPIO_CLOCK                  0x18A
#define ARIZONA_FLL2_CONTROL_1                   0x191
#define ARIZONA_FLL2_CONTROL_2                   0x192
#define ARIZONA_FLL2_CONTROL_3                   0x193
#define ARIZONA_FLL2_CONTROL_4                   0x194
#define ARIZONA_FLL2_CONTROL_5                   0x195
#define ARIZONA_FLL2_CONTROL_6                   0x196
#define ARIZONA_FLL2_LOOP_FILTER_TEST_1          0x197
#define ARIZONA_FLL2_NCO_TEST_0                  0x198
#define ARIZONA_FLL2_CONTROL_7                   0x199
#define ARIZONA_FLL2_SYNCHRONISER_1              0x1A1
#define ARIZONA_FLL2_SYNCHRONISER_2              0x1A2
#define ARIZONA_FLL2_SYNCHRONISER_3              0x1A3
#define ARIZONA_FLL2_SYNCHRONISER_4              0x1A4
#define ARIZONA_FLL2_SYNCHRONISER_5              0x1A5
#define ARIZONA_FLL2_SYNCHRONISER_6              0x1A6
#define ARIZONA_FLL2_SYNCHRONISER_7              0x1A7
#define ARIZONA_FLL2_SPREAD_SPECTRUM             0x1A9
#define ARIZONA_FLL2_GPIO_CLOCK                  0x1AA
#define ARIZONA_MIC_CHARGE_PUMP_1                0x200
#define ARIZONA_LDO1_CONTROL_1                   0x210
#define ARIZONA_LDO1_CONTROL_2                   0x212
#define ARIZONA_LDO2_CONTROL_1                   0x213
#define ARIZONA_MIC_BIAS_CTRL_1                  0x218
#define ARIZONA_MIC_BIAS_CTRL_2                  0x219
#define ARIZONA_MIC_BIAS_CTRL_3                  0x21A
#define ARIZONA_HP_CTRL_1L                       0x225
#define ARIZONA_HP_CTRL_1R                       0x226
#define ARIZONA_ACCESSORY_DETECT_MODE_1          0x293
#define ARIZONA_HEADPHONE_DETECT_1               0x29B
#define ARIZONA_HEADPHONE_DETECT_2               0x29C
#define ARIZONA_HP_DACVAL			 0x29F
#define ARIZONA_MICD_CLAMP_CONTROL               0x2A2
#define ARIZONA_MIC_DETECT_1                     0x2A3
#define ARIZONA_MIC_DETECT_2                     0x2A4
#define ARIZONA_MIC_DETECT_3                     0x2A5
#define ARIZONA_MIC_DETECT_LEVEL_1		 0x2A6
#define ARIZONA_MIC_DETECT_LEVEL_2		 0x2A7
#define ARIZONA_MIC_DETECT_LEVEL_3		 0x2A8
#define ARIZONA_MIC_DETECT_LEVEL_4		 0x2A9
#define ARIZONA_MIC_DETECT_4                     0x2AB
#define ARIZONA_MIC_NOISE_MIX_CONTROL_1          0x2C3
#define ARIZONA_ISOLATION_CONTROL                0x2CB
#define ARIZONA_JACK_DETECT_ANALOGUE             0x2D3
#define ARIZONA_INPUT_ENABLES                    0x300
#define ARIZONA_INPUT_ENABLES_STATUS             0x301
#define ARIZONA_INPUT_RATE                       0x308
#define ARIZONA_INPUT_VOLUME_RAMP                0x309
#define ARIZONA_HPF_CONTROL                      0x30C
#define ARIZONA_IN1L_CONTROL                     0x310
#define ARIZONA_ADC_DIGITAL_VOLUME_1L            0x311
#define ARIZONA_DMIC1L_CONTROL                   0x312
#define ARIZONA_IN1R_CONTROL                     0x314
#define ARIZONA_ADC_DIGITAL_VOLUME_1R            0x315
#define ARIZONA_DMIC1R_CONTROL                   0x316
#define ARIZONA_IN2L_CONTROL                     0x318
#define ARIZONA_ADC_DIGITAL_VOLUME_2L            0x319
#define ARIZONA_DMIC2L_CONTROL                   0x31A
#define ARIZONA_IN2R_CONTROL                     0x31C
#define ARIZONA_ADC_DIGITAL_VOLUME_2R            0x31D
#define ARIZONA_DMIC2R_CONTROL                   0x31E
#define ARIZONA_IN3L_CONTROL                     0x320
#define ARIZONA_ADC_DIGITAL_VOLUME_3L            0x321
#define ARIZONA_DMIC3L_CONTROL                   0x322
#define ARIZONA_IN3R_CONTROL                     0x324
#define ARIZONA_ADC_DIGITAL_VOLUME_3R            0x325
#define ARIZONA_DMIC3R_CONTROL                   0x326
#define ARIZONA_IN4L_CONTROL                     0x328
#define ARIZONA_ADC_DIGITAL_VOLUME_4L            0x329
#define ARIZONA_DMIC4L_CONTROL                   0x32A
#define ARIZONA_IN4R_CONTROL                     0x32C
#define ARIZONA_ADC_DIGITAL_VOLUME_4R            0x32D
#define ARIZONA_DMIC4R_CONTROL                   0x32E
#define ARIZONA_OUTPUT_ENABLES_1                 0x400
#define ARIZONA_OUTPUT_STATUS_1                  0x401
#define ARIZONA_RAW_OUTPUT_STATUS_1              0x406
#define ARIZONA_OUTPUT_RATE_1                    0x408
#define ARIZONA_OUTPUT_VOLUME_RAMP               0x409
#define ARIZONA_OUTPUT_PATH_CONFIG_1L            0x410
#define ARIZONA_DAC_DIGITAL_VOLUME_1L            0x411
#define ARIZONA_DAC_VOLUME_LIMIT_1L              0x412
#define ARIZONA_NOISE_GATE_SELECT_1L             0x413
#define ARIZONA_OUTPUT_PATH_CONFIG_1R            0x414
#define ARIZONA_DAC_DIGITAL_VOLUME_1R            0x415
#define ARIZONA_DAC_VOLUME_LIMIT_1R              0x416
#define ARIZONA_NOISE_GATE_SELECT_1R             0x417
#define ARIZONA_OUTPUT_PATH_CONFIG_2L            0x418
#define ARIZONA_DAC_DIGITAL_VOLUME_2L            0x419
#define ARIZONA_DAC_VOLUME_LIMIT_2L              0x41A
#define ARIZONA_NOISE_GATE_SELECT_2L             0x41B
#define ARIZONA_OUTPUT_PATH_CONFIG_2R            0x41C
#define ARIZONA_DAC_DIGITAL_VOLUME_2R            0x41D
#define ARIZONA_DAC_VOLUME_LIMIT_2R              0x41E
#define ARIZONA_NOISE_GATE_SELECT_2R             0x41F
#define ARIZONA_OUTPUT_PATH_CONFIG_3L            0x420
#define ARIZONA_DAC_DIGITAL_VOLUME_3L            0x421
#define ARIZONA_DAC_VOLUME_LIMIT_3L              0x422
#define ARIZONA_NOISE_GATE_SELECT_3L             0x423
#define ARIZONA_OUTPUT_PATH_CONFIG_3R            0x424
#define ARIZONA_DAC_DIGITAL_VOLUME_3R            0x425
#define ARIZONA_DAC_VOLUME_LIMIT_3R              0x426
#define ARIZONA_NOISE_GATE_SELECT_3R             0x427
#define ARIZONA_OUTPUT_PATH_CONFIG_4L            0x428
#define ARIZONA_DAC_DIGITAL_VOLUME_4L            0x429
#define ARIZONA_OUT_VOLUME_4L                    0x42A
#define ARIZONA_NOISE_GATE_SELECT_4L             0x42B
#define ARIZONA_OUTPUT_PATH_CONFIG_4R            0x42C
#define ARIZONA_DAC_DIGITAL_VOLUME_4R            0x42D
#define ARIZONA_OUT_VOLUME_4R                    0x42E
#define ARIZONA_NOISE_GATE_SELECT_4R             0x42F
#define ARIZONA_OUTPUT_PATH_CONFIG_5L            0x430
#define ARIZONA_DAC_DIGITAL_VOLUME_5L            0x431
#define ARIZONA_DAC_VOLUME_LIMIT_5L              0x432
#define ARIZONA_NOISE_GATE_SELECT_5L             0x433
#define ARIZONA_OUTPUT_PATH_CONFIG_5R            0x434
#define ARIZONA_DAC_DIGITAL_VOLUME_5R            0x435
#define ARIZONA_DAC_VOLUME_LIMIT_5R              0x436
#define ARIZONA_NOISE_GATE_SELECT_5R             0x437
#define ARIZONA_OUTPUT_PATH_CONFIG_6L            0x438
#define ARIZONA_DAC_DIGITAL_VOLUME_6L            0x439
#define ARIZONA_DAC_VOLUME_LIMIT_6L              0x43A
#define ARIZONA_NOISE_GATE_SELECT_6L             0x43B
#define ARIZONA_OUTPUT_PATH_CONFIG_6R            0x43C
#define ARIZONA_DAC_DIGITAL_VOLUME_6R            0x43D
#define ARIZONA_DAC_VOLUME_LIMIT_6R              0x43E
#define ARIZONA_NOISE_GATE_SELECT_6R             0x43F
#define ARIZONA_DRE_ENABLE                       0x440
#define ARIZONA_DRE_CONTROL_1                    0x441
#define ARIZONA_DRE_CONTROL_2                    0x442
#define ARIZONA_DRE_CONTROL_3                    0x443
#define ARIZONA_EDRE_ENABLE                      0x448
#define ARIZONA_DAC_AEC_CONTROL_1                0x450
#define ARIZONA_DAC_AEC_CONTROL_2                0x451
#define ARIZONA_NOISE_GATE_CONTROL               0x458
#define ARIZONA_PDM_SPK1_CTRL_1                  0x490
#define ARIZONA_PDM_SPK1_CTRL_2                  0x491
#define ARIZONA_PDM_SPK2_CTRL_1                  0x492
#define ARIZONA_PDM_SPK2_CTRL_2                  0x493
#define ARIZONA_HP_TEST_CTRL_13                  0x49A
#define ARIZONA_HP1_SHORT_CIRCUIT_CTRL           0x4A0
#define ARIZONA_HP2_SHORT_CIRCUIT_CTRL           0x4A1
#define ARIZONA_HP3_SHORT_CIRCUIT_CTRL           0x4A2
#define ARIZONA_HP_TEST_CTRL_1                   0x4A4
#define ARIZONA_SPK_CTRL_2                       0x4B5
#define ARIZONA_SPK_CTRL_3                       0x4B6
#define ARIZONA_DAC_COMP_1                       0x4DC
#define ARIZONA_DAC_COMP_2                       0x4DD
#define ARIZONA_DAC_COMP_3                       0x4DE
#define ARIZONA_DAC_COMP_4                       0x4DF
#define ARIZONA_AIF1_BCLK_CTRL                   0x500
#define ARIZONA_AIF1_TX_PIN_CTRL                 0x501
#define ARIZONA_AIF1_RX_PIN_CTRL                 0x502
#define ARIZONA_AIF1_RATE_CTRL                   0x503
#define ARIZONA_AIF1_FORMAT                      0x504
#define ARIZONA_AIF1_TX_BCLK_RATE                0x505
#define ARIZONA_AIF1_RX_BCLK_RATE                0x506
#define ARIZONA_AIF1_FRAME_CTRL_1                0x507
#define ARIZONA_AIF1_FRAME_CTRL_2                0x508
#define ARIZONA_AIF1_FRAME_CTRL_3                0x509
#define ARIZONA_AIF1_FRAME_CTRL_4                0x50A
#define ARIZONA_AIF1_FRAME_CTRL_5                0x50B
#define ARIZONA_AIF1_FRAME_CTRL_6                0x50C
#define ARIZONA_AIF1_FRAME_CTRL_7                0x50D
#define ARIZONA_AIF1_FRAME_CTRL_8                0x50E
#define ARIZONA_AIF1_FRAME_CTRL_9                0x50F
#define ARIZONA_AIF1_FRAME_CTRL_10               0x510
#define ARIZONA_AIF1_FRAME_CTRL_11               0x511
#define ARIZONA_AIF1_FRAME_CTRL_12               0x512
#define ARIZONA_AIF1_FRAME_CTRL_13               0x513
#define ARIZONA_AIF1_FRAME_CTRL_14               0x514
#define ARIZONA_AIF1_FRAME_CTRL_15               0x515
#define ARIZONA_AIF1_FRAME_CTRL_16               0x516
#define ARIZONA_AIF1_FRAME_CTRL_17               0x517
#define ARIZONA_AIF1_FRAME_CTRL_18               0x518
#define ARIZONA_AIF1_TX_ENABLES                  0x519
#define ARIZONA_AIF1_RX_ENABLES                  0x51A
#define ARIZONA_AIF1_FORCE_WRITE                 0x51B
#define ARIZONA_AIF2_BCLK_CTRL                   0x540
#define ARIZONA_AIF2_TX_PIN_CTRL                 0x541
#define ARIZONA_AIF2_RX_PIN_CTRL                 0x542
#define ARIZONA_AIF2_RATE_CTRL                   0x543
#define ARIZONA_AIF2_FORMAT                      0x544
#define ARIZONA_AIF2_TX_BCLK_RATE                0x545
#define ARIZONA_AIF2_RX_BCLK_RATE                0x546
#define ARIZONA_AIF2_FRAME_CTRL_1                0x547
#define ARIZONA_AIF2_FRAME_CTRL_2                0x548
#define ARIZONA_AIF2_FRAME_CTRL_3                0x549
#define ARIZONA_AIF2_FRAME_CTRL_4                0x54A
#define ARIZONA_AIF2_FRAME_CTRL_5                0x54B
#define ARIZONA_AIF2_FRAME_CTRL_6                0x54C
#define ARIZONA_AIF2_FRAME_CTRL_7                0x54D
#define ARIZONA_AIF2_FRAME_CTRL_8                0x54E
#define ARIZONA_AIF2_FRAME_CTRL_11               0x551
#define ARIZONA_AIF2_FRAME_CTRL_12               0x552
#define ARIZONA_AIF2_FRAME_CTRL_13               0x553
#define ARIZONA_AIF2_FRAME_CTRL_14               0x554
#define ARIZONA_AIF2_FRAME_CTRL_15               0x555
#define ARIZONA_AIF2_FRAME_CTRL_16               0x556
#define ARIZONA_AIF2_TX_ENABLES                  0x559
#define ARIZONA_AIF2_RX_ENABLES                  0x55A
#define ARIZONA_AIF2_FORCE_WRITE                 0x55B
#define ARIZONA_AIF3_BCLK_CTRL                   0x580
#define ARIZONA_AIF3_TX_PIN_CTRL                 0x581
#define ARIZONA_AIF3_RX_PIN_CTRL                 0x582
#define ARIZONA_AIF3_RATE_CTRL                   0x583
#define ARIZONA_AIF3_FORMAT                      0x584
#define ARIZONA_AIF3_TX_BCLK_RATE                0x585
#define ARIZONA_AIF3_RX_BCLK_RATE                0x586
#define ARIZONA_AIF3_FRAME_CTRL_1                0x587
#define ARIZONA_AIF3_FRAME_CTRL_2                0x588
#define ARIZONA_AIF3_FRAME_CTRL_3                0x589
#define ARIZONA_AIF3_FRAME_CTRL_4                0x58A
#define ARIZONA_AIF3_FRAME_CTRL_11               0x591
#define ARIZONA_AIF3_FRAME_CTRL_12               0x592
#define ARIZONA_AIF3_TX_ENABLES                  0x599
#define ARIZONA_AIF3_RX_ENABLES                  0x59A
#define ARIZONA_AIF3_FORCE_WRITE                 0x59B
#define ARIZONA_SPD1_TX_CONTROL                  0x5C2
#define ARIZONA_SPD1_TX_CHANNEL_STATUS_1         0x5C3
#define ARIZONA_SPD1_TX_CHANNEL_STATUS_2         0x5C4
#define ARIZONA_SPD1_TX_CHANNEL_STATUS_3         0x5C5
#define ARIZONA_SLIMBUS_FRAMER_REF_GEAR          0x5E3
#define ARIZONA_SLIMBUS_RATES_1                  0x5E5
#define ARIZONA_SLIMBUS_RATES_2                  0x5E6
#define ARIZONA_SLIMBUS_RATES_3                  0x5E7
#define ARIZONA_SLIMBUS_RATES_4                  0x5E8
#define ARIZONA_SLIMBUS_RATES_5                  0x5E9
#define ARIZONA_SLIMBUS_RATES_6                  0x5EA
#define ARIZONA_SLIMBUS_RATES_7                  0x5EB
#define ARIZONA_SLIMBUS_RATES_8                  0x5EC
#define ARIZONA_SLIMBUS_RX_CHANNEL_ENABLE        0x5F5
#define ARIZONA_SLIMBUS_TX_CHANNEL_ENABLE        0x5F6
#define ARIZONA_SLIMBUS_RX_PORT_STATUS           0x5F7
#define ARIZONA_SLIMBUS_TX_PORT_STATUS           0x5F8
#define ARIZONA_PWM1MIX_INPUT_1_SOURCE           0x640
#define ARIZONA_PWM1MIX_INPUT_1_VOLUME           0x641
#define ARIZONA_PWM1MIX_INPUT_2_SOURCE           0x642
#define ARIZONA_PWM1MIX_INPUT_2_VOLUME           0x643
#define ARIZONA_PWM1MIX_INPUT_3_SOURCE           0x644
#define ARIZONA_PWM1MIX_INPUT_3_VOLUME           0x645
#define ARIZONA_PWM1MIX_INPUT_4_SOURCE           0x646
#define ARIZONA_PWM1MIX_INPUT_4_VOLUME           0x647
#define ARIZONA_PWM2MIX_INPUT_1_SOURCE           0x648
#define ARIZONA_PWM2MIX_INPUT_1_VOLUME           0x649
#define ARIZONA_PWM2MIX_INPUT_2_SOURCE           0x64A
#define ARIZONA_PWM2MIX_INPUT_2_VOLUME           0x64B
#define ARIZONA_PWM2MIX_INPUT_3_SOURCE           0x64C
#define ARIZONA_PWM2MIX_INPUT_3_VOLUME           0x64D
#define ARIZONA_PWM2MIX_INPUT_4_SOURCE           0x64E
#define ARIZONA_PWM2MIX_INPUT_4_VOLUME           0x64F
#define ARIZONA_MICMIX_INPUT_1_SOURCE            0x660
#define ARIZONA_MICMIX_INPUT_1_VOLUME            0x661
#define ARIZONA_MICMIX_INPUT_2_SOURCE            0x662
#define ARIZONA_MICMIX_INPUT_2_VOLUME            0x663
#define ARIZONA_MICMIX_INPUT_3_SOURCE            0x664
#define ARIZONA_MICMIX_INPUT_3_VOLUME            0x665
#define ARIZONA_MICMIX_INPUT_4_SOURCE            0x666
#define ARIZONA_MICMIX_INPUT_4_VOLUME            0x667
#define ARIZONA_NOISEMIX_INPUT_1_SOURCE          0x668
#define ARIZONA_NOISEMIX_INPUT_1_VOLUME          0x669
#define ARIZONA_NOISEMIX_INPUT_2_SOURCE          0x66A
#define ARIZONA_NOISEMIX_INPUT_2_VOLUME          0x66B
#define ARIZONA_NOISEMIX_INPUT_3_SOURCE          0x66C
#define ARIZONA_NOISEMIX_INPUT_3_VOLUME          0x66D
#define ARIZONA_NOISEMIX_INPUT_4_SOURCE          0x66E
#define ARIZONA_NOISEMIX_INPUT_4_VOLUME          0x66F
#define ARIZONA_OUT1LMIX_INPUT_1_SOURCE          0x680
#define ARIZONA_OUT1LMIX_INPUT_1_VOLUME          0x681
#define ARIZONA_OUT1LMIX_INPUT_2_SOURCE          0x682
#define ARIZONA_OUT1LMIX_INPUT_2_VOLUME          0x683
#define ARIZONA_OUT1LMIX_INPUT_3_SOURCE          0x684
#define ARIZONA_OUT1LMIX_INPUT_3_VOLUME          0x685
#define ARIZONA_OUT1LMIX_INPUT_4_SOURCE          0x686
#define ARIZONA_OUT1LMIX_INPUT_4_VOLUME          0x687
#define ARIZONA_OUT1RMIX_INPUT_1_SOURCE          0x688
#define ARIZONA_OUT1RMIX_INPUT_1_VOLUME          0x689
#define ARIZONA_OUT1RMIX_INPUT_2_SOURCE          0x68A
#define ARIZONA_OUT1RMIX_INPUT_2_VOLUME          0x68B
#define ARIZONA_OUT1RMIX_INPUT_3_SOURCE          0x68C
#define ARIZONA_OUT1RMIX_INPUT_3_VOLUME          0x68D
#define ARIZONA_OUT1RMIX_INPUT_4_SOURCE          0x68E
#define ARIZONA_OUT1RMIX_INPUT_4_VOLUME          0x68F
#define ARIZONA_OUT2LMIX_INPUT_1_SOURCE          0x690
#define ARIZONA_OUT2LMIX_INPUT_1_VOLUME          0x691
#define ARIZONA_OUT2LMIX_INPUT_2_SOURCE          0x692
#define ARIZONA_OUT2LMIX_INPUT_2_VOLUME          0x693
#define ARIZONA_OUT2LMIX_INPUT_3_SOURCE          0x694
#define ARIZONA_OUT2LMIX_INPUT_3_VOLUME          0x695
#define ARIZONA_OUT2LMIX_INPUT_4_SOURCE          0x696
#define ARIZONA_OUT2LMIX_INPUT_4_VOLUME          0x697
#define ARIZONA_OUT2RMIX_INPUT_1_SOURCE          0x698
#define ARIZONA_OUT2RMIX_INPUT_1_VOLUME          0x699
#define ARIZONA_OUT2RMIX_INPUT_2_SOURCE          0x69A
#define ARIZONA_OUT2RMIX_INPUT_2_VOLUME          0x69B
#define ARIZONA_OUT2RMIX_INPUT_3_SOURCE          0x69C
#define ARIZONA_OUT2RMIX_INPUT_3_VOLUME          0x69D
#define ARIZONA_OUT2RMIX_INPUT_4_SOURCE          0x69E
#define ARIZONA_OUT2RMIX_INPUT_4_VOLUME          0x69F
#define ARIZONA_OUT3LMIX_INPUT_1_SOURCE          0x6A0
#define ARIZONA_OUT3LMIX_INPUT_1_VOLUME          0x6A1
#define ARIZONA_OUT3LMIX_INPUT_2_SOURCE          0x6A2
#define ARIZONA_OUT3LMIX_INPUT_2_VOLUME          0x6A3
#define ARIZONA_OUT3LMIX_INPUT_3_SOURCE          0x6A4
#define ARIZONA_OUT3LMIX_INPUT_3_VOLUME          0x6A5
#define ARIZONA_OUT3LMIX_INPUT_4_SOURCE          0x6A6
#define ARIZONA_OUT3LMIX_INPUT_4_VOLUME          0x6A7
#define ARIZONA_OUT3RMIX_INPUT_1_SOURCE          0x6A8
#define ARIZONA_OUT3RMIX_INPUT_1_VOLUME          0x6A9
#define ARIZONA_OUT3RMIX_INPUT_2_SOURCE          0x6AA
#define ARIZONA_OUT3RMIX_INPUT_2_VOLUME          0x6AB
#define ARIZONA_OUT3RMIX_INPUT_3_SOURCE          0x6AC
#define ARIZONA_OUT3RMIX_INPUT_3_VOLUME          0x6AD
#define ARIZONA_OUT3RMIX_INPUT_4_SOURCE          0x6AE
#define ARIZONA_OUT3RMIX_INPUT_4_VOLUME          0x6AF
#define ARIZONA_OUT4LMIX_INPUT_1_SOURCE          0x6B0
#define ARIZONA_OUT4LMIX_INPUT_1_VOLUME          0x6B1
#define ARIZONA_OUT4LMIX_INPUT_2_SOURCE          0x6B2
#define ARIZONA_OUT4LMIX_INPUT_2_VOLUME          0x6B3
#define ARIZONA_OUT4LMIX_INPUT_3_SOURCE          0x6B4
#define ARIZONA_OUT4LMIX_INPUT_3_VOLUME          0x6B5
#define ARIZONA_OUT4LMIX_INPUT_4_SOURCE          0x6B6
#define ARIZONA_OUT4LMIX_INPUT_4_VOLUME          0x6B7
#define ARIZONA_OUT4RMIX_INPUT_1_SOURCE          0x6B8
#define ARIZONA_OUT4RMIX_INPUT_1_VOLUME          0x6B9
#define ARIZONA_OUT4RMIX_INPUT_2_SOURCE          0x6BA
#define ARIZONA_OUT4RMIX_INPUT_2_VOLUME          0x6BB
#define ARIZONA_OUT4RMIX_INPUT_3_SOURCE          0x6BC
#define ARIZONA_OUT4RMIX_INPUT_3_VOLUME          0x6BD
#define ARIZONA_OUT4RMIX_INPUT_4_SOURCE          0x6BE
#define ARIZONA_OUT4RMIX_INPUT_4_VOLUME          0x6BF
#define ARIZONA_OUT5LMIX_INPUT_1_SOURCE          0x6C0
#define ARIZONA_OUT5LMIX_INPUT_1_VOLUME          0x6C1
#define ARIZONA_OUT5LMIX_INPUT_2_SOURCE          0x6C2
#define ARIZONA_OUT5LMIX_INPUT_2_VOLUME          0x6C3
#define ARIZONA_OUT5LMIX_INPUT_3_SOURCE          0x6C4
#define ARIZONA_OUT5LMIX_INPUT_3_VOLUME          0x6C5
#define ARIZONA_OUT5LMIX_INPUT_4_SOURCE          0x6C6
#define ARIZONA_OUT5LMIX_INPUT_4_VOLUME          0x6C7
#define ARIZONA_OUT5RMIX_INPUT_1_SOURCE          0x6C8
#define ARIZONA_OUT5RMIX_INPUT_1_VOLUME          0x6C9
#define ARIZONA_OUT5RMIX_INPUT_2_SOURCE          0x6CA
#define ARIZONA_OUT5RMIX_INPUT_2_VOLUME          0x6CB
#define ARIZONA_OUT5RMIX_INPUT_3_SOURCE          0x6CC
#define ARIZONA_OUT5RMIX_INPUT_3_VOLUME          0x6CD
#define ARIZONA_OUT5RMIX_INPUT_4_SOURCE          0x6CE
#define ARIZONA_OUT5RMIX_INPUT_4_VOLUME          0x6CF
#define ARIZONA_OUT6LMIX_INPUT_1_SOURCE          0x6D0
#define ARIZONA_OUT6LMIX_INPUT_1_VOLUME          0x6D1
#define ARIZONA_OUT6LMIX_INPUT_2_SOURCE          0x6D2
#define ARIZONA_OUT6LMIX_INPUT_2_VOLUME          0x6D3
#define ARIZONA_OUT6LMIX_INPUT_3_SOURCE          0x6D4
#define ARIZONA_OUT6LMIX_INPUT_3_VOLUME          0x6D5
#define ARIZONA_OUT6LMIX_INPUT_4_SOURCE          0x6D6
#define ARIZONA_OUT6LMIX_INPUT_4_VOLUME          0x6D7
#define ARIZONA_OUT6RMIX_INPUT_1_SOURCE          0x6D8
#define ARIZONA_OUT6RMIX_INPUT_1_VOLUME          0x6D9
#define ARIZONA_OUT6RMIX_INPUT_2_SOURCE          0x6DA
#define ARIZONA_OUT6RMIX_INPUT_2_VOLUME          0x6DB
#define ARIZONA_OUT6RMIX_INPUT_3_SOURCE          0x6DC
#define ARIZONA_OUT6RMIX_INPUT_3_VOLUME          0x6DD
#define ARIZONA_OUT6RMIX_INPUT_4_SOURCE          0x6DE
#define ARIZONA_OUT6RMIX_INPUT_4_VOLUME          0x6DF
#define ARIZONA_AIF1TX1MIX_INPUT_1_SOURCE        0x700
#define ARIZONA_AIF1TX1MIX_INPUT_1_VOLUME        0x701
#define ARIZONA_AIF1TX1MIX_INPUT_2_SOURCE        0x702
#define ARIZONA_AIF1TX1MIX_INPUT_2_VOLUME        0x703
#define ARIZONA_AIF1TX1MIX_INPUT_3_SOURCE        0x704
#define ARIZONA_AIF1TX1MIX_INPUT_3_VOLUME        0x705
#define ARIZONA_AIF1TX1MIX_INPUT_4_SOURCE        0x706
#define ARIZONA_AIF1TX1MIX_INPUT_4_VOLUME        0x707
#define ARIZONA_AIF1TX2MIX_INPUT_1_SOURCE        0x708
#define ARIZONA_AIF1TX2MIX_INPUT_1_VOLUME        0x709
#define ARIZONA_AIF1TX2MIX_INPUT_2_SOURCE        0x70A
#define ARIZONA_AIF1TX2MIX_INPUT_2_VOLUME        0x70B
#define ARIZONA_AIF1TX2MIX_INPUT_3_SOURCE        0x70C
#define ARIZONA_AIF1TX2MIX_INPUT_3_VOLUME        0x70D
#define ARIZONA_AIF1TX2MIX_INPUT_4_SOURCE        0x70E
#define ARIZONA_AIF1TX2MIX_INPUT_4_VOLUME        0x70F
#define ARIZONA_AIF1TX3MIX_INPUT_1_SOURCE        0x710
#define ARIZONA_AIF1TX3MIX_INPUT_1_VOLUME        0x711
#define ARIZONA_AIF1TX3MIX_INPUT_2_SOURCE        0x712
#define ARIZONA_AIF1TX3MIX_INPUT_2_VOLUME        0x713
#define ARIZONA_AIF1TX3MIX_INPUT_3_SOURCE        0x714
#define ARIZONA_AIF1TX3MIX_INPUT_3_VOLUME        0x715
#define ARIZONA_AIF1TX3MIX_INPUT_4_SOURCE        0x716
#define ARIZONA_AIF1TX3MIX_INPUT_4_VOLUME        0x717
#define ARIZONA_AIF1TX4MIX_INPUT_1_SOURCE        0x718
#define ARIZONA_AIF1TX4MIX_INPUT_1_VOLUME        0x719
#define ARIZONA_AIF1TX4MIX_INPUT_2_SOURCE        0x71A
#define ARIZONA_AIF1TX4MIX_INPUT_2_VOLUME        0x71B
#define ARIZONA_AIF1TX4MIX_INPUT_3_SOURCE        0x71C
#define ARIZONA_AIF1TX4MIX_INPUT_3_VOLUME        0x71D
#define ARIZONA_AIF1TX4MIX_INPUT_4_SOURCE        0x71E
#define ARIZONA_AIF1TX4MIX_INPUT_4_VOLUME        0x71F
#define ARIZONA_AIF1TX5MIX_INPUT_1_SOURCE        0x720
#define ARIZONA_AIF1TX5MIX_INPUT_1_VOLUME        0x721
#define ARIZONA_AIF1TX5MIX_INPUT_2_SOURCE        0x722
#define ARIZONA_AIF1TX5MIX_INPUT_2_VOLUME        0x723
#define ARIZONA_AIF1TX5MIX_INPUT_3_SOURCE        0x724
#define ARIZONA_AIF1TX5MIX_INPUT_3_VOLUME        0x725
#define ARIZONA_AIF1TX5MIX_INPUT_4_SOURCE        0x726
#define ARIZONA_AIF1TX5MIX_INPUT_4_VOLUME        0x727
#define ARIZONA_AIF1TX6MIX_INPUT_1_SOURCE        0x728
#define ARIZONA_AIF1TX6MIX_INPUT_1_VOLUME        0x729
#define ARIZONA_AIF1TX6MIX_INPUT_2_SOURCE        0x72A
#define ARIZONA_AIF1TX6MIX_INPUT_2_VOLUME        0x72B
#define ARIZONA_AIF1TX6MIX_INPUT_3_SOURCE        0x72C
#define ARIZONA_AIF1TX6MIX_INPUT_3_VOLUME        0x72D
#define ARIZONA_AIF1TX6MIX_INPUT_4_SOURCE        0x72E
#define ARIZONA_AIF1TX6MIX_INPUT_4_VOLUME        0x72F
#define ARIZONA_AIF1TX7MIX_INPUT_1_SOURCE        0x730
#define ARIZONA_AIF1TX7MIX_INPUT_1_VOLUME        0x731
#define ARIZONA_AIF1TX7MIX_INPUT_2_SOURCE        0x732
#define ARIZONA_AIF1TX7MIX_INPUT_2_VOLUME        0x733
#define ARIZONA_AIF1TX7MIX_INPUT_3_SOURCE        0x734
#define ARIZONA_AIF1TX7MIX_INPUT_3_VOLUME        0x735
#define ARIZONA_AIF1TX7MIX_INPUT_4_SOURCE        0x736
#define ARIZONA_AIF1TX7MIX_INPUT_4_VOLUME        0x737
#define ARIZONA_AIF1TX8MIX_INPUT_1_SOURCE        0x738
#define ARIZONA_AIF1TX8MIX_INPUT_1_VOLUME        0x739
#define ARIZONA_AIF1TX8MIX_INPUT_2_SOURCE        0x73A
#define ARIZONA_AIF1TX8MIX_INPUT_2_VOLUME        0x73B
#define ARIZONA_AIF1TX8MIX_INPUT_3_SOURCE        0x73C
#define ARIZONA_AIF1TX8MIX_INPUT_3_VOLUME        0x73D
#define ARIZONA_AIF1TX8MIX_INPUT_4_SOURCE        0x73E
#define ARIZONA_AIF1TX8MIX_INPUT_4_VOLUME        0x73F
#define ARIZONA_AIF2TX1MIX_INPUT_1_SOURCE        0x740
#define ARIZONA_AIF2TX1MIX_INPUT_1_VOLUME        0x741
#define ARIZONA_AIF2TX1MIX_INPUT_2_SOURCE        0x742
#define ARIZONA_AIF2TX1MIX_INPUT_2_VOLUME        0x743
#define ARIZONA_AIF2TX1MIX_INPUT_3_SOURCE        0x744
#define ARIZONA_AIF2TX1MIX_INPUT_3_VOLUME        0x745
#define ARIZONA_AIF2TX1MIX_INPUT_4_SOURCE        0x746
#define ARIZONA_AIF2TX1MIX_INPUT_4_VOLUME        0x747
#define ARIZONA_AIF2TX2MIX_INPUT_1_SOURCE        0x748
#define ARIZONA_AIF2TX2MIX_INPUT_1_VOLUME        0x749
#define ARIZONA_AIF2TX2MIX_INPUT_2_SOURCE        0x74A
#define ARIZONA_AIF2TX2MIX_INPUT_2_VOLUME        0x74B
#define ARIZONA_AIF2TX2MIX_INPUT_3_SOURCE        0x74C
#define ARIZONA_AIF2TX2MIX_INPUT_3_VOLUME        0x74D
#define ARIZONA_AIF2TX2MIX_INPUT_4_SOURCE        0x74E
#define ARIZONA_AIF2TX2MIX_INPUT_4_VOLUME        0x74F
#define ARIZONA_AIF2TX3MIX_INPUT_1_SOURCE        0x750
#define ARIZONA_AIF2TX3MIX_INPUT_1_VOLUME        0x751
#define ARIZONA_AIF2TX3MIX_INPUT_2_SOURCE        0x752
#define ARIZONA_AIF2TX3MIX_INPUT_2_VOLUME        0x753
#define ARIZONA_AIF2TX3MIX_INPUT_3_SOURCE        0x754
#define ARIZONA_AIF2TX3MIX_INPUT_3_VOLUME        0x755
#define ARIZONA_AIF2TX3MIX_INPUT_4_SOURCE        0x756
#define ARIZONA_AIF2TX3MIX_INPUT_4_VOLUME        0x757
#define ARIZONA_AIF2TX4MIX_INPUT_1_SOURCE        0x758
#define ARIZONA_AIF2TX4MIX_INPUT_1_VOLUME        0x759
#define ARIZONA_AIF2TX4MIX_INPUT_2_SOURCE        0x75A
#define ARIZONA_AIF2TX4MIX_INPUT_2_VOLUME        0x75B
#define ARIZONA_AIF2TX4MIX_INPUT_3_SOURCE        0x75C
#define ARIZONA_AIF2TX4MIX_INPUT_3_VOLUME        0x75D
#define ARIZONA_AIF2TX4MIX_INPUT_4_SOURCE        0x75E
#define ARIZONA_AIF2TX4MIX_INPUT_4_VOLUME        0x75F
#define ARIZONA_AIF2TX5MIX_INPUT_1_SOURCE        0x760
#define ARIZONA_AIF2TX5MIX_INPUT_1_VOLUME        0x761
#define ARIZONA_AIF2TX5MIX_INPUT_2_SOURCE        0x762
#define ARIZONA_AIF2TX5MIX_INPUT_2_VOLUME        0x763
#define ARIZONA_AIF2TX5MIX_INPUT_3_SOURCE        0x764
#define ARIZONA_AIF2TX5MIX_INPUT_3_VOLUME        0x765
#define ARIZONA_AIF2TX5MIX_INPUT_4_SOURCE        0x766
#define ARIZONA_AIF2TX5MIX_INPUT_4_VOLUME        0x767
#define ARIZONA_AIF2TX6MIX_INPUT_1_SOURCE        0x768
#define ARIZONA_AIF2TX6MIX_INPUT_1_VOLUME        0x769
#define ARIZONA_AIF2TX6MIX_INPUT_2_SOURCE        0x76A
#define ARIZONA_AIF2TX6MIX_INPUT_2_VOLUME        0x76B
#define ARIZONA_AIF2TX6MIX_INPUT_3_SOURCE        0x76C
#define ARIZONA_AIF2TX6MIX_INPUT_3_VOLUME        0x76D
#define ARIZONA_AIF2TX6MIX_INPUT_4_SOURCE        0x76E
#define ARIZONA_AIF2TX6MIX_INPUT_4_VOLUME        0x76F
#define ARIZONA_AIF3TX1MIX_INPUT_1_SOURCE        0x780
#define ARIZONA_AIF3TX1MIX_INPUT_1_VOLUME        0x781
#define ARIZONA_AIF3TX1MIX_INPUT_2_SOURCE        0x782
#define ARIZONA_AIF3TX1MIX_INPUT_2_VOLUME        0x783
#define ARIZONA_AIF3TX1MIX_INPUT_3_SOURCE        0x784
#define ARIZONA_AIF3TX1MIX_INPUT_3_VOLUME        0x785
#define ARIZONA_AIF3TX1MIX_INPUT_4_SOURCE        0x786
#define ARIZONA_AIF3TX1MIX_INPUT_4_VOLUME        0x787
#define ARIZONA_AIF3TX2MIX_INPUT_1_SOURCE        0x788
#define ARIZONA_AIF3TX2MIX_INPUT_1_VOLUME        0x789
#define ARIZONA_AIF3TX2MIX_INPUT_2_SOURCE        0x78A
#define ARIZONA_AIF3TX2MIX_INPUT_2_VOLUME        0x78B
#define ARIZONA_AIF3TX2MIX_INPUT_3_SOURCE        0x78C
#define ARIZONA_AIF3TX2MIX_INPUT_3_VOLUME        0x78D
#define ARIZONA_AIF3TX2MIX_INPUT_4_SOURCE        0x78E
#define ARIZONA_AIF3TX2MIX_INPUT_4_VOLUME        0x78F
#define ARIZONA_SLIMTX1MIX_INPUT_1_SOURCE        0x7C0
#define ARIZONA_SLIMTX1MIX_INPUT_1_VOLUME        0x7C1
#define ARIZONA_SLIMTX1MIX_INPUT_2_SOURCE        0x7C2
#define ARIZONA_SLIMTX1MIX_INPUT_2_VOLUME        0x7C3
#define ARIZONA_SLIMTX1MIX_INPUT_3_SOURCE        0x7C4
#define ARIZONA_SLIMTX1MIX_INPUT_3_VOLUME        0x7C5
#define ARIZONA_SLIMTX1MIX_INPUT_4_SOURCE        0x7C6
#define ARIZONA_SLIMTX1MIX_INPUT_4_VOLUME        0x7C7
#define ARIZONA_SLIMTX2MIX_INPUT_1_SOURCE        0x7C8
#define ARIZONA_SLIMTX2MIX_INPUT_1_VOLUME        0x7C9
#define ARIZONA_SLIMTX2MIX_INPUT_2_SOURCE        0x7CA
#define ARIZONA_SLIMTX2MIX_INPUT_2_VOLUME        0x7CB
#define ARIZONA_SLIMTX2MIX_INPUT_3_SOURCE        0x7CC
#define ARIZONA_SLIMTX2MIX_INPUT_3_VOLUME        0x7CD
#define ARIZONA_SLIMTX2MIX_INPUT_4_SOURCE        0x7CE
#define ARIZONA_SLIMTX2MIX_INPUT_4_VOLUME        0x7CF
#define ARIZONA_SLIMTX3MIX_INPUT_1_SOURCE        0x7D0
#define ARIZONA_SLIMTX3MIX_INPUT_1_VOLUME        0x7D1
#define ARIZONA_SLIMTX3MIX_INPUT_2_SOURCE        0x7D2
#define ARIZONA_SLIMTX3MIX_INPUT_2_VOLUME        0x7D3
#define ARIZONA_SLIMTX3MIX_INPUT_3_SOURCE        0x7D4
#define ARIZONA_SLIMTX3MIX_INPUT_3_VOLUME        0x7D5
#define ARIZONA_SLIMTX3MIX_INPUT_4_SOURCE        0x7D6
#define ARIZONA_SLIMTX3MIX_INPUT_4_VOLUME        0x7D7
#define ARIZONA_SLIMTX4MIX_INPUT_1_SOURCE        0x7D8
#define ARIZONA_SLIMTX4MIX_INPUT_1_VOLUME        0x7D9
#define ARIZONA_SLIMTX4MIX_INPUT_2_SOURCE        0x7DA
#define ARIZONA_SLIMTX4MIX_INPUT_2_VOLUME        0x7DB
#define ARIZONA_SLIMTX4MIX_INPUT_3_SOURCE        0x7DC
#define ARIZONA_SLIMTX4MIX_INPUT_3_VOLUME        0x7DD
#define ARIZONA_SLIMTX4MIX_INPUT_4_SOURCE        0x7DE
#define ARIZONA_SLIMTX4MIX_INPUT_4_VOLUME        0x7DF
#define ARIZONA_SLIMTX5MIX_INPUT_1_SOURCE        0x7E0
#define ARIZONA_SLIMTX5MIX_INPUT_1_VOLUME        0x7E1
#define ARIZONA_SLIMTX5MIX_INPUT_2_SOURCE        0x7E2
#define ARIZONA_SLIMTX5MIX_INPUT_2_VOLUME        0x7E3
#define ARIZONA_SLIMTX5MIX_INPUT_3_SOURCE        0x7E4
#define ARIZONA_SLIMTX5MIX_INPUT_3_VOLUME        0x7E5
#define ARIZONA_SLIMTX5MIX_INPUT_4_SOURCE        0x7E6
#define ARIZONA_SLIMTX5MIX_INPUT_4_VOLUME        0x7E7
#define ARIZONA_SLIMTX6MIX_INPUT_1_SOURCE        0x7E8
#define ARIZONA_SLIMTX6MIX_INPUT_1_VOLUME        0x7E9
#define ARIZONA_SLIMTX6MIX_INPUT_2_SOURCE        0x7EA
#define ARIZONA_SLIMTX6MIX_INPUT_2_VOLUME        0x7EB
#define ARIZONA_SLIMTX6MIX_INPUT_3_SOURCE        0x7EC
#define ARIZONA_SLIMTX6MIX_INPUT_3_VOLUME        0x7ED
#define ARIZONA_SLIMTX6MIX_INPUT_4_SOURCE        0x7EE
#define ARIZONA_SLIMTX6MIX_INPUT_4_VOLUME        0x7EF
#define ARIZONA_SLIMTX7MIX_INPUT_1_SOURCE        0x7F0
#define ARIZONA_SLIMTX7MIX_INPUT_1_VOLUME        0x7F1
#define ARIZONA_SLIMTX7MIX_INPUT_2_SOURCE        0x7F2
#define ARIZONA_SLIMTX7MIX_INPUT_2_VOLUME        0x7F3
#define ARIZONA_SLIMTX7MIX_INPUT_3_SOURCE        0x7F4
#define ARIZONA_SLIMTX7MIX_INPUT_3_VOLUME        0x7F5
#define ARIZONA_SLIMTX7MIX_INPUT_4_SOURCE        0x7F6
#define ARIZONA_SLIMTX7MIX_INPUT_4_VOLUME        0x7F7
#define ARIZONA_SLIMTX8MIX_INPUT_1_SOURCE        0x7F8
#define ARIZONA_SLIMTX8MIX_INPUT_1_VOLUME        0x7F9
#define ARIZONA_SLIMTX8MIX_INPUT_2_SOURCE        0x7FA
#define ARIZONA_SLIMTX8MIX_INPUT_2_VOLUME        0x7FB
#define ARIZONA_SLIMTX8MIX_INPUT_3_SOURCE        0x7FC
#define ARIZONA_SLIMTX8MIX_INPUT_3_VOLUME        0x7FD
#define ARIZONA_SLIMTX8MIX_INPUT_4_SOURCE        0x7FE
#define ARIZONA_SLIMTX8MIX_INPUT_4_VOLUME        0x7FF
#define ARIZONA_SPDIFTX1MIX_INPUT_1_SOURCE       0x800
#define ARIZONA_SPDIFTX1MIX_INPUT_1_VOLUME       0x801
#define ARIZONA_SPDIFTX2MIX_INPUT_1_SOURCE       0x808
#define ARIZONA_SPDIFTX2MIX_INPUT_1_VOLUME       0x809
#define ARIZONA_EQ1MIX_INPUT_1_SOURCE            0x880
#define ARIZONA_EQ1MIX_INPUT_1_VOLUME            0x881
#define ARIZONA_EQ1MIX_INPUT_2_SOURCE            0x882
#define ARIZONA_EQ1MIX_INPUT_2_VOLUME            0x883
#define ARIZONA_EQ1MIX_INPUT_3_SOURCE            0x884
#define ARIZONA_EQ1MIX_INPUT_3_VOLUME            0x885
#define ARIZONA_EQ1MIX_INPUT_4_SOURCE            0x886
#define ARIZONA_EQ1MIX_INPUT_4_VOLUME            0x887
#define ARIZONA_EQ2MIX_INPUT_1_SOURCE            0x888
#define ARIZONA_EQ2MIX_INPUT_1_VOLUME            0x889
#define ARIZONA_EQ2MIX_INPUT_2_SOURCE            0x88A
#define ARIZONA_EQ2MIX_INPUT_2_VOLUME            0x88B
#define ARIZONA_EQ2MIX_INPUT_3_SOURCE            0x88C
#define ARIZONA_EQ2MIX_INPUT_3_VOLUME            0x88D
#define ARIZONA_EQ2MIX_INPUT_4_SOURCE            0x88E
#define ARIZONA_EQ2MIX_INPUT_4_VOLUME            0x88F
#define ARIZONA_EQ3MIX_INPUT_1_SOURCE            0x890
#define ARIZONA_EQ3MIX_INPUT_1_VOLUME            0x891
#define ARIZONA_EQ3MIX_INPUT_2_SOURCE            0x892
#define ARIZONA_EQ3MIX_INPUT_2_VOLUME            0x893
#define ARIZONA_EQ3MIX_INPUT_3_SOURCE            0x894
#define ARIZONA_EQ3MIX_INPUT_3_VOLUME            0x895
#define ARIZONA_EQ3MIX_INPUT_4_SOURCE            0x896
#define ARIZONA_EQ3MIX_INPUT_4_VOLUME            0x897
#define ARIZONA_EQ4MIX_INPUT_1_SOURCE            0x898
#define ARIZONA_EQ4MIX_INPUT_1_VOLUME            0x899
#define ARIZONA_EQ4MIX_INPUT_2_SOURCE            0x89A
#define ARIZONA_EQ4MIX_INPUT_2_VOLUME            0x89B
#define ARIZONA_EQ4MIX_INPUT_3_SOURCE            0x89C
#define ARIZONA_EQ4MIX_INPUT_3_VOLUME            0x89D
#define ARIZONA_EQ4MIX_INPUT_4_SOURCE            0x89E
#define ARIZONA_EQ4MIX_INPUT_4_VOLUME            0x89F
#define ARIZONA_DRC1LMIX_INPUT_1_SOURCE          0x8C0
#define ARIZONA_DRC1LMIX_INPUT_1_VOLUME          0x8C1
#define ARIZONA_DRC1LMIX_INPUT_2_SOURCE          0x8C2
#define ARIZONA_DRC1LMIX_INPUT_2_VOLUME          0x8C3
#define ARIZONA_DRC1LMIX_INPUT_3_SOURCE          0x8C4
#define ARIZONA_DRC1LMIX_INPUT_3_VOLUME          0x8C5
#define ARIZONA_DRC1LMIX_INPUT_4_SOURCE          0x8C6
#define ARIZONA_DRC1LMIX_INPUT_4_VOLUME          0x8C7
#define ARIZONA_DRC1RMIX_INPUT_1_SOURCE          0x8C8
#define ARIZONA_DRC1RMIX_INPUT_1_VOLUME          0x8C9
#define ARIZONA_DRC1RMIX_INPUT_2_SOURCE          0x8CA
#define ARIZONA_DRC1RMIX_INPUT_2_VOLUME          0x8CB
#define ARIZONA_DRC1RMIX_INPUT_3_SOURCE          0x8CC
#define ARIZONA_DRC1RMIX_INPUT_3_VOLUME          0x8CD
#define ARIZONA_DRC1RMIX_INPUT_4_SOURCE          0x8CE
#define ARIZONA_DRC1RMIX_INPUT_4_VOLUME          0x8CF
#define ARIZONA_DRC2LMIX_INPUT_1_SOURCE          0x8D0
#define ARIZONA_DRC2LMIX_INPUT_1_VOLUME          0x8D1
#define ARIZONA_DRC2LMIX_INPUT_2_SOURCE          0x8D2
#define ARIZONA_DRC2LMIX_INPUT_2_VOLUME          0x8D3
#define ARIZONA_DRC2LMIX_INPUT_3_SOURCE          0x8D4
#define ARIZONA_DRC2LMIX_INPUT_3_VOLUME          0x8D5
#define ARIZONA_DRC2LMIX_INPUT_4_SOURCE          0x8D6
#define ARIZONA_DRC2LMIX_INPUT_4_VOLUME          0x8D7
#define ARIZONA_DRC2RMIX_INPUT_1_SOURCE          0x8D8
#define ARIZONA_DRC2RMIX_INPUT_1_VOLUME          0x8D9
#define ARIZONA_DRC2RMIX_INPUT_2_SOURCE          0x8DA
#define ARIZONA_DRC2RMIX_INPUT_2_VOLUME          0x8DB
#define ARIZONA_DRC2RMIX_INPUT_3_SOURCE          0x8DC
#define ARIZONA_DRC2RMIX_INPUT_3_VOLUME          0x8DD
#define ARIZONA_DRC2RMIX_INPUT_4_SOURCE          0x8DE
#define ARIZONA_DRC2RMIX_INPUT_4_VOLUME          0x8DF
#define ARIZONA_HPLP1MIX_INPUT_1_SOURCE          0x900
#define ARIZONA_HPLP1MIX_INPUT_1_VOLUME          0x901
#define ARIZONA_HPLP1MIX_INPUT_2_SOURCE          0x902
#define ARIZONA_HPLP1MIX_INPUT_2_VOLUME          0x903
#define ARIZONA_HPLP1MIX_INPUT_3_SOURCE          0x904
#define ARIZONA_HPLP1MIX_INPUT_3_VOLUME          0x905
#define ARIZONA_HPLP1MIX_INPUT_4_SOURCE          0x906
#define ARIZONA_HPLP1MIX_INPUT_4_VOLUME          0x907
#define ARIZONA_HPLP2MIX_INPUT_1_SOURCE          0x908
#define ARIZONA_HPLP2MIX_INPUT_1_VOLUME          0x909
#define ARIZONA_HPLP2MIX_INPUT_2_SOURCE          0x90A
#define ARIZONA_HPLP2MIX_INPUT_2_VOLUME          0x90B
#define ARIZONA_HPLP2MIX_INPUT_3_SOURCE          0x90C
#define ARIZONA_HPLP2MIX_INPUT_3_VOLUME          0x90D
#define ARIZONA_HPLP2MIX_INPUT_4_SOURCE          0x90E
#define ARIZONA_HPLP2MIX_INPUT_4_VOLUME          0x90F
#define ARIZONA_HPLP3MIX_INPUT_1_SOURCE          0x910
#define ARIZONA_HPLP3MIX_INPUT_1_VOLUME          0x911
#define ARIZONA_HPLP3MIX_INPUT_2_SOURCE          0x912
#define ARIZONA_HPLP3MIX_INPUT_2_VOLUME          0x913
#define ARIZONA_HPLP3MIX_INPUT_3_SOURCE          0x914
#define ARIZONA_HPLP3MIX_INPUT_3_VOLUME          0x915
#define ARIZONA_HPLP3MIX_INPUT_4_SOURCE          0x916
#define ARIZONA_HPLP3MIX_INPUT_4_VOLUME          0x917
#define ARIZONA_HPLP4MIX_INPUT_1_SOURCE          0x918
#define ARIZONA_HPLP4MIX_INPUT_1_VOLUME          0x919
#define ARIZONA_HPLP4MIX_INPUT_2_SOURCE          0x91A
#define ARIZONA_HPLP4MIX_INPUT_2_VOLUME          0x91B
#define ARIZONA_HPLP4MIX_INPUT_3_SOURCE          0x91C
#define ARIZONA_HPLP4MIX_INPUT_3_VOLUME          0x91D
#define ARIZONA_HPLP4MIX_INPUT_4_SOURCE          0x91E
#define ARIZONA_HPLP4MIX_INPUT_4_VOLUME          0x91F
#define ARIZONA_DSP1LMIX_INPUT_1_SOURCE          0x940
#define ARIZONA_DSP1LMIX_INPUT_1_VOLUME          0x941
#define ARIZONA_DSP1LMIX_INPUT_2_SOURCE          0x942
#define ARIZONA_DSP1LMIX_INPUT_2_VOLUME          0x943
#define ARIZONA_DSP1LMIX_INPUT_3_SOURCE          0x944
#define ARIZONA_DSP1LMIX_INPUT_3_VOLUME          0x945
#define ARIZONA_DSP1LMIX_INPUT_4_SOURCE          0x946
#define ARIZONA_DSP1LMIX_INPUT_4_VOLUME          0x947
#define ARIZONA_DSP1RMIX_INPUT_1_SOURCE          0x948
#define ARIZONA_DSP1RMIX_INPUT_1_VOLUME          0x949
#define ARIZONA_DSP1RMIX_INPUT_2_SOURCE          0x94A
#define ARIZONA_DSP1RMIX_INPUT_2_VOLUME          0x94B
#define ARIZONA_DSP1RMIX_INPUT_3_SOURCE          0x94C
#define ARIZONA_DSP1RMIX_INPUT_3_VOLUME          0x94D
#define ARIZONA_DSP1RMIX_INPUT_4_SOURCE          0x94E
#define ARIZONA_DSP1RMIX_INPUT_4_VOLUME          0x94F
#define ARIZONA_DSP1AUX1MIX_INPUT_1_SOURCE       0x950
#define ARIZONA_DSP1AUX2MIX_INPUT_1_SOURCE       0x958
#define ARIZONA_DSP1AUX3MIX_INPUT_1_SOURCE       0x960
#define ARIZONA_DSP1AUX4MIX_INPUT_1_SOURCE       0x968
#define ARIZONA_DSP1AUX5MIX_INPUT_1_SOURCE       0x970
#define ARIZONA_DSP1AUX6MIX_INPUT_1_SOURCE       0x978
#define ARIZONA_DSP2LMIX_INPUT_1_SOURCE          0x980
#define ARIZONA_DSP2LMIX_INPUT_1_VOLUME          0x981
#define ARIZONA_DSP2LMIX_INPUT_2_SOURCE          0x982
#define ARIZONA_DSP2LMIX_INPUT_2_VOLUME          0x983
#define ARIZONA_DSP2LMIX_INPUT_3_SOURCE          0x984
#define ARIZONA_DSP2LMIX_INPUT_3_VOLUME          0x985
#define ARIZONA_DSP2LMIX_INPUT_4_SOURCE          0x986
#define ARIZONA_DSP2LMIX_INPUT_4_VOLUME          0x987
#define ARIZONA_DSP2RMIX_INPUT_1_SOURCE          0x988
#define ARIZONA_DSP2RMIX_INPUT_1_VOLUME          0x989
#define ARIZONA_DSP2RMIX_INPUT_2_SOURCE          0x98A
#define ARIZONA_DSP2RMIX_INPUT_2_VOLUME          0x98B
#define ARIZONA_DSP2RMIX_INPUT_3_SOURCE          0x98C
#define ARIZONA_DSP2RMIX_INPUT_3_VOLUME          0x98D
#define ARIZONA_DSP2RMIX_INPUT_4_SOURCE          0x98E
#define ARIZONA_DSP2RMIX_INPUT_4_VOLUME          0x98F
#define ARIZONA_DSP2AUX1MIX_INPUT_1_SOURCE       0x990
#define ARIZONA_DSP2AUX2MIX_INPUT_1_SOURCE       0x998
#define ARIZONA_DSP2AUX3MIX_INPUT_1_SOURCE       0x9A0
#define ARIZONA_DSP2AUX4MIX_INPUT_1_SOURCE       0x9A8
#define ARIZONA_DSP2AUX5MIX_INPUT_1_SOURCE       0x9B0
#define ARIZONA_DSP2AUX6MIX_INPUT_1_SOURCE       0x9B8
#define ARIZONA_DSP3LMIX_INPUT_1_SOURCE          0x9C0
#define ARIZONA_DSP3LMIX_INPUT_1_VOLUME          0x9C1
#define ARIZONA_DSP3LMIX_INPUT_2_SOURCE          0x9C2
#define ARIZONA_DSP3LMIX_INPUT_2_VOLUME          0x9C3
#define ARIZONA_DSP3LMIX_INPUT_3_SOURCE          0x9C4
#define ARIZONA_DSP3LMIX_INPUT_3_VOLUME          0x9C5
#define ARIZONA_DSP3LMIX_INPUT_4_SOURCE          0x9C6
#define ARIZONA_DSP3LMIX_INPUT_4_VOLUME          0x9C7
#define ARIZONA_DSP3RMIX_INPUT_1_SOURCE          0x9C8
#define ARIZONA_DSP3RMIX_INPUT_1_VOLUME          0x9C9
#define ARIZONA_DSP3RMIX_INPUT_2_SOURCE          0x9CA
#define ARIZONA_DSP3RMIX_INPUT_2_VOLUME          0x9CB
#define ARIZONA_DSP3RMIX_INPUT_3_SOURCE          0x9CC
#define ARIZONA_DSP3RMIX_INPUT_3_VOLUME          0x9CD
#define ARIZONA_DSP3RMIX_INPUT_4_SOURCE          0x9CE
#define ARIZONA_DSP3RMIX_INPUT_4_VOLUME          0x9CF
#define ARIZONA_DSP3AUX1MIX_INPUT_1_SOURCE       0x9D0
#define ARIZONA_DSP3AUX2MIX_INPUT_1_SOURCE       0x9D8
#define ARIZONA_DSP3AUX3MIX_INPUT_1_SOURCE       0x9E0
#define ARIZONA_DSP3AUX4MIX_INPUT_1_SOURCE       0x9E8
#define ARIZONA_DSP3AUX5MIX_INPUT_1_SOURCE       0x9F0
#define ARIZONA_DSP3AUX6MIX_INPUT_1_SOURCE       0x9F8
#define ARIZONA_DSP4LMIX_INPUT_1_SOURCE          0xA00
#define ARIZONA_DSP4LMIX_INPUT_1_VOLUME          0xA01
#define ARIZONA_DSP4LMIX_INPUT_2_SOURCE          0xA02
#define ARIZONA_DSP4LMIX_INPUT_2_VOLUME          0xA03
#define ARIZONA_DSP4LMIX_INPUT_3_SOURCE          0xA04
#define ARIZONA_DSP4LMIX_INPUT_3_VOLUME          0xA05
#define ARIZONA_DSP4LMIX_INPUT_4_SOURCE          0xA06
#define ARIZONA_DSP4LMIX_INPUT_4_VOLUME          0xA07
#define ARIZONA_DSP4RMIX_INPUT_1_SOURCE          0xA08
#define ARIZONA_DSP4RMIX_INPUT_1_VOLUME          0xA09
#define ARIZONA_DSP4RMIX_INPUT_2_SOURCE          0xA0A
#define ARIZONA_DSP4RMIX_INPUT_2_VOLUME          0xA0B
#define ARIZONA_DSP4RMIX_INPUT_3_SOURCE          0xA0C
#define ARIZONA_DSP4RMIX_INPUT_3_VOLUME          0xA0D
#define ARIZONA_DSP4RMIX_INPUT_4_SOURCE          0xA0E
#define ARIZONA_DSP4RMIX_INPUT_4_VOLUME          0xA0F
#define ARIZONA_DSP4AUX1MIX_INPUT_1_SOURCE       0xA10
#define ARIZONA_DSP4AUX2MIX_INPUT_1_SOURCE       0xA18
#define ARIZONA_DSP4AUX3MIX_INPUT_1_SOURCE       0xA20
#define ARIZONA_DSP4AUX4MIX_INPUT_1_SOURCE       0xA28
#define ARIZONA_DSP4AUX5MIX_INPUT_1_SOURCE       0xA30
#define ARIZONA_DSP4AUX6MIX_INPUT_1_SOURCE       0xA38
#define ARIZONA_ASRC1LMIX_INPUT_1_SOURCE         0xA80
#define ARIZONA_ASRC1RMIX_INPUT_1_SOURCE         0xA88
#define ARIZONA_ASRC2LMIX_INPUT_1_SOURCE         0xA90
#define ARIZONA_ASRC2RMIX_INPUT_1_SOURCE         0xA98
#define ARIZONA_ISRC1DEC1MIX_INPUT_1_SOURCE      0xB00
#define ARIZONA_ISRC1DEC2MIX_INPUT_1_SOURCE      0xB08
#define ARIZONA_ISRC1DEC3MIX_INPUT_1_SOURCE      0xB10
#define ARIZONA_ISRC1DEC4MIX_INPUT_1_SOURCE      0xB18
#define ARIZONA_ISRC1INT1MIX_INPUT_1_SOURCE      0xB20
#define ARIZONA_ISRC1INT2MIX_INPUT_1_SOURCE      0xB28
#define ARIZONA_ISRC1INT3MIX_INPUT_1_SOURCE      0xB30
#define ARIZONA_ISRC1INT4MIX_INPUT_1_SOURCE      0xB38
#define ARIZONA_ISRC2DEC1MIX_INPUT_1_SOURCE      0xB40
#define ARIZONA_ISRC2DEC2MIX_INPUT_1_SOURCE      0xB48
#define ARIZONA_ISRC2DEC3MIX_INPUT_1_SOURCE      0xB50
#define ARIZONA_ISRC2DEC4MIX_INPUT_1_SOURCE      0xB58
#define ARIZONA_ISRC2INT1MIX_INPUT_1_SOURCE      0xB60
#define ARIZONA_ISRC2INT2MIX_INPUT_1_SOURCE      0xB68
#define ARIZONA_ISRC2INT3MIX_INPUT_1_SOURCE      0xB70
#define ARIZONA_ISRC2INT4MIX_INPUT_1_SOURCE      0xB78
#define ARIZONA_ISRC3DEC1MIX_INPUT_1_SOURCE      0xB80
#define ARIZONA_ISRC3DEC2MIX_INPUT_1_SOURCE      0xB88
#define ARIZONA_ISRC3DEC3MIX_INPUT_1_SOURCE      0xB90
#define ARIZONA_ISRC3DEC4MIX_INPUT_1_SOURCE      0xB98
#define ARIZONA_ISRC3INT1MIX_INPUT_1_SOURCE      0xBA0
#define ARIZONA_ISRC3INT2MIX_INPUT_1_SOURCE      0xBA8
#define ARIZONA_ISRC3INT3MIX_INPUT_1_SOURCE      0xBB0
#define ARIZONA_ISRC3INT4MIX_INPUT_1_SOURCE      0xBB8
#define ARIZONA_GPIO1_CTRL                       0xC00
#define ARIZONA_GPIO2_CTRL                       0xC01
#define ARIZONA_GPIO3_CTRL                       0xC02
#define ARIZONA_GPIO4_CTRL                       0xC03
#define ARIZONA_GPIO5_CTRL                       0xC04
#define ARIZONA_IRQ_CTRL_1                       0xC0F
#define ARIZONA_GPIO_DEBOUNCE_CONFIG             0xC10
#define ARIZONA_GP_SWITCH_1                      0xC18
#define ARIZONA_MISC_PAD_CTRL_1                  0xC20
#define ARIZONA_MISC_PAD_CTRL_2                  0xC21
#define ARIZONA_MISC_PAD_CTRL_3                  0xC22
#define ARIZONA_MISC_PAD_CTRL_4                  0xC23
#define ARIZONA_MISC_PAD_CTRL_5                  0xC24
#define ARIZONA_MISC_PAD_CTRL_6                  0xC25
#define ARIZONA_MISC_PAD_CTRL_7                  0xC30
#define ARIZONA_MISC_PAD_CTRL_8                  0xC31
#define ARIZONA_MISC_PAD_CTRL_9                  0xC32
#define ARIZONA_MISC_PAD_CTRL_10                 0xC33
#define ARIZONA_MISC_PAD_CTRL_11                 0xC34
#define ARIZONA_MISC_PAD_CTRL_12                 0xC35
#define ARIZONA_MISC_PAD_CTRL_13                 0xC36
#define ARIZONA_MISC_PAD_CTRL_14                 0xC37
#define ARIZONA_MISC_PAD_CTRL_15                 0xC38
#define ARIZONA_MISC_PAD_CTRL_16                 0xC39
#define ARIZONA_MISC_PAD_CTRL_17                 0xC3A
#define ARIZONA_MISC_PAD_CTRL_18                 0xC3B
#define ARIZONA_INTERRUPT_STATUS_1               0xD00
#define ARIZONA_INTERRUPT_STATUS_2               0xD01
#define ARIZONA_INTERRUPT_STATUS_3               0xD02
#define ARIZONA_INTERRUPT_STATUS_4               0xD03
#define ARIZONA_INTERRUPT_STATUS_5               0xD04
#define ARIZONA_INTERRUPT_STATUS_6               0xD05
#define ARIZONA_INTERRUPT_STATUS_1_MASK          0xD08
#define ARIZONA_INTERRUPT_STATUS_2_MASK          0xD09
#define ARIZONA_INTERRUPT_STATUS_3_MASK          0xD0A
#define ARIZONA_INTERRUPT_STATUS_4_MASK          0xD0B
#define ARIZONA_INTERRUPT_STATUS_5_MASK          0xD0C
#define ARIZONA_INTERRUPT_STATUS_6_MASK          0xD0D
#define ARIZONA_INTERRUPT_CONTROL                0xD0F
#define ARIZONA_IRQ2_STATUS_1                    0xD10
#define ARIZONA_IRQ2_STATUS_2                    0xD11
#define ARIZONA_IRQ2_STATUS_3                    0xD12
#define ARIZONA_IRQ2_STATUS_4                    0xD13
#define ARIZONA_IRQ2_STATUS_5                    0xD14
#define ARIZONA_IRQ2_STATUS_6                    0xD15
#define ARIZONA_IRQ2_STATUS_1_MASK               0xD18
#define ARIZONA_IRQ2_STATUS_2_MASK               0xD19
#define ARIZONA_IRQ2_STATUS_3_MASK               0xD1A
#define ARIZONA_IRQ2_STATUS_4_MASK               0xD1B
#define ARIZONA_IRQ2_STATUS_5_MASK               0xD1C
#define ARIZONA_IRQ2_STATUS_6_MASK               0xD1D
#define ARIZONA_IRQ2_CONTROL                     0xD1F
#define ARIZONA_INTERRUPT_RAW_STATUS_2           0xD20
#define ARIZONA_INTERRUPT_RAW_STATUS_3           0xD21
#define ARIZONA_INTERRUPT_RAW_STATUS_4           0xD22
#define ARIZONA_INTERRUPT_RAW_STATUS_5           0xD23
#define ARIZONA_INTERRUPT_RAW_STATUS_6           0xD24
#define ARIZONA_INTERRUPT_RAW_STATUS_7           0xD25
#define ARIZONA_INTERRUPT_RAW_STATUS_8           0xD26
#define ARIZONA_INTERRUPT_RAW_STATUS_9           0xD28
#define ARIZONA_IRQ_PIN_STATUS                   0xD40
#define ARIZONA_ADSP2_IRQ0                       0xD41
#define ARIZONA_AOD_WKUP_AND_TRIG                0xD50
#define ARIZONA_AOD_IRQ1                         0xD51
#define ARIZONA_AOD_IRQ2                         0xD52
#define ARIZONA_AOD_IRQ_MASK_IRQ1                0xD53
#define ARIZONA_AOD_IRQ_MASK_IRQ2                0xD54
#define ARIZONA_AOD_IRQ_RAW_STATUS               0xD55
#define ARIZONA_JACK_DETECT_DEBOUNCE             0xD56
#define ARIZONA_FX_CTRL1                         0xE00
#define ARIZONA_FX_CTRL2                         0xE01
#define ARIZONA_EQ1_1                            0xE10
#define ARIZONA_EQ1_2                            0xE11
#define ARIZONA_EQ1_3                            0xE12
#define ARIZONA_EQ1_4                            0xE13
#define ARIZONA_EQ1_5                            0xE14
#define ARIZONA_EQ1_6                            0xE15
#define ARIZONA_EQ1_7                            0xE16
#define ARIZONA_EQ1_8                            0xE17
#define ARIZONA_EQ1_9                            0xE18
#define ARIZONA_EQ1_10                           0xE19
#define ARIZONA_EQ1_11                           0xE1A
#define ARIZONA_EQ1_12                           0xE1B
#define ARIZONA_EQ1_13                           0xE1C
#define ARIZONA_EQ1_14                           0xE1D
#define ARIZONA_EQ1_15                           0xE1E
#define ARIZONA_EQ1_16                           0xE1F
#define ARIZONA_EQ1_17                           0xE20
#define ARIZONA_EQ1_18                           0xE21
#define ARIZONA_EQ1_19                           0xE22
#define ARIZONA_EQ1_20                           0xE23
#define ARIZONA_EQ1_21                           0xE24
#define ARIZONA_EQ2_1                            0xE26
#define ARIZONA_EQ2_2                            0xE27
#define ARIZONA_EQ2_3                            0xE28
#define ARIZONA_EQ2_4                            0xE29
#define ARIZONA_EQ2_5                            0xE2A
#define ARIZONA_EQ2_6                            0xE2B
#define ARIZONA_EQ2_7                            0xE2C
#define ARIZONA_EQ2_8                            0xE2D
#define ARIZONA_EQ2_9                            0xE2E
#define ARIZONA_EQ2_10                           0xE2F
#define ARIZONA_EQ2_11                           0xE30
#define ARIZONA_EQ2_12                           0xE31
#define ARIZONA_EQ2_13                           0xE32
#define ARIZONA_EQ2_14                           0xE33
#define ARIZONA_EQ2_15                           0xE34
#define ARIZONA_EQ2_16                           0xE35
#define ARIZONA_EQ2_17                           0xE36
#define ARIZONA_EQ2_18                           0xE37
#define ARIZONA_EQ2_19                           0xE38
#define ARIZONA_EQ2_20                           0xE39
#define ARIZONA_EQ2_21                           0xE3A
#define ARIZONA_EQ3_1                            0xE3C
#define ARIZONA_EQ3_2                            0xE3D
#define ARIZONA_EQ3_3                            0xE3E
#define ARIZONA_EQ3_4                            0xE3F
#define ARIZONA_EQ3_5                            0xE40
#define ARIZONA_EQ3_6                            0xE41
#define ARIZONA_EQ3_7                            0xE42
#define ARIZONA_EQ3_8                            0xE43
#define ARIZONA_EQ3_9                            0xE44
#define ARIZONA_EQ3_10                           0xE45
#define ARIZONA_EQ3_11                           0xE46
#define ARIZONA_EQ3_12                           0xE47
#define ARIZONA_EQ3_13                           0xE48
#define ARIZONA_EQ3_14                           0xE49
#define ARIZONA_EQ3_15                           0xE4A
#define ARIZONA_EQ3_16                           0xE4B
#define ARIZONA_EQ3_17                           0xE4C
#define ARIZONA_EQ3_18                           0xE4D
#define ARIZONA_EQ3_19                           0xE4E
#define ARIZONA_EQ3_20                           0xE4F
#define ARIZONA_EQ3_21                           0xE50
#define ARIZONA_EQ4_1                            0xE52
#define ARIZONA_EQ4_2                            0xE53
#define ARIZONA_EQ4_3                            0xE54
#define ARIZONA_EQ4_4                            0xE55
#define ARIZONA_EQ4_5                            0xE56
#define ARIZONA_EQ4_6                            0xE57
#define ARIZONA_EQ4_7                            0xE58
#define ARIZONA_EQ4_8                            0xE59
#define ARIZONA_EQ4_9                            0xE5A
#define ARIZONA_EQ4_10                           0xE5B
#define ARIZONA_EQ4_11                           0xE5C
#define ARIZONA_EQ4_12                           0xE5D
#define ARIZONA_EQ4_13                           0xE5E
#define ARIZONA_EQ4_14                           0xE5F
#define ARIZONA_EQ4_15                           0xE60
#define ARIZONA_EQ4_16                           0xE61
#define ARIZONA_EQ4_17                           0xE62
#define ARIZONA_EQ4_18                           0xE63
#define ARIZONA_EQ4_19                           0xE64
#define ARIZONA_EQ4_20                           0xE65
#define ARIZONA_EQ4_21                           0xE66
#define ARIZONA_DRC1_CTRL1                       0xE80
#define ARIZONA_DRC1_CTRL2                       0xE81
#define ARIZONA_DRC1_CTRL3                       0xE82
#define ARIZONA_DRC1_CTRL4                       0xE83
#define ARIZONA_DRC1_CTRL5                       0xE84
#define ARIZONA_DRC2_CTRL1                       0xE89
#define ARIZONA_DRC2_CTRL2                       0xE8A
#define ARIZONA_DRC2_CTRL3                       0xE8B
#define ARIZONA_DRC2_CTRL4                       0xE8C
#define ARIZONA_DRC2_CTRL5                       0xE8D
#define ARIZONA_HPLPF1_1                         0xEC0
#define ARIZONA_HPLPF1_2                         0xEC1
#define ARIZONA_HPLPF2_1                         0xEC4
#define ARIZONA_HPLPF2_2                         0xEC5
#define ARIZONA_HPLPF3_1                         0xEC8
#define ARIZONA_HPLPF3_2                         0xEC9
#define ARIZONA_HPLPF4_1                         0xECC
#define ARIZONA_HPLPF4_2                         0xECD
#define ARIZONA_ASRC_ENABLE                      0xEE0
#define ARIZONA_ASRC_STATUS                      0xEE1
#define ARIZONA_ASRC_RATE1                       0xEE2
#define ARIZONA_ASRC_RATE2                       0xEE3
#define ARIZONA_ISRC_1_CTRL_1                    0xEF0
#define ARIZONA_ISRC_1_CTRL_2                    0xEF1
#define ARIZONA_ISRC_1_CTRL_3                    0xEF2
#define ARIZONA_ISRC_2_CTRL_1                    0xEF3
#define ARIZONA_ISRC_2_CTRL_2                    0xEF4
#define ARIZONA_ISRC_2_CTRL_3                    0xEF5
#define ARIZONA_ISRC_3_CTRL_1                    0xEF6
#define ARIZONA_ISRC_3_CTRL_2                    0xEF7
#define ARIZONA_ISRC_3_CTRL_3                    0xEF8
#define ARIZONA_CLOCK_CONTROL                    0xF00
#define ARIZONA_ANC_SRC                          0xF01
#define ARIZONA_DSP_STATUS                       0xF02
#define ARIZONA_ANC_COEFF_START                  0xF08
#define ARIZONA_ANC_COEFF_END                    0xF12
#define ARIZONA_FCL_FILTER_CONTROL               0xF15
#define ARIZONA_FCL_ADC_REFORMATTER_CONTROL      0xF17
#define ARIZONA_FCL_COEFF_START                  0xF18
#define ARIZONA_FCL_COEFF_END                    0xF69
#define ARIZONA_FCR_FILTER_CONTROL               0xF70
#define ARIZONA_FCR_ADC_REFORMATTER_CONTROL      0xF72
#define ARIZONA_FCR_COEFF_START                  0xF73
#define ARIZONA_FCR_COEFF_END                    0xFC4
#define ARIZONA_DSP1_CONTROL_1                   0x1100
#define ARIZONA_DSP1_CLOCKING_1                  0x1101
#define ARIZONA_DSP1_STATUS_1                    0x1104
#define ARIZONA_DSP1_STATUS_2                    0x1105
#define ARIZONA_DSP1_STATUS_3                    0x1106
#define ARIZONA_DSP1_STATUS_4                    0x1107
#define ARIZONA_DSP1_WDMA_BUFFER_1               0x1110
#define ARIZONA_DSP1_WDMA_BUFFER_2               0x1111
#define ARIZONA_DSP1_WDMA_BUFFER_3               0x1112
#define ARIZONA_DSP1_WDMA_BUFFER_4               0x1113
#define ARIZONA_DSP1_WDMA_BUFFER_5               0x1114
#define ARIZONA_DSP1_WDMA_BUFFER_6               0x1115
#define ARIZONA_DSP1_WDMA_BUFFER_7               0x1116
#define ARIZONA_DSP1_WDMA_BUFFER_8               0x1117
#define ARIZONA_DSP1_RDMA_BUFFER_1               0x1120
#define ARIZONA_DSP1_RDMA_BUFFER_2               0x1121
#define ARIZONA_DSP1_RDMA_BUFFER_3               0x1122
#define ARIZONA_DSP1_RDMA_BUFFER_4               0x1123
#define ARIZONA_DSP1_RDMA_BUFFER_5               0x1124
#define ARIZONA_DSP1_RDMA_BUFFER_6               0x1125
#define ARIZONA_DSP1_WDMA_CONFIG_1               0x1130
#define ARIZONA_DSP1_WDMA_CONFIG_2               0x1131
#define ARIZONA_DSP1_WDMA_OFFSET_1               0x1132
#define ARIZONA_DSP1_RDMA_CONFIG_1               0x1134
#define ARIZONA_DSP1_RDMA_OFFSET_1               0x1135
#define ARIZONA_DSP1_EXTERNAL_START_SELECT_1     0x1138
#define ARIZONA_DSP1_SCRATCH_0                   0x1140
#define ARIZONA_DSP1_SCRATCH_1                   0x1141
#define ARIZONA_DSP1_SCRATCH_2                   0x1142
#define ARIZONA_DSP1_SCRATCH_3                   0x1143
#define ARIZONA_DSP2_CONTROL_1                   0x1200
#define ARIZONA_DSP2_CLOCKING_1                  0x1201
#define ARIZONA_DSP2_STATUS_1                    0x1204
#define ARIZONA_DSP2_STATUS_2                    0x1205
#define ARIZONA_DSP2_STATUS_3                    0x1206
#define ARIZONA_DSP2_STATUS_4                    0x1207
#define ARIZONA_DSP2_WDMA_BUFFER_1               0x1210
#define ARIZONA_DSP2_WDMA_BUFFER_2               0x1211
#define ARIZONA_DSP2_WDMA_BUFFER_3               0x1212
#define ARIZONA_DSP2_WDMA_BUFFER_4               0x1213
#define ARIZONA_DSP2_WDMA_BUFFER_5               0x1214
#define ARIZONA_DSP2_WDMA_BUFFER_6               0x1215
#define ARIZONA_DSP2_WDMA_BUFFER_7               0x1216
#define ARIZONA_DSP2_WDMA_BUFFER_8               0x1217
#define ARIZONA_DSP2_RDMA_BUFFER_1               0x1220
#define ARIZONA_DSP2_RDMA_BUFFER_2               0x1221
#define ARIZONA_DSP2_RDMA_BUFFER_3               0x1222
#define ARIZONA_DSP2_RDMA_BUFFER_4               0x1223
#define ARIZONA_DSP2_RDMA_BUFFER_5               0x1224
#define ARIZONA_DSP2_RDMA_BUFFER_6               0x1225
#define ARIZONA_DSP2_WDMA_CONFIG_1               0x1230
#define ARIZONA_DSP2_WDMA_CONFIG_2               0x1231
#define ARIZONA_DSP2_WDMA_OFFSET_1               0x1232
#define ARIZONA_DSP2_RDMA_CONFIG_1               0x1234
#define ARIZONA_DSP2_RDMA_OFFSET_1               0x1235
#define ARIZONA_DSP2_EXTERNAL_START_SELECT_1     0x1238
#define ARIZONA_DSP2_SCRATCH_0                   0x1240
#define ARIZONA_DSP2_SCRATCH_1                   0x1241
#define ARIZONA_DSP2_SCRATCH_2                   0x1242
#define ARIZONA_DSP2_SCRATCH_3                   0x1243
#define ARIZONA_DSP3_CONTROL_1                   0x1300
#define ARIZONA_DSP3_CLOCKING_1                  0x1301
#define ARIZONA_DSP3_STATUS_1                    0x1304
#define ARIZONA_DSP3_STATUS_2                    0x1305
#define ARIZONA_DSP3_STATUS_3                    0x1306
#define ARIZONA_DSP3_STATUS_4                    0x1307
#define ARIZONA_DSP3_WDMA_BUFFER_1               0x1310
#define ARIZONA_DSP3_WDMA_BUFFER_2               0x1311
#define ARIZONA_DSP3_WDMA_BUFFER_3               0x1312
#define ARIZONA_DSP3_WDMA_BUFFER_4               0x1313
#define ARIZONA_DSP3_WDMA_BUFFER_5               0x1314
#define ARIZONA_DSP3_WDMA_BUFFER_6               0x1315
#define ARIZONA_DSP3_WDMA_BUFFER_7               0x1316
#define ARIZONA_DSP3_WDMA_BUFFER_8               0x1317
#define ARIZONA_DSP3_RDMA_BUFFER_1               0x1320
#define ARIZONA_DSP3_RDMA_BUFFER_2               0x1321
#define ARIZONA_DSP3_RDMA_BUFFER_3               0x1322
#define ARIZONA_DSP3_RDMA_BUFFER_4               0x1323
#define ARIZONA_DSP3_RDMA_BUFFER_5               0x1324
#define ARIZONA_DSP3_RDMA_BUFFER_6               0x1325
#define ARIZONA_DSP3_WDMA_CONFIG_1               0x1330
#define ARIZONA_DSP3_WDMA_CONFIG_2               0x1331
#define ARIZONA_DSP3_WDMA_OFFSET_1               0x1332
#define ARIZONA_DSP3_RDMA_CONFIG_1               0x1334
#define ARIZONA_DSP3_RDMA_OFFSET_1               0x1335
#define ARIZONA_DSP3_EXTERNAL_START_SELECT_1     0x1338
#define ARIZONA_DSP3_SCRATCH_0                   0x1340
#define ARIZONA_DSP3_SCRATCH_1                   0x1341
#define ARIZONA_DSP3_SCRATCH_2                   0x1342
#define ARIZONA_DSP3_SCRATCH_3                   0x1343
#define ARIZONA_DSP4_CONTROL_1                   0x1400
#define ARIZONA_DSP4_CLOCKING_1                  0x1401
#define ARIZONA_DSP4_STATUS_1                    0x1404
#define ARIZONA_DSP4_STATUS_2                    0x1405
#define ARIZONA_DSP4_STATUS_3                    0x1406
#define ARIZONA_DSP4_STATUS_4                    0x1407
#define ARIZONA_DSP4_WDMA_BUFFER_1               0x1410
#define ARIZONA_DSP4_WDMA_BUFFER_2               0x1411
#define ARIZONA_DSP4_WDMA_BUFFER_3               0x1412
#define ARIZONA_DSP4_WDMA_BUFFER_4               0x1413
#define ARIZONA_DSP4_WDMA_BUFFER_5               0x1414
#define ARIZONA_DSP4_WDMA_BUFFER_6               0x1415
#define ARIZONA_DSP4_WDMA_BUFFER_7               0x1416
#define ARIZONA_DSP4_WDMA_BUFFER_8               0x1417
#define ARIZONA_DSP4_RDMA_BUFFER_1               0x1420
#define ARIZONA_DSP4_RDMA_BUFFER_2               0x1421
#define ARIZONA_DSP4_RDMA_BUFFER_3               0x1422
#define ARIZONA_DSP4_RDMA_BUFFER_4               0x1423
#define ARIZONA_DSP4_RDMA_BUFFER_5               0x1424
#define ARIZONA_DSP4_RDMA_BUFFER_6               0x1425
#define ARIZONA_DSP4_WDMA_CONFIG_1               0x1430
#define ARIZONA_DSP4_WDMA_CONFIG_2               0x1431
#define ARIZONA_DSP4_WDMA_OFFSET_1               0x1432
#define ARIZONA_DSP4_RDMA_CONFIG_1               0x1434
#define ARIZONA_DSP4_RDMA_OFFSET_1               0x1435
#define ARIZONA_DSP4_EXTERNAL_START_SELECT_1     0x1438
#define ARIZONA_DSP4_SCRATCH_0                   0x1440
#define ARIZONA_DSP4_SCRATCH_1                   0x1441
#define ARIZONA_DSP4_SCRATCH_2                   0x1442
#define ARIZONA_DSP4_SCRATCH_3                   0x1443




#define ARIZONA_SW_RST_DEV_ID1_MASK              0xFFFF  
#define ARIZONA_SW_RST_DEV_ID1_SHIFT                  0  
#define ARIZONA_SW_RST_DEV_ID1_WIDTH                 16  


#define ARIZONA_DEVICE_REVISION_MASK             0x00FF  
#define ARIZONA_DEVICE_REVISION_SHIFT                 0  
#define ARIZONA_DEVICE_REVISION_WIDTH                 8  


#define ARIZONA_SPI_CFG                          0x0010  
#define ARIZONA_SPI_CFG_MASK                     0x0010  
#define ARIZONA_SPI_CFG_SHIFT                         4  
#define ARIZONA_SPI_CFG_WIDTH                         1  
#define ARIZONA_SPI_4WIRE                        0x0008  
#define ARIZONA_SPI_4WIRE_MASK                   0x0008  
#define ARIZONA_SPI_4WIRE_SHIFT                       3  
#define ARIZONA_SPI_4WIRE_WIDTH                       1  
#define ARIZONA_SPI_AUTO_INC_MASK                0x0003  
#define ARIZONA_SPI_AUTO_INC_SHIFT                    0  
#define ARIZONA_SPI_AUTO_INC_WIDTH                    2  


#define ARIZONA_I2C1_AUTO_INC_MASK               0x0003  
#define ARIZONA_I2C1_AUTO_INC_SHIFT                   0  
#define ARIZONA_I2C1_AUTO_INC_WIDTH                   2  


#define ARIZONA_I2C1_BUSY                        0x0020  
#define ARIZONA_I2C1_BUSY_MASK                   0x0020  
#define ARIZONA_I2C1_BUSY_SHIFT                       5  
#define ARIZONA_I2C1_BUSY_WIDTH                       1  
#define ARIZONA_SPI_BUSY                         0x0010  
#define ARIZONA_SPI_BUSY_MASK                    0x0010  
#define ARIZONA_SPI_BUSY_SHIFT                        4  
#define ARIZONA_SPI_BUSY_WIDTH                        1  


#define ARIZONA_WSEQ_ABORT                       0x0800  
#define ARIZONA_WSEQ_ABORT_MASK                  0x0800  
#define ARIZONA_WSEQ_ABORT_SHIFT                     11  
#define ARIZONA_WSEQ_ABORT_WIDTH                      1  
#define ARIZONA_WSEQ_START                       0x0400  
#define ARIZONA_WSEQ_START_MASK                  0x0400  
#define ARIZONA_WSEQ_START_SHIFT                     10  
#define ARIZONA_WSEQ_START_WIDTH                      1  
#define ARIZONA_WSEQ_ENA                         0x0200  
#define ARIZONA_WSEQ_ENA_MASK                    0x0200  
#define ARIZONA_WSEQ_ENA_SHIFT                        9  
#define ARIZONA_WSEQ_ENA_WIDTH                        1  
#define ARIZONA_WSEQ_START_INDEX_MASK            0x01FF  
#define ARIZONA_WSEQ_START_INDEX_SHIFT                0  
#define ARIZONA_WSEQ_START_INDEX_WIDTH                9  


#define ARIZONA_WSEQ_BUSY                        0x0200  
#define ARIZONA_WSEQ_BUSY_MASK                   0x0200  
#define ARIZONA_WSEQ_BUSY_SHIFT                       9  
#define ARIZONA_WSEQ_BUSY_WIDTH                       1  
#define ARIZONA_WSEQ_CURRENT_INDEX_MASK          0x01FF  
#define ARIZONA_WSEQ_CURRENT_INDEX_SHIFT              0  
#define ARIZONA_WSEQ_CURRENT_INDEX_WIDTH              9  


#define ARIZONA_LOAD_DEFAULTS                    0x0002  
#define ARIZONA_LOAD_DEFAULTS_MASK               0x0002  
#define ARIZONA_LOAD_DEFAULTS_SHIFT                   1  
#define ARIZONA_LOAD_DEFAULTS_WIDTH                   1  
#define ARIZONA_WSEQ_LOAD_MEM                    0x0001  
#define ARIZONA_WSEQ_LOAD_MEM_MASK               0x0001  
#define ARIZONA_WSEQ_LOAD_MEM_SHIFT                   0  
#define ARIZONA_WSEQ_LOAD_MEM_WIDTH                   1  


#define ARIZONA_WSEQ_OTP_WRITE                   0x0001  
#define ARIZONA_WSEQ_OTP_WRITE_MASK              0x0001  
#define ARIZONA_WSEQ_OTP_WRITE_SHIFT                  0  
#define ARIZONA_WSEQ_OTP_WRITE_WIDTH                  1  


#define ARIZONA_TONE_RATE_MASK                   0x7800  
#define ARIZONA_TONE_RATE_SHIFT                      11  
#define ARIZONA_TONE_RATE_WIDTH                       4  
#define ARIZONA_TONE_OFFSET_MASK                 0x0300  
#define ARIZONA_TONE_OFFSET_SHIFT                     8  
#define ARIZONA_TONE_OFFSET_WIDTH                     2  
#define ARIZONA_TONE2_OVD                        0x0020  
#define ARIZONA_TONE2_OVD_MASK                   0x0020  
#define ARIZONA_TONE2_OVD_SHIFT                       5  
#define ARIZONA_TONE2_OVD_WIDTH                       1  
#define ARIZONA_TONE1_OVD                        0x0010  
#define ARIZONA_TONE1_OVD_MASK                   0x0010  
#define ARIZONA_TONE1_OVD_SHIFT                       4  
#define ARIZONA_TONE1_OVD_WIDTH                       1  
#define ARIZONA_TONE2_ENA                        0x0002  
#define ARIZONA_TONE2_ENA_MASK                   0x0002  
#define ARIZONA_TONE2_ENA_SHIFT                       1  
#define ARIZONA_TONE2_ENA_WIDTH                       1  
#define ARIZONA_TONE1_ENA                        0x0001  
#define ARIZONA_TONE1_ENA_MASK                   0x0001  
#define ARIZONA_TONE1_ENA_SHIFT                       0  
#define ARIZONA_TONE1_ENA_WIDTH                       1  


#define ARIZONA_TONE1_LVL_0_MASK                 0xFFFF  
#define ARIZONA_TONE1_LVL_0_SHIFT                     0  
#define ARIZONA_TONE1_LVL_0_WIDTH                    16  


#define ARIZONA_TONE1_LVL_MASK                   0x00FF  
#define ARIZONA_TONE1_LVL_SHIFT                       0  
#define ARIZONA_TONE1_LVL_WIDTH                       8  


#define ARIZONA_TONE2_LVL_0_MASK                 0xFFFF  
#define ARIZONA_TONE2_LVL_0_SHIFT                     0  
#define ARIZONA_TONE2_LVL_0_WIDTH                    16  


#define ARIZONA_TONE2_LVL_MASK                   0x00FF  
#define ARIZONA_TONE2_LVL_SHIFT                       0  
#define ARIZONA_TONE2_LVL_WIDTH                       8  


#define ARIZONA_PWM_RATE_MASK                    0x7800  
#define ARIZONA_PWM_RATE_SHIFT                       11  
#define ARIZONA_PWM_RATE_WIDTH                        4  
#define ARIZONA_PWM_CLK_SEL_MASK                 0x0700  
#define ARIZONA_PWM_CLK_SEL_SHIFT                     8  
#define ARIZONA_PWM_CLK_SEL_WIDTH                     3  
#define ARIZONA_PWM2_OVD                         0x0020  
#define ARIZONA_PWM2_OVD_MASK                    0x0020  
#define ARIZONA_PWM2_OVD_SHIFT                        5  
#define ARIZONA_PWM2_OVD_WIDTH                        1  
#define ARIZONA_PWM1_OVD                         0x0010  
#define ARIZONA_PWM1_OVD_MASK                    0x0010  
#define ARIZONA_PWM1_OVD_SHIFT                        4  
#define ARIZONA_PWM1_OVD_WIDTH                        1  
#define ARIZONA_PWM2_ENA                         0x0002  
#define ARIZONA_PWM2_ENA_MASK                    0x0002  
#define ARIZONA_PWM2_ENA_SHIFT                        1  
#define ARIZONA_PWM2_ENA_WIDTH                        1  
#define ARIZONA_PWM1_ENA                         0x0001  
#define ARIZONA_PWM1_ENA_MASK                    0x0001  
#define ARIZONA_PWM1_ENA_SHIFT                        0  
#define ARIZONA_PWM1_ENA_WIDTH                        1  


#define ARIZONA_PWM1_LVL_MASK                    0x03FF  
#define ARIZONA_PWM1_LVL_SHIFT                        0  
#define ARIZONA_PWM1_LVL_WIDTH                       10  


#define ARIZONA_PWM2_LVL_MASK                    0x03FF  
#define ARIZONA_PWM2_LVL_SHIFT                        0  
#define ARIZONA_PWM2_LVL_WIDTH                       10  


#define ARIZONA_WKUP_MICD_CLAMP_FALL             0x0080  
#define ARIZONA_WKUP_MICD_CLAMP_FALL_MASK        0x0080  
#define ARIZONA_WKUP_MICD_CLAMP_FALL_SHIFT            7  
#define ARIZONA_WKUP_MICD_CLAMP_FALL_WIDTH            1  
#define ARIZONA_WKUP_MICD_CLAMP_RISE             0x0040  
#define ARIZONA_WKUP_MICD_CLAMP_RISE_MASK        0x0040  
#define ARIZONA_WKUP_MICD_CLAMP_RISE_SHIFT            6  
#define ARIZONA_WKUP_MICD_CLAMP_RISE_WIDTH            1  
#define ARIZONA_WKUP_GP5_FALL                    0x0020  
#define ARIZONA_WKUP_GP5_FALL_MASK               0x0020  
#define ARIZONA_WKUP_GP5_FALL_SHIFT                   5  
#define ARIZONA_WKUP_GP5_FALL_WIDTH                   1  
#define ARIZONA_WKUP_GP5_RISE                    0x0010  
#define ARIZONA_WKUP_GP5_RISE_MASK               0x0010  
#define ARIZONA_WKUP_GP5_RISE_SHIFT                   4  
#define ARIZONA_WKUP_GP5_RISE_WIDTH                   1  
#define ARIZONA_WKUP_JD1_FALL                    0x0008  
#define ARIZONA_WKUP_JD1_FALL_MASK               0x0008  
#define ARIZONA_WKUP_JD1_FALL_SHIFT                   3  
#define ARIZONA_WKUP_JD1_FALL_WIDTH                   1  
#define ARIZONA_WKUP_JD1_RISE                    0x0004  
#define ARIZONA_WKUP_JD1_RISE_MASK               0x0004  
#define ARIZONA_WKUP_JD1_RISE_SHIFT                   2  
#define ARIZONA_WKUP_JD1_RISE_WIDTH                   1  
#define ARIZONA_WKUP_JD2_FALL                    0x0002  
#define ARIZONA_WKUP_JD2_FALL_MASK               0x0002  
#define ARIZONA_WKUP_JD2_FALL_SHIFT                   1  
#define ARIZONA_WKUP_JD2_FALL_WIDTH                   1  
#define ARIZONA_WKUP_JD2_RISE                    0x0001  
#define ARIZONA_WKUP_JD2_RISE_MASK               0x0001  
#define ARIZONA_WKUP_JD2_RISE_SHIFT                   0  
#define ARIZONA_WKUP_JD2_RISE_WIDTH                   1  


#define ARIZONA_WSEQ_ENA_GP5_FALL                0x0020  
#define ARIZONA_WSEQ_ENA_GP5_FALL_MASK           0x0020  
#define ARIZONA_WSEQ_ENA_GP5_FALL_SHIFT               5  
#define ARIZONA_WSEQ_ENA_GP5_FALL_WIDTH               1  
#define ARIZONA_WSEQ_ENA_GP5_RISE                0x0010  
#define ARIZONA_WSEQ_ENA_GP5_RISE_MASK           0x0010  
#define ARIZONA_WSEQ_ENA_GP5_RISE_SHIFT               4  
#define ARIZONA_WSEQ_ENA_GP5_RISE_WIDTH               1  
#define ARIZONA_WSEQ_ENA_JD1_FALL                0x0008  
#define ARIZONA_WSEQ_ENA_JD1_FALL_MASK           0x0008  
#define ARIZONA_WSEQ_ENA_JD1_FALL_SHIFT               3  
#define ARIZONA_WSEQ_ENA_JD1_FALL_WIDTH               1  
#define ARIZONA_WSEQ_ENA_JD1_RISE                0x0004  
#define ARIZONA_WSEQ_ENA_JD1_RISE_MASK           0x0004  
#define ARIZONA_WSEQ_ENA_JD1_RISE_SHIFT               2  
#define ARIZONA_WSEQ_ENA_JD1_RISE_WIDTH               1  
#define ARIZONA_WSEQ_ENA_JD2_FALL                0x0002  
#define ARIZONA_WSEQ_ENA_JD2_FALL_MASK           0x0002  
#define ARIZONA_WSEQ_ENA_JD2_FALL_SHIFT               1  
#define ARIZONA_WSEQ_ENA_JD2_FALL_WIDTH               1  
#define ARIZONA_WSEQ_ENA_JD2_RISE                0x0001  
#define ARIZONA_WSEQ_ENA_JD2_RISE_MASK           0x0001  
#define ARIZONA_WSEQ_ENA_JD2_RISE_SHIFT               0  
#define ARIZONA_WSEQ_ENA_JD2_RISE_WIDTH               1  


#define ARIZONA_WS_TRG8                          0x0080  
#define ARIZONA_WS_TRG8_MASK                     0x0080  
#define ARIZONA_WS_TRG8_SHIFT                         7  
#define ARIZONA_WS_TRG8_WIDTH                         1  
#define ARIZONA_WS_TRG7                          0x0040  
#define ARIZONA_WS_TRG7_MASK                     0x0040  
#define ARIZONA_WS_TRG7_SHIFT                         6  
#define ARIZONA_WS_TRG7_WIDTH                         1  
#define ARIZONA_WS_TRG6                          0x0020  
#define ARIZONA_WS_TRG6_MASK                     0x0020  
#define ARIZONA_WS_TRG6_SHIFT                         5  
#define ARIZONA_WS_TRG6_WIDTH                         1  
#define ARIZONA_WS_TRG5                          0x0010  
#define ARIZONA_WS_TRG5_MASK                     0x0010  
#define ARIZONA_WS_TRG5_SHIFT                         4  
#define ARIZONA_WS_TRG5_WIDTH                         1  
#define ARIZONA_WS_TRG4                          0x0008  
#define ARIZONA_WS_TRG4_MASK                     0x0008  
#define ARIZONA_WS_TRG4_SHIFT                         3  
#define ARIZONA_WS_TRG4_WIDTH                         1  
#define ARIZONA_WS_TRG3                          0x0004  
#define ARIZONA_WS_TRG3_MASK                     0x0004  
#define ARIZONA_WS_TRG3_SHIFT                         2  
#define ARIZONA_WS_TRG3_WIDTH                         1  
#define ARIZONA_WS_TRG2                          0x0002  
#define ARIZONA_WS_TRG2_MASK                     0x0002  
#define ARIZONA_WS_TRG2_SHIFT                         1  
#define ARIZONA_WS_TRG2_WIDTH                         1  
#define ARIZONA_WS_TRG1                          0x0001  
#define ARIZONA_WS_TRG1_MASK                     0x0001  
#define ARIZONA_WS_TRG1_SHIFT                         0  
#define ARIZONA_WS_TRG1_WIDTH                         1  


#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_A_SEQ_ADDR_MASK 0x01FF  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_A_SEQ_ADDR_SHIFT      0  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_A_SEQ_ADDR_WIDTH      9  


#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_B_SEQ_ADDR_MASK 0x01FF  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_B_SEQ_ADDR_SHIFT      0  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_B_SEQ_ADDR_WIDTH      9  


#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_C_SEQ_ADDR_MASK 0x01FF  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_C_SEQ_ADDR_SHIFT      0  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_C_SEQ_ADDR_WIDTH      9  


#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_D_SEQ_ADDR_MASK 0x01FF  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_D_SEQ_ADDR_SHIFT      0  
#define ARIZONA_WSEQ_SAMPLE_RATE_DETECT_D_SEQ_ADDR_WIDTH      9  


#define ARIZONA_WSEQ_GP5_RISE_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_GP5_RISE_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_GP5_RISE_SEQ_ADDR_WIDTH          9  


#define ARIZONA_WSEQ_GP5_FALL_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_GP5_FALL_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_GP5_FALL_SEQ_ADDR_WIDTH          9  


#define ARIZONA_WSEQ_JD1_RISE_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_JD1_RISE_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_JD1_RISE_SEQ_ADDR_WIDTH          9  


#define ARIZONA_WSEQ_JD1_FALL_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_JD1_FALL_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_JD1_FALL_SEQ_ADDR_WIDTH          9  


#define ARIZONA_WSEQ_JD2_RISE_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_JD2_RISE_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_JD2_RISE_SEQ_ADDR_WIDTH          9  


#define ARIZONA_WSEQ_JD2_FALL_SEQ_ADDR_MASK      0x01FF  
#define ARIZONA_WSEQ_JD2_FALL_SEQ_ADDR_SHIFT          0  
#define ARIZONA_WSEQ_JD2_FALL_SEQ_ADDR_WIDTH          9  


#define ARIZONA_NOISE_GEN_RATE_MASK              0x7800  
#define ARIZONA_NOISE_GEN_RATE_SHIFT                 11  
#define ARIZONA_NOISE_GEN_RATE_WIDTH                  4  
#define ARIZONA_NOISE_GEN_ENA                    0x0020  
#define ARIZONA_NOISE_GEN_ENA_MASK               0x0020  
#define ARIZONA_NOISE_GEN_ENA_SHIFT                   5  
#define ARIZONA_NOISE_GEN_ENA_WIDTH                   1  
#define ARIZONA_NOISE_GEN_GAIN_MASK              0x001F  
#define ARIZONA_NOISE_GEN_GAIN_SHIFT                  0  
#define ARIZONA_NOISE_GEN_GAIN_WIDTH                  5  


#define ARIZONA_HAP_RATE_MASK                    0x7800  
#define ARIZONA_HAP_RATE_SHIFT                       11  
#define ARIZONA_HAP_RATE_WIDTH                        4  
#define ARIZONA_ONESHOT_TRIG                     0x0010  
#define ARIZONA_ONESHOT_TRIG_MASK                0x0010  
#define ARIZONA_ONESHOT_TRIG_SHIFT                    4  
#define ARIZONA_ONESHOT_TRIG_WIDTH                    1  
#define ARIZONA_HAP_CTRL_MASK                    0x000C  
#define ARIZONA_HAP_CTRL_SHIFT                        2  
#define ARIZONA_HAP_CTRL_WIDTH                        2  
#define ARIZONA_HAP_ACT                          0x0002  
#define ARIZONA_HAP_ACT_MASK                     0x0002  
#define ARIZONA_HAP_ACT_SHIFT                         1  
#define ARIZONA_HAP_ACT_WIDTH                         1  


#define ARIZONA_LRA_FREQ_MASK                    0x7FFF  
#define ARIZONA_LRA_FREQ_SHIFT                        0  
#define ARIZONA_LRA_FREQ_WIDTH                       15  


#define ARIZONA_PHASE1_INTENSITY_MASK            0x00FF  
#define ARIZONA_PHASE1_INTENSITY_SHIFT                0  
#define ARIZONA_PHASE1_INTENSITY_WIDTH                8  


#define ARIZONA_PHASE1_DURATION_MASK             0x01FF  
#define ARIZONA_PHASE1_DURATION_SHIFT                 0  
#define ARIZONA_PHASE1_DURATION_WIDTH                 9  


#define ARIZONA_PHASE2_INTENSITY_MASK            0x00FF  
#define ARIZONA_PHASE2_INTENSITY_SHIFT                0  
#define ARIZONA_PHASE2_INTENSITY_WIDTH                8  


#define ARIZONA_PHASE2_DURATION_MASK             0x07FF  
#define ARIZONA_PHASE2_DURATION_SHIFT                 0  
#define ARIZONA_PHASE2_DURATION_WIDTH                11  


#define ARIZONA_PHASE3_INTENSITY_MASK            0x00FF  
#define ARIZONA_PHASE3_INTENSITY_SHIFT                0  
#define ARIZONA_PHASE3_INTENSITY_WIDTH                8  


#define ARIZONA_PHASE3_DURATION_MASK             0x01FF  
#define ARIZONA_PHASE3_DURATION_SHIFT                 0  
#define ARIZONA_PHASE3_DURATION_WIDTH                 9  


#define ARIZONA_ONESHOT_STS                      0x0001  
#define ARIZONA_ONESHOT_STS_MASK                 0x0001  
#define ARIZONA_ONESHOT_STS_SHIFT                     0  
#define ARIZONA_ONESHOT_STS_WIDTH                     1  


#define ARIZONA_CLK_32K_ENA                      0x0040  
#define ARIZONA_CLK_32K_ENA_MASK                 0x0040  
#define ARIZONA_CLK_32K_ENA_SHIFT                     6  
#define ARIZONA_CLK_32K_ENA_WIDTH                     1  
#define ARIZONA_CLK_32K_SRC_MASK                 0x0003  
#define ARIZONA_CLK_32K_SRC_SHIFT                     0  
#define ARIZONA_CLK_32K_SRC_WIDTH                     2  


#define ARIZONA_SYSCLK_FRAC                      0x8000  
#define ARIZONA_SYSCLK_FRAC_MASK                 0x8000  
#define ARIZONA_SYSCLK_FRAC_SHIFT                    15  
#define ARIZONA_SYSCLK_FRAC_WIDTH                     1  
#define ARIZONA_SYSCLK_FREQ_MASK                 0x0700  
#define ARIZONA_SYSCLK_FREQ_SHIFT                     8  
#define ARIZONA_SYSCLK_FREQ_WIDTH                     3  
#define ARIZONA_SYSCLK_ENA                       0x0040  
#define ARIZONA_SYSCLK_ENA_MASK                  0x0040  
#define ARIZONA_SYSCLK_ENA_SHIFT                      6  
#define ARIZONA_SYSCLK_ENA_WIDTH                      1  
#define ARIZONA_SYSCLK_SRC_MASK                  0x000F  
#define ARIZONA_SYSCLK_SRC_SHIFT                      0  
#define ARIZONA_SYSCLK_SRC_WIDTH                      4  


#define ARIZONA_SAMPLE_RATE_1_MASK               0x001F  
#define ARIZONA_SAMPLE_RATE_1_SHIFT                   0  
#define ARIZONA_SAMPLE_RATE_1_WIDTH                   5  


#define ARIZONA_SAMPLE_RATE_2_MASK               0x001F  
#define ARIZONA_SAMPLE_RATE_2_SHIFT                   0  
#define ARIZONA_SAMPLE_RATE_2_WIDTH                   5  


#define ARIZONA_SAMPLE_RATE_3_MASK               0x001F  
#define ARIZONA_SAMPLE_RATE_3_SHIFT                   0  
#define ARIZONA_SAMPLE_RATE_3_WIDTH                   5  


#define ARIZONA_SAMPLE_RATE_1_STS_MASK           0x001F  
#define ARIZONA_SAMPLE_RATE_1_STS_SHIFT               0  
#define ARIZONA_SAMPLE_RATE_1_STS_WIDTH               5  


#define ARIZONA_SAMPLE_RATE_2_STS_MASK           0x001F  
#define ARIZONA_SAMPLE_RATE_2_STS_SHIFT               0  
#define ARIZONA_SAMPLE_RATE_2_STS_WIDTH               5  


#define ARIZONA_SAMPLE_RATE_3_STS_MASK           0x001F  
#define ARIZONA_SAMPLE_RATE_3_STS_SHIFT               0  
#define ARIZONA_SAMPLE_RATE_3_STS_WIDTH               5  


#define ARIZONA_ASYNC_CLK_FREQ_MASK              0x0700  
#define ARIZONA_ASYNC_CLK_FREQ_SHIFT                  8  
#define ARIZONA_ASYNC_CLK_FREQ_WIDTH                  3  
#define ARIZONA_ASYNC_CLK_ENA                    0x0040  
#define ARIZONA_ASYNC_CLK_ENA_MASK               0x0040  
#define ARIZONA_ASYNC_CLK_ENA_SHIFT                   6  
#define ARIZONA_ASYNC_CLK_ENA_WIDTH                   1  
#define ARIZONA_ASYNC_CLK_SRC_MASK               0x000F  
#define ARIZONA_ASYNC_CLK_SRC_SHIFT                   0  
#define ARIZONA_ASYNC_CLK_SRC_WIDTH                   4  


#define ARIZONA_ASYNC_SAMPLE_RATE_1_MASK         0x001F  
#define ARIZONA_ASYNC_SAMPLE_RATE_1_SHIFT             0  
#define ARIZONA_ASYNC_SAMPLE_RATE_1_WIDTH             5  


#define ARIZONA_ASYNC_SAMPLE_RATE_2_MASK         0x001F  
#define ARIZONA_ASYNC_SAMPLE_RATE_2_SHIFT             0  
#define ARIZONA_ASYNC_SAMPLE_RATE_2_WIDTH             5  


#define ARIZONA_ASYNC_SAMPLE_RATE_1_STS_MASK     0x001F  
#define ARIZONA_ASYNC_SAMPLE_RATE_1_STS_SHIFT         0  
#define ARIZONA_ASYNC_SAMPLE_RATE_1_STS_WIDTH         5  


#define ARIZONA_ASYNC_SAMPLE_RATE_2_STS_MASK     0x001F  
#define ARIZONA_ASYNC_SAMPLE_RATE_2_STS_SHIFT         0  
#define ARIZONA_ASYNC_SAMPLE_RATE_2_STS_WIDTH         5  


#define ARIZONA_OPCLK_ENA                        0x8000  
#define ARIZONA_OPCLK_ENA_MASK                   0x8000  
#define ARIZONA_OPCLK_ENA_SHIFT                      15  
#define ARIZONA_OPCLK_ENA_WIDTH                       1  
#define ARIZONA_OPCLK_DIV_MASK                   0x00F8  
#define ARIZONA_OPCLK_DIV_SHIFT                       3  
#define ARIZONA_OPCLK_DIV_WIDTH                       5  
#define ARIZONA_OPCLK_SEL_MASK                   0x0007  
#define ARIZONA_OPCLK_SEL_SHIFT                       0  
#define ARIZONA_OPCLK_SEL_WIDTH                       3  


#define ARIZONA_OPCLK_ASYNC_ENA                  0x8000  
#define ARIZONA_OPCLK_ASYNC_ENA_MASK             0x8000  
#define ARIZONA_OPCLK_ASYNC_ENA_SHIFT                15  
#define ARIZONA_OPCLK_ASYNC_ENA_WIDTH                 1  
#define ARIZONA_OPCLK_ASYNC_DIV_MASK             0x00F8  
#define ARIZONA_OPCLK_ASYNC_DIV_SHIFT                 3  
#define ARIZONA_OPCLK_ASYNC_DIV_WIDTH                 5  
#define ARIZONA_OPCLK_ASYNC_SEL_MASK             0x0007  
#define ARIZONA_OPCLK_ASYNC_SEL_SHIFT                 0  
#define ARIZONA_OPCLK_ASYNC_SEL_WIDTH                 3  


#define ARIZONA_TRIG_ON_STARTUP                  0x0010  
#define ARIZONA_TRIG_ON_STARTUP_MASK             0x0010  
#define ARIZONA_TRIG_ON_STARTUP_SHIFT                 4  
#define ARIZONA_TRIG_ON_STARTUP_WIDTH                 1  
#define ARIZONA_LRCLK_SRC_MASK                   0x000E  
#define ARIZONA_LRCLK_SRC_SHIFT                       1  
#define ARIZONA_LRCLK_SRC_WIDTH                       3  
#define ARIZONA_RATE_EST_ENA                     0x0001  
#define ARIZONA_RATE_EST_ENA_MASK                0x0001  
#define ARIZONA_RATE_EST_ENA_SHIFT                    0  
#define ARIZONA_RATE_EST_ENA_WIDTH                    1  


#define ARIZONA_SAMPLE_RATE_DETECT_A_MASK        0x001F  
#define ARIZONA_SAMPLE_RATE_DETECT_A_SHIFT            0  
#define ARIZONA_SAMPLE_RATE_DETECT_A_WIDTH            5  


#define ARIZONA_SAMPLE_RATE_DETECT_B_MASK        0x001F  
#define ARIZONA_SAMPLE_RATE_DETECT_B_SHIFT            0  
#define ARIZONA_SAMPLE_RATE_DETECT_B_WIDTH            5  


#define ARIZONA_SAMPLE_RATE_DETECT_C_MASK        0x001F  
#define ARIZONA_SAMPLE_RATE_DETECT_C_SHIFT            0  
#define ARIZONA_SAMPLE_RATE_DETECT_C_WIDTH            5  


#define ARIZONA_SAMPLE_RATE_DETECT_D_MASK        0x001F  
#define ARIZONA_SAMPLE_RATE_DETECT_D_SHIFT            0  
#define ARIZONA_SAMPLE_RATE_DETECT_D_WIDTH            5  


#define ARIZONA_SUBSYS_MAX_FREQ                  0x0001  
#define ARIZONA_SUBSYS_MAX_FREQ_SHIFT                 0  
#define ARIZONA_SUBSYS_MAX_FREQ_WIDTH                 1  


#define ARIZONA_FLL1_FREERUN                     0x0002  
#define ARIZONA_FLL1_FREERUN_MASK                0x0002  
#define ARIZONA_FLL1_FREERUN_SHIFT                    1  
#define ARIZONA_FLL1_FREERUN_WIDTH                    1  
#define ARIZONA_FLL1_ENA                         0x0001  
#define ARIZONA_FLL1_ENA_MASK                    0x0001  
#define ARIZONA_FLL1_ENA_SHIFT                        0  
#define ARIZONA_FLL1_ENA_WIDTH                        1  


#define ARIZONA_FLL1_CTRL_UPD                    0x8000  
#define ARIZONA_FLL1_CTRL_UPD_MASK               0x8000  
#define ARIZONA_FLL1_CTRL_UPD_SHIFT                  15  
#define ARIZONA_FLL1_CTRL_UPD_WIDTH                   1  
#define ARIZONA_FLL1_N_MASK                      0x03FF  
#define ARIZONA_FLL1_N_SHIFT                          0  
#define ARIZONA_FLL1_N_WIDTH                         10  


#define ARIZONA_FLL1_THETA_MASK                  0xFFFF  
#define ARIZONA_FLL1_THETA_SHIFT                      0  
#define ARIZONA_FLL1_THETA_WIDTH                     16  


#define ARIZONA_FLL1_LAMBDA_MASK                 0xFFFF  
#define ARIZONA_FLL1_LAMBDA_SHIFT                     0  
#define ARIZONA_FLL1_LAMBDA_WIDTH                    16  


#define ARIZONA_FLL1_FRATIO_MASK                 0x0F00  
#define ARIZONA_FLL1_FRATIO_SHIFT                     8  
#define ARIZONA_FLL1_FRATIO_WIDTH                     4  
#define ARIZONA_FLL1_OUTDIV_MASK                 0x000E  
#define ARIZONA_FLL1_OUTDIV_SHIFT                     1  
#define ARIZONA_FLL1_OUTDIV_WIDTH                     3  


#define ARIZONA_FLL1_CLK_REF_DIV_MASK            0x00C0  
#define ARIZONA_FLL1_CLK_REF_DIV_SHIFT                6  
#define ARIZONA_FLL1_CLK_REF_DIV_WIDTH                2  
#define ARIZONA_FLL1_CLK_REF_SRC_MASK            0x000F  
#define ARIZONA_FLL1_CLK_REF_SRC_SHIFT                0  
#define ARIZONA_FLL1_CLK_REF_SRC_WIDTH                4  


#define ARIZONA_FLL1_FRC_INTEG_UPD               0x8000  
#define ARIZONA_FLL1_FRC_INTEG_UPD_MASK          0x8000  
#define ARIZONA_FLL1_FRC_INTEG_UPD_SHIFT             15  
#define ARIZONA_FLL1_FRC_INTEG_UPD_WIDTH              1  
#define ARIZONA_FLL1_FRC_INTEG_VAL_MASK          0x0FFF  
#define ARIZONA_FLL1_FRC_INTEG_VAL_SHIFT              0  
#define ARIZONA_FLL1_FRC_INTEG_VAL_WIDTH             12  


#define ARIZONA_FLL1_GAIN_MASK                   0x003c  
#define ARIZONA_FLL1_GAIN_SHIFT                       2  
#define ARIZONA_FLL1_GAIN_WIDTH                       4  


#define ARIZONA_FLL1_SYNC_ENA                    0x0001  
#define ARIZONA_FLL1_SYNC_ENA_MASK               0x0001  
#define ARIZONA_FLL1_SYNC_ENA_SHIFT                   0  
#define ARIZONA_FLL1_SYNC_ENA_WIDTH                   1  


#define ARIZONA_FLL1_SYNC_N_MASK                 0x03FF  
#define ARIZONA_FLL1_SYNC_N_SHIFT                     0  
#define ARIZONA_FLL1_SYNC_N_WIDTH                    10  


#define ARIZONA_FLL1_SYNC_THETA_MASK             0xFFFF  
#define ARIZONA_FLL1_SYNC_THETA_SHIFT                 0  
#define ARIZONA_FLL1_SYNC_THETA_WIDTH                16  


#define ARIZONA_FLL1_SYNC_LAMBDA_MASK            0xFFFF  
#define ARIZONA_FLL1_SYNC_LAMBDA_SHIFT                0  
#define ARIZONA_FLL1_SYNC_LAMBDA_WIDTH               16  


#define ARIZONA_FLL1_SYNC_FRATIO_MASK            0x0700  
#define ARIZONA_FLL1_SYNC_FRATIO_SHIFT                8  
#define ARIZONA_FLL1_SYNC_FRATIO_WIDTH                3  


#define ARIZONA_FLL1_CLK_SYNC_DIV_MASK           0x00C0  
#define ARIZONA_FLL1_CLK_SYNC_DIV_SHIFT               6  
#define ARIZONA_FLL1_CLK_SYNC_DIV_WIDTH               2  
#define ARIZONA_FLL1_CLK_SYNC_SRC_MASK           0x000F  
#define ARIZONA_FLL1_CLK_SYNC_SRC_SHIFT               0  
#define ARIZONA_FLL1_CLK_SYNC_SRC_WIDTH               4  


#define ARIZONA_FLL1_SYNC_GAIN_MASK              0x003c  
#define ARIZONA_FLL1_SYNC_GAIN_SHIFT                  2  
#define ARIZONA_FLL1_SYNC_GAIN_WIDTH                  4  
#define ARIZONA_FLL1_SYNC_BW                     0x0001  
#define ARIZONA_FLL1_SYNC_BW_MASK                0x0001  
#define ARIZONA_FLL1_SYNC_BW_SHIFT                    0  
#define ARIZONA_FLL1_SYNC_BW_WIDTH                    1  


#define ARIZONA_FLL1_SS_AMPL_MASK                0x0030  
#define ARIZONA_FLL1_SS_AMPL_SHIFT                    4  
#define ARIZONA_FLL1_SS_AMPL_WIDTH                    2  
#define ARIZONA_FLL1_SS_FREQ_MASK                0x000C  
#define ARIZONA_FLL1_SS_FREQ_SHIFT                    2  
#define ARIZONA_FLL1_SS_FREQ_WIDTH                    2  
#define ARIZONA_FLL1_SS_SEL_MASK                 0x0003  
#define ARIZONA_FLL1_SS_SEL_SHIFT                     0  
#define ARIZONA_FLL1_SS_SEL_WIDTH                     2  


#define ARIZONA_FLL1_GPDIV_MASK                  0x00FE  
#define ARIZONA_FLL1_GPDIV_SHIFT                      1  
#define ARIZONA_FLL1_GPDIV_WIDTH                      7  
#define ARIZONA_FLL1_GPDIV_ENA                   0x0001  
#define ARIZONA_FLL1_GPDIV_ENA_MASK              0x0001  
#define ARIZONA_FLL1_GPDIV_ENA_SHIFT                  0  
#define ARIZONA_FLL1_GPDIV_ENA_WIDTH                  1  


#define ARIZONA_FLL2_FREERUN                     0x0002  
#define ARIZONA_FLL2_FREERUN_MASK                0x0002  
#define ARIZONA_FLL2_FREERUN_SHIFT                    1  
#define ARIZONA_FLL2_FREERUN_WIDTH                    1  
#define ARIZONA_FLL2_ENA                         0x0001  
#define ARIZONA_FLL2_ENA_MASK                    0x0001  
#define ARIZONA_FLL2_ENA_SHIFT                        0  
#define ARIZONA_FLL2_ENA_WIDTH                        1  


#define ARIZONA_FLL2_CTRL_UPD                    0x8000  
#define ARIZONA_FLL2_CTRL_UPD_MASK               0x8000  
#define ARIZONA_FLL2_CTRL_UPD_SHIFT                  15  
#define ARIZONA_FLL2_CTRL_UPD_WIDTH                   1  
#define ARIZONA_FLL2_N_MASK                      0x03FF  
#define ARIZONA_FLL2_N_SHIFT                          0  
#define ARIZONA_FLL2_N_WIDTH                         10  


#define ARIZONA_FLL2_THETA_MASK                  0xFFFF  
#define ARIZONA_FLL2_THETA_SHIFT                      0  
#define ARIZONA_FLL2_THETA_WIDTH                     16  


#define ARIZONA_FLL2_LAMBDA_MASK                 0xFFFF  
#define ARIZONA_FLL2_LAMBDA_SHIFT                     0  
#define ARIZONA_FLL2_LAMBDA_WIDTH                    16  


#define ARIZONA_FLL2_FRATIO_MASK                 0x0700  
#define ARIZONA_FLL2_FRATIO_SHIFT                     8  
#define ARIZONA_FLL2_FRATIO_WIDTH                     3  
#define ARIZONA_FLL2_OUTDIV_MASK                 0x000E  
#define ARIZONA_FLL2_OUTDIV_SHIFT                     1  
#define ARIZONA_FLL2_OUTDIV_WIDTH                     3  


#define ARIZONA_FLL2_CLK_REF_DIV_MASK            0x00C0  
#define ARIZONA_FLL2_CLK_REF_DIV_SHIFT                6  
#define ARIZONA_FLL2_CLK_REF_DIV_WIDTH                2  
#define ARIZONA_FLL2_CLK_REF_SRC_MASK            0x000F  
#define ARIZONA_FLL2_CLK_REF_SRC_SHIFT                0  
#define ARIZONA_FLL2_CLK_REF_SRC_WIDTH                4  


#define ARIZONA_FLL2_FRC_INTEG_UPD               0x8000  
#define ARIZONA_FLL2_FRC_INTEG_UPD_MASK          0x8000  
#define ARIZONA_FLL2_FRC_INTEG_UPD_SHIFT             15  
#define ARIZONA_FLL2_FRC_INTEG_UPD_WIDTH              1  
#define ARIZONA_FLL2_FRC_INTEG_VAL_MASK          0x0FFF  
#define ARIZONA_FLL2_FRC_INTEG_VAL_SHIFT              0  
#define ARIZONA_FLL2_FRC_INTEG_VAL_WIDTH             12  


#define ARIZONA_FLL2_GAIN_MASK                   0x003c  
#define ARIZONA_FLL2_GAIN_SHIFT                       2  
#define ARIZONA_FLL2_GAIN_WIDTH                       4  


#define ARIZONA_FLL2_SYNC_ENA                    0x0001  
#define ARIZONA_FLL2_SYNC_ENA_MASK               0x0001  
#define ARIZONA_FLL2_SYNC_ENA_SHIFT                   0  
#define ARIZONA_FLL2_SYNC_ENA_WIDTH                   1  


#define ARIZONA_FLL2_SYNC_N_MASK                 0x03FF  
#define ARIZONA_FLL2_SYNC_N_SHIFT                     0  
#define ARIZONA_FLL2_SYNC_N_WIDTH                    10  


#define ARIZONA_FLL2_SYNC_THETA_MASK             0xFFFF  
#define ARIZONA_FLL2_SYNC_THETA_SHIFT                 0  
#define ARIZONA_FLL2_SYNC_THETA_WIDTH                16  


#define ARIZONA_FLL2_SYNC_LAMBDA_MASK            0xFFFF  
#define ARIZONA_FLL2_SYNC_LAMBDA_SHIFT                0  
#define ARIZONA_FLL2_SYNC_LAMBDA_WIDTH               16  


#define ARIZONA_FLL2_SYNC_FRATIO_MASK            0x0700  
#define ARIZONA_FLL2_SYNC_FRATIO_SHIFT                8  
#define ARIZONA_FLL2_SYNC_FRATIO_WIDTH                3  


#define ARIZONA_FLL2_CLK_SYNC_DIV_MASK           0x00C0  
#define ARIZONA_FLL2_CLK_SYNC_DIV_SHIFT               6  
#define ARIZONA_FLL2_CLK_SYNC_DIV_WIDTH               2  
#define ARIZONA_FLL2_CLK_SYNC_SRC_MASK           0x000F  
#define ARIZONA_FLL2_CLK_SYNC_SRC_SHIFT               0  
#define ARIZONA_FLL2_CLK_SYNC_SRC_WIDTH               4  


#define ARIZONA_FLL2_SYNC_GAIN_MASK              0x003c  
#define ARIZONA_FLL2_SYNC_GAIN_SHIFT                  2  
#define ARIZONA_FLL2_SYNC_GAIN_WIDTH                  4  
#define ARIZONA_FLL2_SYNC_BW                     0x0001  
#define ARIZONA_FLL2_SYNC_BW_MASK                0x0001  
#define ARIZONA_FLL2_SYNC_BW_SHIFT                    0  
#define ARIZONA_FLL2_SYNC_BW_WIDTH                    1  


#define ARIZONA_FLL2_SS_AMPL_MASK                0x0030  
#define ARIZONA_FLL2_SS_AMPL_SHIFT                    4  
#define ARIZONA_FLL2_SS_AMPL_WIDTH                    2  
#define ARIZONA_FLL2_SS_FREQ_MASK                0x000C  
#define ARIZONA_FLL2_SS_FREQ_SHIFT                    2  
#define ARIZONA_FLL2_SS_FREQ_WIDTH                    2  
#define ARIZONA_FLL2_SS_SEL_MASK                 0x0003  
#define ARIZONA_FLL2_SS_SEL_SHIFT                     0  
#define ARIZONA_FLL2_SS_SEL_WIDTH                     2  


#define ARIZONA_FLL2_GPDIV_MASK                  0x00FE  
#define ARIZONA_FLL2_GPDIV_SHIFT                      1  
#define ARIZONA_FLL2_GPDIV_WIDTH                      7  
#define ARIZONA_FLL2_GPDIV_ENA                   0x0001  
#define ARIZONA_FLL2_GPDIV_ENA_MASK              0x0001  
#define ARIZONA_FLL2_GPDIV_ENA_SHIFT                  0  
#define ARIZONA_FLL2_GPDIV_ENA_WIDTH                  1  


#define ARIZONA_CPMIC_DISCH                      0x0004  
#define ARIZONA_CPMIC_DISCH_MASK                 0x0004  
#define ARIZONA_CPMIC_DISCH_SHIFT                     2  
#define ARIZONA_CPMIC_DISCH_WIDTH                     1  
#define ARIZONA_CPMIC_BYPASS                     0x0002  
#define ARIZONA_CPMIC_BYPASS_MASK                0x0002  
#define ARIZONA_CPMIC_BYPASS_SHIFT                    1  
#define ARIZONA_CPMIC_BYPASS_WIDTH                    1  
#define ARIZONA_CPMIC_ENA                        0x0001  
#define ARIZONA_CPMIC_ENA_MASK                   0x0001  
#define ARIZONA_CPMIC_ENA_SHIFT                       0  
#define ARIZONA_CPMIC_ENA_WIDTH                       1  


#define ARIZONA_LDO1_VSEL_MASK                   0x07E0  
#define ARIZONA_LDO1_VSEL_SHIFT                       5  
#define ARIZONA_LDO1_VSEL_WIDTH                       6  
#define ARIZONA_LDO1_FAST                        0x0010  
#define ARIZONA_LDO1_FAST_MASK                   0x0010  
#define ARIZONA_LDO1_FAST_SHIFT                       4  
#define ARIZONA_LDO1_FAST_WIDTH                       1  
#define ARIZONA_LDO1_DISCH                       0x0004  
#define ARIZONA_LDO1_DISCH_MASK                  0x0004  
#define ARIZONA_LDO1_DISCH_SHIFT                      2  
#define ARIZONA_LDO1_DISCH_WIDTH                      1  
#define ARIZONA_LDO1_BYPASS                      0x0002  
#define ARIZONA_LDO1_BYPASS_MASK                 0x0002  
#define ARIZONA_LDO1_BYPASS_SHIFT                     1  
#define ARIZONA_LDO1_BYPASS_WIDTH                     1  
#define ARIZONA_LDO1_ENA                         0x0001  
#define ARIZONA_LDO1_ENA_MASK                    0x0001  
#define ARIZONA_LDO1_ENA_SHIFT                        0  
#define ARIZONA_LDO1_ENA_WIDTH                        1  


#define ARIZONA_LDO1_HI_PWR                      0x0001  
#define ARIZONA_LDO1_HI_PWR_SHIFT                     0  
#define ARIZONA_LDO1_HI_PWR_WIDTH                     1  


#define ARIZONA_LDO2_VSEL_MASK                   0x07E0  
#define ARIZONA_LDO2_VSEL_SHIFT                       5  
#define ARIZONA_LDO2_VSEL_WIDTH                       6  
#define ARIZONA_LDO2_FAST                        0x0010  
#define ARIZONA_LDO2_FAST_MASK                   0x0010  
#define ARIZONA_LDO2_FAST_SHIFT                       4  
#define ARIZONA_LDO2_FAST_WIDTH                       1  
#define ARIZONA_LDO2_DISCH                       0x0004  
#define ARIZONA_LDO2_DISCH_MASK                  0x0004  
#define ARIZONA_LDO2_DISCH_SHIFT                      2  
#define ARIZONA_LDO2_DISCH_WIDTH                      1  
#define ARIZONA_LDO2_BYPASS                      0x0002  
#define ARIZONA_LDO2_BYPASS_MASK                 0x0002  
#define ARIZONA_LDO2_BYPASS_SHIFT                     1  
#define ARIZONA_LDO2_BYPASS_WIDTH                     1  
#define ARIZONA_LDO2_ENA                         0x0001  
#define ARIZONA_LDO2_ENA_MASK                    0x0001  
#define ARIZONA_LDO2_ENA_SHIFT                        0  
#define ARIZONA_LDO2_ENA_WIDTH                        1  


#define ARIZONA_MICB1_EXT_CAP                    0x8000  
#define ARIZONA_MICB1_EXT_CAP_MASK               0x8000  
#define ARIZONA_MICB1_EXT_CAP_SHIFT                  15  
#define ARIZONA_MICB1_EXT_CAP_WIDTH                   1  
#define ARIZONA_MICB1_LVL_MASK                   0x01E0  
#define ARIZONA_MICB1_LVL_SHIFT                       5  
#define ARIZONA_MICB1_LVL_WIDTH                       4  
#define ARIZONA_MICB1_FAST                       0x0010  
#define ARIZONA_MICB1_FAST_MASK                  0x0010  
#define ARIZONA_MICB1_FAST_SHIFT                      4  
#define ARIZONA_MICB1_FAST_WIDTH                      1  
#define ARIZONA_MICB1_RATE                       0x0008  
#define ARIZONA_MICB1_RATE_MASK                  0x0008  
#define ARIZONA_MICB1_RATE_SHIFT                      3  
#define ARIZONA_MICB1_RATE_WIDTH                      1  
#define ARIZONA_MICB1_DISCH                      0x0004  
#define ARIZONA_MICB1_DISCH_MASK                 0x0004  
#define ARIZONA_MICB1_DISCH_SHIFT                     2  
#define ARIZONA_MICB1_DISCH_WIDTH                     1  
#define ARIZONA_MICB1_BYPASS                     0x0002  
#define ARIZONA_MICB1_BYPASS_MASK                0x0002  
#define ARIZONA_MICB1_BYPASS_SHIFT                    1  
#define ARIZONA_MICB1_BYPASS_WIDTH                    1  
#define ARIZONA_MICB1_ENA                        0x0001  
#define ARIZONA_MICB1_ENA_MASK                   0x0001  
#define ARIZONA_MICB1_ENA_SHIFT                       0  
#define ARIZONA_MICB1_ENA_WIDTH                       1  


#define ARIZONA_MICB2_EXT_CAP                    0x8000  
#define ARIZONA_MICB2_EXT_CAP_MASK               0x8000  
#define ARIZONA_MICB2_EXT_CAP_SHIFT                  15  
#define ARIZONA_MICB2_EXT_CAP_WIDTH                   1  
#define ARIZONA_MICB2_LVL_MASK                   0x01E0  
#define ARIZONA_MICB2_LVL_SHIFT                       5  
#define ARIZONA_MICB2_LVL_WIDTH                       4  
#define ARIZONA_MICB2_FAST                       0x0010  
#define ARIZONA_MICB2_FAST_MASK                  0x0010  
#define ARIZONA_MICB2_FAST_SHIFT                      4  
#define ARIZONA_MICB2_FAST_WIDTH                      1  
#define ARIZONA_MICB2_RATE                       0x0008  
#define ARIZONA_MICB2_RATE_MASK                  0x0008  
#define ARIZONA_MICB2_RATE_SHIFT                      3  
#define ARIZONA_MICB2_RATE_WIDTH                      1  
#define ARIZONA_MICB2_DISCH                      0x0004  
#define ARIZONA_MICB2_DISCH_MASK                 0x0004  
#define ARIZONA_MICB2_DISCH_SHIFT                     2  
#define ARIZONA_MICB2_DISCH_WIDTH                     1  
#define ARIZONA_MICB2_BYPASS                     0x0002  
#define ARIZONA_MICB2_BYPASS_MASK                0x0002  
#define ARIZONA_MICB2_BYPASS_SHIFT                    1  
#define ARIZONA_MICB2_BYPASS_WIDTH                    1  
#define ARIZONA_MICB2_ENA                        0x0001  
#define ARIZONA_MICB2_ENA_MASK                   0x0001  
#define ARIZONA_MICB2_ENA_SHIFT                       0  
#define ARIZONA_MICB2_ENA_WIDTH                       1  


#define ARIZONA_MICB3_EXT_CAP                    0x8000  
#define ARIZONA_MICB3_EXT_CAP_MASK               0x8000  
#define ARIZONA_MICB3_EXT_CAP_SHIFT                  15  
#define ARIZONA_MICB3_EXT_CAP_WIDTH                   1  
#define ARIZONA_MICB3_LVL_MASK                   0x01E0  
#define ARIZONA_MICB3_LVL_SHIFT                       5  
#define ARIZONA_MICB3_LVL_WIDTH                       4  
#define ARIZONA_MICB3_FAST                       0x0010  
#define ARIZONA_MICB3_FAST_MASK                  0x0010  
#define ARIZONA_MICB3_FAST_SHIFT                      4  
#define ARIZONA_MICB3_FAST_WIDTH                      1  
#define ARIZONA_MICB3_RATE                       0x0008  
#define ARIZONA_MICB3_RATE_MASK                  0x0008  
#define ARIZONA_MICB3_RATE_SHIFT                      3  
#define ARIZONA_MICB3_RATE_WIDTH                      1  
#define ARIZONA_MICB3_DISCH                      0x0004  
#define ARIZONA_MICB3_DISCH_MASK                 0x0004  
#define ARIZONA_MICB3_DISCH_SHIFT                     2  
#define ARIZONA_MICB3_DISCH_WIDTH                     1  
#define ARIZONA_MICB3_BYPASS                     0x0002  
#define ARIZONA_MICB3_BYPASS_MASK                0x0002  
#define ARIZONA_MICB3_BYPASS_SHIFT                    1  
#define ARIZONA_MICB3_BYPASS_WIDTH                    1  
#define ARIZONA_MICB3_ENA                        0x0001  
#define ARIZONA_MICB3_ENA_MASK                   0x0001  
#define ARIZONA_MICB3_ENA_SHIFT                       0  
#define ARIZONA_MICB3_ENA_WIDTH                       1  


#define ARIZONA_RMV_SHRT_HP1L                    0x4000  
#define ARIZONA_RMV_SHRT_HP1L_MASK               0x4000  
#define ARIZONA_RMV_SHRT_HP1L_SHIFT                  14  
#define ARIZONA_RMV_SHRT_HP1L_WIDTH                   1  
#define ARIZONA_HP1L_FLWR                        0x0004  
#define ARIZONA_HP1L_FLWR_MASK                   0x0004  
#define ARIZONA_HP1L_FLWR_SHIFT                       2  
#define ARIZONA_HP1L_FLWR_WIDTH                       1  
#define ARIZONA_HP1L_SHRTI                       0x0002  
#define ARIZONA_HP1L_SHRTI_MASK                  0x0002  
#define ARIZONA_HP1L_SHRTI_SHIFT                      1  
#define ARIZONA_HP1L_SHRTI_WIDTH                      1  
#define ARIZONA_HP1L_SHRTO                       0x0001  
#define ARIZONA_HP1L_SHRTO_MASK                  0x0001  
#define ARIZONA_HP1L_SHRTO_SHIFT                      0  
#define ARIZONA_HP1L_SHRTO_WIDTH                      1  


#define ARIZONA_RMV_SHRT_HP1R                    0x4000  
#define ARIZONA_RMV_SHRT_HP1R_MASK               0x4000  
#define ARIZONA_RMV_SHRT_HP1R_SHIFT                  14  
#define ARIZONA_RMV_SHRT_HP1R_WIDTH                   1  
#define ARIZONA_HP1R_FLWR                        0x0004  
#define ARIZONA_HP1R_FLWR_MASK                   0x0004  
#define ARIZONA_HP1R_FLWR_SHIFT                       2  
#define ARIZONA_HP1R_FLWR_WIDTH                       1  
#define ARIZONA_HP1R_SHRTI                       0x0002  
#define ARIZONA_HP1R_SHRTI_MASK                  0x0002  
#define ARIZONA_HP1R_SHRTI_SHIFT                      1  
#define ARIZONA_HP1R_SHRTI_WIDTH                      1  
#define ARIZONA_HP1R_SHRTO                       0x0001  
#define ARIZONA_HP1R_SHRTO_MASK                  0x0001  
#define ARIZONA_HP1R_SHRTO_SHIFT                      0  
#define ARIZONA_HP1R_SHRTO_WIDTH                      1  


#define ARIZONA_ACCDET_SRC                       0x2000  
#define ARIZONA_ACCDET_SRC_MASK                  0x2000  
#define ARIZONA_ACCDET_SRC_SHIFT                     13  
#define ARIZONA_ACCDET_SRC_WIDTH                      1  
#define ARIZONA_ACCDET_MODE_MASK                 0x0007  
#define ARIZONA_ACCDET_MODE_SHIFT                     0  
#define ARIZONA_ACCDET_MODE_WIDTH                     3  


#define ARIZONA_HP_IMPEDANCE_RANGE_MASK          0x0600  
#define ARIZONA_HP_IMPEDANCE_RANGE_SHIFT              9  
#define ARIZONA_HP_IMPEDANCE_RANGE_WIDTH              2  
#define ARIZONA_HP_STEP_SIZE                     0x0100  
#define ARIZONA_HP_STEP_SIZE_MASK                0x0100  
#define ARIZONA_HP_STEP_SIZE_SHIFT                    8  
#define ARIZONA_HP_STEP_SIZE_WIDTH                    1  
#define ARIZONA_HP_HOLDTIME_MASK                 0x00E0  
#define ARIZONA_HP_HOLDTIME_SHIFT                     5  
#define ARIZONA_HP_HOLDTIME_WIDTH                     3  
#define ARIZONA_HP_CLK_DIV_MASK                  0x0018  
#define ARIZONA_HP_CLK_DIV_SHIFT                      3  
#define ARIZONA_HP_CLK_DIV_WIDTH                      2  
#define ARIZONA_HP_IDAC_STEER                    0x0004  
#define ARIZONA_HP_IDAC_STEER_MASK               0x0004  
#define ARIZONA_HP_IDAC_STEER_SHIFT                   2  
#define ARIZONA_HP_IDAC_STEER_WIDTH                   1  
#define WM8998_HP_RATE_MASK                      0x0006  
#define WM8998_HP_RATE_SHIFT                          1  
#define WM8998_HP_RATE_WIDTH                          2  
#define ARIZONA_HP_RATE                          0x0002  
#define ARIZONA_HP_RATE_MASK                     0x0002  
#define ARIZONA_HP_RATE_SHIFT                         1  
#define ARIZONA_HP_RATE_WIDTH                         1  
#define ARIZONA_HP_POLL                          0x0001  
#define ARIZONA_HP_POLL_MASK                     0x0001  
#define ARIZONA_HP_POLL_SHIFT                         0  
#define ARIZONA_HP_POLL_WIDTH                         1  


#define ARIZONA_HP_DONE                          0x0080  
#define ARIZONA_HP_DONE_MASK                     0x0080  
#define ARIZONA_HP_DONE_SHIFT                         7  
#define ARIZONA_HP_DONE_WIDTH                         1  
#define ARIZONA_HP_LVL_MASK                      0x007F  
#define ARIZONA_HP_LVL_SHIFT                          0  
#define ARIZONA_HP_LVL_WIDTH                          7  

#define ARIZONA_HP_DONE_B                        0x8000  
#define ARIZONA_HP_DONE_B_MASK                   0x8000  
#define ARIZONA_HP_DONE_B_SHIFT                      15  
#define ARIZONA_HP_DONE_B_WIDTH                       1  
#define ARIZONA_HP_LVL_B_MASK                    0x7FFF  
#define ARIZONA_HP_LVL_B_SHIFT                        0  
#define ARIZONA_HP_LVL_B_WIDTH                       15  


#define ARIZONA_MICD_CLAMP_MODE_MASK             0x000F  
#define ARIZONA_MICD_CLAMP_MODE_SHIFT                 0  
#define ARIZONA_MICD_CLAMP_MODE_WIDTH                 4  


#define ARIZONA_MICD_BIAS_STARTTIME_MASK         0xF000  
#define ARIZONA_MICD_BIAS_STARTTIME_SHIFT            12  
#define ARIZONA_MICD_BIAS_STARTTIME_WIDTH             4  
#define ARIZONA_MICD_RATE_MASK                   0x0F00  
#define ARIZONA_MICD_RATE_SHIFT                       8  
#define ARIZONA_MICD_RATE_WIDTH                       4  
#define ARIZONA_MICD_BIAS_SRC_MASK               0x0030  
#define ARIZONA_MICD_BIAS_SRC_SHIFT                   4  
#define ARIZONA_MICD_BIAS_SRC_WIDTH                   2  
#define ARIZONA_MICD_DBTIME                      0x0002  
#define ARIZONA_MICD_DBTIME_MASK                 0x0002  
#define ARIZONA_MICD_DBTIME_SHIFT                     1  
#define ARIZONA_MICD_DBTIME_WIDTH                     1  
#define ARIZONA_MICD_ENA                         0x0001  
#define ARIZONA_MICD_ENA_MASK                    0x0001  
#define ARIZONA_MICD_ENA_SHIFT                        0  
#define ARIZONA_MICD_ENA_WIDTH                        1  


#define ARIZONA_MICD_LVL_SEL_MASK                0x00FF  
#define ARIZONA_MICD_LVL_SEL_SHIFT                    0  
#define ARIZONA_MICD_LVL_SEL_WIDTH                    8  


#define ARIZONA_MICD_LVL_0                       0x0004  
#define ARIZONA_MICD_LVL_1                       0x0008  
#define ARIZONA_MICD_LVL_2                       0x0010  
#define ARIZONA_MICD_LVL_3                       0x0020  
#define ARIZONA_MICD_LVL_4                       0x0040  
#define ARIZONA_MICD_LVL_5                       0x0080  
#define ARIZONA_MICD_LVL_6                       0x0100  
#define ARIZONA_MICD_LVL_7                       0x0200  
#define ARIZONA_MICD_LVL_8                       0x0400  
#define ARIZONA_MICD_LVL_MASK                    0x07FC  
#define ARIZONA_MICD_LVL_SHIFT                        2  
#define ARIZONA_MICD_LVL_WIDTH                        9  
#define ARIZONA_MICD_VALID                       0x0002  
#define ARIZONA_MICD_VALID_MASK                  0x0002  
#define ARIZONA_MICD_VALID_SHIFT                      1  
#define ARIZONA_MICD_VALID_WIDTH                      1  
#define ARIZONA_MICD_STS                         0x0001  
#define ARIZONA_MICD_STS_MASK                    0x0001  
#define ARIZONA_MICD_STS_SHIFT                        0  
#define ARIZONA_MICD_STS_WIDTH                        1  


#define ARIZONA_MICDET_ADCVAL_DIFF_MASK          0xFF00  
#define ARIZONA_MICDET_ADCVAL_DIFF_SHIFT              8  
#define ARIZONA_MICDET_ADCVAL_DIFF_WIDTH              8  
#define ARIZONA_MICDET_ADCVAL_MASK               0x007F  
#define ARIZONA_MICDET_ADCVAL_SHIFT                   0  
#define ARIZONA_MICDET_ADCVAL_WIDTH                   7  


#define ARIZONA_MICMUTE_RATE_MASK                0x7800  
#define ARIZONA_MICMUTE_RATE_SHIFT                   11  
#define ARIZONA_MICMUTE_RATE_WIDTH                    4  
#define ARIZONA_MICMUTE_MIX_ENA                  0x0040  
#define ARIZONA_MICMUTE_MIX_ENA_MASK             0x0040  
#define ARIZONA_MICMUTE_MIX_ENA_SHIFT                 6  
#define ARIZONA_MICMUTE_MIX_ENA_WIDTH                 1  


#define ARIZONA_ISOLATE_DCVDD1                   0x0001  
#define ARIZONA_ISOLATE_DCVDD1_MASK              0x0001  
#define ARIZONA_ISOLATE_DCVDD1_SHIFT                  0  
#define ARIZONA_ISOLATE_DCVDD1_WIDTH                  1  


#define ARIZONA_JD2_ENA                          0x0002  
#define ARIZONA_JD2_ENA_MASK                     0x0002  
#define ARIZONA_JD2_ENA_SHIFT                         1  
#define ARIZONA_JD2_ENA_WIDTH                         1  
#define ARIZONA_JD1_ENA                          0x0001  
#define ARIZONA_JD1_ENA_MASK                     0x0001  
#define ARIZONA_JD1_ENA_SHIFT                         0  
#define ARIZONA_JD1_ENA_WIDTH                         1  


#define ARIZONA_IN4L_ENA                         0x0080  
#define ARIZONA_IN4L_ENA_MASK                    0x0080  
#define ARIZONA_IN4L_ENA_SHIFT                        7  
#define ARIZONA_IN4L_ENA_WIDTH                        1  
#define ARIZONA_IN4R_ENA                         0x0040  
#define ARIZONA_IN4R_ENA_MASK                    0x0040  
#define ARIZONA_IN4R_ENA_SHIFT                        6  
#define ARIZONA_IN4R_ENA_WIDTH                        1  
#define ARIZONA_IN3L_ENA                         0x0020  
#define ARIZONA_IN3L_ENA_MASK                    0x0020  
#define ARIZONA_IN3L_ENA_SHIFT                        5  
#define ARIZONA_IN3L_ENA_WIDTH                        1  
#define ARIZONA_IN3R_ENA                         0x0010  
#define ARIZONA_IN3R_ENA_MASK                    0x0010  
#define ARIZONA_IN3R_ENA_SHIFT                        4  
#define ARIZONA_IN3R_ENA_WIDTH                        1  
#define ARIZONA_IN2L_ENA                         0x0008  
#define ARIZONA_IN2L_ENA_MASK                    0x0008  
#define ARIZONA_IN2L_ENA_SHIFT                        3  
#define ARIZONA_IN2L_ENA_WIDTH                        1  
#define ARIZONA_IN2R_ENA                         0x0004  
#define ARIZONA_IN2R_ENA_MASK                    0x0004  
#define ARIZONA_IN2R_ENA_SHIFT                        2  
#define ARIZONA_IN2R_ENA_WIDTH                        1  
#define ARIZONA_IN1L_ENA                         0x0002  
#define ARIZONA_IN1L_ENA_MASK                    0x0002  
#define ARIZONA_IN1L_ENA_SHIFT                        1  
#define ARIZONA_IN1L_ENA_WIDTH                        1  
#define ARIZONA_IN1R_ENA                         0x0001  
#define ARIZONA_IN1R_ENA_MASK                    0x0001  
#define ARIZONA_IN1R_ENA_SHIFT                        0  
#define ARIZONA_IN1R_ENA_WIDTH                        1  


#define ARIZONA_IN_RATE_MASK                     0x7800  
#define ARIZONA_IN_RATE_SHIFT                        11  
#define ARIZONA_IN_RATE_WIDTH                         4  


#define ARIZONA_IN_VD_RAMP_MASK                  0x0070  
#define ARIZONA_IN_VD_RAMP_SHIFT                      4  
#define ARIZONA_IN_VD_RAMP_WIDTH                      3  
#define ARIZONA_IN_VI_RAMP_MASK                  0x0007  
#define ARIZONA_IN_VI_RAMP_SHIFT                      0  
#define ARIZONA_IN_VI_RAMP_WIDTH                      3  


#define ARIZONA_IN_HPF_CUT_MASK                  0x0007  
#define ARIZONA_IN_HPF_CUT_SHIFT                      0  
#define ARIZONA_IN_HPF_CUT_WIDTH                      3  


#define ARIZONA_IN1L_HPF_MASK                    0x8000  
#define ARIZONA_IN1L_HPF_SHIFT                       15  
#define ARIZONA_IN1L_HPF_WIDTH                        1  
#define ARIZONA_IN1_OSR_MASK                     0x6000  
#define ARIZONA_IN1_OSR_SHIFT                        13  
#define ARIZONA_IN1_OSR_WIDTH                         2  
#define ARIZONA_IN1_DMIC_SUP_MASK                0x1800  
#define ARIZONA_IN1_DMIC_SUP_SHIFT                   11  
#define ARIZONA_IN1_DMIC_SUP_WIDTH                    2  
#define ARIZONA_IN1_MODE_MASK                    0x0400  
#define ARIZONA_IN1_MODE_SHIFT                       10  
#define ARIZONA_IN1_MODE_WIDTH                        1  
#define ARIZONA_IN1_SINGLE_ENDED_MASK            0x0200  
#define ARIZONA_IN1_SINGLE_ENDED_SHIFT                9  
#define ARIZONA_IN1_SINGLE_ENDED_WIDTH                1  
#define ARIZONA_IN1L_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN1L_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN1L_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN1L_SRC_MASK                    0x4000  
#define ARIZONA_IN1L_SRC_SHIFT                       14  
#define ARIZONA_IN1L_SRC_WIDTH                        1  
#define ARIZONA_IN1L_SRC_SE_MASK                 0x2000  
#define ARIZONA_IN1L_SRC_SE_SHIFT                    13  
#define ARIZONA_IN1L_SRC_SE_WIDTH                     1  
#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN1L_MUTE                        0x0100  
#define ARIZONA_IN1L_MUTE_MASK                   0x0100  
#define ARIZONA_IN1L_MUTE_SHIFT                       8  
#define ARIZONA_IN1L_MUTE_WIDTH                       1  
#define ARIZONA_IN1L_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN1L_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN1L_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN1_DMICL_DLY_MASK               0x003F  
#define ARIZONA_IN1_DMICL_DLY_SHIFT                   0  
#define ARIZONA_IN1_DMICL_DLY_WIDTH                   6  


#define ARIZONA_IN1R_HPF_MASK                    0x8000  
#define ARIZONA_IN1R_HPF_SHIFT                       15  
#define ARIZONA_IN1R_HPF_WIDTH                        1  
#define ARIZONA_IN1R_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN1R_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN1R_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN1R_SRC_MASK                    0x4000  
#define ARIZONA_IN1R_SRC_SHIFT                       14  
#define ARIZONA_IN1R_SRC_WIDTH                        1  
#define ARIZONA_IN1R_SRC_SE_MASK                 0x2000  
#define ARIZONA_IN1R_SRC_SE_SHIFT                    13  
#define ARIZONA_IN1R_SRC_SE_WIDTH                     1  
#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN1R_MUTE                        0x0100  
#define ARIZONA_IN1R_MUTE_MASK                   0x0100  
#define ARIZONA_IN1R_MUTE_SHIFT                       8  
#define ARIZONA_IN1R_MUTE_WIDTH                       1  
#define ARIZONA_IN1R_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN1R_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN1R_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN1_DMICR_DLY_MASK               0x003F  
#define ARIZONA_IN1_DMICR_DLY_SHIFT                   0  
#define ARIZONA_IN1_DMICR_DLY_WIDTH                   6  


#define ARIZONA_IN2L_HPF_MASK                    0x8000  
#define ARIZONA_IN2L_HPF_SHIFT                       15  
#define ARIZONA_IN2L_HPF_WIDTH                        1  
#define ARIZONA_IN2_OSR_MASK                     0x6000  
#define ARIZONA_IN2_OSR_SHIFT                        13  
#define ARIZONA_IN2_OSR_WIDTH                         2  
#define ARIZONA_IN2_DMIC_SUP_MASK                0x1800  
#define ARIZONA_IN2_DMIC_SUP_SHIFT                   11  
#define ARIZONA_IN2_DMIC_SUP_WIDTH                    2  
#define ARIZONA_IN2_MODE_MASK                    0x0400  
#define ARIZONA_IN2_MODE_SHIFT                       10  
#define ARIZONA_IN2_MODE_WIDTH                        1  
#define ARIZONA_IN2_SINGLE_ENDED_MASK            0x0200  
#define ARIZONA_IN2_SINGLE_ENDED_SHIFT                9  
#define ARIZONA_IN2_SINGLE_ENDED_WIDTH                1  
#define ARIZONA_IN2L_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN2L_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN2L_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN2L_SRC_MASK                    0x4000  
#define ARIZONA_IN2L_SRC_SHIFT                       14  
#define ARIZONA_IN2L_SRC_WIDTH                        1  
#define ARIZONA_IN2L_SRC_SE_MASK                 0x2000  
#define ARIZONA_IN2L_SRC_SE_SHIFT                    13  
#define ARIZONA_IN2L_SRC_SE_WIDTH                     1  
#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN2L_MUTE                        0x0100  
#define ARIZONA_IN2L_MUTE_MASK                   0x0100  
#define ARIZONA_IN2L_MUTE_SHIFT                       8  
#define ARIZONA_IN2L_MUTE_WIDTH                       1  
#define ARIZONA_IN2L_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN2L_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN2L_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN2_DMICL_DLY_MASK               0x003F  
#define ARIZONA_IN2_DMICL_DLY_SHIFT                   0  
#define ARIZONA_IN2_DMICL_DLY_WIDTH                   6  


#define ARIZONA_IN2R_HPF_MASK                    0x8000  
#define ARIZONA_IN2R_HPF_SHIFT                       15  
#define ARIZONA_IN2R_HPF_WIDTH                        1  
#define ARIZONA_IN2R_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN2R_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN2R_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN2R_MUTE                        0x0100  
#define ARIZONA_IN2R_MUTE_MASK                   0x0100  
#define ARIZONA_IN2R_MUTE_SHIFT                       8  
#define ARIZONA_IN2R_MUTE_WIDTH                       1  
#define ARIZONA_IN2R_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN2R_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN2R_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN2_DMICR_DLY_MASK               0x003F  
#define ARIZONA_IN2_DMICR_DLY_SHIFT                   0  
#define ARIZONA_IN2_DMICR_DLY_WIDTH                   6  


#define ARIZONA_IN3L_HPF_MASK                    0x8000  
#define ARIZONA_IN3L_HPF_SHIFT                       15  
#define ARIZONA_IN3L_HPF_WIDTH                        1  
#define ARIZONA_IN3_OSR_MASK                     0x6000  
#define ARIZONA_IN3_OSR_SHIFT                        13  
#define ARIZONA_IN3_OSR_WIDTH                         2  
#define ARIZONA_IN3_DMIC_SUP_MASK                0x1800  
#define ARIZONA_IN3_DMIC_SUP_SHIFT                   11  
#define ARIZONA_IN3_DMIC_SUP_WIDTH                    2  
#define ARIZONA_IN3_MODE_MASK                    0x0400  
#define ARIZONA_IN3_MODE_SHIFT                       10  
#define ARIZONA_IN3_MODE_WIDTH                        1  
#define ARIZONA_IN3_SINGLE_ENDED_MASK            0x0200  
#define ARIZONA_IN3_SINGLE_ENDED_SHIFT                9  
#define ARIZONA_IN3_SINGLE_ENDED_WIDTH                1  
#define ARIZONA_IN3L_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN3L_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN3L_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN3L_MUTE                        0x0100  
#define ARIZONA_IN3L_MUTE_MASK                   0x0100  
#define ARIZONA_IN3L_MUTE_SHIFT                       8  
#define ARIZONA_IN3L_MUTE_WIDTH                       1  
#define ARIZONA_IN3L_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN3L_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN3L_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN3_DMICL_DLY_MASK               0x003F  
#define ARIZONA_IN3_DMICL_DLY_SHIFT                   0  
#define ARIZONA_IN3_DMICL_DLY_WIDTH                   6  


#define ARIZONA_IN3R_HPF_MASK                    0x8000  
#define ARIZONA_IN3R_HPF_SHIFT                       15  
#define ARIZONA_IN3R_HPF_WIDTH                        1  
#define ARIZONA_IN3R_PGA_VOL_MASK                0x00FE  
#define ARIZONA_IN3R_PGA_VOL_SHIFT                    1  
#define ARIZONA_IN3R_PGA_VOL_WIDTH                    7  


#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN3R_MUTE                        0x0100  
#define ARIZONA_IN3R_MUTE_MASK                   0x0100  
#define ARIZONA_IN3R_MUTE_SHIFT                       8  
#define ARIZONA_IN3R_MUTE_WIDTH                       1  
#define ARIZONA_IN3R_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN3R_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN3R_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN3_DMICR_DLY_MASK               0x003F  
#define ARIZONA_IN3_DMICR_DLY_SHIFT                   0  
#define ARIZONA_IN3_DMICR_DLY_WIDTH                   6  


#define ARIZONA_IN4L_HPF_MASK                    0x8000  
#define ARIZONA_IN4L_HPF_SHIFT                       15  
#define ARIZONA_IN4L_HPF_WIDTH                        1  
#define ARIZONA_IN4_OSR_MASK                     0x6000  
#define ARIZONA_IN4_OSR_SHIFT                        13  
#define ARIZONA_IN4_OSR_WIDTH                         2  
#define ARIZONA_IN4_DMIC_SUP_MASK                0x1800  
#define ARIZONA_IN4_DMIC_SUP_SHIFT                   11  
#define ARIZONA_IN4_DMIC_SUP_WIDTH                    2  


#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN4L_MUTE                        0x0100  
#define ARIZONA_IN4L_MUTE_MASK                   0x0100  
#define ARIZONA_IN4L_MUTE_SHIFT                       8  
#define ARIZONA_IN4L_MUTE_WIDTH                       1  
#define ARIZONA_IN4L_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN4L_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN4L_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN4L_DMIC_DLY_MASK               0x003F  
#define ARIZONA_IN4L_DMIC_DLY_SHIFT                   0  
#define ARIZONA_IN4L_DMIC_DLY_WIDTH                   6  


#define ARIZONA_IN4R_HPF_MASK                    0x8000  
#define ARIZONA_IN4R_HPF_SHIFT                       15  
#define ARIZONA_IN4R_HPF_WIDTH                        1  


#define ARIZONA_IN_VU                            0x0200  
#define ARIZONA_IN_VU_MASK                       0x0200  
#define ARIZONA_IN_VU_SHIFT                           9  
#define ARIZONA_IN_VU_WIDTH                           1  
#define ARIZONA_IN4R_MUTE                        0x0100  
#define ARIZONA_IN4R_MUTE_MASK                   0x0100  
#define ARIZONA_IN4R_MUTE_SHIFT                       8  
#define ARIZONA_IN4R_MUTE_WIDTH                       1  
#define ARIZONA_IN4R_DIG_VOL_MASK                0x00FF  
#define ARIZONA_IN4R_DIG_VOL_SHIFT                    0  
#define ARIZONA_IN4R_DIG_VOL_WIDTH                    8  


#define ARIZONA_IN4R_DMIC_DLY_MASK               0x003F  
#define ARIZONA_IN4R_DMIC_DLY_SHIFT                   0  
#define ARIZONA_IN4R_DMIC_DLY_WIDTH                   6  


#define ARIZONA_OUT6L_ENA                        0x0800  
#define ARIZONA_OUT6L_ENA_MASK                   0x0800  
#define ARIZONA_OUT6L_ENA_SHIFT                      11  
#define ARIZONA_OUT6L_ENA_WIDTH                       1  
#define ARIZONA_OUT6R_ENA                        0x0400  
#define ARIZONA_OUT6R_ENA_MASK                   0x0400  
#define ARIZONA_OUT6R_ENA_SHIFT                      10  
#define ARIZONA_OUT6R_ENA_WIDTH                       1  
#define ARIZONA_OUT5L_ENA                        0x0200  
#define ARIZONA_OUT5L_ENA_MASK                   0x0200  
#define ARIZONA_OUT5L_ENA_SHIFT                       9  
#define ARIZONA_OUT5L_ENA_WIDTH                       1  
#define ARIZONA_OUT5R_ENA                        0x0100  
#define ARIZONA_OUT5R_ENA_MASK                   0x0100  
#define ARIZONA_OUT5R_ENA_SHIFT                       8  
#define ARIZONA_OUT5R_ENA_WIDTH                       1  
#define ARIZONA_OUT4L_ENA                        0x0080  
#define ARIZONA_OUT4L_ENA_MASK                   0x0080  
#define ARIZONA_OUT4L_ENA_SHIFT                       7  
#define ARIZONA_OUT4L_ENA_WIDTH                       1  
#define ARIZONA_OUT4R_ENA                        0x0040  
#define ARIZONA_OUT4R_ENA_MASK                   0x0040  
#define ARIZONA_OUT4R_ENA_SHIFT                       6  
#define ARIZONA_OUT4R_ENA_WIDTH                       1  
#define ARIZONA_OUT3L_ENA                        0x0020  
#define ARIZONA_OUT3L_ENA_MASK                   0x0020  
#define ARIZONA_OUT3L_ENA_SHIFT                       5  
#define ARIZONA_OUT3L_ENA_WIDTH                       1  
#define ARIZONA_OUT3R_ENA                        0x0010  
#define ARIZONA_OUT3R_ENA_MASK                   0x0010  
#define ARIZONA_OUT3R_ENA_SHIFT                       4  
#define ARIZONA_OUT3R_ENA_WIDTH                       1  
#define ARIZONA_OUT2L_ENA                        0x0008  
#define ARIZONA_OUT2L_ENA_MASK                   0x0008  
#define ARIZONA_OUT2L_ENA_SHIFT                       3  
#define ARIZONA_OUT2L_ENA_WIDTH                       1  
#define ARIZONA_OUT2R_ENA                        0x0004  
#define ARIZONA_OUT2R_ENA_MASK                   0x0004  
#define ARIZONA_OUT2R_ENA_SHIFT                       2  
#define ARIZONA_OUT2R_ENA_WIDTH                       1  
#define ARIZONA_OUT1L_ENA                        0x0002  
#define ARIZONA_OUT1L_ENA_MASK                   0x0002  
#define ARIZONA_OUT1L_ENA_SHIFT                       1  
#define ARIZONA_OUT1L_ENA_WIDTH                       1  
#define ARIZONA_OUT1R_ENA                        0x0001  
#define ARIZONA_OUT1R_ENA_MASK                   0x0001  
#define ARIZONA_OUT1R_ENA_SHIFT                       0  
#define ARIZONA_OUT1R_ENA_WIDTH                       1  


#define ARIZONA_OUT6L_ENA_STS                    0x0800  
#define ARIZONA_OUT6L_ENA_STS_MASK               0x0800  
#define ARIZONA_OUT6L_ENA_STS_SHIFT                  11  
#define ARIZONA_OUT6L_ENA_STS_WIDTH                   1  
#define ARIZONA_OUT6R_ENA_STS                    0x0400  
#define ARIZONA_OUT6R_ENA_STS_MASK               0x0400  
#define ARIZONA_OUT6R_ENA_STS_SHIFT                  10  
#define ARIZONA_OUT6R_ENA_STS_WIDTH                   1  
#define ARIZONA_OUT5L_ENA_STS                    0x0200  
#define ARIZONA_OUT5L_ENA_STS_MASK               0x0200  
#define ARIZONA_OUT5L_ENA_STS_SHIFT                   9  
#define ARIZONA_OUT5L_ENA_STS_WIDTH                   1  
#define ARIZONA_OUT5R_ENA_STS                    0x0100  
#define ARIZONA_OUT5R_ENA_STS_MASK               0x0100  
#define ARIZONA_OUT5R_ENA_STS_SHIFT                   8  
#define ARIZONA_OUT5R_ENA_STS_WIDTH                   1  
#define ARIZONA_OUT4L_ENA_STS                    0x0080  
#define ARIZONA_OUT4L_ENA_STS_MASK               0x0080  
#define ARIZONA_OUT4L_ENA_STS_SHIFT                   7  
#define ARIZONA_OUT4L_ENA_STS_WIDTH                   1  
#define ARIZONA_OUT4R_ENA_STS                    0x0040  
#define ARIZONA_OUT4R_ENA_STS_MASK               0x0040  
#define ARIZONA_OUT4R_ENA_STS_SHIFT                   6  
#define ARIZONA_OUT4R_ENA_STS_WIDTH                   1  


#define ARIZONA_OUT_RATE_MASK                    0x7800  
#define ARIZONA_OUT_RATE_SHIFT                       11  
#define ARIZONA_OUT_RATE_WIDTH                        4  


#define ARIZONA_OUT_VD_RAMP_MASK                 0x0070  
#define ARIZONA_OUT_VD_RAMP_SHIFT                     4  
#define ARIZONA_OUT_VD_RAMP_WIDTH                     3  
#define ARIZONA_OUT_VI_RAMP_MASK                 0x0007  
#define ARIZONA_OUT_VI_RAMP_SHIFT                     0  
#define ARIZONA_OUT_VI_RAMP_WIDTH                     3  


#define ARIZONA_OUT1_LP_MODE                     0x8000  
#define ARIZONA_OUT1_LP_MODE_MASK                0x8000  
#define ARIZONA_OUT1_LP_MODE_SHIFT                   15  
#define ARIZONA_OUT1_LP_MODE_WIDTH                    1  
#define ARIZONA_OUT1_OSR                         0x2000  
#define ARIZONA_OUT1_OSR_MASK                    0x2000  
#define ARIZONA_OUT1_OSR_SHIFT                       13  
#define ARIZONA_OUT1_OSR_WIDTH                        1  
#define ARIZONA_OUT1_MONO                        0x1000  
#define ARIZONA_OUT1_MONO_MASK                   0x1000  
#define ARIZONA_OUT1_MONO_SHIFT                      12  
#define ARIZONA_OUT1_MONO_WIDTH                       1  
#define ARIZONA_OUT1L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT1L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT1L_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT1L_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT1L_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT1L_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT1L_MUTE                       0x0100  
#define ARIZONA_OUT1L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT1L_MUTE_SHIFT                      8  
#define ARIZONA_OUT1L_MUTE_WIDTH                      1  
#define ARIZONA_OUT1L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT1L_VOL_SHIFT                       0  
#define ARIZONA_OUT1L_VOL_WIDTH                       8  


#define ARIZONA_OUT1L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT1L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT1L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT1L_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT1L_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT1L_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT1R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT1R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT1R_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT1R_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT1R_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT1R_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT1R_MUTE                       0x0100  
#define ARIZONA_OUT1R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT1R_MUTE_SHIFT                      8  
#define ARIZONA_OUT1R_MUTE_WIDTH                      1  
#define ARIZONA_OUT1R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT1R_VOL_SHIFT                       0  
#define ARIZONA_OUT1R_VOL_WIDTH                       8  


#define ARIZONA_OUT1R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT1R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT1R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT1R_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT1R_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT1R_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT2_LP_MODE                     0x8000  
#define ARIZONA_OUT2_LP_MODE_MASK                0x8000  
#define ARIZONA_OUT2_LP_MODE_SHIFT                   15  
#define ARIZONA_OUT2_LP_MODE_WIDTH                    1  
#define ARIZONA_OUT2_OSR                         0x2000  
#define ARIZONA_OUT2_OSR_MASK                    0x2000  
#define ARIZONA_OUT2_OSR_SHIFT                       13  
#define ARIZONA_OUT2_OSR_WIDTH                        1  
#define ARIZONA_OUT2_MONO                        0x1000  
#define ARIZONA_OUT2_MONO_MASK                   0x1000  
#define ARIZONA_OUT2_MONO_SHIFT                      12  
#define ARIZONA_OUT2_MONO_WIDTH                       1  
#define ARIZONA_OUT2L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT2L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT2L_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT2L_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT2L_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT2L_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT2L_MUTE                       0x0100  
#define ARIZONA_OUT2L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT2L_MUTE_SHIFT                      8  
#define ARIZONA_OUT2L_MUTE_WIDTH                      1  
#define ARIZONA_OUT2L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT2L_VOL_SHIFT                       0  
#define ARIZONA_OUT2L_VOL_WIDTH                       8  


#define ARIZONA_OUT2L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT2L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT2L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT2L_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT2L_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT2L_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT2R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT2R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT2R_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT2R_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT2R_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT2R_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT2R_MUTE                       0x0100  
#define ARIZONA_OUT2R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT2R_MUTE_SHIFT                      8  
#define ARIZONA_OUT2R_MUTE_WIDTH                      1  
#define ARIZONA_OUT2R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT2R_VOL_SHIFT                       0  
#define ARIZONA_OUT2R_VOL_WIDTH                       8  


#define ARIZONA_OUT2R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT2R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT2R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT2R_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT2R_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT2R_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT3_LP_MODE                     0x8000  
#define ARIZONA_OUT3_LP_MODE_MASK                0x8000  
#define ARIZONA_OUT3_LP_MODE_SHIFT                   15  
#define ARIZONA_OUT3_LP_MODE_WIDTH                    1  
#define ARIZONA_OUT3_OSR                         0x2000  
#define ARIZONA_OUT3_OSR_MASK                    0x2000  
#define ARIZONA_OUT3_OSR_SHIFT                       13  
#define ARIZONA_OUT3_OSR_WIDTH                        1  
#define ARIZONA_OUT3_MONO                        0x1000  
#define ARIZONA_OUT3_MONO_MASK                   0x1000  
#define ARIZONA_OUT3_MONO_SHIFT                      12  
#define ARIZONA_OUT3_MONO_WIDTH                       1  
#define ARIZONA_OUT3L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT3L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT3L_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT3L_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT3L_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT3L_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT3L_MUTE                       0x0100  
#define ARIZONA_OUT3L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT3L_MUTE_SHIFT                      8  
#define ARIZONA_OUT3L_MUTE_WIDTH                      1  
#define ARIZONA_OUT3L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT3L_VOL_SHIFT                       0  
#define ARIZONA_OUT3L_VOL_WIDTH                       8  


#define ARIZONA_OUT3L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT3L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT3L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT3_NGATE_SRC_MASK              0x0FFF  
#define ARIZONA_OUT3_NGATE_SRC_SHIFT                  0  
#define ARIZONA_OUT3_NGATE_SRC_WIDTH                 12  


#define ARIZONA_OUT3R_PGA_VOL_MASK               0x00FE  
#define ARIZONA_OUT3R_PGA_VOL_SHIFT                   1  
#define ARIZONA_OUT3R_PGA_VOL_WIDTH                   7  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT3R_MUTE                       0x0100  
#define ARIZONA_OUT3R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT3R_MUTE_SHIFT                      8  
#define ARIZONA_OUT3R_MUTE_WIDTH                      1  
#define ARIZONA_OUT3R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT3R_VOL_SHIFT                       0  
#define ARIZONA_OUT3R_VOL_WIDTH                       8  


#define ARIZONA_OUT3R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT3R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT3R_ANC_SRC_WIDTH                   2  
#define ARIZONA_OUT3R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT3R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT3R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT4_OSR                         0x2000  
#define ARIZONA_OUT4_OSR_MASK                    0x2000  
#define ARIZONA_OUT4_OSR_SHIFT                       13  
#define ARIZONA_OUT4_OSR_WIDTH                        1  
#define ARIZONA_OUT4L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT4L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT4L_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT4L_MUTE                       0x0100  
#define ARIZONA_OUT4L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT4L_MUTE_SHIFT                      8  
#define ARIZONA_OUT4L_MUTE_WIDTH                      1  
#define ARIZONA_OUT4L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT4L_VOL_SHIFT                       0  
#define ARIZONA_OUT4L_VOL_WIDTH                       8  


#define ARIZONA_OUT4L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT4L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT4L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT4L_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT4L_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT4L_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT4R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT4R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT4R_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT4R_MUTE                       0x0100  
#define ARIZONA_OUT4R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT4R_MUTE_SHIFT                      8  
#define ARIZONA_OUT4R_MUTE_WIDTH                      1  
#define ARIZONA_OUT4R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT4R_VOL_SHIFT                       0  
#define ARIZONA_OUT4R_VOL_WIDTH                       8  


#define ARIZONA_OUT4R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT4R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT4R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT4R_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT4R_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT4R_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT5_OSR                         0x2000  
#define ARIZONA_OUT5_OSR_MASK                    0x2000  
#define ARIZONA_OUT5_OSR_SHIFT                       13  
#define ARIZONA_OUT5_OSR_WIDTH                        1  
#define ARIZONA_OUT5L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT5L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT5L_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT5L_MUTE                       0x0100  
#define ARIZONA_OUT5L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT5L_MUTE_SHIFT                      8  
#define ARIZONA_OUT5L_MUTE_WIDTH                      1  
#define ARIZONA_OUT5L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT5L_VOL_SHIFT                       0  
#define ARIZONA_OUT5L_VOL_WIDTH                       8  


#define ARIZONA_OUT5L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT5L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT5L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT5L_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT5L_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT5L_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT5R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT5R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT5R_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT5R_MUTE                       0x0100  
#define ARIZONA_OUT5R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT5R_MUTE_SHIFT                      8  
#define ARIZONA_OUT5R_MUTE_WIDTH                      1  
#define ARIZONA_OUT5R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT5R_VOL_SHIFT                       0  
#define ARIZONA_OUT5R_VOL_WIDTH                       8  


#define ARIZONA_OUT5R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT5R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT5R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT5R_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT5R_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT5R_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT6_OSR                         0x2000  
#define ARIZONA_OUT6_OSR_MASK                    0x2000  
#define ARIZONA_OUT6_OSR_SHIFT                       13  
#define ARIZONA_OUT6_OSR_WIDTH                        1  
#define ARIZONA_OUT6L_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT6L_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT6L_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT6L_MUTE                       0x0100  
#define ARIZONA_OUT6L_MUTE_MASK                  0x0100  
#define ARIZONA_OUT6L_MUTE_SHIFT                      8  
#define ARIZONA_OUT6L_MUTE_WIDTH                      1  
#define ARIZONA_OUT6L_VOL_MASK                   0x00FF  
#define ARIZONA_OUT6L_VOL_SHIFT                       0  
#define ARIZONA_OUT6L_VOL_WIDTH                       8  


#define ARIZONA_OUT6L_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT6L_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT6L_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT6L_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT6L_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT6L_NGATE_SRC_WIDTH                12  


#define ARIZONA_OUT6R_ANC_SRC_MASK               0x0C00  
#define ARIZONA_OUT6R_ANC_SRC_SHIFT                  10  
#define ARIZONA_OUT6R_ANC_SRC_WIDTH                   2  


#define ARIZONA_OUT_VU                           0x0200  
#define ARIZONA_OUT_VU_MASK                      0x0200  
#define ARIZONA_OUT_VU_SHIFT                          9  
#define ARIZONA_OUT_VU_WIDTH                          1  
#define ARIZONA_OUT6R_MUTE                       0x0100  
#define ARIZONA_OUT6R_MUTE_MASK                  0x0100  
#define ARIZONA_OUT6R_MUTE_SHIFT                      8  
#define ARIZONA_OUT6R_MUTE_WIDTH                      1  
#define ARIZONA_OUT6R_VOL_MASK                   0x00FF  
#define ARIZONA_OUT6R_VOL_SHIFT                       0  
#define ARIZONA_OUT6R_VOL_WIDTH                       8  


#define ARIZONA_OUT6R_VOL_LIM_MASK               0x00FF  
#define ARIZONA_OUT6R_VOL_LIM_SHIFT                   0  
#define ARIZONA_OUT6R_VOL_LIM_WIDTH                   8  


#define ARIZONA_OUT6R_NGATE_SRC_MASK             0x0FFF  
#define ARIZONA_OUT6R_NGATE_SRC_SHIFT                 0  
#define ARIZONA_OUT6R_NGATE_SRC_WIDTH                12  


#define ARIZONA_DRE3R_ENA                        0x0020  
#define ARIZONA_DRE3R_ENA_MASK                   0x0020  
#define ARIZONA_DRE3R_ENA_SHIFT                       5  
#define ARIZONA_DRE3R_ENA_WIDTH                       1  
#define ARIZONA_DRE3L_ENA                        0x0010  
#define ARIZONA_DRE3L_ENA_MASK                   0x0010  
#define ARIZONA_DRE3L_ENA_SHIFT                       4  
#define ARIZONA_DRE3L_ENA_WIDTH                       1  
#define ARIZONA_DRE2R_ENA                        0x0008  
#define ARIZONA_DRE2R_ENA_MASK                   0x0008  
#define ARIZONA_DRE2R_ENA_SHIFT                       3  
#define ARIZONA_DRE2R_ENA_WIDTH                       1  
#define ARIZONA_DRE2L_ENA                        0x0004  
#define ARIZONA_DRE2L_ENA_MASK                   0x0004  
#define ARIZONA_DRE2L_ENA_SHIFT                       2  
#define ARIZONA_DRE2L_ENA_WIDTH                       1  
#define ARIZONA_DRE1R_ENA                        0x0002  
#define ARIZONA_DRE1R_ENA_MASK                   0x0002  
#define ARIZONA_DRE1R_ENA_SHIFT                       1  
#define ARIZONA_DRE1R_ENA_WIDTH                       1  
#define ARIZONA_DRE1L_ENA                        0x0001  
#define ARIZONA_DRE1L_ENA_MASK                   0x0001  
#define ARIZONA_DRE1L_ENA_SHIFT                       0  
#define ARIZONA_DRE1L_ENA_WIDTH                       1  


#define WM8998_DRE3L_ENA                          0x0020  
#define WM8998_DRE3L_ENA_MASK                     0x0020  
#define WM8998_DRE3L_ENA_SHIFT                         5  
#define WM8998_DRE3L_ENA_WIDTH                         1  
#define WM8998_DRE2L_ENA                          0x0008  
#define WM8998_DRE2L_ENA_MASK                     0x0008  
#define WM8998_DRE2L_ENA_SHIFT                         3  
#define WM8998_DRE2L_ENA_WIDTH                         1  
#define WM8998_DRE2R_ENA                          0x0004  
#define WM8998_DRE2R_ENA_MASK                     0x0004  
#define WM8998_DRE2R_ENA_SHIFT                         2  
#define WM8998_DRE2R_ENA_WIDTH                         1  
#define WM8998_DRE1L_ENA                          0x0002  
#define WM8998_DRE1L_ENA_MASK                     0x0002  
#define WM8998_DRE1L_ENA_SHIFT                         1  
#define WM8998_DRE1L_ENA_WIDTH                         1  
#define WM8998_DRE1R_ENA                          0x0001  
#define WM8998_DRE1R_ENA_MASK                     0x0001  
#define WM8998_DRE1R_ENA_SHIFT                         0  
#define WM8998_DRE1R_ENA_WIDTH                         1  


#define ARIZONA_DRE_ENV_TC_FAST_MASK             0x0F00  
#define ARIZONA_DRE_ENV_TC_FAST_SHIFT                 8  
#define ARIZONA_DRE_ENV_TC_FAST_WIDTH                 4  


#define ARIZONA_DRE_T_LOW_MASK                   0x3F00  
#define ARIZONA_DRE_T_LOW_SHIFT                       8  
#define ARIZONA_DRE_T_LOW_WIDTH                       6  
#define ARIZONA_DRE_ALOG_VOL_DELAY_MASK          0x000F  
#define ARIZONA_DRE_ALOG_VOL_DELAY_SHIFT              0  
#define ARIZONA_DRE_ALOG_VOL_DELAY_WIDTH              4  


#define ARIZONA_DRE_GAIN_SHIFT_MASK              0xC000  
#define ARIZONA_DRE_GAIN_SHIFT_SHIFT                 14  
#define ARIZONA_DRE_GAIN_SHIFT_WIDTH                  2  
#define ARIZONA_DRE_LOW_LEVEL_ABS_MASK           0x000F  
#define ARIZONA_DRE_LOW_LEVEL_ABS_SHIFT               0  
#define ARIZONA_DRE_LOW_LEVEL_ABS_WIDTH               4  


#define ARIZONA_EDRE_OUT4L_THR2_ENA              0x0200  
#define ARIZONA_EDRE_OUT4L_THR2_ENA_MASK         0x0200  
#define ARIZONA_EDRE_OUT4L_THR2_ENA_SHIFT             9  
#define ARIZONA_EDRE_OUT4L_THR2_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT4R_THR2_ENA              0x0100  
#define ARIZONA_EDRE_OUT4R_THR2_ENA_MASK         0x0100  
#define ARIZONA_EDRE_OUT4R_THR2_ENA_SHIFT             8  
#define ARIZONA_EDRE_OUT4R_THR2_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT4L_THR1_ENA              0x0080  
#define ARIZONA_EDRE_OUT4L_THR1_ENA_MASK         0x0080  
#define ARIZONA_EDRE_OUT4L_THR1_ENA_SHIFT             7  
#define ARIZONA_EDRE_OUT4L_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT4R_THR1_ENA              0x0040  
#define ARIZONA_EDRE_OUT4R_THR1_ENA_MASK         0x0040  
#define ARIZONA_EDRE_OUT4R_THR1_ENA_SHIFT             6  
#define ARIZONA_EDRE_OUT4R_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT3L_THR1_ENA              0x0020  
#define ARIZONA_EDRE_OUT3L_THR1_ENA_MASK         0x0020  
#define ARIZONA_EDRE_OUT3L_THR1_ENA_SHIFT             5  
#define ARIZONA_EDRE_OUT3L_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT3R_THR1_ENA              0x0010  
#define ARIZONA_EDRE_OUT3R_THR1_ENA_MASK         0x0010  
#define ARIZONA_EDRE_OUT3R_THR1_ENA_SHIFT             4  
#define ARIZONA_EDRE_OUT3R_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT2L_THR1_ENA              0x0008  
#define ARIZONA_EDRE_OUT2L_THR1_ENA_MASK         0x0008  
#define ARIZONA_EDRE_OUT2L_THR1_ENA_SHIFT             3  
#define ARIZONA_EDRE_OUT2L_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT2R_THR1_ENA              0x0004  
#define ARIZONA_EDRE_OUT2R_THR1_ENA_MASK         0x0004  
#define ARIZONA_EDRE_OUT2R_THR1_ENA_SHIFT             2  
#define ARIZONA_EDRE_OUT2R_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT1L_THR1_ENA              0x0002  
#define ARIZONA_EDRE_OUT1L_THR1_ENA_MASK         0x0002  
#define ARIZONA_EDRE_OUT1L_THR1_ENA_SHIFT             1  
#define ARIZONA_EDRE_OUT1L_THR1_ENA_WIDTH             1  
#define ARIZONA_EDRE_OUT1R_THR1_ENA              0x0001  
#define ARIZONA_EDRE_OUT1R_THR1_ENA_MASK         0x0001  
#define ARIZONA_EDRE_OUT1R_THR1_ENA_SHIFT             0  
#define ARIZONA_EDRE_OUT1R_THR1_ENA_WIDTH             1  


#define ARIZONA_AEC_LOOPBACK_SRC_MASK            0x003C  
#define ARIZONA_AEC_LOOPBACK_SRC_SHIFT                2  
#define ARIZONA_AEC_LOOPBACK_SRC_WIDTH                4  
#define ARIZONA_AEC_ENA_STS                      0x0002  
#define ARIZONA_AEC_ENA_STS_MASK                 0x0002  
#define ARIZONA_AEC_ENA_STS_SHIFT                     1  
#define ARIZONA_AEC_ENA_STS_WIDTH                     1  
#define ARIZONA_AEC_LOOPBACK_ENA                 0x0001  
#define ARIZONA_AEC_LOOPBACK_ENA_MASK            0x0001  
#define ARIZONA_AEC_LOOPBACK_ENA_SHIFT                0  
#define ARIZONA_AEC_LOOPBACK_ENA_WIDTH                1  


#define ARIZONA_NGATE_HOLD_MASK                  0x0030  
#define ARIZONA_NGATE_HOLD_SHIFT                      4  
#define ARIZONA_NGATE_HOLD_WIDTH                      2  
#define ARIZONA_NGATE_THR_MASK                   0x000E  
#define ARIZONA_NGATE_THR_SHIFT                       1  
#define ARIZONA_NGATE_THR_WIDTH                       3  
#define ARIZONA_NGATE_ENA                        0x0001  
#define ARIZONA_NGATE_ENA_MASK                   0x0001  
#define ARIZONA_NGATE_ENA_SHIFT                       0  
#define ARIZONA_NGATE_ENA_WIDTH                       1  


#define ARIZONA_SPK1R_MUTE                       0x2000  
#define ARIZONA_SPK1R_MUTE_MASK                  0x2000  
#define ARIZONA_SPK1R_MUTE_SHIFT                     13  
#define ARIZONA_SPK1R_MUTE_WIDTH                      1  
#define ARIZONA_SPK1L_MUTE                       0x1000  
#define ARIZONA_SPK1L_MUTE_MASK                  0x1000  
#define ARIZONA_SPK1L_MUTE_SHIFT                     12  
#define ARIZONA_SPK1L_MUTE_WIDTH                      1  
#define ARIZONA_SPK1_MUTE_ENDIAN                 0x0100  
#define ARIZONA_SPK1_MUTE_ENDIAN_MASK            0x0100  
#define ARIZONA_SPK1_MUTE_ENDIAN_SHIFT                8  
#define ARIZONA_SPK1_MUTE_ENDIAN_WIDTH                1  
#define ARIZONA_SPK1_MUTE_SEQ1_MASK              0x00FF  
#define ARIZONA_SPK1_MUTE_SEQ1_SHIFT                  0  
#define ARIZONA_SPK1_MUTE_SEQ1_WIDTH                  8  


#define ARIZONA_SPK1_FMT                         0x0001  
#define ARIZONA_SPK1_FMT_MASK                    0x0001  
#define ARIZONA_SPK1_FMT_SHIFT                        0  
#define ARIZONA_SPK1_FMT_WIDTH                        1  


#define ARIZONA_SPK2R_MUTE                       0x2000  
#define ARIZONA_SPK2R_MUTE_MASK                  0x2000  
#define ARIZONA_SPK2R_MUTE_SHIFT                     13  
#define ARIZONA_SPK2R_MUTE_WIDTH                      1  
#define ARIZONA_SPK2L_MUTE                       0x1000  
#define ARIZONA_SPK2L_MUTE_MASK                  0x1000  
#define ARIZONA_SPK2L_MUTE_SHIFT                     12  
#define ARIZONA_SPK2L_MUTE_WIDTH                      1  
#define ARIZONA_SPK2_MUTE_ENDIAN                 0x0100  
#define ARIZONA_SPK2_MUTE_ENDIAN_MASK            0x0100  
#define ARIZONA_SPK2_MUTE_ENDIAN_SHIFT                8  
#define ARIZONA_SPK2_MUTE_ENDIAN_WIDTH                1  
#define ARIZONA_SPK2_MUTE_SEQ_MASK               0x00FF  
#define ARIZONA_SPK2_MUTE_SEQ_SHIFT                   0  
#define ARIZONA_SPK2_MUTE_SEQ_WIDTH                   8  


#define ARIZONA_SPK2_FMT                         0x0001  
#define ARIZONA_SPK2_FMT_MASK                    0x0001  
#define ARIZONA_SPK2_FMT_SHIFT                        0  
#define ARIZONA_SPK2_FMT_WIDTH                        1  


#define ARIZONA_HP1_SC_ENA                       0x1000  
#define ARIZONA_HP1_SC_ENA_MASK                  0x1000  
#define ARIZONA_HP1_SC_ENA_SHIFT                     12  
#define ARIZONA_HP1_SC_ENA_WIDTH                      1  


#define ARIZONA_HP2_SC_ENA                       0x1000  
#define ARIZONA_HP2_SC_ENA_MASK                  0x1000  
#define ARIZONA_HP2_SC_ENA_SHIFT                     12  
#define ARIZONA_HP2_SC_ENA_WIDTH                      1  


#define ARIZONA_HP3_SC_ENA                       0x1000  
#define ARIZONA_HP3_SC_ENA_MASK                  0x1000  
#define ARIZONA_HP3_SC_ENA_SHIFT                     12  
#define ARIZONA_HP3_SC_ENA_WIDTH                      1  


#define ARIZONA_HP1_TST_CAP_SEL_MASK             0x0003  
#define ARIZONA_HP1_TST_CAP_SEL_SHIFT                 0  
#define ARIZONA_HP1_TST_CAP_SEL_WIDTH                 2  


#define ARIZONA_OUT_COMP_COEFF_MASK              0xFFFF  
#define ARIZONA_OUT_COMP_COEFF_SHIFT                  0  
#define ARIZONA_OUT_COMP_COEFF_WIDTH                 16  


#define ARIZONA_OUT_COMP_COEFF_1                 0x0002  
#define ARIZONA_OUT_COMP_COEFF_1_MASK            0x0002  
#define ARIZONA_OUT_COMP_COEFF_1_SHIFT                1  
#define ARIZONA_OUT_COMP_COEFF_1_WIDTH                1  
#define ARIZONA_OUT_COMP_COEFF_SEL               0x0001  
#define ARIZONA_OUT_COMP_COEFF_SEL_MASK          0x0001  
#define ARIZONA_OUT_COMP_COEFF_SEL_SHIFT              0  
#define ARIZONA_OUT_COMP_COEFF_SEL_WIDTH              1  


#define ARIZONA_AEC_COMP_COEFF_MASK              0xFFFF  
#define ARIZONA_AEC_COMP_COEFF_SHIFT                  0  
#define ARIZONA_AEC_COMP_COEFF_WIDTH                 16  


#define ARIZONA_AEC_COMP_COEFF_1                 0x0002  
#define ARIZONA_AEC_COMP_COEFF_1_MASK            0x0002  
#define ARIZONA_AEC_COMP_COEFF_1_SHIFT                1  
#define ARIZONA_AEC_COMP_COEFF_1_WIDTH                1  
#define ARIZONA_AEC_COMP_COEFF_SEL               0x0001  
#define ARIZONA_AEC_COMP_COEFF_SEL_MASK          0x0001  
#define ARIZONA_AEC_COMP_COEFF_SEL_SHIFT              0  
#define ARIZONA_AEC_COMP_COEFF_SEL_WIDTH              1  


#define ARIZONA_AIF1_BCLK_INV                    0x0080  
#define ARIZONA_AIF1_BCLK_INV_MASK               0x0080  
#define ARIZONA_AIF1_BCLK_INV_SHIFT                   7  
#define ARIZONA_AIF1_BCLK_INV_WIDTH                   1  
#define ARIZONA_AIF1_BCLK_FRC                    0x0040  
#define ARIZONA_AIF1_BCLK_FRC_MASK               0x0040  
#define ARIZONA_AIF1_BCLK_FRC_SHIFT                   6  
#define ARIZONA_AIF1_BCLK_FRC_WIDTH                   1  
#define ARIZONA_AIF1_BCLK_MSTR                   0x0020  
#define ARIZONA_AIF1_BCLK_MSTR_MASK              0x0020  
#define ARIZONA_AIF1_BCLK_MSTR_SHIFT                  5  
#define ARIZONA_AIF1_BCLK_MSTR_WIDTH                  1  
#define ARIZONA_AIF1_BCLK_FREQ_MASK              0x001F  
#define ARIZONA_AIF1_BCLK_FREQ_SHIFT                  0  
#define ARIZONA_AIF1_BCLK_FREQ_WIDTH                  5  


#define ARIZONA_AIF1TX_DAT_TRI                   0x0020  
#define ARIZONA_AIF1TX_DAT_TRI_MASK              0x0020  
#define ARIZONA_AIF1TX_DAT_TRI_SHIFT                  5  
#define ARIZONA_AIF1TX_DAT_TRI_WIDTH                  1  
#define ARIZONA_AIF1TX_LRCLK_SRC                 0x0008  
#define ARIZONA_AIF1TX_LRCLK_SRC_MASK            0x0008  
#define ARIZONA_AIF1TX_LRCLK_SRC_SHIFT                3  
#define ARIZONA_AIF1TX_LRCLK_SRC_WIDTH                1  
#define ARIZONA_AIF1TX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF1TX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF1TX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF1TX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF1TX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF1TX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF1TX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF1TX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF1TX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF1TX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF1TX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF1TX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF1RX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF1RX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF1RX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF1RX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF1RX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF1RX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF1RX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF1RX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF1RX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF1RX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF1RX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF1RX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF1_RATE_MASK                   0x7800  
#define ARIZONA_AIF1_RATE_SHIFT                      11  
#define ARIZONA_AIF1_RATE_WIDTH                       4  
#define ARIZONA_AIF1_TRI                         0x0040  
#define ARIZONA_AIF1_TRI_MASK                    0x0040  
#define ARIZONA_AIF1_TRI_SHIFT                        6  
#define ARIZONA_AIF1_TRI_WIDTH                        1  


#define ARIZONA_AIF1_FMT_MASK                    0x0007  
#define ARIZONA_AIF1_FMT_SHIFT                        0  
#define ARIZONA_AIF1_FMT_WIDTH                        3  


#define ARIZONA_AIF1TX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF1TX_BCPF_SHIFT                     0  
#define ARIZONA_AIF1TX_BCPF_WIDTH                    13  


#define ARIZONA_AIF1RX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF1RX_BCPF_SHIFT                     0  
#define ARIZONA_AIF1RX_BCPF_WIDTH                    13  


#define ARIZONA_AIF1TX_WL_MASK                   0x3F00  
#define ARIZONA_AIF1TX_WL_SHIFT                       8  
#define ARIZONA_AIF1TX_WL_WIDTH                       6  
#define ARIZONA_AIF1TX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF1TX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF1TX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF1RX_WL_MASK                   0x3F00  
#define ARIZONA_AIF1RX_WL_SHIFT                       8  
#define ARIZONA_AIF1RX_WL_WIDTH                       6  
#define ARIZONA_AIF1RX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF1RX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF1RX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF1TX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX3_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX3_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX3_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX4_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX4_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX4_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX5_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX5_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX5_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX6_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX6_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX6_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX7_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX7_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX7_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX8_SLOT_MASK                0x003F  
#define ARIZONA_AIF1TX8_SLOT_SHIFT                    0  
#define ARIZONA_AIF1TX8_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX3_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX3_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX3_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX4_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX4_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX4_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX5_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX5_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX5_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX6_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX6_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX6_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX7_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX7_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX7_SLOT_WIDTH                    6  


#define ARIZONA_AIF1RX8_SLOT_MASK                0x003F  
#define ARIZONA_AIF1RX8_SLOT_SHIFT                    0  
#define ARIZONA_AIF1RX8_SLOT_WIDTH                    6  


#define ARIZONA_AIF1TX8_ENA                      0x0080  
#define ARIZONA_AIF1TX8_ENA_MASK                 0x0080  
#define ARIZONA_AIF1TX8_ENA_SHIFT                     7  
#define ARIZONA_AIF1TX8_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX7_ENA                      0x0040  
#define ARIZONA_AIF1TX7_ENA_MASK                 0x0040  
#define ARIZONA_AIF1TX7_ENA_SHIFT                     6  
#define ARIZONA_AIF1TX7_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX6_ENA                      0x0020  
#define ARIZONA_AIF1TX6_ENA_MASK                 0x0020  
#define ARIZONA_AIF1TX6_ENA_SHIFT                     5  
#define ARIZONA_AIF1TX6_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX5_ENA                      0x0010  
#define ARIZONA_AIF1TX5_ENA_MASK                 0x0010  
#define ARIZONA_AIF1TX5_ENA_SHIFT                     4  
#define ARIZONA_AIF1TX5_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX4_ENA                      0x0008  
#define ARIZONA_AIF1TX4_ENA_MASK                 0x0008  
#define ARIZONA_AIF1TX4_ENA_SHIFT                     3  
#define ARIZONA_AIF1TX4_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX3_ENA                      0x0004  
#define ARIZONA_AIF1TX3_ENA_MASK                 0x0004  
#define ARIZONA_AIF1TX3_ENA_SHIFT                     2  
#define ARIZONA_AIF1TX3_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX2_ENA                      0x0002  
#define ARIZONA_AIF1TX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF1TX2_ENA_SHIFT                     1  
#define ARIZONA_AIF1TX2_ENA_WIDTH                     1  
#define ARIZONA_AIF1TX1_ENA                      0x0001  
#define ARIZONA_AIF1TX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF1TX1_ENA_SHIFT                     0  
#define ARIZONA_AIF1TX1_ENA_WIDTH                     1  


#define ARIZONA_AIF1RX8_ENA                      0x0080  
#define ARIZONA_AIF1RX8_ENA_MASK                 0x0080  
#define ARIZONA_AIF1RX8_ENA_SHIFT                     7  
#define ARIZONA_AIF1RX8_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX7_ENA                      0x0040  
#define ARIZONA_AIF1RX7_ENA_MASK                 0x0040  
#define ARIZONA_AIF1RX7_ENA_SHIFT                     6  
#define ARIZONA_AIF1RX7_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX6_ENA                      0x0020  
#define ARIZONA_AIF1RX6_ENA_MASK                 0x0020  
#define ARIZONA_AIF1RX6_ENA_SHIFT                     5  
#define ARIZONA_AIF1RX6_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX5_ENA                      0x0010  
#define ARIZONA_AIF1RX5_ENA_MASK                 0x0010  
#define ARIZONA_AIF1RX5_ENA_SHIFT                     4  
#define ARIZONA_AIF1RX5_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX4_ENA                      0x0008  
#define ARIZONA_AIF1RX4_ENA_MASK                 0x0008  
#define ARIZONA_AIF1RX4_ENA_SHIFT                     3  
#define ARIZONA_AIF1RX4_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX3_ENA                      0x0004  
#define ARIZONA_AIF1RX3_ENA_MASK                 0x0004  
#define ARIZONA_AIF1RX3_ENA_SHIFT                     2  
#define ARIZONA_AIF1RX3_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX2_ENA                      0x0002  
#define ARIZONA_AIF1RX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF1RX2_ENA_SHIFT                     1  
#define ARIZONA_AIF1RX2_ENA_WIDTH                     1  
#define ARIZONA_AIF1RX1_ENA                      0x0001  
#define ARIZONA_AIF1RX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF1RX1_ENA_SHIFT                     0  
#define ARIZONA_AIF1RX1_ENA_WIDTH                     1  


#define ARIZONA_AIF1_FRC_WR                      0x0001  
#define ARIZONA_AIF1_FRC_WR_MASK                 0x0001  
#define ARIZONA_AIF1_FRC_WR_SHIFT                     0  
#define ARIZONA_AIF1_FRC_WR_WIDTH                     1  


#define ARIZONA_AIF2_BCLK_INV                    0x0080  
#define ARIZONA_AIF2_BCLK_INV_MASK               0x0080  
#define ARIZONA_AIF2_BCLK_INV_SHIFT                   7  
#define ARIZONA_AIF2_BCLK_INV_WIDTH                   1  
#define ARIZONA_AIF2_BCLK_FRC                    0x0040  
#define ARIZONA_AIF2_BCLK_FRC_MASK               0x0040  
#define ARIZONA_AIF2_BCLK_FRC_SHIFT                   6  
#define ARIZONA_AIF2_BCLK_FRC_WIDTH                   1  
#define ARIZONA_AIF2_BCLK_MSTR                   0x0020  
#define ARIZONA_AIF2_BCLK_MSTR_MASK              0x0020  
#define ARIZONA_AIF2_BCLK_MSTR_SHIFT                  5  
#define ARIZONA_AIF2_BCLK_MSTR_WIDTH                  1  
#define ARIZONA_AIF2_BCLK_FREQ_MASK              0x001F  
#define ARIZONA_AIF2_BCLK_FREQ_SHIFT                  0  
#define ARIZONA_AIF2_BCLK_FREQ_WIDTH                  5  


#define ARIZONA_AIF2TX_DAT_TRI                   0x0020  
#define ARIZONA_AIF2TX_DAT_TRI_MASK              0x0020  
#define ARIZONA_AIF2TX_DAT_TRI_SHIFT                  5  
#define ARIZONA_AIF2TX_DAT_TRI_WIDTH                  1  
#define ARIZONA_AIF2TX_LRCLK_SRC                 0x0008  
#define ARIZONA_AIF2TX_LRCLK_SRC_MASK            0x0008  
#define ARIZONA_AIF2TX_LRCLK_SRC_SHIFT                3  
#define ARIZONA_AIF2TX_LRCLK_SRC_WIDTH                1  
#define ARIZONA_AIF2TX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF2TX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF2TX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF2TX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF2TX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF2TX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF2TX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF2TX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF2TX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF2TX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF2TX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF2TX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF2RX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF2RX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF2RX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF2RX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF2RX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF2RX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF2RX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF2RX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF2RX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF2RX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF2RX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF2RX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF2_RATE_MASK                   0x7800  
#define ARIZONA_AIF2_RATE_SHIFT                      11  
#define ARIZONA_AIF2_RATE_WIDTH                       4  
#define ARIZONA_AIF2_TRI                         0x0040  
#define ARIZONA_AIF2_TRI_MASK                    0x0040  
#define ARIZONA_AIF2_TRI_SHIFT                        6  
#define ARIZONA_AIF2_TRI_WIDTH                        1  


#define ARIZONA_AIF2_FMT_MASK                    0x0007  
#define ARIZONA_AIF2_FMT_SHIFT                        0  
#define ARIZONA_AIF2_FMT_WIDTH                        3  


#define ARIZONA_AIF2TX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF2TX_BCPF_SHIFT                     0  
#define ARIZONA_AIF2TX_BCPF_WIDTH                    13  


#define ARIZONA_AIF2RX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF2RX_BCPF_SHIFT                     0  
#define ARIZONA_AIF2RX_BCPF_WIDTH                    13  


#define ARIZONA_AIF2TX_WL_MASK                   0x3F00  
#define ARIZONA_AIF2TX_WL_SHIFT                       8  
#define ARIZONA_AIF2TX_WL_WIDTH                       6  
#define ARIZONA_AIF2TX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF2TX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF2TX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF2RX_WL_MASK                   0x3F00  
#define ARIZONA_AIF2RX_WL_SHIFT                       8  
#define ARIZONA_AIF2RX_WL_WIDTH                       6  
#define ARIZONA_AIF2RX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF2RX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF2RX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF2TX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF2TX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF2TX3_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX3_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX3_SLOT_WIDTH                    6  


#define ARIZONA_AIF2TX4_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX4_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX4_SLOT_WIDTH                    6  



#define ARIZONA_AIF2TX5_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX5_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX5_SLOT_WIDTH                    6  


#define ARIZONA_AIF2TX6_SLOT_MASK                0x003F  
#define ARIZONA_AIF2TX6_SLOT_SHIFT                    0  
#define ARIZONA_AIF2TX6_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX3_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX3_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX3_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX4_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX4_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX4_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX5_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX5_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX5_SLOT_WIDTH                    6  


#define ARIZONA_AIF2RX6_SLOT_MASK                0x003F  
#define ARIZONA_AIF2RX6_SLOT_SHIFT                    0  
#define ARIZONA_AIF2RX6_SLOT_WIDTH                    6  


#define ARIZONA_AIF2TX6_ENA                      0x0020  
#define ARIZONA_AIF2TX6_ENA_MASK                 0x0020  
#define ARIZONA_AIF2TX6_ENA_SHIFT                     5  
#define ARIZONA_AIF2TX6_ENA_WIDTH                     1  
#define ARIZONA_AIF2TX5_ENA                      0x0010  
#define ARIZONA_AIF2TX5_ENA_MASK                 0x0010  
#define ARIZONA_AIF2TX5_ENA_SHIFT                     4  
#define ARIZONA_AIF2TX5_ENA_WIDTH                     1  
#define ARIZONA_AIF2TX4_ENA                      0x0008  
#define ARIZONA_AIF2TX4_ENA_MASK                 0x0008  
#define ARIZONA_AIF2TX4_ENA_SHIFT                     3  
#define ARIZONA_AIF2TX4_ENA_WIDTH                     1  
#define ARIZONA_AIF2TX3_ENA                      0x0004  
#define ARIZONA_AIF2TX3_ENA_MASK                 0x0004  
#define ARIZONA_AIF2TX3_ENA_SHIFT                     2  
#define ARIZONA_AIF2TX3_ENA_WIDTH                     1  
#define ARIZONA_AIF2TX2_ENA                      0x0002  
#define ARIZONA_AIF2TX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF2TX2_ENA_SHIFT                     1  
#define ARIZONA_AIF2TX2_ENA_WIDTH                     1  
#define ARIZONA_AIF2TX1_ENA                      0x0001  
#define ARIZONA_AIF2TX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF2TX1_ENA_SHIFT                     0  
#define ARIZONA_AIF2TX1_ENA_WIDTH                     1  


#define ARIZONA_AIF2RX6_ENA                      0x0020  
#define ARIZONA_AIF2RX6_ENA_MASK                 0x0020  
#define ARIZONA_AIF2RX6_ENA_SHIFT                     5  
#define ARIZONA_AIF2RX6_ENA_WIDTH                     1  
#define ARIZONA_AIF2RX5_ENA                      0x0010  
#define ARIZONA_AIF2RX5_ENA_MASK                 0x0010  
#define ARIZONA_AIF2RX5_ENA_SHIFT                     4  
#define ARIZONA_AIF2RX5_ENA_WIDTH                     1  
#define ARIZONA_AIF2RX4_ENA                      0x0008  
#define ARIZONA_AIF2RX4_ENA_MASK                 0x0008  
#define ARIZONA_AIF2RX4_ENA_SHIFT                     3  
#define ARIZONA_AIF2RX4_ENA_WIDTH                     1  
#define ARIZONA_AIF2RX3_ENA                      0x0004  
#define ARIZONA_AIF2RX3_ENA_MASK                 0x0004  
#define ARIZONA_AIF2RX3_ENA_SHIFT                     2  
#define ARIZONA_AIF2RX3_ENA_WIDTH                     1  
#define ARIZONA_AIF2RX2_ENA                      0x0002  
#define ARIZONA_AIF2RX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF2RX2_ENA_SHIFT                     1  
#define ARIZONA_AIF2RX2_ENA_WIDTH                     1  
#define ARIZONA_AIF2RX1_ENA                      0x0001  
#define ARIZONA_AIF2RX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF2RX1_ENA_SHIFT                     0  
#define ARIZONA_AIF2RX1_ENA_WIDTH                     1  


#define ARIZONA_AIF2_FRC_WR                      0x0001  
#define ARIZONA_AIF2_FRC_WR_MASK                 0x0001  
#define ARIZONA_AIF2_FRC_WR_SHIFT                     0  
#define ARIZONA_AIF2_FRC_WR_WIDTH                     1  


#define ARIZONA_AIF3_BCLK_INV                    0x0080  
#define ARIZONA_AIF3_BCLK_INV_MASK               0x0080  
#define ARIZONA_AIF3_BCLK_INV_SHIFT                   7  
#define ARIZONA_AIF3_BCLK_INV_WIDTH                   1  
#define ARIZONA_AIF3_BCLK_FRC                    0x0040  
#define ARIZONA_AIF3_BCLK_FRC_MASK               0x0040  
#define ARIZONA_AIF3_BCLK_FRC_SHIFT                   6  
#define ARIZONA_AIF3_BCLK_FRC_WIDTH                   1  
#define ARIZONA_AIF3_BCLK_MSTR                   0x0020  
#define ARIZONA_AIF3_BCLK_MSTR_MASK              0x0020  
#define ARIZONA_AIF3_BCLK_MSTR_SHIFT                  5  
#define ARIZONA_AIF3_BCLK_MSTR_WIDTH                  1  
#define ARIZONA_AIF3_BCLK_FREQ_MASK              0x001F  
#define ARIZONA_AIF3_BCLK_FREQ_SHIFT                  0  
#define ARIZONA_AIF3_BCLK_FREQ_WIDTH                  5  


#define ARIZONA_AIF3TX_DAT_TRI                   0x0020  
#define ARIZONA_AIF3TX_DAT_TRI_MASK              0x0020  
#define ARIZONA_AIF3TX_DAT_TRI_SHIFT                  5  
#define ARIZONA_AIF3TX_DAT_TRI_WIDTH                  1  
#define ARIZONA_AIF3TX_LRCLK_SRC                 0x0008  
#define ARIZONA_AIF3TX_LRCLK_SRC_MASK            0x0008  
#define ARIZONA_AIF3TX_LRCLK_SRC_SHIFT                3  
#define ARIZONA_AIF3TX_LRCLK_SRC_WIDTH                1  
#define ARIZONA_AIF3TX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF3TX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF3TX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF3TX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF3TX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF3TX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF3TX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF3TX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF3TX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF3TX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF3TX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF3TX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF3RX_LRCLK_INV                 0x0004  
#define ARIZONA_AIF3RX_LRCLK_INV_MASK            0x0004  
#define ARIZONA_AIF3RX_LRCLK_INV_SHIFT                2  
#define ARIZONA_AIF3RX_LRCLK_INV_WIDTH                1  
#define ARIZONA_AIF3RX_LRCLK_FRC                 0x0002  
#define ARIZONA_AIF3RX_LRCLK_FRC_MASK            0x0002  
#define ARIZONA_AIF3RX_LRCLK_FRC_SHIFT                1  
#define ARIZONA_AIF3RX_LRCLK_FRC_WIDTH                1  
#define ARIZONA_AIF3RX_LRCLK_MSTR                0x0001  
#define ARIZONA_AIF3RX_LRCLK_MSTR_MASK           0x0001  
#define ARIZONA_AIF3RX_LRCLK_MSTR_SHIFT               0  
#define ARIZONA_AIF3RX_LRCLK_MSTR_WIDTH               1  


#define ARIZONA_AIF3_RATE_MASK                   0x7800  
#define ARIZONA_AIF3_RATE_SHIFT                      11  
#define ARIZONA_AIF3_RATE_WIDTH                       4  
#define ARIZONA_AIF3_TRI                         0x0040  
#define ARIZONA_AIF3_TRI_MASK                    0x0040  
#define ARIZONA_AIF3_TRI_SHIFT                        6  
#define ARIZONA_AIF3_TRI_WIDTH                        1  


#define ARIZONA_AIF3_FMT_MASK                    0x0007  
#define ARIZONA_AIF3_FMT_SHIFT                        0  
#define ARIZONA_AIF3_FMT_WIDTH                        3  


#define ARIZONA_AIF3TX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF3TX_BCPF_SHIFT                     0  
#define ARIZONA_AIF3TX_BCPF_WIDTH                    13  


#define ARIZONA_AIF3RX_BCPF_MASK                 0x1FFF  
#define ARIZONA_AIF3RX_BCPF_SHIFT                     0  
#define ARIZONA_AIF3RX_BCPF_WIDTH                    13  


#define ARIZONA_AIF3TX_WL_MASK                   0x3F00  
#define ARIZONA_AIF3TX_WL_SHIFT                       8  
#define ARIZONA_AIF3TX_WL_WIDTH                       6  
#define ARIZONA_AIF3TX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF3TX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF3TX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF3RX_WL_MASK                   0x3F00  
#define ARIZONA_AIF3RX_WL_SHIFT                       8  
#define ARIZONA_AIF3RX_WL_WIDTH                       6  
#define ARIZONA_AIF3RX_SLOT_LEN_MASK             0x00FF  
#define ARIZONA_AIF3RX_SLOT_LEN_SHIFT                 0  
#define ARIZONA_AIF3RX_SLOT_LEN_WIDTH                 8  


#define ARIZONA_AIF3TX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF3TX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF3TX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF3TX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF3TX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF3TX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF3RX1_SLOT_MASK                0x003F  
#define ARIZONA_AIF3RX1_SLOT_SHIFT                    0  
#define ARIZONA_AIF3RX1_SLOT_WIDTH                    6  


#define ARIZONA_AIF3RX2_SLOT_MASK                0x003F  
#define ARIZONA_AIF3RX2_SLOT_SHIFT                    0  
#define ARIZONA_AIF3RX2_SLOT_WIDTH                    6  


#define ARIZONA_AIF3TX2_ENA                      0x0002  
#define ARIZONA_AIF3TX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF3TX2_ENA_SHIFT                     1  
#define ARIZONA_AIF3TX2_ENA_WIDTH                     1  
#define ARIZONA_AIF3TX1_ENA                      0x0001  
#define ARIZONA_AIF3TX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF3TX1_ENA_SHIFT                     0  
#define ARIZONA_AIF3TX1_ENA_WIDTH                     1  


#define ARIZONA_AIF3RX2_ENA                      0x0002  
#define ARIZONA_AIF3RX2_ENA_MASK                 0x0002  
#define ARIZONA_AIF3RX2_ENA_SHIFT                     1  
#define ARIZONA_AIF3RX2_ENA_WIDTH                     1  
#define ARIZONA_AIF3RX1_ENA                      0x0001  
#define ARIZONA_AIF3RX1_ENA_MASK                 0x0001  
#define ARIZONA_AIF3RX1_ENA_SHIFT                     0  
#define ARIZONA_AIF3RX1_ENA_WIDTH                     1  


#define ARIZONA_AIF3_FRC_WR                      0x0001  
#define ARIZONA_AIF3_FRC_WR_MASK                 0x0001  
#define ARIZONA_AIF3_FRC_WR_SHIFT                     0  
#define ARIZONA_AIF3_FRC_WR_WIDTH                     1  


#define ARIZONA_SPD1_VAL2                        0x2000  
#define ARIZONA_SPD1_VAL2_MASK                   0x2000  
#define ARIZONA_SPD1_VAL2_SHIFT                      13  
#define ARIZONA_SPD1_VAL2_WIDTH                       1  
#define ARIZONA_SPD1_VAL1                        0x1000  
#define ARIZONA_SPD1_VAL1_MASK                   0x1000  
#define ARIZONA_SPD1_VAL1_SHIFT                      12  
#define ARIZONA_SPD1_VAL1_WIDTH                       1  
#define ARIZONA_SPD1_RATE_MASK                   0x00F0  
#define ARIZONA_SPD1_RATE_SHIFT                       4  
#define ARIZONA_SPD1_RATE_WIDTH                       4  
#define ARIZONA_SPD1_ENA                         0x0001  
#define ARIZONA_SPD1_ENA_MASK                    0x0001  
#define ARIZONA_SPD1_ENA_SHIFT                        0  
#define ARIZONA_SPD1_ENA_WIDTH                        1  


#define ARIZONA_SPD1_CATCODE_MASK                0xFF00  
#define ARIZONA_SPD1_CATCODE_SHIFT                    8  
#define ARIZONA_SPD1_CATCODE_WIDTH                    8  
#define ARIZONA_SPD1_CHSTMODE_MASK               0x00C0  
#define ARIZONA_SPD1_CHSTMODE_SHIFT                   6  
#define ARIZONA_SPD1_CHSTMODE_WIDTH                   2  
#define ARIZONA_SPD1_PREEMPH_MASK                0x0038  
#define ARIZONA_SPD1_PREEMPH_SHIFT                    3  
#define ARIZONA_SPD1_PREEMPH_WIDTH                    3  
#define ARIZONA_SPD1_NOCOPY                      0x0004  
#define ARIZONA_SPD1_NOCOPY_MASK                 0x0004  
#define ARIZONA_SPD1_NOCOPY_SHIFT                     2  
#define ARIZONA_SPD1_NOCOPY_WIDTH                     1  
#define ARIZONA_SPD1_NOAUDIO                     0x0002  
#define ARIZONA_SPD1_NOAUDIO_MASK                0x0002  
#define ARIZONA_SPD1_NOAUDIO_SHIFT                    1  
#define ARIZONA_SPD1_NOAUDIO_WIDTH                    1  
#define ARIZONA_SPD1_PRO                         0x0001  
#define ARIZONA_SPD1_PRO_MASK                    0x0001  
#define ARIZONA_SPD1_PRO_SHIFT                        0  
#define ARIZONA_SPD1_PRO_WIDTH                        1  


#define ARIZONA_SPD1_FREQ_MASK                   0xF000  
#define ARIZONA_SPD1_FREQ_SHIFT                      12  
#define ARIZONA_SPD1_FREQ_WIDTH                       4  
#define ARIZONA_SPD1_CHNUM2_MASK                 0x0F00  
#define ARIZONA_SPD1_CHNUM2_SHIFT                     8  
#define ARIZONA_SPD1_CHNUM2_WIDTH                     4  
#define ARIZONA_SPD1_CHNUM1_MASK                 0x00F0  
#define ARIZONA_SPD1_CHNUM1_SHIFT                     4  
#define ARIZONA_SPD1_CHNUM1_WIDTH                     4  
#define ARIZONA_SPD1_SRCNUM_MASK                 0x000F  
#define ARIZONA_SPD1_SRCNUM_SHIFT                     0  
#define ARIZONA_SPD1_SRCNUM_WIDTH                     4  


#define ARIZONA_SPD1_ORGSAMP_MASK                 0x0F00  
#define ARIZONA_SPD1_ORGSAMP_SHIFT                     8  
#define ARIZONA_SPD1_ORGSAMP_WIDTH                     4  
#define ARIZONA_SPD1_TXWL_MASK                    0x00E0  
#define ARIZONA_SPD1_TXWL_SHIFT                        5  
#define ARIZONA_SPD1_TXWL_WIDTH                        3  
#define ARIZONA_SPD1_MAXWL                        0x0010  
#define ARIZONA_SPD1_MAXWL_MASK                   0x0010  
#define ARIZONA_SPD1_MAXWL_SHIFT                       4  
#define ARIZONA_SPD1_MAXWL_WIDTH                       1  
#define ARIZONA_SPD1_CS31_30_MASK                 0x000C  
#define ARIZONA_SPD1_CS31_30_SHIFT                     2  
#define ARIZONA_SPD1_CS31_30_WIDTH                     2  
#define ARIZONA_SPD1_CLKACU_MASK                  0x0003  
#define ARIZONA_SPD1_CLKACU_SHIFT                      2  
#define ARIZONA_SPD1_CLKACU_WIDTH                      0  


#define ARIZONA_SLIMCLK_SRC                      0x0010  
#define ARIZONA_SLIMCLK_SRC_MASK                 0x0010  
#define ARIZONA_SLIMCLK_SRC_SHIFT                     4  
#define ARIZONA_SLIMCLK_SRC_WIDTH                     1  
#define ARIZONA_FRAMER_REF_GEAR_MASK             0x000F  
#define ARIZONA_FRAMER_REF_GEAR_SHIFT                 0  
#define ARIZONA_FRAMER_REF_GEAR_WIDTH                 4  


#define ARIZONA_SLIMRX2_RATE_MASK                0x7800  
#define ARIZONA_SLIMRX2_RATE_SHIFT                   11  
#define ARIZONA_SLIMRX2_RATE_WIDTH                    4  
#define ARIZONA_SLIMRX1_RATE_MASK                0x0078  
#define ARIZONA_SLIMRX1_RATE_SHIFT                    3  
#define ARIZONA_SLIMRX1_RATE_WIDTH                    4  


#define ARIZONA_SLIMRX4_RATE_MASK                0x7800  
#define ARIZONA_SLIMRX4_RATE_SHIFT                   11  
#define ARIZONA_SLIMRX4_RATE_WIDTH                    4  
#define ARIZONA_SLIMRX3_RATE_MASK                0x0078  
#define ARIZONA_SLIMRX3_RATE_SHIFT                    3  
#define ARIZONA_SLIMRX3_RATE_WIDTH                    4  


#define ARIZONA_SLIMRX6_RATE_MASK                0x7800  
#define ARIZONA_SLIMRX6_RATE_SHIFT                   11  
#define ARIZONA_SLIMRX6_RATE_WIDTH                    4  
#define ARIZONA_SLIMRX5_RATE_MASK                0x0078  
#define ARIZONA_SLIMRX5_RATE_SHIFT                    3  
#define ARIZONA_SLIMRX5_RATE_WIDTH                    4  


#define ARIZONA_SLIMRX8_RATE_MASK                0x7800  
#define ARIZONA_SLIMRX8_RATE_SHIFT                   11  
#define ARIZONA_SLIMRX8_RATE_WIDTH                    4  
#define ARIZONA_SLIMRX7_RATE_MASK                0x0078  
#define ARIZONA_SLIMRX7_RATE_SHIFT                    3  
#define ARIZONA_SLIMRX7_RATE_WIDTH                    4  


#define ARIZONA_SLIMTX2_RATE_MASK                0x7800  
#define ARIZONA_SLIMTX2_RATE_SHIFT                   11  
#define ARIZONA_SLIMTX2_RATE_WIDTH                    4  
#define ARIZONA_SLIMTX1_RATE_MASK                0x0078  
#define ARIZONA_SLIMTX1_RATE_SHIFT                    3  
#define ARIZONA_SLIMTX1_RATE_WIDTH                    4  


#define ARIZONA_SLIMTX4_RATE_MASK                0x7800  
#define ARIZONA_SLIMTX4_RATE_SHIFT                   11  
#define ARIZONA_SLIMTX4_RATE_WIDTH                    4  
#define ARIZONA_SLIMTX3_RATE_MASK                0x0078  
#define ARIZONA_SLIMTX3_RATE_SHIFT                    3  
#define ARIZONA_SLIMTX3_RATE_WIDTH                    4  


#define ARIZONA_SLIMTX6_RATE_MASK                0x7800  
#define ARIZONA_SLIMTX6_RATE_SHIFT                   11  
#define ARIZONA_SLIMTX6_RATE_WIDTH                    4  
#define ARIZONA_SLIMTX5_RATE_MASK                0x0078  
#define ARIZONA_SLIMTX5_RATE_SHIFT                    3  
#define ARIZONA_SLIMTX5_RATE_WIDTH                    4  


#define ARIZONA_SLIMTX8_RATE_MASK                0x7800  
#define ARIZONA_SLIMTX8_RATE_SHIFT                   11  
#define ARIZONA_SLIMTX8_RATE_WIDTH                    4  
#define ARIZONA_SLIMTX7_RATE_MASK                0x0078  
#define ARIZONA_SLIMTX7_RATE_SHIFT                    3  
#define ARIZONA_SLIMTX7_RATE_WIDTH                    4  


#define ARIZONA_SLIMRX8_ENA                      0x0080  
#define ARIZONA_SLIMRX8_ENA_MASK                 0x0080  
#define ARIZONA_SLIMRX8_ENA_SHIFT                     7  
#define ARIZONA_SLIMRX8_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX7_ENA                      0x0040  
#define ARIZONA_SLIMRX7_ENA_MASK                 0x0040  
#define ARIZONA_SLIMRX7_ENA_SHIFT                     6  
#define ARIZONA_SLIMRX7_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX6_ENA                      0x0020  
#define ARIZONA_SLIMRX6_ENA_MASK                 0x0020  
#define ARIZONA_SLIMRX6_ENA_SHIFT                     5  
#define ARIZONA_SLIMRX6_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX5_ENA                      0x0010  
#define ARIZONA_SLIMRX5_ENA_MASK                 0x0010  
#define ARIZONA_SLIMRX5_ENA_SHIFT                     4  
#define ARIZONA_SLIMRX5_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX4_ENA                      0x0008  
#define ARIZONA_SLIMRX4_ENA_MASK                 0x0008  
#define ARIZONA_SLIMRX4_ENA_SHIFT                     3  
#define ARIZONA_SLIMRX4_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX3_ENA                      0x0004  
#define ARIZONA_SLIMRX3_ENA_MASK                 0x0004  
#define ARIZONA_SLIMRX3_ENA_SHIFT                     2  
#define ARIZONA_SLIMRX3_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX2_ENA                      0x0002  
#define ARIZONA_SLIMRX2_ENA_MASK                 0x0002  
#define ARIZONA_SLIMRX2_ENA_SHIFT                     1  
#define ARIZONA_SLIMRX2_ENA_WIDTH                     1  
#define ARIZONA_SLIMRX1_ENA                      0x0001  
#define ARIZONA_SLIMRX1_ENA_MASK                 0x0001  
#define ARIZONA_SLIMRX1_ENA_SHIFT                     0  
#define ARIZONA_SLIMRX1_ENA_WIDTH                     1  


#define ARIZONA_SLIMTX8_ENA                      0x0080  
#define ARIZONA_SLIMTX8_ENA_MASK                 0x0080  
#define ARIZONA_SLIMTX8_ENA_SHIFT                     7  
#define ARIZONA_SLIMTX8_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX7_ENA                      0x0040  
#define ARIZONA_SLIMTX7_ENA_MASK                 0x0040  
#define ARIZONA_SLIMTX7_ENA_SHIFT                     6  
#define ARIZONA_SLIMTX7_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX6_ENA                      0x0020  
#define ARIZONA_SLIMTX6_ENA_MASK                 0x0020  
#define ARIZONA_SLIMTX6_ENA_SHIFT                     5  
#define ARIZONA_SLIMTX6_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX5_ENA                      0x0010  
#define ARIZONA_SLIMTX5_ENA_MASK                 0x0010  
#define ARIZONA_SLIMTX5_ENA_SHIFT                     4  
#define ARIZONA_SLIMTX5_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX4_ENA                      0x0008  
#define ARIZONA_SLIMTX4_ENA_MASK                 0x0008  
#define ARIZONA_SLIMTX4_ENA_SHIFT                     3  
#define ARIZONA_SLIMTX4_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX3_ENA                      0x0004  
#define ARIZONA_SLIMTX3_ENA_MASK                 0x0004  
#define ARIZONA_SLIMTX3_ENA_SHIFT                     2  
#define ARIZONA_SLIMTX3_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX2_ENA                      0x0002  
#define ARIZONA_SLIMTX2_ENA_MASK                 0x0002  
#define ARIZONA_SLIMTX2_ENA_SHIFT                     1  
#define ARIZONA_SLIMTX2_ENA_WIDTH                     1  
#define ARIZONA_SLIMTX1_ENA                      0x0001  
#define ARIZONA_SLIMTX1_ENA_MASK                 0x0001  
#define ARIZONA_SLIMTX1_ENA_SHIFT                     0  
#define ARIZONA_SLIMTX1_ENA_WIDTH                     1  


#define ARIZONA_SLIMRX8_PORT_STS                 0x0080  
#define ARIZONA_SLIMRX8_PORT_STS_MASK            0x0080  
#define ARIZONA_SLIMRX8_PORT_STS_SHIFT                7  
#define ARIZONA_SLIMRX8_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX7_PORT_STS                 0x0040  
#define ARIZONA_SLIMRX7_PORT_STS_MASK            0x0040  
#define ARIZONA_SLIMRX7_PORT_STS_SHIFT                6  
#define ARIZONA_SLIMRX7_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX6_PORT_STS                 0x0020  
#define ARIZONA_SLIMRX6_PORT_STS_MASK            0x0020  
#define ARIZONA_SLIMRX6_PORT_STS_SHIFT                5  
#define ARIZONA_SLIMRX6_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX5_PORT_STS                 0x0010  
#define ARIZONA_SLIMRX5_PORT_STS_MASK            0x0010  
#define ARIZONA_SLIMRX5_PORT_STS_SHIFT                4  
#define ARIZONA_SLIMRX5_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX4_PORT_STS                 0x0008  
#define ARIZONA_SLIMRX4_PORT_STS_MASK            0x0008  
#define ARIZONA_SLIMRX4_PORT_STS_SHIFT                3  
#define ARIZONA_SLIMRX4_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX3_PORT_STS                 0x0004  
#define ARIZONA_SLIMRX3_PORT_STS_MASK            0x0004  
#define ARIZONA_SLIMRX3_PORT_STS_SHIFT                2  
#define ARIZONA_SLIMRX3_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX2_PORT_STS                 0x0002  
#define ARIZONA_SLIMRX2_PORT_STS_MASK            0x0002  
#define ARIZONA_SLIMRX2_PORT_STS_SHIFT                1  
#define ARIZONA_SLIMRX2_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMRX1_PORT_STS                 0x0001  
#define ARIZONA_SLIMRX1_PORT_STS_MASK            0x0001  
#define ARIZONA_SLIMRX1_PORT_STS_SHIFT                0  
#define ARIZONA_SLIMRX1_PORT_STS_WIDTH                1  


#define ARIZONA_SLIMTX8_PORT_STS                 0x0080  
#define ARIZONA_SLIMTX8_PORT_STS_MASK            0x0080  
#define ARIZONA_SLIMTX8_PORT_STS_SHIFT                7  
#define ARIZONA_SLIMTX8_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX7_PORT_STS                 0x0040  
#define ARIZONA_SLIMTX7_PORT_STS_MASK            0x0040  
#define ARIZONA_SLIMTX7_PORT_STS_SHIFT                6  
#define ARIZONA_SLIMTX7_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX6_PORT_STS                 0x0020  
#define ARIZONA_SLIMTX6_PORT_STS_MASK            0x0020  
#define ARIZONA_SLIMTX6_PORT_STS_SHIFT                5  
#define ARIZONA_SLIMTX6_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX5_PORT_STS                 0x0010  
#define ARIZONA_SLIMTX5_PORT_STS_MASK            0x0010  
#define ARIZONA_SLIMTX5_PORT_STS_SHIFT                4  
#define ARIZONA_SLIMTX5_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX4_PORT_STS                 0x0008  
#define ARIZONA_SLIMTX4_PORT_STS_MASK            0x0008  
#define ARIZONA_SLIMTX4_PORT_STS_SHIFT                3  
#define ARIZONA_SLIMTX4_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX3_PORT_STS                 0x0004  
#define ARIZONA_SLIMTX3_PORT_STS_MASK            0x0004  
#define ARIZONA_SLIMTX3_PORT_STS_SHIFT                2  
#define ARIZONA_SLIMTX3_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX2_PORT_STS                 0x0002  
#define ARIZONA_SLIMTX2_PORT_STS_MASK            0x0002  
#define ARIZONA_SLIMTX2_PORT_STS_SHIFT                1  
#define ARIZONA_SLIMTX2_PORT_STS_WIDTH                1  
#define ARIZONA_SLIMTX1_PORT_STS                 0x0001  
#define ARIZONA_SLIMTX1_PORT_STS_MASK            0x0001  
#define ARIZONA_SLIMTX1_PORT_STS_SHIFT                0  
#define ARIZONA_SLIMTX1_PORT_STS_WIDTH                1  


#define ARIZONA_IRQ_POL                          0x0400  
#define ARIZONA_IRQ_POL_MASK                     0x0400  
#define ARIZONA_IRQ_POL_SHIFT                        10  
#define ARIZONA_IRQ_POL_WIDTH                         1  
#define ARIZONA_IRQ_OP_CFG                       0x0200  
#define ARIZONA_IRQ_OP_CFG_MASK                  0x0200  
#define ARIZONA_IRQ_OP_CFG_SHIFT                      9  
#define ARIZONA_IRQ_OP_CFG_WIDTH                      1  


#define ARIZONA_GP_DBTIME_MASK                   0xF000  
#define ARIZONA_GP_DBTIME_SHIFT                      12  
#define ARIZONA_GP_DBTIME_WIDTH                       4  


#define ARIZONA_SW1_MODE_MASK                    0x0003  
#define ARIZONA_SW1_MODE_SHIFT                        0  
#define ARIZONA_SW1_MODE_WIDTH                        2  


#define ARIZONA_LDO1ENA_PD                       0x8000  
#define ARIZONA_LDO1ENA_PD_MASK                  0x8000  
#define ARIZONA_LDO1ENA_PD_SHIFT                     15  
#define ARIZONA_LDO1ENA_PD_WIDTH                      1  
#define ARIZONA_MCLK2_PD                         0x2000  
#define ARIZONA_MCLK2_PD_MASK                    0x2000  
#define ARIZONA_MCLK2_PD_SHIFT                       13  
#define ARIZONA_MCLK2_PD_WIDTH                        1  
#define ARIZONA_RSTB_PU                          0x0002  
#define ARIZONA_RSTB_PU_MASK                     0x0002  
#define ARIZONA_RSTB_PU_SHIFT                         1  
#define ARIZONA_RSTB_PU_WIDTH                         1  


#define ARIZONA_MCLK1_PD                         0x1000  
#define ARIZONA_MCLK1_PD_MASK                    0x1000  
#define ARIZONA_MCLK1_PD_SHIFT                       12  
#define ARIZONA_MCLK1_PD_WIDTH                        1  
#define ARIZONA_MICD_PD                          0x0100  
#define ARIZONA_MICD_PD_MASK                     0x0100  
#define ARIZONA_MICD_PD_SHIFT                         8  
#define ARIZONA_MICD_PD_WIDTH                         1  
#define ARIZONA_ADDR_PD                          0x0001  
#define ARIZONA_ADDR_PD_MASK                     0x0001  
#define ARIZONA_ADDR_PD_SHIFT                         0  
#define ARIZONA_ADDR_PD_WIDTH                         1  


#define ARIZONA_DMICDAT4_PD                      0x0008  
#define ARIZONA_DMICDAT4_PD_MASK                 0x0008  
#define ARIZONA_DMICDAT4_PD_SHIFT                     3  
#define ARIZONA_DMICDAT4_PD_WIDTH                     1  
#define ARIZONA_DMICDAT3_PD                      0x0004  
#define ARIZONA_DMICDAT3_PD_MASK                 0x0004  
#define ARIZONA_DMICDAT3_PD_SHIFT                     2  
#define ARIZONA_DMICDAT3_PD_WIDTH                     1  
#define ARIZONA_DMICDAT2_PD                      0x0002  
#define ARIZONA_DMICDAT2_PD_MASK                 0x0002  
#define ARIZONA_DMICDAT2_PD_SHIFT                     1  
#define ARIZONA_DMICDAT2_PD_WIDTH                     1  
#define ARIZONA_DMICDAT1_PD                      0x0001  
#define ARIZONA_DMICDAT1_PD_MASK                 0x0001  
#define ARIZONA_DMICDAT1_PD_SHIFT                     0  
#define ARIZONA_DMICDAT1_PD_WIDTH                     1  


#define ARIZONA_AIF1RXLRCLK_PU                   0x0020  
#define ARIZONA_AIF1RXLRCLK_PU_MASK              0x0020  
#define ARIZONA_AIF1RXLRCLK_PU_SHIFT                  5  
#define ARIZONA_AIF1RXLRCLK_PU_WIDTH                  1  
#define ARIZONA_AIF1RXLRCLK_PD                   0x0010  
#define ARIZONA_AIF1RXLRCLK_PD_MASK              0x0010  
#define ARIZONA_AIF1RXLRCLK_PD_SHIFT                  4  
#define ARIZONA_AIF1RXLRCLK_PD_WIDTH                  1  
#define ARIZONA_AIF1BCLK_PU                      0x0008  
#define ARIZONA_AIF1BCLK_PU_MASK                 0x0008  
#define ARIZONA_AIF1BCLK_PU_SHIFT                     3  
#define ARIZONA_AIF1BCLK_PU_WIDTH                     1  
#define ARIZONA_AIF1BCLK_PD                      0x0004  
#define ARIZONA_AIF1BCLK_PD_MASK                 0x0004  
#define ARIZONA_AIF1BCLK_PD_SHIFT                     2  
#define ARIZONA_AIF1BCLK_PD_WIDTH                     1  
#define ARIZONA_AIF1RXDAT_PU                     0x0002  
#define ARIZONA_AIF1RXDAT_PU_MASK                0x0002  
#define ARIZONA_AIF1RXDAT_PU_SHIFT                    1  
#define ARIZONA_AIF1RXDAT_PU_WIDTH                    1  
#define ARIZONA_AIF1RXDAT_PD                     0x0001  
#define ARIZONA_AIF1RXDAT_PD_MASK                0x0001  
#define ARIZONA_AIF1RXDAT_PD_SHIFT                    0  
#define ARIZONA_AIF1RXDAT_PD_WIDTH                    1  


#define ARIZONA_AIF2RXLRCLK_PU                   0x0020  
#define ARIZONA_AIF2RXLRCLK_PU_MASK              0x0020  
#define ARIZONA_AIF2RXLRCLK_PU_SHIFT                  5  
#define ARIZONA_AIF2RXLRCLK_PU_WIDTH                  1  
#define ARIZONA_AIF2RXLRCLK_PD                   0x0010  
#define ARIZONA_AIF2RXLRCLK_PD_MASK              0x0010  
#define ARIZONA_AIF2RXLRCLK_PD_SHIFT                  4  
#define ARIZONA_AIF2RXLRCLK_PD_WIDTH                  1  
#define ARIZONA_AIF2BCLK_PU                      0x0008  
#define ARIZONA_AIF2BCLK_PU_MASK                 0x0008  
#define ARIZONA_AIF2BCLK_PU_SHIFT                     3  
#define ARIZONA_AIF2BCLK_PU_WIDTH                     1  
#define ARIZONA_AIF2BCLK_PD                      0x0004  
#define ARIZONA_AIF2BCLK_PD_MASK                 0x0004  
#define ARIZONA_AIF2BCLK_PD_SHIFT                     2  
#define ARIZONA_AIF2BCLK_PD_WIDTH                     1  
#define ARIZONA_AIF2RXDAT_PU                     0x0002  
#define ARIZONA_AIF2RXDAT_PU_MASK                0x0002  
#define ARIZONA_AIF2RXDAT_PU_SHIFT                    1  
#define ARIZONA_AIF2RXDAT_PU_WIDTH                    1  
#define ARIZONA_AIF2RXDAT_PD                     0x0001  
#define ARIZONA_AIF2RXDAT_PD_MASK                0x0001  
#define ARIZONA_AIF2RXDAT_PD_SHIFT                    0  
#define ARIZONA_AIF2RXDAT_PD_WIDTH                    1  


#define ARIZONA_AIF3RXLRCLK_PU                   0x0020  
#define ARIZONA_AIF3RXLRCLK_PU_MASK              0x0020  
#define ARIZONA_AIF3RXLRCLK_PU_SHIFT                  5  
#define ARIZONA_AIF3RXLRCLK_PU_WIDTH                  1  
#define ARIZONA_AIF3RXLRCLK_PD                   0x0010  
#define ARIZONA_AIF3RXLRCLK_PD_MASK              0x0010  
#define ARIZONA_AIF3RXLRCLK_PD_SHIFT                  4  
#define ARIZONA_AIF3RXLRCLK_PD_WIDTH                  1  
#define ARIZONA_AIF3BCLK_PU                      0x0008  
#define ARIZONA_AIF3BCLK_PU_MASK                 0x0008  
#define ARIZONA_AIF3BCLK_PU_SHIFT                     3  
#define ARIZONA_AIF3BCLK_PU_WIDTH                     1  
#define ARIZONA_AIF3BCLK_PD                      0x0004  
#define ARIZONA_AIF3BCLK_PD_MASK                 0x0004  
#define ARIZONA_AIF3BCLK_PD_SHIFT                     2  
#define ARIZONA_AIF3BCLK_PD_WIDTH                     1  
#define ARIZONA_AIF3RXDAT_PU                     0x0002  
#define ARIZONA_AIF3RXDAT_PU_MASK                0x0002  
#define ARIZONA_AIF3RXDAT_PU_SHIFT                    1  
#define ARIZONA_AIF3RXDAT_PU_WIDTH                    1  
#define ARIZONA_AIF3RXDAT_PD                     0x0001  
#define ARIZONA_AIF3RXDAT_PD_MASK                0x0001  
#define ARIZONA_AIF3RXDAT_PD_SHIFT                    0  
#define ARIZONA_AIF3RXDAT_PD_WIDTH                    1  


#define ARIZONA_GP4_EINT1                        0x0008  
#define ARIZONA_GP4_EINT1_MASK                   0x0008  
#define ARIZONA_GP4_EINT1_SHIFT                       3  
#define ARIZONA_GP4_EINT1_WIDTH                       1  
#define ARIZONA_GP3_EINT1                        0x0004  
#define ARIZONA_GP3_EINT1_MASK                   0x0004  
#define ARIZONA_GP3_EINT1_SHIFT                       2  
#define ARIZONA_GP3_EINT1_WIDTH                       1  
#define ARIZONA_GP2_EINT1                        0x0002  
#define ARIZONA_GP2_EINT1_MASK                   0x0002  
#define ARIZONA_GP2_EINT1_SHIFT                       1  
#define ARIZONA_GP2_EINT1_WIDTH                       1  
#define ARIZONA_GP1_EINT1                        0x0001  
#define ARIZONA_GP1_EINT1_MASK                   0x0001  
#define ARIZONA_GP1_EINT1_SHIFT                       0  
#define ARIZONA_GP1_EINT1_WIDTH                       1  


#define ARIZONA_DSP4_RAM_RDY_EINT1               0x0800  
#define ARIZONA_DSP4_RAM_RDY_EINT1_MASK          0x0800  
#define ARIZONA_DSP4_RAM_RDY_EINT1_SHIFT             11  
#define ARIZONA_DSP4_RAM_RDY_EINT1_WIDTH              1  
#define ARIZONA_DSP3_RAM_RDY_EINT1               0x0400  
#define ARIZONA_DSP3_RAM_RDY_EINT1_MASK          0x0400  
#define ARIZONA_DSP3_RAM_RDY_EINT1_SHIFT             10  
#define ARIZONA_DSP3_RAM_RDY_EINT1_WIDTH              1  
#define ARIZONA_DSP2_RAM_RDY_EINT1               0x0200  
#define ARIZONA_DSP2_RAM_RDY_EINT1_MASK          0x0200  
#define ARIZONA_DSP2_RAM_RDY_EINT1_SHIFT              9  
#define ARIZONA_DSP2_RAM_RDY_EINT1_WIDTH              1  
#define ARIZONA_DSP1_RAM_RDY_EINT1               0x0100  
#define ARIZONA_DSP1_RAM_RDY_EINT1_MASK          0x0100  
#define ARIZONA_DSP1_RAM_RDY_EINT1_SHIFT              8  
#define ARIZONA_DSP1_RAM_RDY_EINT1_WIDTH              1  
#define ARIZONA_DSP_IRQ8_EINT1                   0x0080  
#define ARIZONA_DSP_IRQ8_EINT1_MASK              0x0080  
#define ARIZONA_DSP_IRQ8_EINT1_SHIFT                  7  
#define ARIZONA_DSP_IRQ8_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ7_EINT1                   0x0040  
#define ARIZONA_DSP_IRQ7_EINT1_MASK              0x0040  
#define ARIZONA_DSP_IRQ7_EINT1_SHIFT                  6  
#define ARIZONA_DSP_IRQ7_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ6_EINT1                   0x0020  
#define ARIZONA_DSP_IRQ6_EINT1_MASK              0x0020  
#define ARIZONA_DSP_IRQ6_EINT1_SHIFT                  5  
#define ARIZONA_DSP_IRQ6_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ5_EINT1                   0x0010  
#define ARIZONA_DSP_IRQ5_EINT1_MASK              0x0010  
#define ARIZONA_DSP_IRQ5_EINT1_SHIFT                  4  
#define ARIZONA_DSP_IRQ5_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ4_EINT1                   0x0008  
#define ARIZONA_DSP_IRQ4_EINT1_MASK              0x0008  
#define ARIZONA_DSP_IRQ4_EINT1_SHIFT                  3  
#define ARIZONA_DSP_IRQ4_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ3_EINT1                   0x0004  
#define ARIZONA_DSP_IRQ3_EINT1_MASK              0x0004  
#define ARIZONA_DSP_IRQ3_EINT1_SHIFT                  2  
#define ARIZONA_DSP_IRQ3_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ2_EINT1                   0x0002  
#define ARIZONA_DSP_IRQ2_EINT1_MASK              0x0002  
#define ARIZONA_DSP_IRQ2_EINT1_SHIFT                  1  
#define ARIZONA_DSP_IRQ2_EINT1_WIDTH                  1  
#define ARIZONA_DSP_IRQ1_EINT1                   0x0001  
#define ARIZONA_DSP_IRQ1_EINT1_MASK              0x0001  
#define ARIZONA_DSP_IRQ1_EINT1_SHIFT                  0  
#define ARIZONA_DSP_IRQ1_EINT1_WIDTH                  1  


#define ARIZONA_SPK_OVERHEAT_WARN_EINT1          0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT1_MASK     0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT1_SHIFT        15  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT1_WIDTH         1  
#define ARIZONA_SPK_OVERHEAT_EINT1               0x4000  
#define ARIZONA_SPK_OVERHEAT_EINT1_MASK          0x4000  
#define ARIZONA_SPK_OVERHEAT_EINT1_SHIFT             14  
#define ARIZONA_SPK_OVERHEAT_EINT1_WIDTH              1  
#define ARIZONA_HPDET_EINT1                      0x2000  
#define ARIZONA_HPDET_EINT1_MASK                 0x2000  
#define ARIZONA_HPDET_EINT1_SHIFT                    13  
#define ARIZONA_HPDET_EINT1_WIDTH                     1  
#define ARIZONA_MICDET_EINT1                     0x1000  
#define ARIZONA_MICDET_EINT1_MASK                0x1000  
#define ARIZONA_MICDET_EINT1_SHIFT                   12  
#define ARIZONA_MICDET_EINT1_WIDTH                    1  
#define ARIZONA_WSEQ_DONE_EINT1                  0x0800  
#define ARIZONA_WSEQ_DONE_EINT1_MASK             0x0800  
#define ARIZONA_WSEQ_DONE_EINT1_SHIFT                11  
#define ARIZONA_WSEQ_DONE_EINT1_WIDTH                 1  
#define ARIZONA_DRC2_SIG_DET_EINT1               0x0400  
#define ARIZONA_DRC2_SIG_DET_EINT1_MASK          0x0400  
#define ARIZONA_DRC2_SIG_DET_EINT1_SHIFT             10  
#define ARIZONA_DRC2_SIG_DET_EINT1_WIDTH              1  
#define ARIZONA_DRC1_SIG_DET_EINT1               0x0200  
#define ARIZONA_DRC1_SIG_DET_EINT1_MASK          0x0200  
#define ARIZONA_DRC1_SIG_DET_EINT1_SHIFT              9  
#define ARIZONA_DRC1_SIG_DET_EINT1_WIDTH              1  
#define ARIZONA_ASRC2_LOCK_EINT1                 0x0100  
#define ARIZONA_ASRC2_LOCK_EINT1_MASK            0x0100  
#define ARIZONA_ASRC2_LOCK_EINT1_SHIFT                8  
#define ARIZONA_ASRC2_LOCK_EINT1_WIDTH                1  
#define ARIZONA_ASRC1_LOCK_EINT1                 0x0080  
#define ARIZONA_ASRC1_LOCK_EINT1_MASK            0x0080  
#define ARIZONA_ASRC1_LOCK_EINT1_SHIFT                7  
#define ARIZONA_ASRC1_LOCK_EINT1_WIDTH                1  
#define ARIZONA_UNDERCLOCKED_EINT1               0x0040  
#define ARIZONA_UNDERCLOCKED_EINT1_MASK          0x0040  
#define ARIZONA_UNDERCLOCKED_EINT1_SHIFT              6  
#define ARIZONA_UNDERCLOCKED_EINT1_WIDTH              1  
#define ARIZONA_OVERCLOCKED_EINT1                0x0020  
#define ARIZONA_OVERCLOCKED_EINT1_MASK           0x0020  
#define ARIZONA_OVERCLOCKED_EINT1_SHIFT               5  
#define ARIZONA_OVERCLOCKED_EINT1_WIDTH               1  
#define ARIZONA_FLL2_LOCK_EINT1                  0x0008  
#define ARIZONA_FLL2_LOCK_EINT1_MASK             0x0008  
#define ARIZONA_FLL2_LOCK_EINT1_SHIFT                 3  
#define ARIZONA_FLL2_LOCK_EINT1_WIDTH                 1  
#define ARIZONA_FLL1_LOCK_EINT1                  0x0004  
#define ARIZONA_FLL1_LOCK_EINT1_MASK             0x0004  
#define ARIZONA_FLL1_LOCK_EINT1_SHIFT                 2  
#define ARIZONA_FLL1_LOCK_EINT1_WIDTH                 1  
#define ARIZONA_CLKGEN_ERR_EINT1                 0x0002  
#define ARIZONA_CLKGEN_ERR_EINT1_MASK            0x0002  
#define ARIZONA_CLKGEN_ERR_EINT1_SHIFT                1  
#define ARIZONA_CLKGEN_ERR_EINT1_WIDTH                1  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT1           0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT1_MASK      0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT1_SHIFT          0  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT1_WIDTH          1  


#define ARIZONA_ASRC_CFG_ERR_EINT1               0x8000  
#define ARIZONA_ASRC_CFG_ERR_EINT1_MASK          0x8000  
#define ARIZONA_ASRC_CFG_ERR_EINT1_SHIFT             15  
#define ARIZONA_ASRC_CFG_ERR_EINT1_WIDTH              1  
#define ARIZONA_AIF3_ERR_EINT1                   0x4000  
#define ARIZONA_AIF3_ERR_EINT1_MASK              0x4000  
#define ARIZONA_AIF3_ERR_EINT1_SHIFT                 14  
#define ARIZONA_AIF3_ERR_EINT1_WIDTH                  1  
#define ARIZONA_AIF2_ERR_EINT1                   0x2000  
#define ARIZONA_AIF2_ERR_EINT1_MASK              0x2000  
#define ARIZONA_AIF2_ERR_EINT1_SHIFT                 13  
#define ARIZONA_AIF2_ERR_EINT1_WIDTH                  1  
#define ARIZONA_AIF1_ERR_EINT1                   0x1000  
#define ARIZONA_AIF1_ERR_EINT1_MASK              0x1000  
#define ARIZONA_AIF1_ERR_EINT1_SHIFT                 12  
#define ARIZONA_AIF1_ERR_EINT1_WIDTH                  1  
#define ARIZONA_CTRLIF_ERR_EINT1                 0x0800  
#define ARIZONA_CTRLIF_ERR_EINT1_MASK            0x0800  
#define ARIZONA_CTRLIF_ERR_EINT1_SHIFT               11  
#define ARIZONA_CTRLIF_ERR_EINT1_WIDTH                1  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT1       0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT1_MASK  0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT1_SHIFT     10  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT1_WIDTH      1  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT1          0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT1_MASK     0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT1_SHIFT         9  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT1_WIDTH         1  
#define ARIZONA_SYSCLK_ENA_LOW_EINT1             0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_EINT1_MASK        0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_EINT1_SHIFT            8  
#define ARIZONA_SYSCLK_ENA_LOW_EINT1_WIDTH            1  
#define ARIZONA_ISRC1_CFG_ERR_EINT1              0x0080  
#define ARIZONA_ISRC1_CFG_ERR_EINT1_MASK         0x0080  
#define ARIZONA_ISRC1_CFG_ERR_EINT1_SHIFT             7  
#define ARIZONA_ISRC1_CFG_ERR_EINT1_WIDTH             1  
#define ARIZONA_ISRC2_CFG_ERR_EINT1              0x0040  
#define ARIZONA_ISRC2_CFG_ERR_EINT1_MASK         0x0040  
#define ARIZONA_ISRC2_CFG_ERR_EINT1_SHIFT             6  
#define ARIZONA_ISRC2_CFG_ERR_EINT1_WIDTH             1  
#define ARIZONA_HP3R_DONE_EINT1                  0x0020  
#define ARIZONA_HP3R_DONE_EINT1_MASK             0x0020  
#define ARIZONA_HP3R_DONE_EINT1_SHIFT                 5  
#define ARIZONA_HP3R_DONE_EINT1_WIDTH                 1  
#define ARIZONA_HP3L_DONE_EINT1                  0x0010  
#define ARIZONA_HP3L_DONE_EINT1_MASK             0x0010  
#define ARIZONA_HP3L_DONE_EINT1_SHIFT                 4  
#define ARIZONA_HP3L_DONE_EINT1_WIDTH                 1  
#define ARIZONA_HP2R_DONE_EINT1                  0x0008  
#define ARIZONA_HP2R_DONE_EINT1_MASK             0x0008  
#define ARIZONA_HP2R_DONE_EINT1_SHIFT                 3  
#define ARIZONA_HP2R_DONE_EINT1_WIDTH                 1  
#define ARIZONA_HP2L_DONE_EINT1                  0x0004  
#define ARIZONA_HP2L_DONE_EINT1_MASK             0x0004  
#define ARIZONA_HP2L_DONE_EINT1_SHIFT                 2  
#define ARIZONA_HP2L_DONE_EINT1_WIDTH                 1  
#define ARIZONA_HP1R_DONE_EINT1                  0x0002  
#define ARIZONA_HP1R_DONE_EINT1_MASK             0x0002  
#define ARIZONA_HP1R_DONE_EINT1_SHIFT                 1  
#define ARIZONA_HP1R_DONE_EINT1_WIDTH                 1  
#define ARIZONA_HP1L_DONE_EINT1                  0x0001  
#define ARIZONA_HP1L_DONE_EINT1_MASK             0x0001  
#define ARIZONA_HP1L_DONE_EINT1_SHIFT                 0  
#define ARIZONA_HP1L_DONE_EINT1_WIDTH                 1  


#define ARIZONA_V2_AIF3_ERR_EINT1                  0x8000  
#define ARIZONA_V2_AIF3_ERR_EINT1_MASK             0x8000  
#define ARIZONA_V2_AIF3_ERR_EINT1_SHIFT                15  
#define ARIZONA_V2_AIF3_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_AIF2_ERR_EINT1                  0x4000  
#define ARIZONA_V2_AIF2_ERR_EINT1_MASK             0x4000  
#define ARIZONA_V2_AIF2_ERR_EINT1_SHIFT                14  
#define ARIZONA_V2_AIF2_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_AIF1_ERR_EINT1                  0x2000  
#define ARIZONA_V2_AIF1_ERR_EINT1_MASK             0x2000  
#define ARIZONA_V2_AIF1_ERR_EINT1_SHIFT                13  
#define ARIZONA_V2_AIF1_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_CTRLIF_ERR_EINT1                0x1000  
#define ARIZONA_V2_CTRLIF_ERR_EINT1_MASK           0x1000  
#define ARIZONA_V2_CTRLIF_ERR_EINT1_SHIFT              12  
#define ARIZONA_V2_CTRLIF_ERR_EINT1_WIDTH               1  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT1      0x0800  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT1_MASK 0x0800  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT1_SHIFT    11  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT1_WIDTH     1  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT1         0x0400  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT1_MASK    0x0400  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT1_SHIFT       10  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT1_WIDTH        1  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT1            0x0200  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT1_MASK       0x0200  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT1_SHIFT           9  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT1_WIDTH           1  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT1             0x0100  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT1_MASK        0x0100  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT1_SHIFT            8  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT1_WIDTH            1  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT1             0x0080  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT1_MASK        0x0080  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT1_SHIFT            7  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT1_WIDTH            1  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT1             0x0040  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT1_MASK        0x0040  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT1_SHIFT            6  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT1_WIDTH            1  


#define ARIZONA_BOOT_DONE_EINT1                  0x0100  
#define ARIZONA_BOOT_DONE_EINT1_MASK             0x0100  
#define ARIZONA_BOOT_DONE_EINT1_SHIFT                 8  
#define ARIZONA_BOOT_DONE_EINT1_WIDTH                 1  
#define ARIZONA_DCS_DAC_DONE_EINT1               0x0080  
#define ARIZONA_DCS_DAC_DONE_EINT1_MASK          0x0080  
#define ARIZONA_DCS_DAC_DONE_EINT1_SHIFT              7  
#define ARIZONA_DCS_DAC_DONE_EINT1_WIDTH              1  
#define ARIZONA_DCS_HP_DONE_EINT1                0x0040  
#define ARIZONA_DCS_HP_DONE_EINT1_MASK           0x0040  
#define ARIZONA_DCS_HP_DONE_EINT1_SHIFT               6  
#define ARIZONA_DCS_HP_DONE_EINT1_WIDTH               1  
#define ARIZONA_FLL2_CLOCK_OK_EINT1              0x0002  
#define ARIZONA_FLL2_CLOCK_OK_EINT1_MASK         0x0002  
#define ARIZONA_FLL2_CLOCK_OK_EINT1_SHIFT             1  
#define ARIZONA_FLL2_CLOCK_OK_EINT1_WIDTH             1  
#define ARIZONA_FLL1_CLOCK_OK_EINT1              0x0001  
#define ARIZONA_FLL1_CLOCK_OK_EINT1_MASK         0x0001  
#define ARIZONA_FLL1_CLOCK_OK_EINT1_SHIFT             0  
#define ARIZONA_FLL1_CLOCK_OK_EINT1_WIDTH             1  


#define ARIZONA_V2_ASRC_CFG_ERR_EINT1            0x0008  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT1_MASK       0x0008  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT1_SHIFT           3  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT1_WIDTH           1  


#define ARIZONA_DSP_SHARED_WR_COLL_EINT1         0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT1_MASK    0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT1_SHIFT       15  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT1_WIDTH        1  
#define ARIZONA_SPK_SHUTDOWN_EINT1               0x4000  
#define ARIZONA_SPK_SHUTDOWN_EINT1_MASK          0x4000  
#define ARIZONA_SPK_SHUTDOWN_EINT1_SHIFT             14  
#define ARIZONA_SPK_SHUTDOWN_EINT1_WIDTH              1  
#define ARIZONA_SPK1R_SHORT_EINT1                0x2000  
#define ARIZONA_SPK1R_SHORT_EINT1_MASK           0x2000  
#define ARIZONA_SPK1R_SHORT_EINT1_SHIFT              13  
#define ARIZONA_SPK1R_SHORT_EINT1_WIDTH               1  
#define ARIZONA_SPK1L_SHORT_EINT1                0x1000  
#define ARIZONA_SPK1L_SHORT_EINT1_MASK           0x1000  
#define ARIZONA_SPK1L_SHORT_EINT1_SHIFT              12  
#define ARIZONA_SPK1L_SHORT_EINT1_WIDTH               1  
#define ARIZONA_HP3R_SC_NEG_EINT1                0x0800  
#define ARIZONA_HP3R_SC_NEG_EINT1_MASK           0x0800  
#define ARIZONA_HP3R_SC_NEG_EINT1_SHIFT              11  
#define ARIZONA_HP3R_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP3R_SC_POS_EINT1                0x0400  
#define ARIZONA_HP3R_SC_POS_EINT1_MASK           0x0400  
#define ARIZONA_HP3R_SC_POS_EINT1_SHIFT              10  
#define ARIZONA_HP3R_SC_POS_EINT1_WIDTH               1  
#define ARIZONA_HP3L_SC_NEG_EINT1                0x0200  
#define ARIZONA_HP3L_SC_NEG_EINT1_MASK           0x0200  
#define ARIZONA_HP3L_SC_NEG_EINT1_SHIFT               9  
#define ARIZONA_HP3L_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP3L_SC_POS_EINT1                0x0100  
#define ARIZONA_HP3L_SC_POS_EINT1_MASK           0x0100  
#define ARIZONA_HP3L_SC_POS_EINT1_SHIFT               8  
#define ARIZONA_HP3L_SC_POS_EINT1_WIDTH               1  
#define ARIZONA_HP2R_SC_NEG_EINT1                0x0080  
#define ARIZONA_HP2R_SC_NEG_EINT1_MASK           0x0080  
#define ARIZONA_HP2R_SC_NEG_EINT1_SHIFT               7  
#define ARIZONA_HP2R_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP2R_SC_POS_EINT1                0x0040  
#define ARIZONA_HP2R_SC_POS_EINT1_MASK           0x0040  
#define ARIZONA_HP2R_SC_POS_EINT1_SHIFT               6  
#define ARIZONA_HP2R_SC_POS_EINT1_WIDTH               1  
#define ARIZONA_HP2L_SC_NEG_EINT1                0x0020  
#define ARIZONA_HP2L_SC_NEG_EINT1_MASK           0x0020  
#define ARIZONA_HP2L_SC_NEG_EINT1_SHIFT               5  
#define ARIZONA_HP2L_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP2L_SC_POS_EINT1                0x0010  
#define ARIZONA_HP2L_SC_POS_EINT1_MASK           0x0010  
#define ARIZONA_HP2L_SC_POS_EINT1_SHIFT               4  
#define ARIZONA_HP2L_SC_POS_EINT1_WIDTH               1  
#define ARIZONA_HP1R_SC_NEG_EINT1                0x0008  
#define ARIZONA_HP1R_SC_NEG_EINT1_MASK           0x0008  
#define ARIZONA_HP1R_SC_NEG_EINT1_SHIFT               3  
#define ARIZONA_HP1R_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP1R_SC_POS_EINT1                0x0004  
#define ARIZONA_HP1R_SC_POS_EINT1_MASK           0x0004  
#define ARIZONA_HP1R_SC_POS_EINT1_SHIFT               2  
#define ARIZONA_HP1R_SC_POS_EINT1_WIDTH               1  
#define ARIZONA_HP1L_SC_NEG_EINT1                0x0002  
#define ARIZONA_HP1L_SC_NEG_EINT1_MASK           0x0002  
#define ARIZONA_HP1L_SC_NEG_EINT1_SHIFT               1  
#define ARIZONA_HP1L_SC_NEG_EINT1_WIDTH               1  
#define ARIZONA_HP1L_SC_POS_EINT1                0x0001  
#define ARIZONA_HP1L_SC_POS_EINT1_MASK           0x0001  
#define ARIZONA_HP1L_SC_POS_EINT1_SHIFT               0  
#define ARIZONA_HP1L_SC_POS_EINT1_WIDTH               1  


#define ARIZONA_IM_GP4_EINT1                     0x0008  
#define ARIZONA_IM_GP4_EINT1_MASK                0x0008  
#define ARIZONA_IM_GP4_EINT1_SHIFT                    3  
#define ARIZONA_IM_GP4_EINT1_WIDTH                    1  
#define ARIZONA_IM_GP3_EINT1                     0x0004  
#define ARIZONA_IM_GP3_EINT1_MASK                0x0004  
#define ARIZONA_IM_GP3_EINT1_SHIFT                    2  
#define ARIZONA_IM_GP3_EINT1_WIDTH                    1  
#define ARIZONA_IM_GP2_EINT1                     0x0002  
#define ARIZONA_IM_GP2_EINT1_MASK                0x0002  
#define ARIZONA_IM_GP2_EINT1_SHIFT                    1  
#define ARIZONA_IM_GP2_EINT1_WIDTH                    1  
#define ARIZONA_IM_GP1_EINT1                     0x0001  
#define ARIZONA_IM_GP1_EINT1_MASK                0x0001  
#define ARIZONA_IM_GP1_EINT1_SHIFT                    0  
#define ARIZONA_IM_GP1_EINT1_WIDTH                    1  


#define ARIZONA_IM_DSP1_RAM_RDY_EINT1            0x0100  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT1_MASK       0x0100  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT1_SHIFT           8  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT1_WIDTH           1  
#define ARIZONA_IM_DSP_IRQ2_EINT1                0x0002  
#define ARIZONA_IM_DSP_IRQ2_EINT1_MASK           0x0002  
#define ARIZONA_IM_DSP_IRQ2_EINT1_SHIFT               1  
#define ARIZONA_IM_DSP_IRQ2_EINT1_WIDTH               1  
#define ARIZONA_IM_DSP_IRQ1_EINT1                0x0001  
#define ARIZONA_IM_DSP_IRQ1_EINT1_MASK           0x0001  
#define ARIZONA_IM_DSP_IRQ1_EINT1_SHIFT               0  
#define ARIZONA_IM_DSP_IRQ1_EINT1_WIDTH               1  


#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT1       0x8000  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT1_MASK  0x8000  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT1_SHIFT     15  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT1_WIDTH      1  
#define ARIZONA_IM_SPK_OVERHEAT_EINT1            0x4000  
#define ARIZONA_IM_SPK_OVERHEAT_EINT1_MASK       0x4000  
#define ARIZONA_IM_SPK_OVERHEAT_EINT1_SHIFT          14  
#define ARIZONA_IM_SPK_OVERHEAT_EINT1_WIDTH           1  
#define ARIZONA_IM_HPDET_EINT1                   0x2000  
#define ARIZONA_IM_HPDET_EINT1_MASK              0x2000  
#define ARIZONA_IM_HPDET_EINT1_SHIFT                 13  
#define ARIZONA_IM_HPDET_EINT1_WIDTH                  1  
#define ARIZONA_IM_MICDET_EINT1                  0x1000  
#define ARIZONA_IM_MICDET_EINT1_MASK             0x1000  
#define ARIZONA_IM_MICDET_EINT1_SHIFT                12  
#define ARIZONA_IM_MICDET_EINT1_WIDTH                 1  
#define ARIZONA_IM_WSEQ_DONE_EINT1               0x0800  
#define ARIZONA_IM_WSEQ_DONE_EINT1_MASK          0x0800  
#define ARIZONA_IM_WSEQ_DONE_EINT1_SHIFT             11  
#define ARIZONA_IM_WSEQ_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_DRC2_SIG_DET_EINT1            0x0400  
#define ARIZONA_IM_DRC2_SIG_DET_EINT1_MASK       0x0400  
#define ARIZONA_IM_DRC2_SIG_DET_EINT1_SHIFT          10  
#define ARIZONA_IM_DRC2_SIG_DET_EINT1_WIDTH           1  
#define ARIZONA_IM_DRC1_SIG_DET_EINT1            0x0200  
#define ARIZONA_IM_DRC1_SIG_DET_EINT1_MASK       0x0200  
#define ARIZONA_IM_DRC1_SIG_DET_EINT1_SHIFT           9  
#define ARIZONA_IM_DRC1_SIG_DET_EINT1_WIDTH           1  
#define ARIZONA_IM_ASRC2_LOCK_EINT1              0x0100  
#define ARIZONA_IM_ASRC2_LOCK_EINT1_MASK         0x0100  
#define ARIZONA_IM_ASRC2_LOCK_EINT1_SHIFT             8  
#define ARIZONA_IM_ASRC2_LOCK_EINT1_WIDTH             1  
#define ARIZONA_IM_ASRC1_LOCK_EINT1              0x0080  
#define ARIZONA_IM_ASRC1_LOCK_EINT1_MASK         0x0080  
#define ARIZONA_IM_ASRC1_LOCK_EINT1_SHIFT             7  
#define ARIZONA_IM_ASRC1_LOCK_EINT1_WIDTH             1  
#define ARIZONA_IM_UNDERCLOCKED_EINT1            0x0040  
#define ARIZONA_IM_UNDERCLOCKED_EINT1_MASK       0x0040  
#define ARIZONA_IM_UNDERCLOCKED_EINT1_SHIFT           6  
#define ARIZONA_IM_UNDERCLOCKED_EINT1_WIDTH           1  
#define ARIZONA_IM_OVERCLOCKED_EINT1             0x0020  
#define ARIZONA_IM_OVERCLOCKED_EINT1_MASK        0x0020  
#define ARIZONA_IM_OVERCLOCKED_EINT1_SHIFT            5  
#define ARIZONA_IM_OVERCLOCKED_EINT1_WIDTH            1  
#define ARIZONA_IM_FLL2_LOCK_EINT1               0x0008  
#define ARIZONA_IM_FLL2_LOCK_EINT1_MASK          0x0008  
#define ARIZONA_IM_FLL2_LOCK_EINT1_SHIFT              3  
#define ARIZONA_IM_FLL2_LOCK_EINT1_WIDTH              1  
#define ARIZONA_IM_FLL1_LOCK_EINT1               0x0004  
#define ARIZONA_IM_FLL1_LOCK_EINT1_MASK          0x0004  
#define ARIZONA_IM_FLL1_LOCK_EINT1_SHIFT              2  
#define ARIZONA_IM_FLL1_LOCK_EINT1_WIDTH              1  
#define ARIZONA_IM_CLKGEN_ERR_EINT1              0x0002  
#define ARIZONA_IM_CLKGEN_ERR_EINT1_MASK         0x0002  
#define ARIZONA_IM_CLKGEN_ERR_EINT1_SHIFT             1  
#define ARIZONA_IM_CLKGEN_ERR_EINT1_WIDTH             1  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT1        0x0001  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT1_MASK   0x0001  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT1_SHIFT       0  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT1_WIDTH       1  


#define ARIZONA_IM_ASRC_CFG_ERR_EINT1            0x8000  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT1_MASK       0x8000  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT1_SHIFT          15  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT1_WIDTH           1  
#define ARIZONA_IM_AIF3_ERR_EINT1                0x4000  
#define ARIZONA_IM_AIF3_ERR_EINT1_MASK           0x4000  
#define ARIZONA_IM_AIF3_ERR_EINT1_SHIFT              14  
#define ARIZONA_IM_AIF3_ERR_EINT1_WIDTH               1  
#define ARIZONA_IM_AIF2_ERR_EINT1                0x2000  
#define ARIZONA_IM_AIF2_ERR_EINT1_MASK           0x2000  
#define ARIZONA_IM_AIF2_ERR_EINT1_SHIFT              13  
#define ARIZONA_IM_AIF2_ERR_EINT1_WIDTH               1  
#define ARIZONA_IM_AIF1_ERR_EINT1                0x1000  
#define ARIZONA_IM_AIF1_ERR_EINT1_MASK           0x1000  
#define ARIZONA_IM_AIF1_ERR_EINT1_SHIFT              12  
#define ARIZONA_IM_AIF1_ERR_EINT1_WIDTH               1  
#define ARIZONA_IM_CTRLIF_ERR_EINT1              0x0800  
#define ARIZONA_IM_CTRLIF_ERR_EINT1_MASK         0x0800  
#define ARIZONA_IM_CTRLIF_ERR_EINT1_SHIFT            11  
#define ARIZONA_IM_CTRLIF_ERR_EINT1_WIDTH             1  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT1    0x0400  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT1_MASK 0x0400  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT1_SHIFT     10  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT1_WIDTH      1  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT1       0x0200  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT1_MASK  0x0200  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT1_SHIFT      9  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT1_WIDTH      1  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT1          0x0100  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT1_MASK     0x0100  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT1_SHIFT         8  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT1_WIDTH         1  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT1           0x0080  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT1_MASK      0x0080  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT1_SHIFT          7  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT1_WIDTH          1  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT1           0x0040  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT1_MASK      0x0040  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT1_SHIFT          6  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT1_WIDTH          1  
#define ARIZONA_IM_HP3R_DONE_EINT1               0x0020  
#define ARIZONA_IM_HP3R_DONE_EINT1_MASK          0x0020  
#define ARIZONA_IM_HP3R_DONE_EINT1_SHIFT              5  
#define ARIZONA_IM_HP3R_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_HP3L_DONE_EINT1               0x0010  
#define ARIZONA_IM_HP3L_DONE_EINT1_MASK          0x0010  
#define ARIZONA_IM_HP3L_DONE_EINT1_SHIFT              4  
#define ARIZONA_IM_HP3L_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_HP2R_DONE_EINT1               0x0008  
#define ARIZONA_IM_HP2R_DONE_EINT1_MASK          0x0008  
#define ARIZONA_IM_HP2R_DONE_EINT1_SHIFT              3  
#define ARIZONA_IM_HP2R_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_HP2L_DONE_EINT1               0x0004  
#define ARIZONA_IM_HP2L_DONE_EINT1_MASK          0x0004  
#define ARIZONA_IM_HP2L_DONE_EINT1_SHIFT              2  
#define ARIZONA_IM_HP2L_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_HP1R_DONE_EINT1               0x0002  
#define ARIZONA_IM_HP1R_DONE_EINT1_MASK          0x0002  
#define ARIZONA_IM_HP1R_DONE_EINT1_SHIFT              1  
#define ARIZONA_IM_HP1R_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_HP1L_DONE_EINT1               0x0001  
#define ARIZONA_IM_HP1L_DONE_EINT1_MASK          0x0001  
#define ARIZONA_IM_HP1L_DONE_EINT1_SHIFT              0  
#define ARIZONA_IM_HP1L_DONE_EINT1_WIDTH              1  


#define ARIZONA_V2_IM_AIF3_ERR_EINT1                  0x8000  
#define ARIZONA_V2_IM_AIF3_ERR_EINT1_MASK             0x8000  
#define ARIZONA_V2_IM_AIF3_ERR_EINT1_SHIFT                15  
#define ARIZONA_V2_IM_AIF3_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_IM_AIF2_ERR_EINT1                  0x4000  
#define ARIZONA_V2_IM_AIF2_ERR_EINT1_MASK             0x4000  
#define ARIZONA_V2_IM_AIF2_ERR_EINT1_SHIFT                14  
#define ARIZONA_V2_IM_AIF2_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_IM_AIF1_ERR_EINT1                  0x2000  
#define ARIZONA_V2_IM_AIF1_ERR_EINT1_MASK             0x2000  
#define ARIZONA_V2_IM_AIF1_ERR_EINT1_SHIFT                13  
#define ARIZONA_V2_IM_AIF1_ERR_EINT1_WIDTH                 1  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT1                0x1000  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT1_MASK           0x1000  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT1_SHIFT              12  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT1_WIDTH               1  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT1      0x0800  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT1_MASK 0x0800  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT1_SHIFT    11  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT1_WIDTH     1  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT1         0x0400  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT1_MASK    0x0400  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT1_SHIFT       10  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT1_WIDTH        1  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT1            0x0200  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT1_MASK       0x0200  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT1_SHIFT           9  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT1_WIDTH           1  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT1             0x0100  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT1_MASK        0x0100  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT1_SHIFT            8  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT1_WIDTH            1  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT1             0x0080  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT1_MASK        0x0080  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT1_SHIFT            7  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT1_WIDTH            1  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT1             0x0040  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT1_MASK        0x0040  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT1_SHIFT            6  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT1_WIDTH            1  


#define ARIZONA_IM_BOOT_DONE_EINT1               0x0100  
#define ARIZONA_IM_BOOT_DONE_EINT1_MASK          0x0100  
#define ARIZONA_IM_BOOT_DONE_EINT1_SHIFT              8  
#define ARIZONA_IM_BOOT_DONE_EINT1_WIDTH              1  
#define ARIZONA_IM_DCS_DAC_DONE_EINT1            0x0080  
#define ARIZONA_IM_DCS_DAC_DONE_EINT1_MASK       0x0080  
#define ARIZONA_IM_DCS_DAC_DONE_EINT1_SHIFT           7  
#define ARIZONA_IM_DCS_DAC_DONE_EINT1_WIDTH           1  
#define ARIZONA_IM_DCS_HP_DONE_EINT1             0x0040  
#define ARIZONA_IM_DCS_HP_DONE_EINT1_MASK        0x0040  
#define ARIZONA_IM_DCS_HP_DONE_EINT1_SHIFT            6  
#define ARIZONA_IM_DCS_HP_DONE_EINT1_WIDTH            1  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT1           0x0002  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT1_MASK      0x0002  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT1_SHIFT          1  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT1_WIDTH          1  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT1           0x0001  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT1_MASK      0x0001  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT1_SHIFT          0  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT1_WIDTH          1  


#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT1         0x0008  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT1_MASK    0x0008  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT1_SHIFT        3  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT1_WIDTH        1  


#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT1      0x8000  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT1_MASK 0x8000  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT1_SHIFT    15  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT1_WIDTH     1  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT1            0x4000  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT1_MASK       0x4000  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT1_SHIFT          14  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT1_WIDTH           1  
#define ARIZONA_IM_SPK1R_SHORT_EINT1             0x2000  
#define ARIZONA_IM_SPK1R_SHORT_EINT1_MASK        0x2000  
#define ARIZONA_IM_SPK1R_SHORT_EINT1_SHIFT           13  
#define ARIZONA_IM_SPK1R_SHORT_EINT1_WIDTH            1  
#define ARIZONA_IM_SPK1L_SHORT_EINT1             0x1000  
#define ARIZONA_IM_SPK1L_SHORT_EINT1_MASK        0x1000  
#define ARIZONA_IM_SPK1L_SHORT_EINT1_SHIFT           12  
#define ARIZONA_IM_SPK1L_SHORT_EINT1_WIDTH            1  
#define ARIZONA_IM_HP3R_SC_NEG_EINT1             0x0800  
#define ARIZONA_IM_HP3R_SC_NEG_EINT1_MASK        0x0800  
#define ARIZONA_IM_HP3R_SC_NEG_EINT1_SHIFT           11  
#define ARIZONA_IM_HP3R_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP3R_SC_POS_EINT1             0x0400  
#define ARIZONA_IM_HP3R_SC_POS_EINT1_MASK        0x0400  
#define ARIZONA_IM_HP3R_SC_POS_EINT1_SHIFT           10  
#define ARIZONA_IM_HP3R_SC_POS_EINT1_WIDTH            1  
#define ARIZONA_IM_HP3L_SC_NEG_EINT1             0x0200  
#define ARIZONA_IM_HP3L_SC_NEG_EINT1_MASK        0x0200  
#define ARIZONA_IM_HP3L_SC_NEG_EINT1_SHIFT            9  
#define ARIZONA_IM_HP3L_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP3L_SC_POS_EINT1             0x0100  
#define ARIZONA_IM_HP3L_SC_POS_EINT1_MASK        0x0100  
#define ARIZONA_IM_HP3L_SC_POS_EINT1_SHIFT            8  
#define ARIZONA_IM_HP3L_SC_POS_EINT1_WIDTH            1  
#define ARIZONA_IM_HP2R_SC_NEG_EINT1             0x0080  
#define ARIZONA_IM_HP2R_SC_NEG_EINT1_MASK        0x0080  
#define ARIZONA_IM_HP2R_SC_NEG_EINT1_SHIFT            7  
#define ARIZONA_IM_HP2R_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP2R_SC_POS_EINT1             0x0040  
#define ARIZONA_IM_HP2R_SC_POS_EINT1_MASK        0x0040  
#define ARIZONA_IM_HP2R_SC_POS_EINT1_SHIFT            6  
#define ARIZONA_IM_HP2R_SC_POS_EINT1_WIDTH            1  
#define ARIZONA_IM_HP2L_SC_NEG_EINT1             0x0020  
#define ARIZONA_IM_HP2L_SC_NEG_EINT1_MASK        0x0020  
#define ARIZONA_IM_HP2L_SC_NEG_EINT1_SHIFT            5  
#define ARIZONA_IM_HP2L_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP2L_SC_POS_EINT1             0x0010  
#define ARIZONA_IM_HP2L_SC_POS_EINT1_MASK        0x0010  
#define ARIZONA_IM_HP2L_SC_POS_EINT1_SHIFT            4  
#define ARIZONA_IM_HP2L_SC_POS_EINT1_WIDTH            1  
#define ARIZONA_IM_HP1R_SC_NEG_EINT1             0x0008  
#define ARIZONA_IM_HP1R_SC_NEG_EINT1_MASK        0x0008  
#define ARIZONA_IM_HP1R_SC_NEG_EINT1_SHIFT            3  
#define ARIZONA_IM_HP1R_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP1R_SC_POS_EINT1             0x0004  
#define ARIZONA_IM_HP1R_SC_POS_EINT1_MASK        0x0004  
#define ARIZONA_IM_HP1R_SC_POS_EINT1_SHIFT            2  
#define ARIZONA_IM_HP1R_SC_POS_EINT1_WIDTH            1  
#define ARIZONA_IM_HP1L_SC_NEG_EINT1             0x0002  
#define ARIZONA_IM_HP1L_SC_NEG_EINT1_MASK        0x0002  
#define ARIZONA_IM_HP1L_SC_NEG_EINT1_SHIFT            1  
#define ARIZONA_IM_HP1L_SC_NEG_EINT1_WIDTH            1  
#define ARIZONA_IM_HP1L_SC_POS_EINT1             0x0001  
#define ARIZONA_IM_HP1L_SC_POS_EINT1_MASK        0x0001  
#define ARIZONA_IM_HP1L_SC_POS_EINT1_SHIFT            0  
#define ARIZONA_IM_HP1L_SC_POS_EINT1_WIDTH            1  


#define ARIZONA_IM_IRQ1                          0x0001  
#define ARIZONA_IM_IRQ1_MASK                     0x0001  
#define ARIZONA_IM_IRQ1_SHIFT                         0  
#define ARIZONA_IM_IRQ1_WIDTH                         1  


#define ARIZONA_GP4_EINT2                        0x0008  
#define ARIZONA_GP4_EINT2_MASK                   0x0008  
#define ARIZONA_GP4_EINT2_SHIFT                       3  
#define ARIZONA_GP4_EINT2_WIDTH                       1  
#define ARIZONA_GP3_EINT2                        0x0004  
#define ARIZONA_GP3_EINT2_MASK                   0x0004  
#define ARIZONA_GP3_EINT2_SHIFT                       2  
#define ARIZONA_GP3_EINT2_WIDTH                       1  
#define ARIZONA_GP2_EINT2                        0x0002  
#define ARIZONA_GP2_EINT2_MASK                   0x0002  
#define ARIZONA_GP2_EINT2_SHIFT                       1  
#define ARIZONA_GP2_EINT2_WIDTH                       1  
#define ARIZONA_GP1_EINT2                        0x0001  
#define ARIZONA_GP1_EINT2_MASK                   0x0001  
#define ARIZONA_GP1_EINT2_SHIFT                       0  
#define ARIZONA_GP1_EINT2_WIDTH                       1  


#define ARIZONA_DSP1_RAM_RDY_EINT2               0x0100  
#define ARIZONA_DSP1_RAM_RDY_EINT2_MASK          0x0100  
#define ARIZONA_DSP1_RAM_RDY_EINT2_SHIFT              8  
#define ARIZONA_DSP1_RAM_RDY_EINT2_WIDTH              1  
#define ARIZONA_DSP_IRQ2_EINT2                   0x0002  
#define ARIZONA_DSP_IRQ2_EINT2_MASK              0x0002  
#define ARIZONA_DSP_IRQ2_EINT2_SHIFT                  1  
#define ARIZONA_DSP_IRQ2_EINT2_WIDTH                  1  
#define ARIZONA_DSP_IRQ1_EINT2                   0x0001  
#define ARIZONA_DSP_IRQ1_EINT2_MASK              0x0001  
#define ARIZONA_DSP_IRQ1_EINT2_SHIFT                  0  
#define ARIZONA_DSP_IRQ1_EINT2_WIDTH                  1  


#define ARIZONA_SPK_OVERHEAT_WARN_EINT2          0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT2_MASK     0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT2_SHIFT        15  
#define ARIZONA_SPK_OVERHEAT_WARN_EINT2_WIDTH         1  
#define ARIZONA_SPK_OVERHEAT_EINT2               0x4000  
#define ARIZONA_SPK_OVERHEAT_EINT2_MASK          0x4000  
#define ARIZONA_SPK_OVERHEAT_EINT2_SHIFT             14  
#define ARIZONA_SPK_OVERHEAT_EINT2_WIDTH              1  
#define ARIZONA_HPDET_EINT2                      0x2000  
#define ARIZONA_HPDET_EINT2_MASK                 0x2000  
#define ARIZONA_HPDET_EINT2_SHIFT                    13  
#define ARIZONA_HPDET_EINT2_WIDTH                     1  
#define ARIZONA_MICDET_EINT2                     0x1000  
#define ARIZONA_MICDET_EINT2_MASK                0x1000  
#define ARIZONA_MICDET_EINT2_SHIFT                   12  
#define ARIZONA_MICDET_EINT2_WIDTH                    1  
#define ARIZONA_WSEQ_DONE_EINT2                  0x0800  
#define ARIZONA_WSEQ_DONE_EINT2_MASK             0x0800  
#define ARIZONA_WSEQ_DONE_EINT2_SHIFT                11  
#define ARIZONA_WSEQ_DONE_EINT2_WIDTH                 1  
#define ARIZONA_DRC2_SIG_DET_EINT2               0x0400  
#define ARIZONA_DRC2_SIG_DET_EINT2_MASK          0x0400  
#define ARIZONA_DRC2_SIG_DET_EINT2_SHIFT             10  
#define ARIZONA_DRC2_SIG_DET_EINT2_WIDTH              1  
#define ARIZONA_DRC1_SIG_DET_EINT2               0x0200  
#define ARIZONA_DRC1_SIG_DET_EINT2_MASK          0x0200  
#define ARIZONA_DRC1_SIG_DET_EINT2_SHIFT              9  
#define ARIZONA_DRC1_SIG_DET_EINT2_WIDTH              1  
#define ARIZONA_ASRC2_LOCK_EINT2                 0x0100  
#define ARIZONA_ASRC2_LOCK_EINT2_MASK            0x0100  
#define ARIZONA_ASRC2_LOCK_EINT2_SHIFT                8  
#define ARIZONA_ASRC2_LOCK_EINT2_WIDTH                1  
#define ARIZONA_ASRC1_LOCK_EINT2                 0x0080  
#define ARIZONA_ASRC1_LOCK_EINT2_MASK            0x0080  
#define ARIZONA_ASRC1_LOCK_EINT2_SHIFT                7  
#define ARIZONA_ASRC1_LOCK_EINT2_WIDTH                1  
#define ARIZONA_UNDERCLOCKED_EINT2               0x0040  
#define ARIZONA_UNDERCLOCKED_EINT2_MASK          0x0040  
#define ARIZONA_UNDERCLOCKED_EINT2_SHIFT              6  
#define ARIZONA_UNDERCLOCKED_EINT2_WIDTH              1  
#define ARIZONA_OVERCLOCKED_EINT2                0x0020  
#define ARIZONA_OVERCLOCKED_EINT2_MASK           0x0020  
#define ARIZONA_OVERCLOCKED_EINT2_SHIFT               5  
#define ARIZONA_OVERCLOCKED_EINT2_WIDTH               1  
#define ARIZONA_FLL2_LOCK_EINT2                  0x0008  
#define ARIZONA_FLL2_LOCK_EINT2_MASK             0x0008  
#define ARIZONA_FLL2_LOCK_EINT2_SHIFT                 3  
#define ARIZONA_FLL2_LOCK_EINT2_WIDTH                 1  
#define ARIZONA_FLL1_LOCK_EINT2                  0x0004  
#define ARIZONA_FLL1_LOCK_EINT2_MASK             0x0004  
#define ARIZONA_FLL1_LOCK_EINT2_SHIFT                 2  
#define ARIZONA_FLL1_LOCK_EINT2_WIDTH                 1  
#define ARIZONA_CLKGEN_ERR_EINT2                 0x0002  
#define ARIZONA_CLKGEN_ERR_EINT2_MASK            0x0002  
#define ARIZONA_CLKGEN_ERR_EINT2_SHIFT                1  
#define ARIZONA_CLKGEN_ERR_EINT2_WIDTH                1  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT2           0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT2_MASK      0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT2_SHIFT          0  
#define ARIZONA_CLKGEN_ERR_ASYNC_EINT2_WIDTH          1  


#define ARIZONA_ASRC_CFG_ERR_EINT2               0x8000  
#define ARIZONA_ASRC_CFG_ERR_EINT2_MASK          0x8000  
#define ARIZONA_ASRC_CFG_ERR_EINT2_SHIFT             15  
#define ARIZONA_ASRC_CFG_ERR_EINT2_WIDTH              1  
#define ARIZONA_AIF3_ERR_EINT2                   0x4000  
#define ARIZONA_AIF3_ERR_EINT2_MASK              0x4000  
#define ARIZONA_AIF3_ERR_EINT2_SHIFT                 14  
#define ARIZONA_AIF3_ERR_EINT2_WIDTH                  1  
#define ARIZONA_AIF2_ERR_EINT2                   0x2000  
#define ARIZONA_AIF2_ERR_EINT2_MASK              0x2000  
#define ARIZONA_AIF2_ERR_EINT2_SHIFT                 13  
#define ARIZONA_AIF2_ERR_EINT2_WIDTH                  1  
#define ARIZONA_AIF1_ERR_EINT2                   0x1000  
#define ARIZONA_AIF1_ERR_EINT2_MASK              0x1000  
#define ARIZONA_AIF1_ERR_EINT2_SHIFT                 12  
#define ARIZONA_AIF1_ERR_EINT2_WIDTH                  1  
#define ARIZONA_CTRLIF_ERR_EINT2                 0x0800  
#define ARIZONA_CTRLIF_ERR_EINT2_MASK            0x0800  
#define ARIZONA_CTRLIF_ERR_EINT2_SHIFT               11  
#define ARIZONA_CTRLIF_ERR_EINT2_WIDTH                1  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT2       0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT2_MASK  0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT2_SHIFT     10  
#define ARIZONA_MIXER_DROPPED_SAMPLE_EINT2_WIDTH      1  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT2          0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT2_MASK     0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT2_SHIFT         9  
#define ARIZONA_ASYNC_CLK_ENA_LOW_EINT2_WIDTH         1  
#define ARIZONA_SYSCLK_ENA_LOW_EINT2             0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_EINT2_MASK        0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_EINT2_SHIFT            8  
#define ARIZONA_SYSCLK_ENA_LOW_EINT2_WIDTH            1  
#define ARIZONA_ISRC1_CFG_ERR_EINT2              0x0080  
#define ARIZONA_ISRC1_CFG_ERR_EINT2_MASK         0x0080  
#define ARIZONA_ISRC1_CFG_ERR_EINT2_SHIFT             7  
#define ARIZONA_ISRC1_CFG_ERR_EINT2_WIDTH             1  
#define ARIZONA_ISRC2_CFG_ERR_EINT2              0x0040  
#define ARIZONA_ISRC2_CFG_ERR_EINT2_MASK         0x0040  
#define ARIZONA_ISRC2_CFG_ERR_EINT2_SHIFT             6  
#define ARIZONA_ISRC2_CFG_ERR_EINT2_WIDTH             1  
#define ARIZONA_HP3R_DONE_EINT2                  0x0020  
#define ARIZONA_HP3R_DONE_EINT2_MASK             0x0020  
#define ARIZONA_HP3R_DONE_EINT2_SHIFT                 5  
#define ARIZONA_HP3R_DONE_EINT2_WIDTH                 1  
#define ARIZONA_HP3L_DONE_EINT2                  0x0010  
#define ARIZONA_HP3L_DONE_EINT2_MASK             0x0010  
#define ARIZONA_HP3L_DONE_EINT2_SHIFT                 4  
#define ARIZONA_HP3L_DONE_EINT2_WIDTH                 1  
#define ARIZONA_HP2R_DONE_EINT2                  0x0008  
#define ARIZONA_HP2R_DONE_EINT2_MASK             0x0008  
#define ARIZONA_HP2R_DONE_EINT2_SHIFT                 3  
#define ARIZONA_HP2R_DONE_EINT2_WIDTH                 1  
#define ARIZONA_HP2L_DONE_EINT2                  0x0004  
#define ARIZONA_HP2L_DONE_EINT2_MASK             0x0004  
#define ARIZONA_HP2L_DONE_EINT2_SHIFT                 2  
#define ARIZONA_HP2L_DONE_EINT2_WIDTH                 1  
#define ARIZONA_HP1R_DONE_EINT2                  0x0002  
#define ARIZONA_HP1R_DONE_EINT2_MASK             0x0002  
#define ARIZONA_HP1R_DONE_EINT2_SHIFT                 1  
#define ARIZONA_HP1R_DONE_EINT2_WIDTH                 1  
#define ARIZONA_HP1L_DONE_EINT2                  0x0001  
#define ARIZONA_HP1L_DONE_EINT2_MASK             0x0001  
#define ARIZONA_HP1L_DONE_EINT2_SHIFT                 0  
#define ARIZONA_HP1L_DONE_EINT2_WIDTH                 1  


#define ARIZONA_V2_AIF3_ERR_EINT2                  0x8000  
#define ARIZONA_V2_AIF3_ERR_EINT2_MASK             0x8000  
#define ARIZONA_V2_AIF3_ERR_EINT2_SHIFT                15  
#define ARIZONA_V2_AIF3_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_AIF2_ERR_EINT2                  0x4000  
#define ARIZONA_V2_AIF2_ERR_EINT2_MASK             0x4000  
#define ARIZONA_V2_AIF2_ERR_EINT2_SHIFT                14  
#define ARIZONA_V2_AIF2_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_AIF1_ERR_EINT2                  0x2000  
#define ARIZONA_V2_AIF1_ERR_EINT2_MASK             0x2000  
#define ARIZONA_V2_AIF1_ERR_EINT2_SHIFT                13  
#define ARIZONA_V2_AIF1_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_CTRLIF_ERR_EINT2                0x1000  
#define ARIZONA_V2_CTRLIF_ERR_EINT2_MASK           0x1000  
#define ARIZONA_V2_CTRLIF_ERR_EINT2_SHIFT              12  
#define ARIZONA_V2_CTRLIF_ERR_EINT2_WIDTH               1  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT2      0x0800  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT2_MASK 0x0800  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT2_SHIFT    11  
#define ARIZONA_V2_MIXER_DROPPED_SAMPLE_EINT2_WIDTH     1  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT2         0x0400  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT2_MASK    0x0400  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT2_SHIFT       10  
#define ARIZONA_V2_ASYNC_CLK_ENA_LOW_EINT2_WIDTH        1  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT2            0x0200  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT2_MASK       0x0200  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT2_SHIFT           9  
#define ARIZONA_V2_SYSCLK_ENA_LOW_EINT2_WIDTH           1  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT2             0x0100  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT2_MASK        0x0100  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT2_SHIFT            8  
#define ARIZONA_V2_ISRC1_CFG_ERR_EINT2_WIDTH            1  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT2             0x0080  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT2_MASK        0x0080  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT2_SHIFT            7  
#define ARIZONA_V2_ISRC2_CFG_ERR_EINT2_WIDTH            1  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT2             0x0040  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT2_MASK        0x0040  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT2_SHIFT            6  
#define ARIZONA_V2_ISRC3_CFG_ERR_EINT2_WIDTH            1  


#define ARIZONA_BOOT_DONE_EINT2                  0x0100  
#define ARIZONA_BOOT_DONE_EINT2_MASK             0x0100  
#define ARIZONA_BOOT_DONE_EINT2_SHIFT                 8  
#define ARIZONA_BOOT_DONE_EINT2_WIDTH                 1  
#define ARIZONA_DCS_DAC_DONE_EINT2               0x0080  
#define ARIZONA_DCS_DAC_DONE_EINT2_MASK          0x0080  
#define ARIZONA_DCS_DAC_DONE_EINT2_SHIFT              7  
#define ARIZONA_DCS_DAC_DONE_EINT2_WIDTH              1  
#define ARIZONA_DCS_HP_DONE_EINT2                0x0040  
#define ARIZONA_DCS_HP_DONE_EINT2_MASK           0x0040  
#define ARIZONA_DCS_HP_DONE_EINT2_SHIFT               6  
#define ARIZONA_DCS_HP_DONE_EINT2_WIDTH               1  
#define ARIZONA_FLL2_CLOCK_OK_EINT2              0x0002  
#define ARIZONA_FLL2_CLOCK_OK_EINT2_MASK         0x0002  
#define ARIZONA_FLL2_CLOCK_OK_EINT2_SHIFT             1  
#define ARIZONA_FLL2_CLOCK_OK_EINT2_WIDTH             1  
#define ARIZONA_FLL1_CLOCK_OK_EINT2              0x0001  
#define ARIZONA_FLL1_CLOCK_OK_EINT2_MASK         0x0001  
#define ARIZONA_FLL1_CLOCK_OK_EINT2_SHIFT             0  
#define ARIZONA_FLL1_CLOCK_OK_EINT2_WIDTH             1  


#define ARIZONA_V2_ASRC_CFG_ERR_EINT2            0x0008  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT2_MASK       0x0008  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT2_SHIFT           3  
#define ARIZONA_V2_ASRC_CFG_ERR_EINT2_WIDTH           1  


#define ARIZONA_DSP_SHARED_WR_COLL_EINT2         0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT2_MASK    0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT2_SHIFT       15  
#define ARIZONA_DSP_SHARED_WR_COLL_EINT2_WIDTH        1  
#define ARIZONA_SPK_SHUTDOWN_EINT2               0x4000  
#define ARIZONA_SPK_SHUTDOWN_EINT2_MASK          0x4000  
#define ARIZONA_SPK_SHUTDOWN_EINT2_SHIFT             14  
#define ARIZONA_SPK_SHUTDOWN_EINT2_WIDTH              1  
#define ARIZONA_SPK1R_SHORT_EINT2                0x2000  
#define ARIZONA_SPK1R_SHORT_EINT2_MASK           0x2000  
#define ARIZONA_SPK1R_SHORT_EINT2_SHIFT              13  
#define ARIZONA_SPK1R_SHORT_EINT2_WIDTH               1  
#define ARIZONA_SPK1L_SHORT_EINT2                0x1000  
#define ARIZONA_SPK1L_SHORT_EINT2_MASK           0x1000  
#define ARIZONA_SPK1L_SHORT_EINT2_SHIFT              12  
#define ARIZONA_SPK1L_SHORT_EINT2_WIDTH               1  
#define ARIZONA_HP3R_SC_NEG_EINT2                0x0800  
#define ARIZONA_HP3R_SC_NEG_EINT2_MASK           0x0800  
#define ARIZONA_HP3R_SC_NEG_EINT2_SHIFT              11  
#define ARIZONA_HP3R_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP3R_SC_POS_EINT2                0x0400  
#define ARIZONA_HP3R_SC_POS_EINT2_MASK           0x0400  
#define ARIZONA_HP3R_SC_POS_EINT2_SHIFT              10  
#define ARIZONA_HP3R_SC_POS_EINT2_WIDTH               1  
#define ARIZONA_HP3L_SC_NEG_EINT2                0x0200  
#define ARIZONA_HP3L_SC_NEG_EINT2_MASK           0x0200  
#define ARIZONA_HP3L_SC_NEG_EINT2_SHIFT               9  
#define ARIZONA_HP3L_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP3L_SC_POS_EINT2                0x0100  
#define ARIZONA_HP3L_SC_POS_EINT2_MASK           0x0100  
#define ARIZONA_HP3L_SC_POS_EINT2_SHIFT               8  
#define ARIZONA_HP3L_SC_POS_EINT2_WIDTH               1  
#define ARIZONA_HP2R_SC_NEG_EINT2                0x0080  
#define ARIZONA_HP2R_SC_NEG_EINT2_MASK           0x0080  
#define ARIZONA_HP2R_SC_NEG_EINT2_SHIFT               7  
#define ARIZONA_HP2R_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP2R_SC_POS_EINT2                0x0040  
#define ARIZONA_HP2R_SC_POS_EINT2_MASK           0x0040  
#define ARIZONA_HP2R_SC_POS_EINT2_SHIFT               6  
#define ARIZONA_HP2R_SC_POS_EINT2_WIDTH               1  
#define ARIZONA_HP2L_SC_NEG_EINT2                0x0020  
#define ARIZONA_HP2L_SC_NEG_EINT2_MASK           0x0020  
#define ARIZONA_HP2L_SC_NEG_EINT2_SHIFT               5  
#define ARIZONA_HP2L_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP2L_SC_POS_EINT2                0x0010  
#define ARIZONA_HP2L_SC_POS_EINT2_MASK           0x0010  
#define ARIZONA_HP2L_SC_POS_EINT2_SHIFT               4  
#define ARIZONA_HP2L_SC_POS_EINT2_WIDTH               1  
#define ARIZONA_HP1R_SC_NEG_EINT2                0x0008  
#define ARIZONA_HP1R_SC_NEG_EINT2_MASK           0x0008  
#define ARIZONA_HP1R_SC_NEG_EINT2_SHIFT               3  
#define ARIZONA_HP1R_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP1R_SC_POS_EINT2                0x0004  
#define ARIZONA_HP1R_SC_POS_EINT2_MASK           0x0004  
#define ARIZONA_HP1R_SC_POS_EINT2_SHIFT               2  
#define ARIZONA_HP1R_SC_POS_EINT2_WIDTH               1  
#define ARIZONA_HP1L_SC_NEG_EINT2                0x0002  
#define ARIZONA_HP1L_SC_NEG_EINT2_MASK           0x0002  
#define ARIZONA_HP1L_SC_NEG_EINT2_SHIFT               1  
#define ARIZONA_HP1L_SC_NEG_EINT2_WIDTH               1  
#define ARIZONA_HP1L_SC_POS_EINT2                0x0001  
#define ARIZONA_HP1L_SC_POS_EINT2_MASK           0x0001  
#define ARIZONA_HP1L_SC_POS_EINT2_SHIFT               0  
#define ARIZONA_HP1L_SC_POS_EINT2_WIDTH               1  


#define ARIZONA_IM_GP4_EINT2                     0x0008  
#define ARIZONA_IM_GP4_EINT2_MASK                0x0008  
#define ARIZONA_IM_GP4_EINT2_SHIFT                    3  
#define ARIZONA_IM_GP4_EINT2_WIDTH                    1  
#define ARIZONA_IM_GP3_EINT2                     0x0004  
#define ARIZONA_IM_GP3_EINT2_MASK                0x0004  
#define ARIZONA_IM_GP3_EINT2_SHIFT                    2  
#define ARIZONA_IM_GP3_EINT2_WIDTH                    1  
#define ARIZONA_IM_GP2_EINT2                     0x0002  
#define ARIZONA_IM_GP2_EINT2_MASK                0x0002  
#define ARIZONA_IM_GP2_EINT2_SHIFT                    1  
#define ARIZONA_IM_GP2_EINT2_WIDTH                    1  
#define ARIZONA_IM_GP1_EINT2                     0x0001  
#define ARIZONA_IM_GP1_EINT2_MASK                0x0001  
#define ARIZONA_IM_GP1_EINT2_SHIFT                    0  
#define ARIZONA_IM_GP1_EINT2_WIDTH                    1  


#define ARIZONA_IM_DSP1_RAM_RDY_EINT2            0x0100  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT2_MASK       0x0100  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT2_SHIFT           8  
#define ARIZONA_IM_DSP1_RAM_RDY_EINT2_WIDTH           1  
#define ARIZONA_IM_DSP_IRQ2_EINT2                0x0002  
#define ARIZONA_IM_DSP_IRQ2_EINT2_MASK           0x0002  
#define ARIZONA_IM_DSP_IRQ2_EINT2_SHIFT               1  
#define ARIZONA_IM_DSP_IRQ2_EINT2_WIDTH               1  
#define ARIZONA_IM_DSP_IRQ1_EINT2                0x0001  
#define ARIZONA_IM_DSP_IRQ1_EINT2_MASK           0x0001  
#define ARIZONA_IM_DSP_IRQ1_EINT2_SHIFT               0  
#define ARIZONA_IM_DSP_IRQ1_EINT2_WIDTH               1  


#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT2       0x8000  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT2_MASK  0x8000  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT2_SHIFT     15  
#define ARIZONA_IM_SPK_OVERHEAT_WARN_EINT2_WIDTH      1  
#define ARIZONA_IM_SPK_OVERHEAT_EINT2            0x4000  
#define ARIZONA_IM_SPK_OVERHEAT_EINT2_MASK       0x4000  
#define ARIZONA_IM_SPK_OVERHEAT_EINT2_SHIFT          14  
#define ARIZONA_IM_SPK_OVERHEAT_EINT2_WIDTH           1  
#define ARIZONA_IM_HPDET_EINT2                   0x2000  
#define ARIZONA_IM_HPDET_EINT2_MASK              0x2000  
#define ARIZONA_IM_HPDET_EINT2_SHIFT                 13  
#define ARIZONA_IM_HPDET_EINT2_WIDTH                  1  
#define ARIZONA_IM_MICDET_EINT2                  0x1000  
#define ARIZONA_IM_MICDET_EINT2_MASK             0x1000  
#define ARIZONA_IM_MICDET_EINT2_SHIFT                12  
#define ARIZONA_IM_MICDET_EINT2_WIDTH                 1  
#define ARIZONA_IM_WSEQ_DONE_EINT2               0x0800  
#define ARIZONA_IM_WSEQ_DONE_EINT2_MASK          0x0800  
#define ARIZONA_IM_WSEQ_DONE_EINT2_SHIFT             11  
#define ARIZONA_IM_WSEQ_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_DRC2_SIG_DET_EINT2            0x0400  
#define ARIZONA_IM_DRC2_SIG_DET_EINT2_MASK       0x0400  
#define ARIZONA_IM_DRC2_SIG_DET_EINT2_SHIFT          10  
#define ARIZONA_IM_DRC2_SIG_DET_EINT2_WIDTH           1  
#define ARIZONA_IM_DRC1_SIG_DET_EINT2            0x0200  
#define ARIZONA_IM_DRC1_SIG_DET_EINT2_MASK       0x0200  
#define ARIZONA_IM_DRC1_SIG_DET_EINT2_SHIFT           9  
#define ARIZONA_IM_DRC1_SIG_DET_EINT2_WIDTH           1  
#define ARIZONA_IM_ASRC2_LOCK_EINT2              0x0100  
#define ARIZONA_IM_ASRC2_LOCK_EINT2_MASK         0x0100  
#define ARIZONA_IM_ASRC2_LOCK_EINT2_SHIFT             8  
#define ARIZONA_IM_ASRC2_LOCK_EINT2_WIDTH             1  
#define ARIZONA_IM_ASRC1_LOCK_EINT2              0x0080  
#define ARIZONA_IM_ASRC1_LOCK_EINT2_MASK         0x0080  
#define ARIZONA_IM_ASRC1_LOCK_EINT2_SHIFT             7  
#define ARIZONA_IM_ASRC1_LOCK_EINT2_WIDTH             1  
#define ARIZONA_IM_UNDERCLOCKED_EINT2            0x0040  
#define ARIZONA_IM_UNDERCLOCKED_EINT2_MASK       0x0040  
#define ARIZONA_IM_UNDERCLOCKED_EINT2_SHIFT           6  
#define ARIZONA_IM_UNDERCLOCKED_EINT2_WIDTH           1  
#define ARIZONA_IM_OVERCLOCKED_EINT2             0x0020  
#define ARIZONA_IM_OVERCLOCKED_EINT2_MASK        0x0020  
#define ARIZONA_IM_OVERCLOCKED_EINT2_SHIFT            5  
#define ARIZONA_IM_OVERCLOCKED_EINT2_WIDTH            1  
#define ARIZONA_IM_FLL2_LOCK_EINT2               0x0008  
#define ARIZONA_IM_FLL2_LOCK_EINT2_MASK          0x0008  
#define ARIZONA_IM_FLL2_LOCK_EINT2_SHIFT              3  
#define ARIZONA_IM_FLL2_LOCK_EINT2_WIDTH              1  
#define ARIZONA_IM_FLL1_LOCK_EINT2               0x0004  
#define ARIZONA_IM_FLL1_LOCK_EINT2_MASK          0x0004  
#define ARIZONA_IM_FLL1_LOCK_EINT2_SHIFT              2  
#define ARIZONA_IM_FLL1_LOCK_EINT2_WIDTH              1  
#define ARIZONA_IM_CLKGEN_ERR_EINT2              0x0002  
#define ARIZONA_IM_CLKGEN_ERR_EINT2_MASK         0x0002  
#define ARIZONA_IM_CLKGEN_ERR_EINT2_SHIFT             1  
#define ARIZONA_IM_CLKGEN_ERR_EINT2_WIDTH             1  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT2        0x0001  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT2_MASK   0x0001  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT2_SHIFT       0  
#define ARIZONA_IM_CLKGEN_ERR_ASYNC_EINT2_WIDTH       1  


#define ARIZONA_IM_ASRC_CFG_ERR_EINT2            0x8000  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT2_MASK       0x8000  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT2_SHIFT          15  
#define ARIZONA_IM_ASRC_CFG_ERR_EINT2_WIDTH           1  
#define ARIZONA_IM_AIF3_ERR_EINT2                0x4000  
#define ARIZONA_IM_AIF3_ERR_EINT2_MASK           0x4000  
#define ARIZONA_IM_AIF3_ERR_EINT2_SHIFT              14  
#define ARIZONA_IM_AIF3_ERR_EINT2_WIDTH               1  
#define ARIZONA_IM_AIF2_ERR_EINT2                0x2000  
#define ARIZONA_IM_AIF2_ERR_EINT2_MASK           0x2000  
#define ARIZONA_IM_AIF2_ERR_EINT2_SHIFT              13  
#define ARIZONA_IM_AIF2_ERR_EINT2_WIDTH               1  
#define ARIZONA_IM_AIF1_ERR_EINT2                0x1000  
#define ARIZONA_IM_AIF1_ERR_EINT2_MASK           0x1000  
#define ARIZONA_IM_AIF1_ERR_EINT2_SHIFT              12  
#define ARIZONA_IM_AIF1_ERR_EINT2_WIDTH               1  
#define ARIZONA_IM_CTRLIF_ERR_EINT2              0x0800  
#define ARIZONA_IM_CTRLIF_ERR_EINT2_MASK         0x0800  
#define ARIZONA_IM_CTRLIF_ERR_EINT2_SHIFT            11  
#define ARIZONA_IM_CTRLIF_ERR_EINT2_WIDTH             1  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT2    0x0400  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT2_MASK 0x0400  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT2_SHIFT     10  
#define ARIZONA_IM_MIXER_DROPPED_SAMPLE_EINT2_WIDTH      1  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT2       0x0200  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT2_MASK  0x0200  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT2_SHIFT      9  
#define ARIZONA_IM_ASYNC_CLK_ENA_LOW_EINT2_WIDTH      1  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT2          0x0100  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT2_MASK     0x0100  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT2_SHIFT         8  
#define ARIZONA_IM_SYSCLK_ENA_LOW_EINT2_WIDTH         1  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT2           0x0080  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT2_MASK      0x0080  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT2_SHIFT          7  
#define ARIZONA_IM_ISRC1_CFG_ERR_EINT2_WIDTH          1  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT2           0x0040  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT2_MASK      0x0040  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT2_SHIFT          6  
#define ARIZONA_IM_ISRC2_CFG_ERR_EINT2_WIDTH          1  
#define ARIZONA_IM_HP3R_DONE_EINT2               0x0020  
#define ARIZONA_IM_HP3R_DONE_EINT2_MASK          0x0020  
#define ARIZONA_IM_HP3R_DONE_EINT2_SHIFT              5  
#define ARIZONA_IM_HP3R_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_HP3L_DONE_EINT2               0x0010  
#define ARIZONA_IM_HP3L_DONE_EINT2_MASK          0x0010  
#define ARIZONA_IM_HP3L_DONE_EINT2_SHIFT              4  
#define ARIZONA_IM_HP3L_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_HP2R_DONE_EINT2               0x0008  
#define ARIZONA_IM_HP2R_DONE_EINT2_MASK          0x0008  
#define ARIZONA_IM_HP2R_DONE_EINT2_SHIFT              3  
#define ARIZONA_IM_HP2R_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_HP2L_DONE_EINT2               0x0004  
#define ARIZONA_IM_HP2L_DONE_EINT2_MASK          0x0004  
#define ARIZONA_IM_HP2L_DONE_EINT2_SHIFT              2  
#define ARIZONA_IM_HP2L_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_HP1R_DONE_EINT2               0x0002  
#define ARIZONA_IM_HP1R_DONE_EINT2_MASK          0x0002  
#define ARIZONA_IM_HP1R_DONE_EINT2_SHIFT              1  
#define ARIZONA_IM_HP1R_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_HP1L_DONE_EINT2               0x0001  
#define ARIZONA_IM_HP1L_DONE_EINT2_MASK          0x0001  
#define ARIZONA_IM_HP1L_DONE_EINT2_SHIFT              0  
#define ARIZONA_IM_HP1L_DONE_EINT2_WIDTH              1  


#define ARIZONA_V2_IM_AIF3_ERR_EINT2                  0x8000  
#define ARIZONA_V2_IM_AIF3_ERR_EINT2_MASK             0x8000  
#define ARIZONA_V2_IM_AIF3_ERR_EINT2_SHIFT                15  
#define ARIZONA_V2_IM_AIF3_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_IM_AIF2_ERR_EINT2                  0x4000  
#define ARIZONA_V2_IM_AIF2_ERR_EINT2_MASK             0x4000  
#define ARIZONA_V2_IM_AIF2_ERR_EINT2_SHIFT                14  
#define ARIZONA_V2_IM_AIF2_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_IM_AIF1_ERR_EINT2                  0x2000  
#define ARIZONA_V2_IM_AIF1_ERR_EINT2_MASK             0x2000  
#define ARIZONA_V2_IM_AIF1_ERR_EINT2_SHIFT                13  
#define ARIZONA_V2_IM_AIF1_ERR_EINT2_WIDTH                 1  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT2                0x1000  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT2_MASK           0x1000  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT2_SHIFT              12  
#define ARIZONA_V2_IM_CTRLIF_ERR_EINT2_WIDTH               1  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT2      0x0800  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT2_MASK 0x0800  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT2_SHIFT    11  
#define ARIZONA_V2_IM_MIXER_DROPPED_SAMPLE_EINT2_WIDTH     1  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT2         0x0400  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT2_MASK    0x0400  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT2_SHIFT       10  
#define ARIZONA_V2_IM_ASYNC_CLK_ENA_LOW_EINT2_WIDTH        1  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT2            0x0200  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT2_MASK       0x0200  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT2_SHIFT           9  
#define ARIZONA_V2_IM_SYSCLK_ENA_LOW_EINT2_WIDTH           1  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT2             0x0100  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT2_MASK        0x0100  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT2_SHIFT            8  
#define ARIZONA_V2_IM_ISRC1_CFG_ERR_EINT2_WIDTH            1  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT2             0x0080  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT2_MASK        0x0080  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT2_SHIFT            7  
#define ARIZONA_V2_IM_ISRC2_CFG_ERR_EINT2_WIDTH            1  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT2             0x0040  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT2_MASK        0x0040  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT2_SHIFT            6  
#define ARIZONA_V2_IM_ISRC3_CFG_ERR_EINT2_WIDTH            1  



#define ARIZONA_IM_BOOT_DONE_EINT2               0x0100  
#define ARIZONA_IM_BOOT_DONE_EINT2_MASK          0x0100  
#define ARIZONA_IM_BOOT_DONE_EINT2_SHIFT              8  
#define ARIZONA_IM_BOOT_DONE_EINT2_WIDTH              1  
#define ARIZONA_IM_DCS_DAC_DONE_EINT2            0x0080  
#define ARIZONA_IM_DCS_DAC_DONE_EINT2_MASK       0x0080  
#define ARIZONA_IM_DCS_DAC_DONE_EINT2_SHIFT           7  
#define ARIZONA_IM_DCS_DAC_DONE_EINT2_WIDTH           1  
#define ARIZONA_IM_DCS_HP_DONE_EINT2             0x0040  
#define ARIZONA_IM_DCS_HP_DONE_EINT2_MASK        0x0040  
#define ARIZONA_IM_DCS_HP_DONE_EINT2_SHIFT            6  
#define ARIZONA_IM_DCS_HP_DONE_EINT2_WIDTH            1  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT2           0x0002  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT2_MASK      0x0002  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT2_SHIFT          1  
#define ARIZONA_IM_FLL2_CLOCK_OK_EINT2_WIDTH          1  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT2           0x0001  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT2_MASK      0x0001  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT2_SHIFT          0  
#define ARIZONA_IM_FLL1_CLOCK_OK_EINT2_WIDTH          1  


#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT2         0x0008  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT2_MASK    0x0008  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT2_SHIFT        3  
#define ARIZONA_V2_IM_ASRC_CFG_ERR_EINT2_WIDTH        1  


#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT2      0x8000  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT2_MASK 0x8000  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT2_SHIFT    15  
#define ARIZONA_IM_DSP_SHARED_WR_COLL_EINT2_WIDTH     1  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT2            0x4000  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT2_MASK       0x4000  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT2_SHIFT          14  
#define ARIZONA_IM_SPK_SHUTDOWN_EINT2_WIDTH           1  
#define ARIZONA_IM_SPK1R_SHORT_EINT2             0x2000  
#define ARIZONA_IM_SPK1R_SHORT_EINT2_MASK        0x2000  
#define ARIZONA_IM_SPK1R_SHORT_EINT2_SHIFT           13  
#define ARIZONA_IM_SPK1R_SHORT_EINT2_WIDTH            1  
#define ARIZONA_IM_SPK1L_SHORT_EINT2             0x1000  
#define ARIZONA_IM_SPK1L_SHORT_EINT2_MASK        0x1000  
#define ARIZONA_IM_SPK1L_SHORT_EINT2_SHIFT           12  
#define ARIZONA_IM_SPK1L_SHORT_EINT2_WIDTH            1  
#define ARIZONA_IM_HP3R_SC_NEG_EINT2             0x0800  
#define ARIZONA_IM_HP3R_SC_NEG_EINT2_MASK        0x0800  
#define ARIZONA_IM_HP3R_SC_NEG_EINT2_SHIFT           11  
#define ARIZONA_IM_HP3R_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP3R_SC_POS_EINT2             0x0400  
#define ARIZONA_IM_HP3R_SC_POS_EINT2_MASK        0x0400  
#define ARIZONA_IM_HP3R_SC_POS_EINT2_SHIFT           10  
#define ARIZONA_IM_HP3R_SC_POS_EINT2_WIDTH            1  
#define ARIZONA_IM_HP3L_SC_NEG_EINT2             0x0200  
#define ARIZONA_IM_HP3L_SC_NEG_EINT2_MASK        0x0200  
#define ARIZONA_IM_HP3L_SC_NEG_EINT2_SHIFT            9  
#define ARIZONA_IM_HP3L_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP3L_SC_POS_EINT2             0x0100  
#define ARIZONA_IM_HP3L_SC_POS_EINT2_MASK        0x0100  
#define ARIZONA_IM_HP3L_SC_POS_EINT2_SHIFT            8  
#define ARIZONA_IM_HP3L_SC_POS_EINT2_WIDTH            1  
#define ARIZONA_IM_HP2R_SC_NEG_EINT2             0x0080  
#define ARIZONA_IM_HP2R_SC_NEG_EINT2_MASK        0x0080  
#define ARIZONA_IM_HP2R_SC_NEG_EINT2_SHIFT            7  
#define ARIZONA_IM_HP2R_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP2R_SC_POS_EINT2             0x0040  
#define ARIZONA_IM_HP2R_SC_POS_EINT2_MASK        0x0040  
#define ARIZONA_IM_HP2R_SC_POS_EINT2_SHIFT            6  
#define ARIZONA_IM_HP2R_SC_POS_EINT2_WIDTH            1  
#define ARIZONA_IM_HP2L_SC_NEG_EINT2             0x0020  
#define ARIZONA_IM_HP2L_SC_NEG_EINT2_MASK        0x0020  
#define ARIZONA_IM_HP2L_SC_NEG_EINT2_SHIFT            5  
#define ARIZONA_IM_HP2L_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP2L_SC_POS_EINT2             0x0010  
#define ARIZONA_IM_HP2L_SC_POS_EINT2_MASK        0x0010  
#define ARIZONA_IM_HP2L_SC_POS_EINT2_SHIFT            4  
#define ARIZONA_IM_HP2L_SC_POS_EINT2_WIDTH            1  
#define ARIZONA_IM_HP1R_SC_NEG_EINT2             0x0008  
#define ARIZONA_IM_HP1R_SC_NEG_EINT2_MASK        0x0008  
#define ARIZONA_IM_HP1R_SC_NEG_EINT2_SHIFT            3  
#define ARIZONA_IM_HP1R_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP1R_SC_POS_EINT2             0x0004  
#define ARIZONA_IM_HP1R_SC_POS_EINT2_MASK        0x0004  
#define ARIZONA_IM_HP1R_SC_POS_EINT2_SHIFT            2  
#define ARIZONA_IM_HP1R_SC_POS_EINT2_WIDTH            1  
#define ARIZONA_IM_HP1L_SC_NEG_EINT2             0x0002  
#define ARIZONA_IM_HP1L_SC_NEG_EINT2_MASK        0x0002  
#define ARIZONA_IM_HP1L_SC_NEG_EINT2_SHIFT            1  
#define ARIZONA_IM_HP1L_SC_NEG_EINT2_WIDTH            1  
#define ARIZONA_IM_HP1L_SC_POS_EINT2             0x0001  
#define ARIZONA_IM_HP1L_SC_POS_EINT2_MASK        0x0001  
#define ARIZONA_IM_HP1L_SC_POS_EINT2_SHIFT            0  
#define ARIZONA_IM_HP1L_SC_POS_EINT2_WIDTH            1  


#define ARIZONA_IM_IRQ2                          0x0001  
#define ARIZONA_IM_IRQ2_MASK                     0x0001  
#define ARIZONA_IM_IRQ2_SHIFT                         0  
#define ARIZONA_IM_IRQ2_WIDTH                         1  


#define ARIZONA_DSP1_RAM_RDY_STS                 0x0100  
#define ARIZONA_DSP1_RAM_RDY_STS_MASK            0x0100  
#define ARIZONA_DSP1_RAM_RDY_STS_SHIFT                8  
#define ARIZONA_DSP1_RAM_RDY_STS_WIDTH                1  
#define ARIZONA_DSP_IRQ2_STS                     0x0002  
#define ARIZONA_DSP_IRQ2_STS_MASK                0x0002  
#define ARIZONA_DSP_IRQ2_STS_SHIFT                    1  
#define ARIZONA_DSP_IRQ2_STS_WIDTH                    1  
#define ARIZONA_DSP_IRQ1_STS                     0x0001  
#define ARIZONA_DSP_IRQ1_STS_MASK                0x0001  
#define ARIZONA_DSP_IRQ1_STS_SHIFT                    0  
#define ARIZONA_DSP_IRQ1_STS_WIDTH                    1  


#define ARIZONA_SPK_OVERHEAT_WARN_STS            0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_STS_MASK       0x8000  
#define ARIZONA_SPK_OVERHEAT_WARN_STS_SHIFT          15  
#define ARIZONA_SPK_OVERHEAT_WARN_STS_WIDTH           1  
#define ARIZONA_SPK_OVERHEAT_STS                 0x4000  
#define ARIZONA_SPK_OVERHEAT_STS_MASK            0x4000  
#define ARIZONA_SPK_OVERHEAT_STS_SHIFT               14  
#define ARIZONA_SPK_OVERHEAT_STS_WIDTH                1  
#define ARIZONA_HPDET_STS                        0x2000  
#define ARIZONA_HPDET_STS_MASK                   0x2000  
#define ARIZONA_HPDET_STS_SHIFT                      13  
#define ARIZONA_HPDET_STS_WIDTH                       1  
#define ARIZONA_MICDET_STS                       0x1000  
#define ARIZONA_MICDET_STS_MASK                  0x1000  
#define ARIZONA_MICDET_STS_SHIFT                     12  
#define ARIZONA_MICDET_STS_WIDTH                      1  
#define ARIZONA_WSEQ_DONE_STS                    0x0800  
#define ARIZONA_WSEQ_DONE_STS_MASK               0x0800  
#define ARIZONA_WSEQ_DONE_STS_SHIFT                  11  
#define ARIZONA_WSEQ_DONE_STS_WIDTH                   1  
#define ARIZONA_DRC2_SIG_DET_STS                 0x0400  
#define ARIZONA_DRC2_SIG_DET_STS_MASK            0x0400  
#define ARIZONA_DRC2_SIG_DET_STS_SHIFT               10  
#define ARIZONA_DRC2_SIG_DET_STS_WIDTH                1  
#define ARIZONA_DRC1_SIG_DET_STS                 0x0200  
#define ARIZONA_DRC1_SIG_DET_STS_MASK            0x0200  
#define ARIZONA_DRC1_SIG_DET_STS_SHIFT                9  
#define ARIZONA_DRC1_SIG_DET_STS_WIDTH                1  
#define ARIZONA_ASRC2_LOCK_STS                   0x0100  
#define ARIZONA_ASRC2_LOCK_STS_MASK              0x0100  
#define ARIZONA_ASRC2_LOCK_STS_SHIFT                  8  
#define ARIZONA_ASRC2_LOCK_STS_WIDTH                  1  
#define ARIZONA_ASRC1_LOCK_STS                   0x0080  
#define ARIZONA_ASRC1_LOCK_STS_MASK              0x0080  
#define ARIZONA_ASRC1_LOCK_STS_SHIFT                  7  
#define ARIZONA_ASRC1_LOCK_STS_WIDTH                  1  
#define ARIZONA_UNDERCLOCKED_STS                 0x0040  
#define ARIZONA_UNDERCLOCKED_STS_MASK            0x0040  
#define ARIZONA_UNDERCLOCKED_STS_SHIFT                6  
#define ARIZONA_UNDERCLOCKED_STS_WIDTH                1  
#define ARIZONA_OVERCLOCKED_STS                  0x0020  
#define ARIZONA_OVERCLOCKED_STS_MASK             0x0020  
#define ARIZONA_OVERCLOCKED_STS_SHIFT                 5  
#define ARIZONA_OVERCLOCKED_STS_WIDTH                 1  
#define ARIZONA_FLL2_LOCK_STS                    0x0008  
#define ARIZONA_FLL2_LOCK_STS_MASK               0x0008  
#define ARIZONA_FLL2_LOCK_STS_SHIFT                   3  
#define ARIZONA_FLL2_LOCK_STS_WIDTH                   1  
#define ARIZONA_FLL1_LOCK_STS                    0x0004  
#define ARIZONA_FLL1_LOCK_STS_MASK               0x0004  
#define ARIZONA_FLL1_LOCK_STS_SHIFT                   2  
#define ARIZONA_FLL1_LOCK_STS_WIDTH                   1  
#define ARIZONA_CLKGEN_ERR_STS                   0x0002  
#define ARIZONA_CLKGEN_ERR_STS_MASK              0x0002  
#define ARIZONA_CLKGEN_ERR_STS_SHIFT                  1  
#define ARIZONA_CLKGEN_ERR_STS_WIDTH                  1  
#define ARIZONA_CLKGEN_ERR_ASYNC_STS             0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_STS_MASK        0x0001  
#define ARIZONA_CLKGEN_ERR_ASYNC_STS_SHIFT            0  
#define ARIZONA_CLKGEN_ERR_ASYNC_STS_WIDTH            1  


#define ARIZONA_ASRC_CFG_ERR_STS                 0x8000  
#define ARIZONA_ASRC_CFG_ERR_STS_MASK            0x8000  
#define ARIZONA_ASRC_CFG_ERR_STS_SHIFT               15  
#define ARIZONA_ASRC_CFG_ERR_STS_WIDTH                1  
#define ARIZONA_AIF3_ERR_STS                     0x4000  
#define ARIZONA_AIF3_ERR_STS_MASK                0x4000  
#define ARIZONA_AIF3_ERR_STS_SHIFT                   14  
#define ARIZONA_AIF3_ERR_STS_WIDTH                    1  
#define ARIZONA_AIF2_ERR_STS                     0x2000  
#define ARIZONA_AIF2_ERR_STS_MASK                0x2000  
#define ARIZONA_AIF2_ERR_STS_SHIFT                   13  
#define ARIZONA_AIF2_ERR_STS_WIDTH                    1  
#define ARIZONA_AIF1_ERR_STS                     0x1000  
#define ARIZONA_AIF1_ERR_STS_MASK                0x1000  
#define ARIZONA_AIF1_ERR_STS_SHIFT                   12  
#define ARIZONA_AIF1_ERR_STS_WIDTH                    1  
#define ARIZONA_CTRLIF_ERR_STS                   0x0800  
#define ARIZONA_CTRLIF_ERR_STS_MASK              0x0800  
#define ARIZONA_CTRLIF_ERR_STS_SHIFT                 11  
#define ARIZONA_CTRLIF_ERR_STS_WIDTH                  1  
#define ARIZONA_MIXER_DROPPED_SAMPLE_STS         0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_STS_MASK    0x0400  
#define ARIZONA_MIXER_DROPPED_SAMPLE_STS_SHIFT       10  
#define ARIZONA_MIXER_DROPPED_SAMPLE_STS_WIDTH        1  
#define ARIZONA_ASYNC_CLK_ENA_LOW_STS            0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_STS_MASK       0x0200  
#define ARIZONA_ASYNC_CLK_ENA_LOW_STS_SHIFT           9  
#define ARIZONA_ASYNC_CLK_ENA_LOW_STS_WIDTH           1  
#define ARIZONA_SYSCLK_ENA_LOW_STS               0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_STS_MASK          0x0100  
#define ARIZONA_SYSCLK_ENA_LOW_STS_SHIFT              8  
#define ARIZONA_SYSCLK_ENA_LOW_STS_WIDTH              1  
#define ARIZONA_ISRC1_CFG_ERR_STS                0x0080  
#define ARIZONA_ISRC1_CFG_ERR_STS_MASK           0x0080  
#define ARIZONA_ISRC1_CFG_ERR_STS_SHIFT               7  
#define ARIZONA_ISRC1_CFG_ERR_STS_WIDTH               1  
#define ARIZONA_ISRC2_CFG_ERR_STS                0x0040  
#define ARIZONA_ISRC2_CFG_ERR_STS_MASK           0x0040  
#define ARIZONA_ISRC2_CFG_ERR_STS_SHIFT               6  
#define ARIZONA_ISRC2_CFG_ERR_STS_WIDTH               1  
#define ARIZONA_HP3R_DONE_STS                    0x0020  
#define ARIZONA_HP3R_DONE_STS_MASK               0x0020  
#define ARIZONA_HP3R_DONE_STS_SHIFT                   5  
#define ARIZONA_HP3R_DONE_STS_WIDTH                   1  
#define ARIZONA_HP3L_DONE_STS                    0x0010  
#define ARIZONA_HP3L_DONE_STS_MASK               0x0010  
#define ARIZONA_HP3L_DONE_STS_SHIFT                   4  
#define ARIZONA_HP3L_DONE_STS_WIDTH                   1  
#define ARIZONA_HP2R_DONE_STS                    0x0008  
#define ARIZONA_HP2R_DONE_STS_MASK               0x0008  
#define ARIZONA_HP2R_DONE_STS_SHIFT                   3  
#define ARIZONA_HP2R_DONE_STS_WIDTH                   1  
#define ARIZONA_HP2L_DONE_STS                    0x0004  
#define ARIZONA_HP2L_DONE_STS_MASK               0x0004  
#define ARIZONA_HP2L_DONE_STS_SHIFT                   2  
#define ARIZONA_HP2L_DONE_STS_WIDTH                   1  
#define ARIZONA_HP1R_DONE_STS                    0x0002  
#define ARIZONA_HP1R_DONE_STS_MASK               0x0002  
#define ARIZONA_HP1R_DONE_STS_SHIFT                   1  
#define ARIZONA_HP1R_DONE_STS_WIDTH                   1  
#define ARIZONA_HP1L_DONE_STS                    0x0001  
#define ARIZONA_HP1L_DONE_STS_MASK               0x0001  
#define ARIZONA_HP1L_DONE_STS_SHIFT                   0  
#define ARIZONA_HP1L_DONE_STS_WIDTH                   1  


#define ARIZONA_BOOT_DONE_STS                    0x0100  
#define ARIZONA_BOOT_DONE_STS_MASK               0x0100  
#define ARIZONA_BOOT_DONE_STS_SHIFT                   8  
#define ARIZONA_BOOT_DONE_STS_WIDTH                   1  
#define ARIZONA_DCS_DAC_DONE_STS                 0x0080  
#define ARIZONA_DCS_DAC_DONE_STS_MASK            0x0080  
#define ARIZONA_DCS_DAC_DONE_STS_SHIFT                7  
#define ARIZONA_DCS_DAC_DONE_STS_WIDTH                1  
#define ARIZONA_DCS_HP_DONE_STS                  0x0040  
#define ARIZONA_DCS_HP_DONE_STS_MASK             0x0040  
#define ARIZONA_DCS_HP_DONE_STS_SHIFT                 6  
#define ARIZONA_DCS_HP_DONE_STS_WIDTH                 1  
#define ARIZONA_FLL2_CLOCK_OK_STS                0x0002  
#define ARIZONA_FLL2_CLOCK_OK_STS_MASK           0x0002  
#define ARIZONA_FLL2_CLOCK_OK_STS_SHIFT               1  
#define ARIZONA_FLL2_CLOCK_OK_STS_WIDTH               1  
#define ARIZONA_FLL1_CLOCK_OK_STS                0x0001  
#define ARIZONA_FLL1_CLOCK_OK_STS_MASK           0x0001  
#define ARIZONA_FLL1_CLOCK_OK_STS_SHIFT               0  
#define ARIZONA_FLL1_CLOCK_OK_STS_WIDTH               1  


#define ARIZONA_PWM_OVERCLOCKED_STS              0x2000  
#define ARIZONA_PWM_OVERCLOCKED_STS_MASK         0x2000  
#define ARIZONA_PWM_OVERCLOCKED_STS_SHIFT            13  
#define ARIZONA_PWM_OVERCLOCKED_STS_WIDTH             1  
#define ARIZONA_FX_CORE_OVERCLOCKED_STS          0x1000  
#define ARIZONA_FX_CORE_OVERCLOCKED_STS_MASK     0x1000  
#define ARIZONA_FX_CORE_OVERCLOCKED_STS_SHIFT        12  
#define ARIZONA_FX_CORE_OVERCLOCKED_STS_WIDTH         1  
#define ARIZONA_DAC_SYS_OVERCLOCKED_STS          0x0400  
#define ARIZONA_DAC_SYS_OVERCLOCKED_STS_MASK     0x0400  
#define ARIZONA_DAC_SYS_OVERCLOCKED_STS_SHIFT        10  
#define ARIZONA_DAC_SYS_OVERCLOCKED_STS_WIDTH         1  
#define ARIZONA_DAC_WARP_OVERCLOCKED_STS         0x0200  
#define ARIZONA_DAC_WARP_OVERCLOCKED_STS_MASK    0x0200  
#define ARIZONA_DAC_WARP_OVERCLOCKED_STS_SHIFT        9  
#define ARIZONA_DAC_WARP_OVERCLOCKED_STS_WIDTH        1  
#define ARIZONA_ADC_OVERCLOCKED_STS              0x0100  
#define ARIZONA_ADC_OVERCLOCKED_STS_MASK         0x0100  
#define ARIZONA_ADC_OVERCLOCKED_STS_SHIFT             8  
#define ARIZONA_ADC_OVERCLOCKED_STS_WIDTH             1  
#define ARIZONA_MIXER_OVERCLOCKED_STS            0x0080  
#define ARIZONA_MIXER_OVERCLOCKED_STS_MASK       0x0080  
#define ARIZONA_MIXER_OVERCLOCKED_STS_SHIFT           7  
#define ARIZONA_MIXER_OVERCLOCKED_STS_WIDTH           1  
#define ARIZONA_AIF3_ASYNC_OVERCLOCKED_STS       0x0040  
#define ARIZONA_AIF3_ASYNC_OVERCLOCKED_STS_MASK  0x0040  
#define ARIZONA_AIF3_ASYNC_OVERCLOCKED_STS_SHIFT      6  
#define ARIZONA_AIF3_ASYNC_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_AIF2_ASYNC_OVERCLOCKED_STS       0x0020  
#define ARIZONA_AIF2_ASYNC_OVERCLOCKED_STS_MASK  0x0020  
#define ARIZONA_AIF2_ASYNC_OVERCLOCKED_STS_SHIFT      5  
#define ARIZONA_AIF2_ASYNC_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_AIF1_ASYNC_OVERCLOCKED_STS       0x0010  
#define ARIZONA_AIF1_ASYNC_OVERCLOCKED_STS_MASK  0x0010  
#define ARIZONA_AIF1_ASYNC_OVERCLOCKED_STS_SHIFT      4  
#define ARIZONA_AIF1_ASYNC_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_AIF3_SYNC_OVERCLOCKED_STS        0x0008  
#define ARIZONA_AIF3_SYNC_OVERCLOCKED_STS_MASK   0x0008  
#define ARIZONA_AIF3_SYNC_OVERCLOCKED_STS_SHIFT       3  
#define ARIZONA_AIF3_SYNC_OVERCLOCKED_STS_WIDTH       1  
#define ARIZONA_AIF2_SYNC_OVERCLOCKED_STS        0x0004  
#define ARIZONA_AIF2_SYNC_OVERCLOCKED_STS_MASK   0x0004  
#define ARIZONA_AIF2_SYNC_OVERCLOCKED_STS_SHIFT       2  
#define ARIZONA_AIF2_SYNC_OVERCLOCKED_STS_WIDTH       1  
#define ARIZONA_AIF1_SYNC_OVERCLOCKED_STS        0x0002  
#define ARIZONA_AIF1_SYNC_OVERCLOCKED_STS_MASK   0x0002  
#define ARIZONA_AIF1_SYNC_OVERCLOCKED_STS_SHIFT       1  
#define ARIZONA_AIF1_SYNC_OVERCLOCKED_STS_WIDTH       1  
#define ARIZONA_PAD_CTRL_OVERCLOCKED_STS         0x0001  
#define ARIZONA_PAD_CTRL_OVERCLOCKED_STS_MASK    0x0001  
#define ARIZONA_PAD_CTRL_OVERCLOCKED_STS_SHIFT        0  
#define ARIZONA_PAD_CTRL_OVERCLOCKED_STS_WIDTH        1  


#define ARIZONA_SLIMBUS_SUBSYS_OVERCLOCKED_STS   0x8000  
#define ARIZONA_SLIMBUS_SUBSYS_OVERCLOCKED_STS_MASK 0x8000  
#define ARIZONA_SLIMBUS_SUBSYS_OVERCLOCKED_STS_SHIFT     15  
#define ARIZONA_SLIMBUS_SUBSYS_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_SLIMBUS_ASYNC_OVERCLOCKED_STS    0x4000  
#define ARIZONA_SLIMBUS_ASYNC_OVERCLOCKED_STS_MASK 0x4000  
#define ARIZONA_SLIMBUS_ASYNC_OVERCLOCKED_STS_SHIFT     14  
#define ARIZONA_SLIMBUS_ASYNC_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_SLIMBUS_SYNC_OVERCLOCKED_STS     0x2000  
#define ARIZONA_SLIMBUS_SYNC_OVERCLOCKED_STS_MASK 0x2000  
#define ARIZONA_SLIMBUS_SYNC_OVERCLOCKED_STS_SHIFT     13  
#define ARIZONA_SLIMBUS_SYNC_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_ASRC_ASYNC_SYS_OVERCLOCKED_STS   0x1000  
#define ARIZONA_ASRC_ASYNC_SYS_OVERCLOCKED_STS_MASK 0x1000  
#define ARIZONA_ASRC_ASYNC_SYS_OVERCLOCKED_STS_SHIFT     12  
#define ARIZONA_ASRC_ASYNC_SYS_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_ASRC_ASYNC_WARP_OVERCLOCKED_STS  0x0800  
#define ARIZONA_ASRC_ASYNC_WARP_OVERCLOCKED_STS_MASK 0x0800  
#define ARIZONA_ASRC_ASYNC_WARP_OVERCLOCKED_STS_SHIFT     11  
#define ARIZONA_ASRC_ASYNC_WARP_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_ASRC_SYNC_SYS_OVERCLOCKED_STS    0x0400  
#define ARIZONA_ASRC_SYNC_SYS_OVERCLOCKED_STS_MASK 0x0400  
#define ARIZONA_ASRC_SYNC_SYS_OVERCLOCKED_STS_SHIFT     10  
#define ARIZONA_ASRC_SYNC_SYS_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_ASRC_SYNC_WARP_OVERCLOCKED_STS   0x0200  
#define ARIZONA_ASRC_SYNC_WARP_OVERCLOCKED_STS_MASK 0x0200  
#define ARIZONA_ASRC_SYNC_WARP_OVERCLOCKED_STS_SHIFT      9  
#define ARIZONA_ASRC_SYNC_WARP_OVERCLOCKED_STS_WIDTH      1  
#define ARIZONA_ADSP2_1_OVERCLOCKED_STS          0x0008  
#define ARIZONA_ADSP2_1_OVERCLOCKED_STS_MASK     0x0008  
#define ARIZONA_ADSP2_1_OVERCLOCKED_STS_SHIFT         3  
#define ARIZONA_ADSP2_1_OVERCLOCKED_STS_WIDTH         1  
#define ARIZONA_ISRC3_OVERCLOCKED_STS            0x0004  
#define ARIZONA_ISRC3_OVERCLOCKED_STS_MASK       0x0004  
#define ARIZONA_ISRC3_OVERCLOCKED_STS_SHIFT           2  
#define ARIZONA_ISRC3_OVERCLOCKED_STS_WIDTH           1  
#define ARIZONA_ISRC2_OVERCLOCKED_STS            0x0002  
#define ARIZONA_ISRC2_OVERCLOCKED_STS_MASK       0x0002  
#define ARIZONA_ISRC2_OVERCLOCKED_STS_SHIFT           1  
#define ARIZONA_ISRC2_OVERCLOCKED_STS_WIDTH           1  
#define ARIZONA_ISRC1_OVERCLOCKED_STS            0x0001  
#define ARIZONA_ISRC1_OVERCLOCKED_STS_MASK       0x0001  
#define ARIZONA_ISRC1_OVERCLOCKED_STS_SHIFT           0  
#define ARIZONA_ISRC1_OVERCLOCKED_STS_WIDTH           1  


#define ARIZONA_SPDIF_OVERCLOCKED_STS            0x8000  
#define ARIZONA_SPDIF_OVERCLOCKED_STS_MASK       0x8000  
#define ARIZONA_SPDIF_OVERCLOCKED_STS_SHIFT          15  
#define ARIZONA_SPDIF_OVERCLOCKED_STS_WIDTH           1  
#define ARIZONA_AIF3_UNDERCLOCKED_STS            0x0400  
#define ARIZONA_AIF3_UNDERCLOCKED_STS_MASK       0x0400  
#define ARIZONA_AIF3_UNDERCLOCKED_STS_SHIFT          10  
#define ARIZONA_AIF3_UNDERCLOCKED_STS_WIDTH           1  
#define ARIZONA_AIF2_UNDERCLOCKED_STS            0x0200  
#define ARIZONA_AIF2_UNDERCLOCKED_STS_MASK       0x0200  
#define ARIZONA_AIF2_UNDERCLOCKED_STS_SHIFT           9  
#define ARIZONA_AIF2_UNDERCLOCKED_STS_WIDTH           1  
#define ARIZONA_AIF1_UNDERCLOCKED_STS            0x0100  
#define ARIZONA_AIF1_UNDERCLOCKED_STS_MASK       0x0100  
#define ARIZONA_AIF1_UNDERCLOCKED_STS_SHIFT           8  
#define ARIZONA_AIF1_UNDERCLOCKED_STS_WIDTH           1  
#define ARIZONA_ISRC3_UNDERCLOCKED_STS           0x0080  
#define ARIZONA_ISRC3_UNDERCLOCKED_STS_MASK      0x0080  
#define ARIZONA_ISRC3_UNDERCLOCKED_STS_SHIFT          7  
#define ARIZONA_ISRC3_UNDERCLOCKED_STS_WIDTH          1  
#define ARIZONA_ISRC2_UNDERCLOCKED_STS           0x0040  
#define ARIZONA_ISRC2_UNDERCLOCKED_STS_MASK      0x0040  
#define ARIZONA_ISRC2_UNDERCLOCKED_STS_SHIFT          6  
#define ARIZONA_ISRC2_UNDERCLOCKED_STS_WIDTH          1  
#define ARIZONA_ISRC1_UNDERCLOCKED_STS           0x0020  
#define ARIZONA_ISRC1_UNDERCLOCKED_STS_MASK      0x0020  
#define ARIZONA_ISRC1_UNDERCLOCKED_STS_SHIFT          5  
#define ARIZONA_ISRC1_UNDERCLOCKED_STS_WIDTH          1  
#define ARIZONA_FX_UNDERCLOCKED_STS              0x0010  
#define ARIZONA_FX_UNDERCLOCKED_STS_MASK         0x0010  
#define ARIZONA_FX_UNDERCLOCKED_STS_SHIFT             4  
#define ARIZONA_FX_UNDERCLOCKED_STS_WIDTH             1  
#define ARIZONA_ASRC_UNDERCLOCKED_STS            0x0008  
#define ARIZONA_ASRC_UNDERCLOCKED_STS_MASK       0x0008  
#define ARIZONA_ASRC_UNDERCLOCKED_STS_SHIFT           3  
#define ARIZONA_ASRC_UNDERCLOCKED_STS_WIDTH           1  
#define ARIZONA_DAC_UNDERCLOCKED_STS             0x0004  
#define ARIZONA_DAC_UNDERCLOCKED_STS_MASK        0x0004  
#define ARIZONA_DAC_UNDERCLOCKED_STS_SHIFT            2  
#define ARIZONA_DAC_UNDERCLOCKED_STS_WIDTH            1  
#define ARIZONA_ADC_UNDERCLOCKED_STS             0x0002  
#define ARIZONA_ADC_UNDERCLOCKED_STS_MASK        0x0002  
#define ARIZONA_ADC_UNDERCLOCKED_STS_SHIFT            1  
#define ARIZONA_ADC_UNDERCLOCKED_STS_WIDTH            1  
#define ARIZONA_MIXER_UNDERCLOCKED_STS           0x0001  
#define ARIZONA_MIXER_UNDERCLOCKED_STS_MASK      0x0001  
#define ARIZONA_MIXER_UNDERCLOCKED_STS_SHIFT          0  
#define ARIZONA_MIXER_UNDERCLOCKED_STS_WIDTH          1  


#define ARIZONA_DSP_SHARED_WR_COLL_STS           0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_STS_MASK      0x8000  
#define ARIZONA_DSP_SHARED_WR_COLL_STS_SHIFT         15  
#define ARIZONA_DSP_SHARED_WR_COLL_STS_WIDTH          1  
#define ARIZONA_SPK_SHUTDOWN_STS                 0x4000  
#define ARIZONA_SPK_SHUTDOWN_STS_MASK            0x4000  
#define ARIZONA_SPK_SHUTDOWN_STS_SHIFT               14  
#define ARIZONA_SPK_SHUTDOWN_STS_WIDTH                1  
#define ARIZONA_SPK1R_SHORT_STS                  0x2000  
#define ARIZONA_SPK1R_SHORT_STS_MASK             0x2000  
#define ARIZONA_SPK1R_SHORT_STS_SHIFT                13  
#define ARIZONA_SPK1R_SHORT_STS_WIDTH                 1  
#define ARIZONA_SPK1L_SHORT_STS                  0x1000  
#define ARIZONA_SPK1L_SHORT_STS_MASK             0x1000  
#define ARIZONA_SPK1L_SHORT_STS_SHIFT                12  
#define ARIZONA_SPK1L_SHORT_STS_WIDTH                 1  
#define ARIZONA_HP3R_SC_NEG_STS                  0x0800  
#define ARIZONA_HP3R_SC_NEG_STS_MASK             0x0800  
#define ARIZONA_HP3R_SC_NEG_STS_SHIFT                11  
#define ARIZONA_HP3R_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP3R_SC_POS_STS                  0x0400  
#define ARIZONA_HP3R_SC_POS_STS_MASK             0x0400  
#define ARIZONA_HP3R_SC_POS_STS_SHIFT                10  
#define ARIZONA_HP3R_SC_POS_STS_WIDTH                 1  
#define ARIZONA_HP3L_SC_NEG_STS                  0x0200  
#define ARIZONA_HP3L_SC_NEG_STS_MASK             0x0200  
#define ARIZONA_HP3L_SC_NEG_STS_SHIFT                 9  
#define ARIZONA_HP3L_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP3L_SC_POS_STS                  0x0100  
#define ARIZONA_HP3L_SC_POS_STS_MASK             0x0100  
#define ARIZONA_HP3L_SC_POS_STS_SHIFT                 8  
#define ARIZONA_HP3L_SC_POS_STS_WIDTH                 1  
#define ARIZONA_HP2R_SC_NEG_STS                  0x0080  
#define ARIZONA_HP2R_SC_NEG_STS_MASK             0x0080  
#define ARIZONA_HP2R_SC_NEG_STS_SHIFT                 7  
#define ARIZONA_HP2R_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP2R_SC_POS_STS                  0x0040  
#define ARIZONA_HP2R_SC_POS_STS_MASK             0x0040  
#define ARIZONA_HP2R_SC_POS_STS_SHIFT                 6  
#define ARIZONA_HP2R_SC_POS_STS_WIDTH                 1  
#define ARIZONA_HP2L_SC_NEG_STS                  0x0020  
#define ARIZONA_HP2L_SC_NEG_STS_MASK             0x0020  
#define ARIZONA_HP2L_SC_NEG_STS_SHIFT                 5  
#define ARIZONA_HP2L_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP2L_SC_POS_STS                  0x0010  
#define ARIZONA_HP2L_SC_POS_STS_MASK             0x0010  
#define ARIZONA_HP2L_SC_POS_STS_SHIFT                 4  
#define ARIZONA_HP2L_SC_POS_STS_WIDTH                 1  
#define ARIZONA_HP1R_SC_NEG_STS                  0x0008  
#define ARIZONA_HP1R_SC_NEG_STS_MASK             0x0008  
#define ARIZONA_HP1R_SC_NEG_STS_SHIFT                 3  
#define ARIZONA_HP1R_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP1R_SC_POS_STS                  0x0004  
#define ARIZONA_HP1R_SC_POS_STS_MASK             0x0004  
#define ARIZONA_HP1R_SC_POS_STS_SHIFT                 2  
#define ARIZONA_HP1R_SC_POS_STS_WIDTH                 1  
#define ARIZONA_HP1L_SC_NEG_STS                  0x0002  
#define ARIZONA_HP1L_SC_NEG_STS_MASK             0x0002  
#define ARIZONA_HP1L_SC_NEG_STS_SHIFT                 1  
#define ARIZONA_HP1L_SC_NEG_STS_WIDTH                 1  
#define ARIZONA_HP1L_SC_POS_STS                  0x0001  
#define ARIZONA_HP1L_SC_POS_STS_MASK             0x0001  
#define ARIZONA_HP1L_SC_POS_STS_SHIFT                 0  
#define ARIZONA_HP1L_SC_POS_STS_WIDTH                 1  


#define ARIZONA_IRQ2_STS                         0x0002  
#define ARIZONA_IRQ2_STS_MASK                    0x0002  
#define ARIZONA_IRQ2_STS_SHIFT                        1  
#define ARIZONA_IRQ2_STS_WIDTH                        1  
#define ARIZONA_IRQ1_STS                         0x0001  
#define ARIZONA_IRQ1_STS_MASK                    0x0001  
#define ARIZONA_IRQ1_STS_SHIFT                        0  
#define ARIZONA_IRQ1_STS_WIDTH                        1  


#define ARIZONA_DSP_IRQ2                         0x0002  
#define ARIZONA_DSP_IRQ2_MASK                    0x0002  
#define ARIZONA_DSP_IRQ2_SHIFT                        1  
#define ARIZONA_DSP_IRQ2_WIDTH                        1  
#define ARIZONA_DSP_IRQ1                         0x0001  
#define ARIZONA_DSP_IRQ1_MASK                    0x0001  
#define ARIZONA_DSP_IRQ1_SHIFT                        0  
#define ARIZONA_DSP_IRQ1_WIDTH                        1  


#define ARIZONA_MICD_CLAMP_FALL_TRIG_STS         0x0080  
#define ARIZONA_MICD_CLAMP_FALL_TRIG_STS_MASK    0x0080  
#define ARIZONA_MICD_CLAMP_FALL_TRIG_STS_SHIFT        7  
#define ARIZONA_MICD_CLAMP_FALL_TRIG_STS_WIDTH        1  
#define ARIZONA_MICD_CLAMP_RISE_TRIG_STS         0x0040  
#define ARIZONA_MICD_CLAMP_RISE_TRIG_STS_MASK    0x0040  
#define ARIZONA_MICD_CLAMP_RISE_TRIG_STS_SHIFT        6  
#define ARIZONA_MICD_CLAMP_RISE_TRIG_STS_WIDTH        1  
#define ARIZONA_GP5_FALL_TRIG_STS                0x0020  
#define ARIZONA_GP5_FALL_TRIG_STS_MASK           0x0020  
#define ARIZONA_GP5_FALL_TRIG_STS_SHIFT               5  
#define ARIZONA_GP5_FALL_TRIG_STS_WIDTH               1  
#define ARIZONA_GP5_RISE_TRIG_STS                0x0010  
#define ARIZONA_GP5_RISE_TRIG_STS_MASK           0x0010  
#define ARIZONA_GP5_RISE_TRIG_STS_SHIFT               4  
#define ARIZONA_GP5_RISE_TRIG_STS_WIDTH               1  
#define ARIZONA_JD1_FALL_TRIG_STS                0x0008  
#define ARIZONA_JD1_FALL_TRIG_STS_MASK           0x0008  
#define ARIZONA_JD1_FALL_TRIG_STS_SHIFT               3  
#define ARIZONA_JD1_FALL_TRIG_STS_WIDTH               1  
#define ARIZONA_JD1_RISE_TRIG_STS                0x0004  
#define ARIZONA_JD1_RISE_TRIG_STS_MASK           0x0004  
#define ARIZONA_JD1_RISE_TRIG_STS_SHIFT               2  
#define ARIZONA_JD1_RISE_TRIG_STS_WIDTH               1  
#define ARIZONA_JD2_FALL_TRIG_STS                0x0002  
#define ARIZONA_JD2_FALL_TRIG_STS_MASK           0x0002  
#define ARIZONA_JD2_FALL_TRIG_STS_SHIFT               1  
#define ARIZONA_JD2_FALL_TRIG_STS_WIDTH               1  
#define ARIZONA_JD2_RISE_TRIG_STS                0x0001  
#define ARIZONA_JD2_RISE_TRIG_STS_MASK           0x0001  
#define ARIZONA_JD2_RISE_TRIG_STS_SHIFT               0  
#define ARIZONA_JD2_RISE_TRIG_STS_WIDTH               1  


#define ARIZONA_MICD_CLAMP_FALL_EINT1            0x0080  
#define ARIZONA_MICD_CLAMP_FALL_EINT1_MASK       0x0080  
#define ARIZONA_MICD_CLAMP_FALL_EINT1_SHIFT           7  
#define ARIZONA_MICD_CLAMP_RISE_EINT1            0x0040  
#define ARIZONA_MICD_CLAMP_RISE_EINT1_MASK       0x0040  
#define ARIZONA_MICD_CLAMP_RISE_EINT1_SHIFT           6  
#define ARIZONA_GP5_FALL_EINT1                   0x0020  
#define ARIZONA_GP5_FALL_EINT1_MASK              0x0020  
#define ARIZONA_GP5_FALL_EINT1_SHIFT                  5  
#define ARIZONA_GP5_FALL_EINT1_WIDTH                  1  
#define ARIZONA_GP5_RISE_EINT1                   0x0010  
#define ARIZONA_GP5_RISE_EINT1_MASK              0x0010  
#define ARIZONA_GP5_RISE_EINT1_SHIFT                  4  
#define ARIZONA_GP5_RISE_EINT1_WIDTH                  1  
#define ARIZONA_JD1_FALL_EINT1                   0x0008  
#define ARIZONA_JD1_FALL_EINT1_MASK              0x0008  
#define ARIZONA_JD1_FALL_EINT1_SHIFT                  3  
#define ARIZONA_JD1_FALL_EINT1_WIDTH                  1  
#define ARIZONA_JD1_RISE_EINT1                   0x0004  
#define ARIZONA_JD1_RISE_EINT1_MASK              0x0004  
#define ARIZONA_JD1_RISE_EINT1_SHIFT                  2  
#define ARIZONA_JD1_RISE_EINT1_WIDTH                  1  
#define ARIZONA_JD2_FALL_EINT1                   0x0002  
#define ARIZONA_JD2_FALL_EINT1_MASK              0x0002  
#define ARIZONA_JD2_FALL_EINT1_SHIFT                  1  
#define ARIZONA_JD2_FALL_EINT1_WIDTH                  1  
#define ARIZONA_JD2_RISE_EINT1                   0x0001  
#define ARIZONA_JD2_RISE_EINT1_MASK              0x0001  
#define ARIZONA_JD2_RISE_EINT1_SHIFT                  0  
#define ARIZONA_JD2_RISE_EINT1_WIDTH                  1  


#define ARIZONA_MICD_CLAMP_FALL_EINT2            0x0080  
#define ARIZONA_MICD_CLAMP_FALL_EINT2_MASK       0x0080  
#define ARIZONA_MICD_CLAMP_FALL_EINT2_SHIFT           7  
#define ARIZONA_MICD_CLAMP_RISE_EINT2            0x0040  
#define ARIZONA_MICD_CLAMP_RISE_EINT2_MASK       0x0040  
#define ARIZONA_MICD_CLAMP_RISE_EINT2_SHIFT           6  
#define ARIZONA_GP5_FALL_EINT2                   0x0020  
#define ARIZONA_GP5_FALL_EINT2_MASK              0x0020  
#define ARIZONA_GP5_FALL_EINT2_SHIFT                  5  
#define ARIZONA_GP5_FALL_EINT2_WIDTH                  1  
#define ARIZONA_GP5_RISE_EINT2                   0x0010  
#define ARIZONA_GP5_RISE_EINT2_MASK              0x0010  
#define ARIZONA_GP5_RISE_EINT2_SHIFT                  4  
#define ARIZONA_GP5_RISE_EINT2_WIDTH                  1  
#define ARIZONA_JD1_FALL_EINT2                   0x0008  
#define ARIZONA_JD1_FALL_EINT2_MASK              0x0008  
#define ARIZONA_JD1_FALL_EINT2_SHIFT                  3  
#define ARIZONA_JD1_FALL_EINT2_WIDTH                  1  
#define ARIZONA_JD1_RISE_EINT2                   0x0004  
#define ARIZONA_JD1_RISE_EINT2_MASK              0x0004  
#define ARIZONA_JD1_RISE_EINT2_SHIFT                  2  
#define ARIZONA_JD1_RISE_EINT2_WIDTH                  1  
#define ARIZONA_JD2_FALL_EINT2                   0x0002  
#define ARIZONA_JD2_FALL_EINT2_MASK              0x0002  
#define ARIZONA_JD2_FALL_EINT2_SHIFT                  1  
#define ARIZONA_JD2_FALL_EINT2_WIDTH                  1  
#define ARIZONA_JD2_RISE_EINT2                   0x0001  
#define ARIZONA_JD2_RISE_EINT2_MASK              0x0001  
#define ARIZONA_JD2_RISE_EINT2_SHIFT                  0  
#define ARIZONA_JD2_RISE_EINT2_WIDTH                  1  


#define ARIZONA_IM_GP5_FALL_EINT1                0x0020  
#define ARIZONA_IM_GP5_FALL_EINT1_MASK           0x0020  
#define ARIZONA_IM_GP5_FALL_EINT1_SHIFT               5  
#define ARIZONA_IM_GP5_FALL_EINT1_WIDTH               1  
#define ARIZONA_IM_GP5_RISE_EINT1                0x0010  
#define ARIZONA_IM_GP5_RISE_EINT1_MASK           0x0010  
#define ARIZONA_IM_GP5_RISE_EINT1_SHIFT               4  
#define ARIZONA_IM_GP5_RISE_EINT1_WIDTH               1  
#define ARIZONA_IM_JD1_FALL_EINT1                0x0008  
#define ARIZONA_IM_JD1_FALL_EINT1_MASK           0x0008  
#define ARIZONA_IM_JD1_FALL_EINT1_SHIFT               3  
#define ARIZONA_IM_JD1_FALL_EINT1_WIDTH               1  
#define ARIZONA_IM_JD1_RISE_EINT1                0x0004  
#define ARIZONA_IM_JD1_RISE_EINT1_MASK           0x0004  
#define ARIZONA_IM_JD1_RISE_EINT1_SHIFT               2  
#define ARIZONA_IM_JD1_RISE_EINT1_WIDTH               1  
#define ARIZONA_IM_JD2_FALL_EINT1                0x0002  
#define ARIZONA_IM_JD2_FALL_EINT1_MASK           0x0002  
#define ARIZONA_IM_JD2_FALL_EINT1_SHIFT               1  
#define ARIZONA_IM_JD2_FALL_EINT1_WIDTH               1  
#define ARIZONA_IM_JD2_RISE_EINT1                0x0001  
#define ARIZONA_IM_JD2_RISE_EINT1_MASK           0x0001  
#define ARIZONA_IM_JD2_RISE_EINT1_SHIFT               0  
#define ARIZONA_IM_JD2_RISE_EINT1_WIDTH               1  


#define ARIZONA_IM_GP5_FALL_EINT2                0x0020  
#define ARIZONA_IM_GP5_FALL_EINT2_MASK           0x0020  
#define ARIZONA_IM_GP5_FALL_EINT2_SHIFT               5  
#define ARIZONA_IM_GP5_FALL_EINT2_WIDTH               1  
#define ARIZONA_IM_GP5_RISE_EINT2                0x0010  
#define ARIZONA_IM_GP5_RISE_EINT2_MASK           0x0010  
#define ARIZONA_IM_GP5_RISE_EINT2_SHIFT               4  
#define ARIZONA_IM_GP5_RISE_EINT2_WIDTH               1  
#define ARIZONA_IM_JD1_FALL_EINT2                0x0008  
#define ARIZONA_IM_JD1_FALL_EINT2_MASK           0x0008  
#define ARIZONA_IM_JD1_FALL_EINT2_SHIFT               3  
#define ARIZONA_IM_JD1_FALL_EINT2_WIDTH               1  
#define ARIZONA_IM_JD1_RISE_EINT2                0x0004  
#define ARIZONA_IM_JD1_RISE_EINT2_MASK           0x0004  
#define ARIZONA_IM_JD1_RISE_EINT2_SHIFT               2  
#define ARIZONA_IM_JD1_RISE_EINT2_WIDTH               1  
#define ARIZONA_IM_JD2_FALL_EINT2                0x0002  
#define ARIZONA_IM_JD2_FALL_EINT2_MASK           0x0002  
#define ARIZONA_IM_JD2_FALL_EINT2_SHIFT               1  
#define ARIZONA_IM_JD2_FALL_EINT2_WIDTH               1  
#define ARIZONA_IM_JD2_RISE_EINT2                0x0001  
#define ARIZONA_IM_JD2_RISE_EINT2_MASK           0x0001  
#define ARIZONA_IM_JD2_RISE_EINT2_SHIFT               0  
#define ARIZONA_IM_JD2_RISE_EINT2_WIDTH               1  


#define ARIZONA_MICD_CLAMP_STS                   0x0008  
#define ARIZONA_MICD_CLAMP_STS_MASK              0x0008  
#define ARIZONA_MICD_CLAMP_STS_SHIFT                  3  
#define ARIZONA_MICD_CLAMP_STS_WIDTH                  1  
#define ARIZONA_GP5_STS                          0x0004  
#define ARIZONA_GP5_STS_MASK                     0x0004  
#define ARIZONA_GP5_STS_SHIFT                         2  
#define ARIZONA_GP5_STS_WIDTH                         1  
#define ARIZONA_JD2_STS                          0x0002  
#define ARIZONA_JD2_STS_MASK                     0x0002  
#define ARIZONA_JD2_STS_SHIFT                         1  
#define ARIZONA_JD2_STS_WIDTH                         1  
#define ARIZONA_JD1_STS                          0x0001  
#define ARIZONA_JD1_STS_MASK                     0x0001  
#define ARIZONA_JD1_STS_SHIFT                         0  
#define ARIZONA_JD1_STS_WIDTH                         1  


#define ARIZONA_MICD_CLAMP_DB                    0x0008  
#define ARIZONA_MICD_CLAMP_DB_MASK               0x0008  
#define ARIZONA_MICD_CLAMP_DB_SHIFT                   3  
#define ARIZONA_MICD_CLAMP_DB_WIDTH                   1  
#define ARIZONA_JD2_DB                           0x0002  
#define ARIZONA_JD2_DB_MASK                      0x0002  
#define ARIZONA_JD2_DB_SHIFT                          1  
#define ARIZONA_JD2_DB_WIDTH                          1  
#define ARIZONA_JD1_DB                           0x0001  
#define ARIZONA_JD1_DB_MASK                      0x0001  
#define ARIZONA_JD1_DB_SHIFT                          0  
#define ARIZONA_JD1_DB_WIDTH                          1  


#define ARIZONA_FX_RATE_MASK                     0x7800  
#define ARIZONA_FX_RATE_SHIFT                        11  
#define ARIZONA_FX_RATE_WIDTH                         4  


#define ARIZONA_FX_STS_MASK                      0xFFF0  
#define ARIZONA_FX_STS_SHIFT                          4  
#define ARIZONA_FX_STS_WIDTH                         12  


#define ARIZONA_EQ1_B1_GAIN_MASK                 0xF800  
#define ARIZONA_EQ1_B1_GAIN_SHIFT                    11  
#define ARIZONA_EQ1_B1_GAIN_WIDTH                     5  
#define ARIZONA_EQ1_B2_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ1_B2_GAIN_SHIFT                     6  
#define ARIZONA_EQ1_B2_GAIN_WIDTH                     5  
#define ARIZONA_EQ1_B3_GAIN_MASK                 0x003E  
#define ARIZONA_EQ1_B3_GAIN_SHIFT                     1  
#define ARIZONA_EQ1_B3_GAIN_WIDTH                     5  
#define ARIZONA_EQ1_ENA                          0x0001  
#define ARIZONA_EQ1_ENA_MASK                     0x0001  
#define ARIZONA_EQ1_ENA_SHIFT                         0  
#define ARIZONA_EQ1_ENA_WIDTH                         1  


#define ARIZONA_EQ1_B4_GAIN_MASK                 0xF800  
#define ARIZONA_EQ1_B4_GAIN_SHIFT                    11  
#define ARIZONA_EQ1_B4_GAIN_WIDTH                     5  
#define ARIZONA_EQ1_B5_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ1_B5_GAIN_SHIFT                     6  
#define ARIZONA_EQ1_B5_GAIN_WIDTH                     5  
#define ARIZONA_EQ1_B1_MODE                      0x0001  
#define ARIZONA_EQ1_B1_MODE_MASK                 0x0001  
#define ARIZONA_EQ1_B1_MODE_SHIFT                     0  
#define ARIZONA_EQ1_B1_MODE_WIDTH                     1  


#define ARIZONA_EQ1_B1_A_MASK                    0xFFFF  
#define ARIZONA_EQ1_B1_A_SHIFT                        0  
#define ARIZONA_EQ1_B1_A_WIDTH                       16  


#define ARIZONA_EQ1_B1_B_MASK                    0xFFFF  
#define ARIZONA_EQ1_B1_B_SHIFT                        0  
#define ARIZONA_EQ1_B1_B_WIDTH                       16  


#define ARIZONA_EQ1_B1_PG_MASK                   0xFFFF  
#define ARIZONA_EQ1_B1_PG_SHIFT                       0  
#define ARIZONA_EQ1_B1_PG_WIDTH                      16  


#define ARIZONA_EQ1_B2_A_MASK                    0xFFFF  
#define ARIZONA_EQ1_B2_A_SHIFT                        0  
#define ARIZONA_EQ1_B2_A_WIDTH                       16  


#define ARIZONA_EQ1_B2_B_MASK                    0xFFFF  
#define ARIZONA_EQ1_B2_B_SHIFT                        0  
#define ARIZONA_EQ1_B2_B_WIDTH                       16  


#define ARIZONA_EQ1_B2_C_MASK                    0xFFFF  
#define ARIZONA_EQ1_B2_C_SHIFT                        0  
#define ARIZONA_EQ1_B2_C_WIDTH                       16  


#define ARIZONA_EQ1_B2_PG_MASK                   0xFFFF  
#define ARIZONA_EQ1_B2_PG_SHIFT                       0  
#define ARIZONA_EQ1_B2_PG_WIDTH                      16  


#define ARIZONA_EQ1_B3_A_MASK                    0xFFFF  
#define ARIZONA_EQ1_B3_A_SHIFT                        0  
#define ARIZONA_EQ1_B3_A_WIDTH                       16  


#define ARIZONA_EQ1_B3_B_MASK                    0xFFFF  
#define ARIZONA_EQ1_B3_B_SHIFT                        0  
#define ARIZONA_EQ1_B3_B_WIDTH                       16  


#define ARIZONA_EQ1_B3_C_MASK                    0xFFFF  
#define ARIZONA_EQ1_B3_C_SHIFT                        0  
#define ARIZONA_EQ1_B3_C_WIDTH                       16  


#define ARIZONA_EQ1_B3_PG_MASK                   0xFFFF  
#define ARIZONA_EQ1_B3_PG_SHIFT                       0  
#define ARIZONA_EQ1_B3_PG_WIDTH                      16  


#define ARIZONA_EQ1_B4_A_MASK                    0xFFFF  
#define ARIZONA_EQ1_B4_A_SHIFT                        0  
#define ARIZONA_EQ1_B4_A_WIDTH                       16  


#define ARIZONA_EQ1_B4_B_MASK                    0xFFFF  
#define ARIZONA_EQ1_B4_B_SHIFT                        0  
#define ARIZONA_EQ1_B4_B_WIDTH                       16  


#define ARIZONA_EQ1_B4_C_MASK                    0xFFFF  
#define ARIZONA_EQ1_B4_C_SHIFT                        0  
#define ARIZONA_EQ1_B4_C_WIDTH                       16  


#define ARIZONA_EQ1_B4_PG_MASK                   0xFFFF  
#define ARIZONA_EQ1_B4_PG_SHIFT                       0  
#define ARIZONA_EQ1_B4_PG_WIDTH                      16  


#define ARIZONA_EQ1_B5_A_MASK                    0xFFFF  
#define ARIZONA_EQ1_B5_A_SHIFT                        0  
#define ARIZONA_EQ1_B5_A_WIDTH                       16  


#define ARIZONA_EQ1_B5_B_MASK                    0xFFFF  
#define ARIZONA_EQ1_B5_B_SHIFT                        0  
#define ARIZONA_EQ1_B5_B_WIDTH                       16  


#define ARIZONA_EQ1_B5_PG_MASK                   0xFFFF  
#define ARIZONA_EQ1_B5_PG_SHIFT                       0  
#define ARIZONA_EQ1_B5_PG_WIDTH                      16  


#define ARIZONA_EQ1_B1_C_MASK                    0xFFFF  
#define ARIZONA_EQ1_B1_C_SHIFT                        0  
#define ARIZONA_EQ1_B1_C_WIDTH                       16  


#define ARIZONA_EQ2_B1_GAIN_MASK                 0xF800  
#define ARIZONA_EQ2_B1_GAIN_SHIFT                    11  
#define ARIZONA_EQ2_B1_GAIN_WIDTH                     5  
#define ARIZONA_EQ2_B2_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ2_B2_GAIN_SHIFT                     6  
#define ARIZONA_EQ2_B2_GAIN_WIDTH                     5  
#define ARIZONA_EQ2_B3_GAIN_MASK                 0x003E  
#define ARIZONA_EQ2_B3_GAIN_SHIFT                     1  
#define ARIZONA_EQ2_B3_GAIN_WIDTH                     5  
#define ARIZONA_EQ2_ENA                          0x0001  
#define ARIZONA_EQ2_ENA_MASK                     0x0001  
#define ARIZONA_EQ2_ENA_SHIFT                         0  
#define ARIZONA_EQ2_ENA_WIDTH                         1  


#define ARIZONA_EQ2_B4_GAIN_MASK                 0xF800  
#define ARIZONA_EQ2_B4_GAIN_SHIFT                    11  
#define ARIZONA_EQ2_B4_GAIN_WIDTH                     5  
#define ARIZONA_EQ2_B5_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ2_B5_GAIN_SHIFT                     6  
#define ARIZONA_EQ2_B5_GAIN_WIDTH                     5  
#define ARIZONA_EQ2_B1_MODE                      0x0001  
#define ARIZONA_EQ2_B1_MODE_MASK                 0x0001  
#define ARIZONA_EQ2_B1_MODE_SHIFT                     0  
#define ARIZONA_EQ2_B1_MODE_WIDTH                     1  


#define ARIZONA_EQ2_B1_A_MASK                    0xFFFF  
#define ARIZONA_EQ2_B1_A_SHIFT                        0  
#define ARIZONA_EQ2_B1_A_WIDTH                       16  


#define ARIZONA_EQ2_B1_B_MASK                    0xFFFF  
#define ARIZONA_EQ2_B1_B_SHIFT                        0  
#define ARIZONA_EQ2_B1_B_WIDTH                       16  


#define ARIZONA_EQ2_B1_PG_MASK                   0xFFFF  
#define ARIZONA_EQ2_B1_PG_SHIFT                       0  
#define ARIZONA_EQ2_B1_PG_WIDTH                      16  


#define ARIZONA_EQ2_B2_A_MASK                    0xFFFF  
#define ARIZONA_EQ2_B2_A_SHIFT                        0  
#define ARIZONA_EQ2_B2_A_WIDTH                       16  


#define ARIZONA_EQ2_B2_B_MASK                    0xFFFF  
#define ARIZONA_EQ2_B2_B_SHIFT                        0  
#define ARIZONA_EQ2_B2_B_WIDTH                       16  


#define ARIZONA_EQ2_B2_C_MASK                    0xFFFF  
#define ARIZONA_EQ2_B2_C_SHIFT                        0  
#define ARIZONA_EQ2_B2_C_WIDTH                       16  


#define ARIZONA_EQ2_B2_PG_MASK                   0xFFFF  
#define ARIZONA_EQ2_B2_PG_SHIFT                       0  
#define ARIZONA_EQ2_B2_PG_WIDTH                      16  


#define ARIZONA_EQ2_B3_A_MASK                    0xFFFF  
#define ARIZONA_EQ2_B3_A_SHIFT                        0  
#define ARIZONA_EQ2_B3_A_WIDTH                       16  


#define ARIZONA_EQ2_B3_B_MASK                    0xFFFF  
#define ARIZONA_EQ2_B3_B_SHIFT                        0  
#define ARIZONA_EQ2_B3_B_WIDTH                       16  


#define ARIZONA_EQ2_B3_C_MASK                    0xFFFF  
#define ARIZONA_EQ2_B3_C_SHIFT                        0  
#define ARIZONA_EQ2_B3_C_WIDTH                       16  


#define ARIZONA_EQ2_B3_PG_MASK                   0xFFFF  
#define ARIZONA_EQ2_B3_PG_SHIFT                       0  
#define ARIZONA_EQ2_B3_PG_WIDTH                      16  


#define ARIZONA_EQ2_B4_A_MASK                    0xFFFF  
#define ARIZONA_EQ2_B4_A_SHIFT                        0  
#define ARIZONA_EQ2_B4_A_WIDTH                       16  


#define ARIZONA_EQ2_B4_B_MASK                    0xFFFF  
#define ARIZONA_EQ2_B4_B_SHIFT                        0  
#define ARIZONA_EQ2_B4_B_WIDTH                       16  


#define ARIZONA_EQ2_B4_C_MASK                    0xFFFF  
#define ARIZONA_EQ2_B4_C_SHIFT                        0  
#define ARIZONA_EQ2_B4_C_WIDTH                       16  


#define ARIZONA_EQ2_B4_PG_MASK                   0xFFFF  
#define ARIZONA_EQ2_B4_PG_SHIFT                       0  
#define ARIZONA_EQ2_B4_PG_WIDTH                      16  


#define ARIZONA_EQ2_B5_A_MASK                    0xFFFF  
#define ARIZONA_EQ2_B5_A_SHIFT                        0  
#define ARIZONA_EQ2_B5_A_WIDTH                       16  


#define ARIZONA_EQ2_B5_B_MASK                    0xFFFF  
#define ARIZONA_EQ2_B5_B_SHIFT                        0  
#define ARIZONA_EQ2_B5_B_WIDTH                       16  


#define ARIZONA_EQ2_B5_PG_MASK                   0xFFFF  
#define ARIZONA_EQ2_B5_PG_SHIFT                       0  
#define ARIZONA_EQ2_B5_PG_WIDTH                      16  


#define ARIZONA_EQ2_B1_C_MASK                    0xFFFF  
#define ARIZONA_EQ2_B1_C_SHIFT                        0  
#define ARIZONA_EQ2_B1_C_WIDTH                       16  


#define ARIZONA_EQ3_B1_GAIN_MASK                 0xF800  
#define ARIZONA_EQ3_B1_GAIN_SHIFT                    11  
#define ARIZONA_EQ3_B1_GAIN_WIDTH                     5  
#define ARIZONA_EQ3_B2_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ3_B2_GAIN_SHIFT                     6  
#define ARIZONA_EQ3_B2_GAIN_WIDTH                     5  
#define ARIZONA_EQ3_B3_GAIN_MASK                 0x003E  
#define ARIZONA_EQ3_B3_GAIN_SHIFT                     1  
#define ARIZONA_EQ3_B3_GAIN_WIDTH                     5  
#define ARIZONA_EQ3_ENA                          0x0001  
#define ARIZONA_EQ3_ENA_MASK                     0x0001  
#define ARIZONA_EQ3_ENA_SHIFT                         0  
#define ARIZONA_EQ3_ENA_WIDTH                         1  


#define ARIZONA_EQ3_B4_GAIN_MASK                 0xF800  
#define ARIZONA_EQ3_B4_GAIN_SHIFT                    11  
#define ARIZONA_EQ3_B4_GAIN_WIDTH                     5  
#define ARIZONA_EQ3_B5_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ3_B5_GAIN_SHIFT                     6  
#define ARIZONA_EQ3_B5_GAIN_WIDTH                     5  
#define ARIZONA_EQ3_B1_MODE                      0x0001  
#define ARIZONA_EQ3_B1_MODE_MASK                 0x0001  
#define ARIZONA_EQ3_B1_MODE_SHIFT                     0  
#define ARIZONA_EQ3_B1_MODE_WIDTH                     1  


#define ARIZONA_EQ3_B1_A_MASK                    0xFFFF  
#define ARIZONA_EQ3_B1_A_SHIFT                        0  
#define ARIZONA_EQ3_B1_A_WIDTH                       16  


#define ARIZONA_EQ3_B1_B_MASK                    0xFFFF  
#define ARIZONA_EQ3_B1_B_SHIFT                        0  
#define ARIZONA_EQ3_B1_B_WIDTH                       16  


#define ARIZONA_EQ3_B1_PG_MASK                   0xFFFF  
#define ARIZONA_EQ3_B1_PG_SHIFT                       0  
#define ARIZONA_EQ3_B1_PG_WIDTH                      16  


#define ARIZONA_EQ3_B2_A_MASK                    0xFFFF  
#define ARIZONA_EQ3_B2_A_SHIFT                        0  
#define ARIZONA_EQ3_B2_A_WIDTH                       16  


#define ARIZONA_EQ3_B2_B_MASK                    0xFFFF  
#define ARIZONA_EQ3_B2_B_SHIFT                        0  
#define ARIZONA_EQ3_B2_B_WIDTH                       16  


#define ARIZONA_EQ3_B2_C_MASK                    0xFFFF  
#define ARIZONA_EQ3_B2_C_SHIFT                        0  
#define ARIZONA_EQ3_B2_C_WIDTH                       16  


#define ARIZONA_EQ3_B2_PG_MASK                   0xFFFF  
#define ARIZONA_EQ3_B2_PG_SHIFT                       0  
#define ARIZONA_EQ3_B2_PG_WIDTH                      16  


#define ARIZONA_EQ3_B3_A_MASK                    0xFFFF  
#define ARIZONA_EQ3_B3_A_SHIFT                        0  
#define ARIZONA_EQ3_B3_A_WIDTH                       16  


#define ARIZONA_EQ3_B3_B_MASK                    0xFFFF  
#define ARIZONA_EQ3_B3_B_SHIFT                        0  
#define ARIZONA_EQ3_B3_B_WIDTH                       16  


#define ARIZONA_EQ3_B3_C_MASK                    0xFFFF  
#define ARIZONA_EQ3_B3_C_SHIFT                        0  
#define ARIZONA_EQ3_B3_C_WIDTH                       16  


#define ARIZONA_EQ3_B3_PG_MASK                   0xFFFF  
#define ARIZONA_EQ3_B3_PG_SHIFT                       0  
#define ARIZONA_EQ3_B3_PG_WIDTH                      16  


#define ARIZONA_EQ3_B4_A_MASK                    0xFFFF  
#define ARIZONA_EQ3_B4_A_SHIFT                        0  
#define ARIZONA_EQ3_B4_A_WIDTH                       16  


#define ARIZONA_EQ3_B4_B_MASK                    0xFFFF  
#define ARIZONA_EQ3_B4_B_SHIFT                        0  
#define ARIZONA_EQ3_B4_B_WIDTH                       16  


#define ARIZONA_EQ3_B4_C_MASK                    0xFFFF  
#define ARIZONA_EQ3_B4_C_SHIFT                        0  
#define ARIZONA_EQ3_B4_C_WIDTH                       16  


#define ARIZONA_EQ3_B4_PG_MASK                   0xFFFF  
#define ARIZONA_EQ3_B4_PG_SHIFT                       0  
#define ARIZONA_EQ3_B4_PG_WIDTH                      16  


#define ARIZONA_EQ3_B5_A_MASK                    0xFFFF  
#define ARIZONA_EQ3_B5_A_SHIFT                        0  
#define ARIZONA_EQ3_B5_A_WIDTH                       16  


#define ARIZONA_EQ3_B5_B_MASK                    0xFFFF  
#define ARIZONA_EQ3_B5_B_SHIFT                        0  
#define ARIZONA_EQ3_B5_B_WIDTH                       16  


#define ARIZONA_EQ3_B5_PG_MASK                   0xFFFF  
#define ARIZONA_EQ3_B5_PG_SHIFT                       0  
#define ARIZONA_EQ3_B5_PG_WIDTH                      16  


#define ARIZONA_EQ3_B1_C_MASK                    0xFFFF  
#define ARIZONA_EQ3_B1_C_SHIFT                        0  
#define ARIZONA_EQ3_B1_C_WIDTH                       16  


#define ARIZONA_EQ4_B1_GAIN_MASK                 0xF800  
#define ARIZONA_EQ4_B1_GAIN_SHIFT                    11  
#define ARIZONA_EQ4_B1_GAIN_WIDTH                     5  
#define ARIZONA_EQ4_B2_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ4_B2_GAIN_SHIFT                     6  
#define ARIZONA_EQ4_B2_GAIN_WIDTH                     5  
#define ARIZONA_EQ4_B3_GAIN_MASK                 0x003E  
#define ARIZONA_EQ4_B3_GAIN_SHIFT                     1  
#define ARIZONA_EQ4_B3_GAIN_WIDTH                     5  
#define ARIZONA_EQ4_ENA                          0x0001  
#define ARIZONA_EQ4_ENA_MASK                     0x0001  
#define ARIZONA_EQ4_ENA_SHIFT                         0  
#define ARIZONA_EQ4_ENA_WIDTH                         1  


#define ARIZONA_EQ4_B4_GAIN_MASK                 0xF800  
#define ARIZONA_EQ4_B4_GAIN_SHIFT                    11  
#define ARIZONA_EQ4_B4_GAIN_WIDTH                     5  
#define ARIZONA_EQ4_B5_GAIN_MASK                 0x07C0  
#define ARIZONA_EQ4_B5_GAIN_SHIFT                     6  
#define ARIZONA_EQ4_B5_GAIN_WIDTH                     5  
#define ARIZONA_EQ4_B1_MODE                      0x0001  
#define ARIZONA_EQ4_B1_MODE_MASK                 0x0001  
#define ARIZONA_EQ4_B1_MODE_SHIFT                     0  
#define ARIZONA_EQ4_B1_MODE_WIDTH                     1  


#define ARIZONA_EQ4_B1_A_MASK                    0xFFFF  
#define ARIZONA_EQ4_B1_A_SHIFT                        0  
#define ARIZONA_EQ4_B1_A_WIDTH                       16  


#define ARIZONA_EQ4_B1_B_MASK                    0xFFFF  
#define ARIZONA_EQ4_B1_B_SHIFT                        0  
#define ARIZONA_EQ4_B1_B_WIDTH                       16  


#define ARIZONA_EQ4_B1_PG_MASK                   0xFFFF  
#define ARIZONA_EQ4_B1_PG_SHIFT                       0  
#define ARIZONA_EQ4_B1_PG_WIDTH                      16  


#define ARIZONA_EQ4_B2_A_MASK                    0xFFFF  
#define ARIZONA_EQ4_B2_A_SHIFT                        0  
#define ARIZONA_EQ4_B2_A_WIDTH                       16  


#define ARIZONA_EQ4_B2_B_MASK                    0xFFFF  
#define ARIZONA_EQ4_B2_B_SHIFT                        0  
#define ARIZONA_EQ4_B2_B_WIDTH                       16  


#define ARIZONA_EQ4_B2_C_MASK                    0xFFFF  
#define ARIZONA_EQ4_B2_C_SHIFT                        0  
#define ARIZONA_EQ4_B2_C_WIDTH                       16  


#define ARIZONA_EQ4_B2_PG_MASK                   0xFFFF  
#define ARIZONA_EQ4_B2_PG_SHIFT                       0  
#define ARIZONA_EQ4_B2_PG_WIDTH                      16  


#define ARIZONA_EQ4_B3_A_MASK                    0xFFFF  
#define ARIZONA_EQ4_B3_A_SHIFT                        0  
#define ARIZONA_EQ4_B3_A_WIDTH                       16  


#define ARIZONA_EQ4_B3_B_MASK                    0xFFFF  
#define ARIZONA_EQ4_B3_B_SHIFT                        0  
#define ARIZONA_EQ4_B3_B_WIDTH                       16  


#define ARIZONA_EQ4_B3_C_MASK                    0xFFFF  
#define ARIZONA_EQ4_B3_C_SHIFT                        0  
#define ARIZONA_EQ4_B3_C_WIDTH                       16  


#define ARIZONA_EQ4_B3_PG_MASK                   0xFFFF  
#define ARIZONA_EQ4_B3_PG_SHIFT                       0  
#define ARIZONA_EQ4_B3_PG_WIDTH                      16  


#define ARIZONA_EQ4_B4_A_MASK                    0xFFFF  
#define ARIZONA_EQ4_B4_A_SHIFT                        0  
#define ARIZONA_EQ4_B4_A_WIDTH                       16  


#define ARIZONA_EQ4_B4_B_MASK                    0xFFFF  
#define ARIZONA_EQ4_B4_B_SHIFT                        0  
#define ARIZONA_EQ4_B4_B_WIDTH                       16  


#define ARIZONA_EQ4_B4_C_MASK                    0xFFFF  
#define ARIZONA_EQ4_B4_C_SHIFT                        0  
#define ARIZONA_EQ4_B4_C_WIDTH                       16  


#define ARIZONA_EQ4_B4_PG_MASK                   0xFFFF  
#define ARIZONA_EQ4_B4_PG_SHIFT                       0  
#define ARIZONA_EQ4_B4_PG_WIDTH                      16  


#define ARIZONA_EQ4_B5_A_MASK                    0xFFFF  
#define ARIZONA_EQ4_B5_A_SHIFT                        0  
#define ARIZONA_EQ4_B5_A_WIDTH                       16  


#define ARIZONA_EQ4_B5_B_MASK                    0xFFFF  
#define ARIZONA_EQ4_B5_B_SHIFT                        0  
#define ARIZONA_EQ4_B5_B_WIDTH                       16  


#define ARIZONA_EQ4_B5_PG_MASK                   0xFFFF  
#define ARIZONA_EQ4_B5_PG_SHIFT                       0  
#define ARIZONA_EQ4_B5_PG_WIDTH                      16  


#define ARIZONA_EQ4_B1_C_MASK                    0xFFFF  
#define ARIZONA_EQ4_B1_C_SHIFT                        0  
#define ARIZONA_EQ4_B1_C_WIDTH                       16  


#define ARIZONA_DRC1_SIG_DET_RMS_MASK            0xF800  
#define ARIZONA_DRC1_SIG_DET_RMS_SHIFT               11  
#define ARIZONA_DRC1_SIG_DET_RMS_WIDTH                5  
#define ARIZONA_DRC1_SIG_DET_PK_MASK             0x0600  
#define ARIZONA_DRC1_SIG_DET_PK_SHIFT                 9  
#define ARIZONA_DRC1_SIG_DET_PK_WIDTH                 2  
#define ARIZONA_DRC1_NG_ENA                      0x0100  
#define ARIZONA_DRC1_NG_ENA_MASK                 0x0100  
#define ARIZONA_DRC1_NG_ENA_SHIFT                     8  
#define ARIZONA_DRC1_NG_ENA_WIDTH                     1  
#define ARIZONA_DRC1_SIG_DET_MODE                0x0080  
#define ARIZONA_DRC1_SIG_DET_MODE_MASK           0x0080  
#define ARIZONA_DRC1_SIG_DET_MODE_SHIFT               7  
#define ARIZONA_DRC1_SIG_DET_MODE_WIDTH               1  
#define ARIZONA_DRC1_SIG_DET                     0x0040  
#define ARIZONA_DRC1_SIG_DET_MASK                0x0040  
#define ARIZONA_DRC1_SIG_DET_SHIFT                    6  
#define ARIZONA_DRC1_SIG_DET_WIDTH                    1  
#define ARIZONA_DRC1_KNEE2_OP_ENA                0x0020  
#define ARIZONA_DRC1_KNEE2_OP_ENA_MASK           0x0020  
#define ARIZONA_DRC1_KNEE2_OP_ENA_SHIFT               5  
#define ARIZONA_DRC1_KNEE2_OP_ENA_WIDTH               1  
#define ARIZONA_DRC1_QR                          0x0010  
#define ARIZONA_DRC1_QR_MASK                     0x0010  
#define ARIZONA_DRC1_QR_SHIFT                         4  
#define ARIZONA_DRC1_QR_WIDTH                         1  
#define ARIZONA_DRC1_ANTICLIP                    0x0008  
#define ARIZONA_DRC1_ANTICLIP_MASK               0x0008  
#define ARIZONA_DRC1_ANTICLIP_SHIFT                   3  
#define ARIZONA_DRC1_ANTICLIP_WIDTH                   1  
#define ARIZONA_DRC1L_ENA                        0x0002  
#define ARIZONA_DRC1L_ENA_MASK                   0x0002  
#define ARIZONA_DRC1L_ENA_SHIFT                       1  
#define ARIZONA_DRC1L_ENA_WIDTH                       1  
#define ARIZONA_DRC1R_ENA                        0x0001  
#define ARIZONA_DRC1R_ENA_MASK                   0x0001  
#define ARIZONA_DRC1R_ENA_SHIFT                       0  
#define ARIZONA_DRC1R_ENA_WIDTH                       1  


#define ARIZONA_DRC1_ATK_MASK                    0x1E00  
#define ARIZONA_DRC1_ATK_SHIFT                        9  
#define ARIZONA_DRC1_ATK_WIDTH                        4  
#define ARIZONA_DRC1_DCY_MASK                    0x01E0  
#define ARIZONA_DRC1_DCY_SHIFT                        5  
#define ARIZONA_DRC1_DCY_WIDTH                        4  
#define ARIZONA_DRC1_MINGAIN_MASK                0x001C  
#define ARIZONA_DRC1_MINGAIN_SHIFT                    2  
#define ARIZONA_DRC1_MINGAIN_WIDTH                    3  
#define ARIZONA_DRC1_MAXGAIN_MASK                0x0003  
#define ARIZONA_DRC1_MAXGAIN_SHIFT                    0  
#define ARIZONA_DRC1_MAXGAIN_WIDTH                    2  


#define ARIZONA_DRC1_NG_MINGAIN_MASK             0xF000  
#define ARIZONA_DRC1_NG_MINGAIN_SHIFT                12  
#define ARIZONA_DRC1_NG_MINGAIN_WIDTH                 4  
#define ARIZONA_DRC1_NG_EXP_MASK                 0x0C00  
#define ARIZONA_DRC1_NG_EXP_SHIFT                    10  
#define ARIZONA_DRC1_NG_EXP_WIDTH                     2  
#define ARIZONA_DRC1_QR_THR_MASK                 0x0300  
#define ARIZONA_DRC1_QR_THR_SHIFT                     8  
#define ARIZONA_DRC1_QR_THR_WIDTH                     2  
#define ARIZONA_DRC1_QR_DCY_MASK                 0x00C0  
#define ARIZONA_DRC1_QR_DCY_SHIFT                     6  
#define ARIZONA_DRC1_QR_DCY_WIDTH                     2  
#define ARIZONA_DRC1_HI_COMP_MASK                0x0038  
#define ARIZONA_DRC1_HI_COMP_SHIFT                    3  
#define ARIZONA_DRC1_HI_COMP_WIDTH                    3  
#define ARIZONA_DRC1_LO_COMP_MASK                0x0007  
#define ARIZONA_DRC1_LO_COMP_SHIFT                    0  
#define ARIZONA_DRC1_LO_COMP_WIDTH                    3  


#define ARIZONA_DRC1_KNEE_IP_MASK                0x07E0  
#define ARIZONA_DRC1_KNEE_IP_SHIFT                    5  
#define ARIZONA_DRC1_KNEE_IP_WIDTH                    6  
#define ARIZONA_DRC1_KNEE_OP_MASK                0x001F  
#define ARIZONA_DRC1_KNEE_OP_SHIFT                    0  
#define ARIZONA_DRC1_KNEE_OP_WIDTH                    5  


#define ARIZONA_DRC1_KNEE2_IP_MASK               0x03E0  
#define ARIZONA_DRC1_KNEE2_IP_SHIFT                   5  
#define ARIZONA_DRC1_KNEE2_IP_WIDTH                   5  
#define ARIZONA_DRC1_KNEE2_OP_MASK               0x001F  
#define ARIZONA_DRC1_KNEE2_OP_SHIFT                   0  
#define ARIZONA_DRC1_KNEE2_OP_WIDTH                   5  


#define ARIZONA_DRC2_SIG_DET_RMS_MASK            0xF800  
#define ARIZONA_DRC2_SIG_DET_RMS_SHIFT               11  
#define ARIZONA_DRC2_SIG_DET_RMS_WIDTH                5  
#define ARIZONA_DRC2_SIG_DET_PK_MASK             0x0600  
#define ARIZONA_DRC2_SIG_DET_PK_SHIFT                 9  
#define ARIZONA_DRC2_SIG_DET_PK_WIDTH                 2  
#define ARIZONA_DRC2_NG_ENA                      0x0100  
#define ARIZONA_DRC2_NG_ENA_MASK                 0x0100  
#define ARIZONA_DRC2_NG_ENA_SHIFT                     8  
#define ARIZONA_DRC2_NG_ENA_WIDTH                     1  
#define ARIZONA_DRC2_SIG_DET_MODE                0x0080  
#define ARIZONA_DRC2_SIG_DET_MODE_MASK           0x0080  
#define ARIZONA_DRC2_SIG_DET_MODE_SHIFT               7  
#define ARIZONA_DRC2_SIG_DET_MODE_WIDTH               1  
#define ARIZONA_DRC2_SIG_DET                     0x0040  
#define ARIZONA_DRC2_SIG_DET_MASK                0x0040  
#define ARIZONA_DRC2_SIG_DET_SHIFT                    6  
#define ARIZONA_DRC2_SIG_DET_WIDTH                    1  
#define ARIZONA_DRC2_KNEE2_OP_ENA                0x0020  
#define ARIZONA_DRC2_KNEE2_OP_ENA_MASK           0x0020  
#define ARIZONA_DRC2_KNEE2_OP_ENA_SHIFT               5  
#define ARIZONA_DRC2_KNEE2_OP_ENA_WIDTH               1  
#define ARIZONA_DRC2_QR                          0x0010  
#define ARIZONA_DRC2_QR_MASK                     0x0010  
#define ARIZONA_DRC2_QR_SHIFT                         4  
#define ARIZONA_DRC2_QR_WIDTH                         1  
#define ARIZONA_DRC2_ANTICLIP                    0x0008  
#define ARIZONA_DRC2_ANTICLIP_MASK               0x0008  
#define ARIZONA_DRC2_ANTICLIP_SHIFT                   3  
#define ARIZONA_DRC2_ANTICLIP_WIDTH                   1  
#define ARIZONA_DRC2L_ENA                        0x0002  
#define ARIZONA_DRC2L_ENA_MASK                   0x0002  
#define ARIZONA_DRC2L_ENA_SHIFT                       1  
#define ARIZONA_DRC2L_ENA_WIDTH                       1  
#define ARIZONA_DRC2R_ENA                        0x0001  
#define ARIZONA_DRC2R_ENA_MASK                   0x0001  
#define ARIZONA_DRC2R_ENA_SHIFT                       0  
#define ARIZONA_DRC2R_ENA_WIDTH                       1  


#define ARIZONA_DRC2_ATK_MASK                    0x1E00  
#define ARIZONA_DRC2_ATK_SHIFT                        9  
#define ARIZONA_DRC2_ATK_WIDTH                        4  
#define ARIZONA_DRC2_DCY_MASK                    0x01E0  
#define ARIZONA_DRC2_DCY_SHIFT                        5  
#define ARIZONA_DRC2_DCY_WIDTH                        4  
#define ARIZONA_DRC2_MINGAIN_MASK                0x001C  
#define ARIZONA_DRC2_MINGAIN_SHIFT                    2  
#define ARIZONA_DRC2_MINGAIN_WIDTH                    3  
#define ARIZONA_DRC2_MAXGAIN_MASK                0x0003  
#define ARIZONA_DRC2_MAXGAIN_SHIFT                    0  
#define ARIZONA_DRC2_MAXGAIN_WIDTH                    2  


#define ARIZONA_DRC2_NG_MINGAIN_MASK             0xF000  
#define ARIZONA_DRC2_NG_MINGAIN_SHIFT                12  
#define ARIZONA_DRC2_NG_MINGAIN_WIDTH                 4  
#define ARIZONA_DRC2_NG_EXP_MASK                 0x0C00  
#define ARIZONA_DRC2_NG_EXP_SHIFT                    10  
#define ARIZONA_DRC2_NG_EXP_WIDTH                     2  
#define ARIZONA_DRC2_QR_THR_MASK                 0x0300  
#define ARIZONA_DRC2_QR_THR_SHIFT                     8  
#define ARIZONA_DRC2_QR_THR_WIDTH                     2  
#define ARIZONA_DRC2_QR_DCY_MASK                 0x00C0  
#define ARIZONA_DRC2_QR_DCY_SHIFT                     6  
#define ARIZONA_DRC2_QR_DCY_WIDTH                     2  
#define ARIZONA_DRC2_HI_COMP_MASK                0x0038  
#define ARIZONA_DRC2_HI_COMP_SHIFT                    3  
#define ARIZONA_DRC2_HI_COMP_WIDTH                    3  
#define ARIZONA_DRC2_LO_COMP_MASK                0x0007  
#define ARIZONA_DRC2_LO_COMP_SHIFT                    0  
#define ARIZONA_DRC2_LO_COMP_WIDTH                    3  


#define ARIZONA_DRC2_KNEE_IP_MASK                0x07E0  
#define ARIZONA_DRC2_KNEE_IP_SHIFT                    5  
#define ARIZONA_DRC2_KNEE_IP_WIDTH                    6  
#define ARIZONA_DRC2_KNEE_OP_MASK                0x001F  
#define ARIZONA_DRC2_KNEE_OP_SHIFT                    0  
#define ARIZONA_DRC2_KNEE_OP_WIDTH                    5  


#define ARIZONA_DRC2_KNEE2_IP_MASK               0x03E0  
#define ARIZONA_DRC2_KNEE2_IP_SHIFT                   5  
#define ARIZONA_DRC2_KNEE2_IP_WIDTH                   5  
#define ARIZONA_DRC2_KNEE2_OP_MASK               0x001F  
#define ARIZONA_DRC2_KNEE2_OP_SHIFT                   0  
#define ARIZONA_DRC2_KNEE2_OP_WIDTH                   5  


#define ARIZONA_LHPF1_MODE                       0x0002  
#define ARIZONA_LHPF1_MODE_MASK                  0x0002  
#define ARIZONA_LHPF1_MODE_SHIFT                      1  
#define ARIZONA_LHPF1_MODE_WIDTH                      1  
#define ARIZONA_LHPF1_ENA                        0x0001  
#define ARIZONA_LHPF1_ENA_MASK                   0x0001  
#define ARIZONA_LHPF1_ENA_SHIFT                       0  
#define ARIZONA_LHPF1_ENA_WIDTH                       1  


#define ARIZONA_LHPF1_COEFF_MASK                 0xFFFF  
#define ARIZONA_LHPF1_COEFF_SHIFT                     0  
#define ARIZONA_LHPF1_COEFF_WIDTH                    16  


#define ARIZONA_LHPF2_MODE                       0x0002  
#define ARIZONA_LHPF2_MODE_MASK                  0x0002  
#define ARIZONA_LHPF2_MODE_SHIFT                      1  
#define ARIZONA_LHPF2_MODE_WIDTH                      1  
#define ARIZONA_LHPF2_ENA                        0x0001  
#define ARIZONA_LHPF2_ENA_MASK                   0x0001  
#define ARIZONA_LHPF2_ENA_SHIFT                       0  
#define ARIZONA_LHPF2_ENA_WIDTH                       1  


#define ARIZONA_LHPF2_COEFF_MASK                 0xFFFF  
#define ARIZONA_LHPF2_COEFF_SHIFT                     0  
#define ARIZONA_LHPF2_COEFF_WIDTH                    16  


#define ARIZONA_LHPF3_MODE                       0x0002  
#define ARIZONA_LHPF3_MODE_MASK                  0x0002  
#define ARIZONA_LHPF3_MODE_SHIFT                      1  
#define ARIZONA_LHPF3_MODE_WIDTH                      1  
#define ARIZONA_LHPF3_ENA                        0x0001  
#define ARIZONA_LHPF3_ENA_MASK                   0x0001  
#define ARIZONA_LHPF3_ENA_SHIFT                       0  
#define ARIZONA_LHPF3_ENA_WIDTH                       1  


#define ARIZONA_LHPF3_COEFF_MASK                 0xFFFF  
#define ARIZONA_LHPF3_COEFF_SHIFT                     0  
#define ARIZONA_LHPF3_COEFF_WIDTH                    16  


#define ARIZONA_LHPF4_MODE                       0x0002  
#define ARIZONA_LHPF4_MODE_MASK                  0x0002  
#define ARIZONA_LHPF4_MODE_SHIFT                      1  
#define ARIZONA_LHPF4_MODE_WIDTH                      1  
#define ARIZONA_LHPF4_ENA                        0x0001  
#define ARIZONA_LHPF4_ENA_MASK                   0x0001  
#define ARIZONA_LHPF4_ENA_SHIFT                       0  
#define ARIZONA_LHPF4_ENA_WIDTH                       1  


#define ARIZONA_LHPF4_COEFF_MASK                 0xFFFF  
#define ARIZONA_LHPF4_COEFF_SHIFT                     0  
#define ARIZONA_LHPF4_COEFF_WIDTH                    16  


#define ARIZONA_ASRC2L_ENA                       0x0008  
#define ARIZONA_ASRC2L_ENA_MASK                  0x0008  
#define ARIZONA_ASRC2L_ENA_SHIFT                      3  
#define ARIZONA_ASRC2L_ENA_WIDTH                      1  
#define ARIZONA_ASRC2R_ENA                       0x0004  
#define ARIZONA_ASRC2R_ENA_MASK                  0x0004  
#define ARIZONA_ASRC2R_ENA_SHIFT                      2  
#define ARIZONA_ASRC2R_ENA_WIDTH                      1  
#define ARIZONA_ASRC1L_ENA                       0x0002  
#define ARIZONA_ASRC1L_ENA_MASK                  0x0002  
#define ARIZONA_ASRC1L_ENA_SHIFT                      1  
#define ARIZONA_ASRC1L_ENA_WIDTH                      1  
#define ARIZONA_ASRC1R_ENA                       0x0001  
#define ARIZONA_ASRC1R_ENA_MASK                  0x0001  
#define ARIZONA_ASRC1R_ENA_SHIFT                      0  
#define ARIZONA_ASRC1R_ENA_WIDTH                      1  


#define ARIZONA_ASRC_RATE1_MASK                  0x7800  
#define ARIZONA_ASRC_RATE1_SHIFT                     11  
#define ARIZONA_ASRC_RATE1_WIDTH                      4  


#define ARIZONA_ASRC_RATE2_MASK                  0x7800  
#define ARIZONA_ASRC_RATE2_SHIFT                     11  
#define ARIZONA_ASRC_RATE2_WIDTH                      4  


#define ARIZONA_ISRC1_FSH_MASK                   0x7800  
#define ARIZONA_ISRC1_FSH_SHIFT                      11  
#define ARIZONA_ISRC1_FSH_WIDTH                       4  
#define ARIZONA_ISRC1_CLK_SEL_MASK               0x0700  
#define ARIZONA_ISRC1_CLK_SEL_SHIFT                   8  
#define ARIZONA_ISRC1_CLK_SEL_WIDTH                   3  


#define ARIZONA_ISRC1_FSL_MASK                   0x7800  
#define ARIZONA_ISRC1_FSL_SHIFT                      11  
#define ARIZONA_ISRC1_FSL_WIDTH                       4  


#define ARIZONA_ISRC1_INT0_ENA                   0x8000  
#define ARIZONA_ISRC1_INT0_ENA_MASK              0x8000  
#define ARIZONA_ISRC1_INT0_ENA_SHIFT                 15  
#define ARIZONA_ISRC1_INT0_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_INT1_ENA                   0x4000  
#define ARIZONA_ISRC1_INT1_ENA_MASK              0x4000  
#define ARIZONA_ISRC1_INT1_ENA_SHIFT                 14  
#define ARIZONA_ISRC1_INT1_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_INT2_ENA                   0x2000  
#define ARIZONA_ISRC1_INT2_ENA_MASK              0x2000  
#define ARIZONA_ISRC1_INT2_ENA_SHIFT                 13  
#define ARIZONA_ISRC1_INT2_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_INT3_ENA                   0x1000  
#define ARIZONA_ISRC1_INT3_ENA_MASK              0x1000  
#define ARIZONA_ISRC1_INT3_ENA_SHIFT                 12  
#define ARIZONA_ISRC1_INT3_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_DEC0_ENA                   0x0200  
#define ARIZONA_ISRC1_DEC0_ENA_MASK              0x0200  
#define ARIZONA_ISRC1_DEC0_ENA_SHIFT                  9  
#define ARIZONA_ISRC1_DEC0_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_DEC1_ENA                   0x0100  
#define ARIZONA_ISRC1_DEC1_ENA_MASK              0x0100  
#define ARIZONA_ISRC1_DEC1_ENA_SHIFT                  8  
#define ARIZONA_ISRC1_DEC1_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_DEC2_ENA                   0x0080  
#define ARIZONA_ISRC1_DEC2_ENA_MASK              0x0080  
#define ARIZONA_ISRC1_DEC2_ENA_SHIFT                  7  
#define ARIZONA_ISRC1_DEC2_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_DEC3_ENA                   0x0040  
#define ARIZONA_ISRC1_DEC3_ENA_MASK              0x0040  
#define ARIZONA_ISRC1_DEC3_ENA_SHIFT                  6  
#define ARIZONA_ISRC1_DEC3_ENA_WIDTH                  1  
#define ARIZONA_ISRC1_NOTCH_ENA                  0x0001  
#define ARIZONA_ISRC1_NOTCH_ENA_MASK             0x0001  
#define ARIZONA_ISRC1_NOTCH_ENA_SHIFT                 0  
#define ARIZONA_ISRC1_NOTCH_ENA_WIDTH                 1  


#define ARIZONA_ISRC2_FSH_MASK                   0x7800  
#define ARIZONA_ISRC2_FSH_SHIFT                      11  
#define ARIZONA_ISRC2_FSH_WIDTH                       4  
#define ARIZONA_ISRC2_CLK_SEL_MASK               0x0700  
#define ARIZONA_ISRC2_CLK_SEL_SHIFT                   8  
#define ARIZONA_ISRC2_CLK_SEL_WIDTH                   3  


#define ARIZONA_ISRC2_FSL_MASK                   0x7800  
#define ARIZONA_ISRC2_FSL_SHIFT                      11  
#define ARIZONA_ISRC2_FSL_WIDTH                       4  


#define ARIZONA_ISRC2_INT0_ENA                   0x8000  
#define ARIZONA_ISRC2_INT0_ENA_MASK              0x8000  
#define ARIZONA_ISRC2_INT0_ENA_SHIFT                 15  
#define ARIZONA_ISRC2_INT0_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_INT1_ENA                   0x4000  
#define ARIZONA_ISRC2_INT1_ENA_MASK              0x4000  
#define ARIZONA_ISRC2_INT1_ENA_SHIFT                 14  
#define ARIZONA_ISRC2_INT1_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_INT2_ENA                   0x2000  
#define ARIZONA_ISRC2_INT2_ENA_MASK              0x2000  
#define ARIZONA_ISRC2_INT2_ENA_SHIFT                 13  
#define ARIZONA_ISRC2_INT2_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_INT3_ENA                   0x1000  
#define ARIZONA_ISRC2_INT3_ENA_MASK              0x1000  
#define ARIZONA_ISRC2_INT3_ENA_SHIFT                 12  
#define ARIZONA_ISRC2_INT3_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_DEC0_ENA                   0x0200  
#define ARIZONA_ISRC2_DEC0_ENA_MASK              0x0200  
#define ARIZONA_ISRC2_DEC0_ENA_SHIFT                  9  
#define ARIZONA_ISRC2_DEC0_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_DEC1_ENA                   0x0100  
#define ARIZONA_ISRC2_DEC1_ENA_MASK              0x0100  
#define ARIZONA_ISRC2_DEC1_ENA_SHIFT                  8  
#define ARIZONA_ISRC2_DEC1_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_DEC2_ENA                   0x0080  
#define ARIZONA_ISRC2_DEC2_ENA_MASK              0x0080  
#define ARIZONA_ISRC2_DEC2_ENA_SHIFT                  7  
#define ARIZONA_ISRC2_DEC2_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_DEC3_ENA                   0x0040  
#define ARIZONA_ISRC2_DEC3_ENA_MASK              0x0040  
#define ARIZONA_ISRC2_DEC3_ENA_SHIFT                  6  
#define ARIZONA_ISRC2_DEC3_ENA_WIDTH                  1  
#define ARIZONA_ISRC2_NOTCH_ENA                  0x0001  
#define ARIZONA_ISRC2_NOTCH_ENA_MASK             0x0001  
#define ARIZONA_ISRC2_NOTCH_ENA_SHIFT                 0  
#define ARIZONA_ISRC2_NOTCH_ENA_WIDTH                 1  


#define ARIZONA_ISRC3_FSH_MASK                   0x7800  
#define ARIZONA_ISRC3_FSH_SHIFT                      11  
#define ARIZONA_ISRC3_FSH_WIDTH                       4  
#define ARIZONA_ISRC3_CLK_SEL_MASK               0x0700  
#define ARIZONA_ISRC3_CLK_SEL_SHIFT                   8  
#define ARIZONA_ISRC3_CLK_SEL_WIDTH                   3  


#define ARIZONA_ISRC3_FSL_MASK                   0x7800  
#define ARIZONA_ISRC3_FSL_SHIFT                      11  
#define ARIZONA_ISRC3_FSL_WIDTH                       4  


#define ARIZONA_ISRC3_INT0_ENA                   0x8000  
#define ARIZONA_ISRC3_INT0_ENA_MASK              0x8000  
#define ARIZONA_ISRC3_INT0_ENA_SHIFT                 15  
#define ARIZONA_ISRC3_INT0_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_INT1_ENA                   0x4000  
#define ARIZONA_ISRC3_INT1_ENA_MASK              0x4000  
#define ARIZONA_ISRC3_INT1_ENA_SHIFT                 14  
#define ARIZONA_ISRC3_INT1_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_INT2_ENA                   0x2000  
#define ARIZONA_ISRC3_INT2_ENA_MASK              0x2000  
#define ARIZONA_ISRC3_INT2_ENA_SHIFT                 13  
#define ARIZONA_ISRC3_INT2_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_INT3_ENA                   0x1000  
#define ARIZONA_ISRC3_INT3_ENA_MASK              0x1000  
#define ARIZONA_ISRC3_INT3_ENA_SHIFT                 12  
#define ARIZONA_ISRC3_INT3_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_DEC0_ENA                   0x0200  
#define ARIZONA_ISRC3_DEC0_ENA_MASK              0x0200  
#define ARIZONA_ISRC3_DEC0_ENA_SHIFT                  9  
#define ARIZONA_ISRC3_DEC0_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_DEC1_ENA                   0x0100  
#define ARIZONA_ISRC3_DEC1_ENA_MASK              0x0100  
#define ARIZONA_ISRC3_DEC1_ENA_SHIFT                  8  
#define ARIZONA_ISRC3_DEC1_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_DEC2_ENA                   0x0080  
#define ARIZONA_ISRC3_DEC2_ENA_MASK              0x0080  
#define ARIZONA_ISRC3_DEC2_ENA_SHIFT                  7  
#define ARIZONA_ISRC3_DEC2_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_DEC3_ENA                   0x0040  
#define ARIZONA_ISRC3_DEC3_ENA_MASK              0x0040  
#define ARIZONA_ISRC3_DEC3_ENA_SHIFT                  6  
#define ARIZONA_ISRC3_DEC3_ENA_WIDTH                  1  
#define ARIZONA_ISRC3_NOTCH_ENA                  0x0001  
#define ARIZONA_ISRC3_NOTCH_ENA_MASK             0x0001  
#define ARIZONA_ISRC3_NOTCH_ENA_SHIFT                 0  
#define ARIZONA_ISRC3_NOTCH_ENA_WIDTH                 1  


#define ARIZONA_EXT_NG_SEL_CLR                   0x0080  
#define ARIZONA_EXT_NG_SEL_CLR_MASK              0x0080  
#define ARIZONA_EXT_NG_SEL_CLR_SHIFT                  7  
#define ARIZONA_EXT_NG_SEL_CLR_WIDTH                  1  
#define ARIZONA_EXT_NG_SEL_SET                   0x0040  
#define ARIZONA_EXT_NG_SEL_SET_MASK              0x0040  
#define ARIZONA_EXT_NG_SEL_SET_SHIFT                  6  
#define ARIZONA_EXT_NG_SEL_SET_WIDTH                  1  
#define ARIZONA_CLK_R_ENA_CLR                    0x0020  
#define ARIZONA_CLK_R_ENA_CLR_MASK               0x0020  
#define ARIZONA_CLK_R_ENA_CLR_SHIFT                   5  
#define ARIZONA_CLK_R_ENA_CLR_WIDTH                   1  
#define ARIZONA_CLK_R_ENA_SET                    0x0010  
#define ARIZONA_CLK_R_ENA_SET_MASK               0x0010  
#define ARIZONA_CLK_R_ENA_SET_SHIFT                   4  
#define ARIZONA_CLK_R_ENA_SET_WIDTH                   1  
#define ARIZONA_CLK_NG_ENA_CLR                   0x0008  
#define ARIZONA_CLK_NG_ENA_CLR_MASK              0x0008  
#define ARIZONA_CLK_NG_ENA_CLR_SHIFT                  3  
#define ARIZONA_CLK_NG_ENA_CLR_WIDTH                  1  
#define ARIZONA_CLK_NG_ENA_SET                   0x0004  
#define ARIZONA_CLK_NG_ENA_SET_MASK              0x0004  
#define ARIZONA_CLK_NG_ENA_SET_SHIFT                  2  
#define ARIZONA_CLK_NG_ENA_SET_WIDTH                  1  
#define ARIZONA_CLK_L_ENA_CLR                    0x0002  
#define ARIZONA_CLK_L_ENA_CLR_MASK               0x0002  
#define ARIZONA_CLK_L_ENA_CLR_SHIFT                   1  
#define ARIZONA_CLK_L_ENA_CLR_WIDTH                   1  
#define ARIZONA_CLK_L_ENA_SET                    0x0001  
#define ARIZONA_CLK_L_ENA_SET_MASK               0x0001  
#define ARIZONA_CLK_L_ENA_SET_SHIFT                   0  
#define ARIZONA_CLK_L_ENA_SET_WIDTH                   1  


#define ARIZONA_IN_RXANCR_SEL_MASK               0x0070  
#define ARIZONA_IN_RXANCR_SEL_SHIFT                   4  
#define ARIZONA_IN_RXANCR_SEL_WIDTH                   3  
#define ARIZONA_IN_RXANCL_SEL_MASK               0x0007  
#define ARIZONA_IN_RXANCL_SEL_SHIFT                   0  
#define ARIZONA_IN_RXANCL_SEL_WIDTH                   3  


#define ARIZONA_FCL_MIC_MODE_SEL                 0x000C  
#define ARIZONA_FCL_MIC_MODE_SEL_SHIFT                2  
#define ARIZONA_FCL_MIC_MODE_SEL_WIDTH                2  


#define ARIZONA_FCR_MIC_MODE_SEL                 0x000C  
#define ARIZONA_FCR_MIC_MODE_SEL_SHIFT                2  
#define ARIZONA_FCR_MIC_MODE_SEL_WIDTH                2  


#define ARIZONA_DSP1_RATE_MASK                   0x7800  
#define ARIZONA_DSP1_RATE_SHIFT                      11  
#define ARIZONA_DSP1_RATE_WIDTH                       4  
#define ARIZONA_DSP1_MEM_ENA                     0x0010  
#define ARIZONA_DSP1_MEM_ENA_MASK                0x0010  
#define ARIZONA_DSP1_MEM_ENA_SHIFT                    4  
#define ARIZONA_DSP1_MEM_ENA_WIDTH                    1  
#define ARIZONA_DSP1_SYS_ENA                     0x0004  
#define ARIZONA_DSP1_SYS_ENA_MASK                0x0004  
#define ARIZONA_DSP1_SYS_ENA_SHIFT                    2  
#define ARIZONA_DSP1_SYS_ENA_WIDTH                    1  
#define ARIZONA_DSP1_CORE_ENA                    0x0002  
#define ARIZONA_DSP1_CORE_ENA_MASK               0x0002  
#define ARIZONA_DSP1_CORE_ENA_SHIFT                   1  
#define ARIZONA_DSP1_CORE_ENA_WIDTH                   1  
#define ARIZONA_DSP1_START                       0x0001  
#define ARIZONA_DSP1_START_MASK                  0x0001  
#define ARIZONA_DSP1_START_SHIFT                      0  
#define ARIZONA_DSP1_START_WIDTH                      1  


#define ARIZONA_DSP1_CLK_SEL_MASK                0x0007  
#define ARIZONA_DSP1_CLK_SEL_SHIFT                    0  
#define ARIZONA_DSP1_CLK_SEL_WIDTH                    3  


#define ARIZONA_DSP1_RAM_RDY                     0x0001  
#define ARIZONA_DSP1_RAM_RDY_MASK                0x0001  
#define ARIZONA_DSP1_RAM_RDY_SHIFT                    0  
#define ARIZONA_DSP1_RAM_RDY_WIDTH                    1  


#define ARIZONA_DSP1_PING_FULL                   0x8000  
#define ARIZONA_DSP1_PING_FULL_MASK              0x8000  
#define ARIZONA_DSP1_PING_FULL_SHIFT                 15  
#define ARIZONA_DSP1_PING_FULL_WIDTH                  1  
#define ARIZONA_DSP1_PONG_FULL                   0x4000  
#define ARIZONA_DSP1_PONG_FULL_MASK              0x4000  
#define ARIZONA_DSP1_PONG_FULL_SHIFT                 14  
#define ARIZONA_DSP1_PONG_FULL_WIDTH                  1  
#define ARIZONA_DSP1_WDMA_ACTIVE_CHANNELS_MASK   0x00FF  
#define ARIZONA_DSP1_WDMA_ACTIVE_CHANNELS_SHIFT       0  
#define ARIZONA_DSP1_WDMA_ACTIVE_CHANNELS_WIDTH       8  

#endif
