/* SPDX-License-Identifier: GPL-2.0 */


#ifndef CS42L43_CORE_REGS_H
#define CS42L43_CORE_REGS_H


#define CS42L43_GEN_INT_STAT_1					0x000000C0
#define CS42L43_GEN_INT_MASK_1					0x000000C1
#define CS42L43_DEVID						0x00003000
#define CS42L43_REVID						0x00003004
#define CS42L43_RELID						0x0000300C
#define CS42L43_SFT_RESET					0x00003020
#define CS42L43_DRV_CTRL1					0x00006004
#define CS42L43_DRV_CTRL3					0x0000600C
#define CS42L43_DRV_CTRL4					0x00006010
#define CS42L43_DRV_CTRL_5					0x00006014
#define CS42L43_GPIO_CTRL1					0x00006034
#define CS42L43_GPIO_CTRL2					0x00006038
#define CS42L43_GPIO_STS					0x0000603C
#define CS42L43_GPIO_FN_SEL					0x00006040
#define CS42L43_MCLK_SRC_SEL					0x00007004
#define CS42L43_CCM_BLK_CLK_CONTROL				0x00007010
#define CS42L43_SAMPLE_RATE1					0x00007014
#define CS42L43_SAMPLE_RATE2					0x00007018
#define CS42L43_SAMPLE_RATE3					0x0000701C
#define CS42L43_SAMPLE_RATE4					0x00007020
#define CS42L43_PLL_CONTROL					0x00007034
#define CS42L43_FS_SELECT1					0x00007038
#define CS42L43_FS_SELECT2					0x0000703C
#define CS42L43_FS_SELECT3					0x00007040
#define CS42L43_FS_SELECT4					0x00007044
#define CS42L43_PDM_CONTROL					0x0000704C
#define CS42L43_ASP_CLK_CONFIG1					0x00007058
#define CS42L43_ASP_CLK_CONFIG2					0x0000705C
#define CS42L43_OSC_DIV_SEL					0x00007068
#define CS42L43_ADC_B_CTRL1					0x00008000
#define CS42L43_ADC_B_CTRL2					0x00008004
#define CS42L43_DECIM_HPF_WNF_CTRL1				0x0000803C
#define CS42L43_DECIM_HPF_WNF_CTRL2				0x00008040
#define CS42L43_DECIM_HPF_WNF_CTRL3				0x00008044
#define CS42L43_DECIM_HPF_WNF_CTRL4				0x00008048
#define CS42L43_DMIC_PDM_CTRL					0x0000804C
#define CS42L43_DECIM_VOL_CTRL_CH1_CH2				0x00008050
#define CS42L43_DECIM_VOL_CTRL_CH3_CH4				0x00008054
#define CS42L43_DECIM_VOL_CTRL_UPDATE				0x00008058
#define CS42L43_INTP_VOLUME_CTRL1				0x00009008
#define CS42L43_INTP_VOLUME_CTRL2				0x0000900C
#define CS42L43_AMP1_2_VOL_RAMP					0x00009010
#define CS42L43_ASP_CTRL					0x0000A000
#define CS42L43_ASP_FSYNC_CTRL1					0x0000A004
#define CS42L43_ASP_FSYNC_CTRL2					0x0000A008
#define CS42L43_ASP_FSYNC_CTRL3					0x0000A00C
#define CS42L43_ASP_FSYNC_CTRL4					0x0000A010
#define CS42L43_ASP_DATA_CTRL					0x0000A018
#define CS42L43_ASP_RX_EN					0x0000A020
#define CS42L43_ASP_TX_EN					0x0000A024
#define CS42L43_ASP_RX_CH1_CTRL					0x0000A028
#define CS42L43_ASP_RX_CH2_CTRL					0x0000A02C
#define CS42L43_ASP_RX_CH3_CTRL					0x0000A030
#define CS42L43_ASP_RX_CH4_CTRL					0x0000A034
#define CS42L43_ASP_RX_CH5_CTRL					0x0000A038
#define CS42L43_ASP_RX_CH6_CTRL					0x0000A03C
#define CS42L43_ASP_TX_CH1_CTRL					0x0000A068
#define CS42L43_ASP_TX_CH2_CTRL					0x0000A06C
#define CS42L43_ASP_TX_CH3_CTRL					0x0000A070
#define CS42L43_ASP_TX_CH4_CTRL					0x0000A074
#define CS42L43_ASP_TX_CH5_CTRL					0x0000A078
#define CS42L43_ASP_TX_CH6_CTRL					0x0000A07C
#define CS42L43_OTP_REVISION_ID					0x0000B02C
#define CS42L43_ASPTX1_INPUT					0x0000C200
#define CS42L43_ASPTX2_INPUT					0x0000C210
#define CS42L43_ASPTX3_INPUT					0x0000C220
#define CS42L43_ASPTX4_INPUT					0x0000C230
#define CS42L43_ASPTX5_INPUT					0x0000C240
#define CS42L43_ASPTX6_INPUT					0x0000C250
#define CS42L43_SWIRE_DP1_CH1_INPUT				0x0000C280
#define CS42L43_SWIRE_DP1_CH2_INPUT				0x0000C290
#define CS42L43_SWIRE_DP1_CH3_INPUT				0x0000C2A0
#define CS42L43_SWIRE_DP1_CH4_INPUT				0x0000C2B0
#define CS42L43_SWIRE_DP2_CH1_INPUT				0x0000C2C0
#define CS42L43_SWIRE_DP2_CH2_INPUT				0x0000C2D0
#define CS42L43_SWIRE_DP3_CH1_INPUT				0x0000C2E0
#define CS42L43_SWIRE_DP3_CH2_INPUT				0x0000C2F0
#define CS42L43_SWIRE_DP4_CH1_INPUT				0x0000C300
#define CS42L43_SWIRE_DP4_CH2_INPUT				0x0000C310
#define CS42L43_ASRC_INT1_INPUT1				0x0000C400
#define CS42L43_ASRC_INT2_INPUT1				0x0000C410
#define CS42L43_ASRC_INT3_INPUT1				0x0000C420
#define CS42L43_ASRC_INT4_INPUT1				0x0000C430
#define CS42L43_ASRC_DEC1_INPUT1				0x0000C440
#define CS42L43_ASRC_DEC2_INPUT1				0x0000C450
#define CS42L43_ASRC_DEC3_INPUT1				0x0000C460
#define CS42L43_ASRC_DEC4_INPUT1				0x0000C470
#define CS42L43_ISRC1INT1_INPUT1				0x0000C500
#define CS42L43_ISRC1INT2_INPUT1				0x0000C510
#define CS42L43_ISRC1DEC1_INPUT1				0x0000C520
#define CS42L43_ISRC1DEC2_INPUT1				0x0000C530
#define CS42L43_ISRC2INT1_INPUT1				0x0000C540
#define CS42L43_ISRC2INT2_INPUT1				0x0000C550
#define CS42L43_ISRC2DEC1_INPUT1				0x0000C560
#define CS42L43_ISRC2DEC2_INPUT1				0x0000C570
#define CS42L43_EQ1MIX_INPUT1					0x0000C580
#define CS42L43_EQ1MIX_INPUT2					0x0000C584
#define CS42L43_EQ1MIX_INPUT3					0x0000C588
#define CS42L43_EQ1MIX_INPUT4					0x0000C58C
#define CS42L43_EQ2MIX_INPUT1					0x0000C590
#define CS42L43_EQ2MIX_INPUT2					0x0000C594
#define CS42L43_EQ2MIX_INPUT3					0x0000C598
#define CS42L43_EQ2MIX_INPUT4					0x0000C59C
#define CS42L43_SPDIF1_INPUT1					0x0000C600
#define CS42L43_SPDIF2_INPUT1					0x0000C610
#define CS42L43_AMP1MIX_INPUT1					0x0000C620
#define CS42L43_AMP1MIX_INPUT2					0x0000C624
#define CS42L43_AMP1MIX_INPUT3					0x0000C628
#define CS42L43_AMP1MIX_INPUT4					0x0000C62C
#define CS42L43_AMP2MIX_INPUT1					0x0000C630
#define CS42L43_AMP2MIX_INPUT2					0x0000C634
#define CS42L43_AMP2MIX_INPUT3					0x0000C638
#define CS42L43_AMP2MIX_INPUT4					0x0000C63C
#define CS42L43_AMP3MIX_INPUT1					0x0000C640
#define CS42L43_AMP3MIX_INPUT2					0x0000C644
#define CS42L43_AMP3MIX_INPUT3					0x0000C648
#define CS42L43_AMP3MIX_INPUT4					0x0000C64C
#define CS42L43_AMP4MIX_INPUT1					0x0000C650
#define CS42L43_AMP4MIX_INPUT2					0x0000C654
#define CS42L43_AMP4MIX_INPUT3					0x0000C658
#define CS42L43_AMP4MIX_INPUT4					0x0000C65C
#define CS42L43_ASRC_INT_ENABLES				0x0000E000
#define CS42L43_ASRC_DEC_ENABLES				0x0000E004
#define CS42L43_PDNCNTL						0x00010000
#define CS42L43_RINGSENSE_DEB_CTRL				0x0001001C
#define CS42L43_TIPSENSE_DEB_CTRL				0x00010020
#define CS42L43_TIP_RING_SENSE_INTERRUPT_STATUS			0x00010028
#define CS42L43_HS2						0x00010040
#define CS42L43_HS_STAT						0x00010048
#define CS42L43_MCU_SW_INTERRUPT				0x00010094
#define CS42L43_STEREO_MIC_CTRL					0x000100A4
#define CS42L43_STEREO_MIC_CLAMP_CTRL				0x000100C4
#define CS42L43_BLOCK_EN2					0x00010104
#define CS42L43_BLOCK_EN3					0x00010108
#define CS42L43_BLOCK_EN4					0x0001010C
#define CS42L43_BLOCK_EN5					0x00010110
#define CS42L43_BLOCK_EN6					0x00010114
#define CS42L43_BLOCK_EN7					0x00010118
#define CS42L43_BLOCK_EN8					0x0001011C
#define CS42L43_BLOCK_EN9					0x00010120
#define CS42L43_BLOCK_EN10					0x00010124
#define CS42L43_BLOCK_EN11					0x00010128
#define CS42L43_TONE_CH1_CTRL					0x00010134
#define CS42L43_TONE_CH2_CTRL					0x00010138
#define CS42L43_MIC_DETECT_CONTROL_1				0x00011074
#define CS42L43_DETECT_STATUS_1					0x0001107C
#define CS42L43_HS_BIAS_SENSE_AND_CLAMP_AUTOCONTROL		0x00011090
#define CS42L43_MIC_DETECT_CONTROL_ANDROID			0x000110B0
#define CS42L43_ISRC1_CTRL					0x00012004
#define CS42L43_ISRC2_CTRL					0x00013004
#define CS42L43_CTRL_REG					0x00014000
#define CS42L43_FDIV_FRAC					0x00014004
#define CS42L43_CAL_RATIO					0x00014008
#define CS42L43_SPI_CLK_CONFIG1					0x00016004
#define CS42L43_SPI_CONFIG1					0x00016010
#define CS42L43_SPI_CONFIG2					0x00016014
#define CS42L43_SPI_CONFIG3					0x00016018
#define CS42L43_SPI_CONFIG4					0x00016024
#define CS42L43_SPI_STATUS1					0x00016100
#define CS42L43_SPI_STATUS2					0x00016104
#define CS42L43_TRAN_CONFIG1					0x00016200
#define CS42L43_TRAN_CONFIG2					0x00016204
#define CS42L43_TRAN_CONFIG3					0x00016208
#define CS42L43_TRAN_CONFIG4					0x0001620C
#define CS42L43_TRAN_CONFIG5					0x00016220
#define CS42L43_TRAN_CONFIG6					0x00016224
#define CS42L43_TRAN_CONFIG7					0x00016228
#define CS42L43_TRAN_CONFIG8					0x0001622C
#define CS42L43_TRAN_STATUS1					0x00016300
#define CS42L43_TRAN_STATUS2					0x00016304
#define CS42L43_TRAN_STATUS3					0x00016308
#define CS42L43_TX_DATA						0x00016400
#define CS42L43_RX_DATA						0x00016600
#define CS42L43_DACCNFG1					0x00017000
#define CS42L43_DACCNFG2					0x00017004
#define CS42L43_HPPATHVOL					0x0001700C
#define CS42L43_PGAVOL						0x00017014
#define CS42L43_LOADDETRESULTS					0x00017018
#define CS42L43_LOADDETENA					0x00017024
#define CS42L43_CTRL						0x00017028
#define CS42L43_COEFF_DATA_IN0					0x00018000
#define CS42L43_COEFF_RD_WR0					0x00018008
#define CS42L43_INIT_DONE0					0x00018010
#define CS42L43_START_EQZ0					0x00018014
#define CS42L43_MUTE_EQ_IN0					0x0001801C
#define CS42L43_DECIM_INT					0x0001B000
#define CS42L43_EQ_INT						0x0001B004
#define CS42L43_ASP_INT						0x0001B008
#define CS42L43_PLL_INT						0x0001B00C
#define CS42L43_SOFT_INT					0x0001B010
#define CS42L43_SWIRE_INT					0x0001B014
#define CS42L43_MSM_INT						0x0001B018
#define CS42L43_ACC_DET_INT					0x0001B01C
#define CS42L43_I2C_TGT_INT					0x0001B020
#define CS42L43_SPI_MSTR_INT					0x0001B024
#define CS42L43_SW_TO_SPI_BRIDGE_INT				0x0001B028
#define CS42L43_OTP_INT						0x0001B02C
#define CS42L43_CLASS_D_AMP_INT					0x0001B030
#define CS42L43_GPIO_INT					0x0001B034
#define CS42L43_ASRC_INT					0x0001B038
#define CS42L43_HPOUT_INT					0x0001B03C
#define CS42L43_DECIM_MASK					0x0001B0A0
#define CS42L43_EQ_MIX_MASK					0x0001B0A4
#define CS42L43_ASP_MASK					0x0001B0A8
#define CS42L43_PLL_MASK					0x0001B0AC
#define CS42L43_SOFT_MASK					0x0001B0B0
#define CS42L43_SWIRE_MASK					0x0001B0B4
#define CS42L43_MSM_MASK					0x0001B0B8
#define CS42L43_ACC_DET_MASK					0x0001B0BC
#define CS42L43_I2C_TGT_MASK					0x0001B0C0
#define CS42L43_SPI_MSTR_MASK					0x0001B0C4
#define CS42L43_SW_TO_SPI_BRIDGE_MASK				0x0001B0C8
#define CS42L43_OTP_MASK					0x0001B0CC
#define CS42L43_CLASS_D_AMP_MASK				0x0001B0D0
#define CS42L43_GPIO_INT_MASK					0x0001B0D4
#define CS42L43_ASRC_MASK					0x0001B0D8
#define CS42L43_HPOUT_MASK					0x0001B0DC
#define CS42L43_DECIM_INT_SHADOW				0x0001B300
#define CS42L43_EQ_MIX_INT_SHADOW				0x0001B304
#define CS42L43_ASP_INT_SHADOW					0x0001B308
#define CS42L43_PLL_INT_SHADOW					0x0001B30C
#define CS42L43_SOFT_INT_SHADOW					0x0001B310
#define CS42L43_SWIRE_INT_SHADOW				0x0001B314
#define CS42L43_MSM_INT_SHADOW					0x0001B318
#define CS42L43_ACC_DET_INT_SHADOW				0x0001B31C
#define CS42L43_I2C_TGT_INT_SHADOW				0x0001B320
#define CS42L43_SPI_MSTR_INT_SHADOW				0x0001B324
#define CS42L43_SW_TO_SPI_BRIDGE_SHADOW				0x0001B328
#define CS42L43_OTP_INT_SHADOW					0x0001B32C
#define CS42L43_CLASS_D_AMP_INT_SHADOW				0x0001B330
#define CS42L43_GPIO_SHADOW					0x0001B334
#define CS42L43_ASRC_SHADOW					0x0001B338
#define CS42L43_HP_OUT_SHADOW					0x0001B33C
#define CS42L43_BOOT_CONTROL					0x00101000
#define CS42L43_BLOCK_EN					0x00101008
#define CS42L43_SHUTTER_CONTROL					0x0010100C
#define CS42L43_MCU_SW_REV					0x00114000
#define CS42L43_PATCH_START_ADDR				0x00114004
#define CS42L43_NEED_CONFIGS					0x0011400C
#define CS42L43_BOOT_STATUS					0x0011401C
#define CS42L43_FW_SH_BOOT_CFG_NEED_CONFIGS			0x0011F8F8
#define CS42L43_FW_MISSION_CTRL_NEED_CONFIGS			0x0011FE00
#define CS42L43_FW_MISSION_CTRL_HAVE_CONFIGS			0x0011FE04
#define CS42L43_FW_MISSION_CTRL_MM_CTRL_SELECTION		0x0011FE0C
#define CS42L43_FW_MISSION_CTRL_MM_MCU_CFG_REG			0x0011FE10
#define CS42L43_MCU_RAM_MAX					0x0011FFFF


#define CS42L43_DEVID_VAL					0x00042A43


#define CS42L43_INT_STAT_GEN1_MASK				0x00000001
#define CS42L43_INT_STAT_GEN1_SHIFT				0


#define CS42L43_SFT_RESET_MASK					0xFF000000
#define CS42L43_SFT_RESET_SHIFT					24

#define CS42L43_SFT_RESET_VAL					0x5A000000


#define CS42L43_ASP_DOUT_DRV_MASK				0x00038000
#define CS42L43_ASP_DOUT_DRV_SHIFT				15
#define CS42L43_ASP_FSYNC_DRV_MASK				0x00000E00
#define CS42L43_ASP_FSYNC_DRV_SHIFT				9
#define CS42L43_ASP_BCLK_DRV_MASK				0x000001C0
#define CS42L43_ASP_BCLK_DRV_SHIFT				6


#define CS42L43_I2C_ADDR_DRV_MASK				0x30000000
#define CS42L43_I2C_ADDR_DRV_SHIFT				28
#define CS42L43_I2C_SDA_DRV_MASK				0x0C000000
#define CS42L43_I2C_SDA_DRV_SHIFT				26
#define CS42L43_PDMOUT2_CLK_DRV_MASK				0x00E00000
#define CS42L43_PDMOUT2_CLK_DRV_SHIFT				21
#define CS42L43_PDMOUT2_DATA_DRV_MASK				0x001C0000
#define CS42L43_PDMOUT2_DATA_DRV_SHIFT				18
#define CS42L43_PDMOUT1_CLK_DRV_MASK				0x00038000
#define CS42L43_PDMOUT1_CLK_DRV_SHIFT				15
#define CS42L43_PDMOUT1_DATA_DRV_MASK				0x00007000
#define CS42L43_PDMOUT1_DATA_DRV_SHIFT				12
#define CS42L43_SPI_MISO_DRV_MASK				0x00000038
#define CS42L43_SPI_MISO_DRV_SHIFT				3


#define CS42L43_GPIO3_DRV_MASK					0x00000E00
#define CS42L43_GPIO3_DRV_SHIFT					9
#define CS42L43_GPIO2_DRV_MASK					0x000001C0
#define CS42L43_GPIO2_DRV_SHIFT					6
#define CS42L43_GPIO1_DRV_MASK					0x00000038
#define CS42L43_GPIO1_DRV_SHIFT					3


#define CS42L43_I2C_SCL_DRV_MASK				0x18000000
#define CS42L43_I2C_SCL_DRV_SHIFT				27
#define CS42L43_SPI_SCK_DRV_MASK				0x07000000
#define CS42L43_SPI_SCK_DRV_SHIFT				24
#define CS42L43_SPI_MOSI_DRV_MASK				0x00E00000
#define CS42L43_SPI_MOSI_DRV_SHIFT				21
#define CS42L43_SPI_SSB_DRV_MASK				0x001C0000
#define CS42L43_SPI_SSB_DRV_SHIFT				18
#define CS42L43_ASP_DIN_DRV_MASK				0x000001C0
#define CS42L43_ASP_DIN_DRV_SHIFT				6


#define CS42L43_GPIO3_POL_MASK					0x00040000
#define CS42L43_GPIO3_POL_SHIFT					18
#define CS42L43_GPIO2_POL_MASK					0x00020000
#define CS42L43_GPIO2_POL_SHIFT					17
#define CS42L43_GPIO1_POL_MASK					0x00010000
#define CS42L43_GPIO1_POL_SHIFT					16
#define CS42L43_GPIO3_LVL_MASK					0x00000400
#define CS42L43_GPIO3_LVL_SHIFT					10
#define CS42L43_GPIO2_LVL_MASK					0x00000200
#define CS42L43_GPIO2_LVL_SHIFT					9
#define CS42L43_GPIO1_LVL_MASK					0x00000100
#define CS42L43_GPIO1_LVL_SHIFT					8
#define CS42L43_GPIO3_DIR_MASK					0x00000004
#define CS42L43_GPIO3_DIR_SHIFT					2
#define CS42L43_GPIO2_DIR_MASK					0x00000002
#define CS42L43_GPIO2_DIR_SHIFT					1
#define CS42L43_GPIO1_DIR_MASK					0x00000001
#define CS42L43_GPIO1_DIR_SHIFT					0


#define CS42L43_GPIO3_DEGLITCH_BYP_MASK				0x00000004
#define CS42L43_GPIO3_DEGLITCH_BYP_SHIFT			2
#define CS42L43_GPIO2_DEGLITCH_BYP_MASK				0x00000002
#define CS42L43_GPIO2_DEGLITCH_BYP_SHIFT			1
#define CS42L43_GPIO1_DEGLITCH_BYP_MASK				0x00000001
#define CS42L43_GPIO1_DEGLITCH_BYP_SHIFT			0


#define CS42L43_GPIO3_STS_MASK					0x00000004
#define CS42L43_GPIO3_STS_SHIFT					2
#define CS42L43_GPIO2_STS_MASK					0x00000002
#define CS42L43_GPIO2_STS_SHIFT					1
#define CS42L43_GPIO1_STS_MASK					0x00000001
#define CS42L43_GPIO1_STS_SHIFT					0


#define CS42L43_GPIO3_FN_SEL_MASK				0x00000004
#define CS42L43_GPIO3_FN_SEL_SHIFT				2
#define CS42L43_GPIO1_FN_SEL_MASK				0x00000001
#define CS42L43_GPIO1_FN_SEL_SHIFT				0


#define CS42L43_OSC_PLL_MCLK_SEL_MASK				0x00000001
#define CS42L43_OSC_PLL_MCLK_SEL_SHIFT				0


#define CS42L43_SAMPLE_RATE_MASK				0x0000001F
#define CS42L43_SAMPLE_RATE_SHIFT				0


#define CS42L43_PLL_REFCLK_EN_MASK				0x00000008
#define CS42L43_PLL_REFCLK_EN_SHIFT				3
#define CS42L43_PLL_REFCLK_DIV_MASK				0x00000006
#define CS42L43_PLL_REFCLK_DIV_SHIFT				1
#define CS42L43_PLL_REFCLK_SRC_MASK				0x00000001
#define CS42L43_PLL_REFCLK_SRC_SHIFT				0


#define CS42L43_ASP_RATE_MASK					0x00000003
#define CS42L43_ASP_RATE_SHIFT					0


#define CS42L43_ASRC_DEC_OUT_RATE_MASK				0x000000C0
#define CS42L43_ASRC_DEC_OUT_RATE_SHIFT				6
#define CS42L43_ASRC_INT_OUT_RATE_MASK				0x00000030
#define CS42L43_ASRC_INT_OUT_RATE_SHIFT				4
#define CS42L43_ASRC_DEC_IN_RATE_MASK				0x0000000C
#define CS42L43_ASRC_DEC_IN_RATE_SHIFT				2
#define CS42L43_ASRC_INT_IN_RATE_MASK				0x00000003
#define CS42L43_ASRC_INT_IN_RATE_SHIFT				0


#define CS42L43_HPOUT_RATE_MASK					0x0000C000
#define CS42L43_HPOUT_RATE_SHIFT				14
#define CS42L43_EQZ_RATE_MASK					0x00003000
#define CS42L43_EQZ_RATE_SHIFT					12
#define CS42L43_DIAGGEN_RATE_MASK				0x00000C00
#define CS42L43_DIAGGEN_RATE_SHIFT				10
#define CS42L43_DECIM_CH4_RATE_MASK				0x00000300
#define CS42L43_DECIM_CH4_RATE_SHIFT				8
#define CS42L43_DECIM_CH3_RATE_MASK				0x000000C0
#define CS42L43_DECIM_CH3_RATE_SHIFT				6
#define CS42L43_DECIM_CH2_RATE_MASK				0x00000030
#define CS42L43_DECIM_CH2_RATE_SHIFT				4
#define CS42L43_DECIM_CH1_RATE_MASK				0x0000000C
#define CS42L43_DECIM_CH1_RATE_SHIFT				2
#define CS42L43_AMP1_2_RATE_MASK				0x00000003
#define CS42L43_AMP1_2_RATE_SHIFT				0


#define CS42L43_SW_DP7_RATE_MASK				0x00C00000
#define CS42L43_SW_DP7_RATE_SHIFT				22
#define CS42L43_SW_DP6_RATE_MASK				0x00300000
#define CS42L43_SW_DP6_RATE_SHIFT				20
#define CS42L43_SPDIF_RATE_MASK					0x000C0000
#define CS42L43_SPDIF_RATE_SHIFT				18
#define CS42L43_SW_DP5_RATE_MASK				0x00030000
#define CS42L43_SW_DP5_RATE_SHIFT				16
#define CS42L43_SW_DP4_RATE_MASK				0x0000C000
#define CS42L43_SW_DP4_RATE_SHIFT				14
#define CS42L43_SW_DP3_RATE_MASK				0x00003000
#define CS42L43_SW_DP3_RATE_SHIFT				12
#define CS42L43_SW_DP2_RATE_MASK				0x00000C00
#define CS42L43_SW_DP2_RATE_SHIFT				10
#define CS42L43_SW_DP1_RATE_MASK				0x00000300
#define CS42L43_SW_DP1_RATE_SHIFT				8
#define CS42L43_ISRC2_LOW_RATE_MASK				0x000000C0
#define CS42L43_ISRC2_LOW_RATE_SHIFT				6
#define CS42L43_ISRC2_HIGH_RATE_MASK				0x00000030
#define CS42L43_ISRC2_HIGH_RATE_SHIFT				4
#define CS42L43_ISRC1_LOW_RATE_MASK				0x0000000C
#define CS42L43_ISRC1_LOW_RATE_SHIFT				2
#define CS42L43_ISRC1_HIGH_RATE_MASK				0x00000003
#define CS42L43_ISRC1_HIGH_RATE_SHIFT				0


#define CS42L43_PDM2_CLK_DIV_MASK				0x0000000C
#define CS42L43_PDM2_CLK_DIV_SHIFT				2
#define CS42L43_PDM1_CLK_DIV_MASK				0x00000003
#define CS42L43_PDM1_CLK_DIV_SHIFT				0


#define CS42L43_ASP_BCLK_N_MASK					0x03FF0000
#define CS42L43_ASP_BCLK_N_SHIFT				16
#define CS42L43_ASP_BCLK_M_MASK					0x000003FF
#define CS42L43_ASP_BCLK_M_SHIFT				0


#define CS42L43_ASP_MASTER_MODE_MASK				0x00000002
#define CS42L43_ASP_MASTER_MODE_SHIFT				1
#define CS42L43_ASP_BCLK_INV_MASK				0x00000001
#define CS42L43_ASP_BCLK_INV_SHIFT				0


#define CS42L43_OSC_DIV2_EN_MASK				0x00000001
#define CS42L43_OSC_DIV2_EN_SHIFT				0


#define CS42L43_PGA_WIDESWING_MODE_EN_MASK			0x00000080
#define CS42L43_PGA_WIDESWING_MODE_EN_SHIFT			7
#define CS42L43_ADC_AIN_SEL_MASK				0x00000010
#define CS42L43_ADC_AIN_SEL_SHIFT				4
#define CS42L43_ADC_PGA_GAIN_MASK				0x0000000F
#define CS42L43_ADC_PGA_GAIN_SHIFT				0


#define CS42L43_DECIM_WNF_CF_MASK				0x00000070
#define CS42L43_DECIM_WNF_CF_SHIFT				4
#define CS42L43_DECIM_WNF_EN_MASK				0x00000008
#define CS42L43_DECIM_WNF_EN_SHIFT				3
#define CS42L43_DECIM_HPF_CF_MASK				0x00000006
#define CS42L43_DECIM_HPF_CF_SHIFT				1
#define CS42L43_DECIM_HPF_EN_MASK				0x00000001
#define CS42L43_DECIM_HPF_EN_SHIFT				0


#define CS42L43_PDM2R_INV_MASK					0x00000020
#define CS42L43_PDM2R_INV_SHIFT					5
#define CS42L43_PDM2L_INV_MASK					0x00000010
#define CS42L43_PDM2L_INV_SHIFT					4
#define CS42L43_PDM1R_INV_MASK					0x00000008
#define CS42L43_PDM1R_INV_SHIFT					3
#define CS42L43_PDM1L_INV_MASK					0x00000004
#define CS42L43_PDM1L_INV_SHIFT					2


#define CS42L43_DECIM2_MUTE_MASK				0x80000000
#define CS42L43_DECIM2_MUTE_SHIFT				31
#define CS42L43_DECIM2_VOL_MASK					0x3FC00000
#define CS42L43_DECIM2_VOL_SHIFT				22
#define CS42L43_DECIM2_VD_RAMP_MASK				0x00380000
#define CS42L43_DECIM2_VD_RAMP_SHIFT				19
#define CS42L43_DECIM2_VI_RAMP_MASK				0x00070000
#define CS42L43_DECIM2_VI_RAMP_SHIFT				16
#define CS42L43_DECIM1_MUTE_MASK				0x00008000
#define CS42L43_DECIM1_MUTE_SHIFT				15
#define CS42L43_DECIM1_VOL_MASK					0x00003FC0
#define CS42L43_DECIM1_VOL_SHIFT				6
#define CS42L43_DECIM1_VD_RAMP_MASK				0x00000038
#define CS42L43_DECIM1_VD_RAMP_SHIFT				3
#define CS42L43_DECIM1_VI_RAMP_MASK				0x00000007
#define CS42L43_DECIM1_VI_RAMP_SHIFT				0


#define CS42L43_DECIM4_MUTE_MASK				0x80000000
#define CS42L43_DECIM4_MUTE_SHIFT				31
#define CS42L43_DECIM4_VOL_MASK					0x3FC00000
#define CS42L43_DECIM4_VOL_SHIFT				22
#define CS42L43_DECIM4_VD_RAMP_MASK				0x00380000
#define CS42L43_DECIM4_VD_RAMP_SHIFT				19
#define CS42L43_DECIM4_VI_RAMP_MASK				0x00070000
#define CS42L43_DECIM4_VI_RAMP_SHIFT				16
#define CS42L43_DECIM3_MUTE_MASK				0x00008000
#define CS42L43_DECIM3_MUTE_SHIFT				15
#define CS42L43_DECIM3_VOL_MASK					0x00003FC0
#define CS42L43_DECIM3_VOL_SHIFT				6
#define CS42L43_DECIM3_VD_RAMP_MASK				0x00000038
#define CS42L43_DECIM3_VD_RAMP_SHIFT				3
#define CS42L43_DECIM3_VI_RAMP_MASK				0x00000007
#define CS42L43_DECIM3_VI_RAMP_SHIFT				0


#define CS42L43_DECIM4_VOL_UPDATE_MASK				0x00000008
#define CS42L43_DECIM4_VOL_UPDATE_SHIFT				3
#define CS42L43_DECIM3_VOL_UPDATE_MASK				0x00000004
#define CS42L43_DECIM3_VOL_UPDATE_SHIFT				2
#define CS42L43_DECIM2_VOL_UPDATE_MASK				0x00000002
#define CS42L43_DECIM2_VOL_UPDATE_SHIFT				1
#define CS42L43_DECIM1_VOL_UPDATE_MASK				0x00000001
#define CS42L43_DECIM1_VOL_UPDATE_SHIFT				0


#define CS42L43_AMP1_2_VU_MASK					0x00000200
#define CS42L43_AMP1_2_VU_SHIFT					9
#define CS42L43_AMP_MUTE_MASK					0x00000100
#define CS42L43_AMP_MUTE_SHIFT					8
#define CS42L43_AMP_VOL_MASK					0x000000FF
#define CS42L43_AMP_VOL_SHIFT					0


#define CS42L43_AMP1_2_VD_RAMP_MASK				0x00000070
#define CS42L43_AMP1_2_VD_RAMP_SHIFT				4
#define CS42L43_AMP1_2_VI_RAMP_MASK				0x00000007
#define CS42L43_AMP1_2_VI_RAMP_SHIFT				0


#define CS42L43_ASP_FSYNC_MODE_MASK				0x00000004
#define CS42L43_ASP_FSYNC_MODE_SHIFT				2
#define CS42L43_ASP_BCLK_EN_MASK				0x00000002
#define CS42L43_ASP_BCLK_EN_SHIFT				1
#define CS42L43_ASP_FSYNC_EN_MASK				0x00000001
#define CS42L43_ASP_FSYNC_EN_SHIFT				0


#define CS42L43_ASP_FSYNC_M_MASK				0x0007FFFF
#define CS42L43_ASP_FSYNC_M_SHIFT				0


#define CS42L43_ASP_FSYNC_IN_INV_MASK				0x00000002
#define CS42L43_ASP_FSYNC_IN_INV_SHIFT				1
#define CS42L43_ASP_FSYNC_OUT_INV_MASK				0x00000001
#define CS42L43_ASP_FSYNC_OUT_INV_SHIFT				0


#define CS42L43_ASP_NUM_BCLKS_PER_FSYNC_MASK			0x00001FFE
#define CS42L43_ASP_NUM_BCLKS_PER_FSYNC_SHIFT			1


#define CS42L43_ASP_FSYNC_FRAME_START_PHASE_MASK		0x00000008
#define CS42L43_ASP_FSYNC_FRAME_START_PHASE_SHIFT		3
#define CS42L43_ASP_FSYNC_FRAME_START_DLY_MASK			0x00000007
#define CS42L43_ASP_FSYNC_FRAME_START_DLY_SHIFT			0


#define CS42L43_ASP_RX_CH6_EN_MASK				0x00000020
#define CS42L43_ASP_RX_CH6_EN_SHIFT				5
#define CS42L43_ASP_RX_CH5_EN_MASK				0x00000010
#define CS42L43_ASP_RX_CH5_EN_SHIFT				4
#define CS42L43_ASP_RX_CH4_EN_MASK				0x00000008
#define CS42L43_ASP_RX_CH4_EN_SHIFT				3
#define CS42L43_ASP_RX_CH3_EN_MASK				0x00000004
#define CS42L43_ASP_RX_CH3_EN_SHIFT				2
#define CS42L43_ASP_RX_CH2_EN_MASK				0x00000002
#define CS42L43_ASP_RX_CH2_EN_SHIFT				1
#define CS42L43_ASP_RX_CH1_EN_MASK				0x00000001
#define CS42L43_ASP_RX_CH1_EN_SHIFT				0


#define CS42L43_ASP_TX_CH6_EN_MASK				0x00000020
#define CS42L43_ASP_TX_CH6_EN_SHIFT				5
#define CS42L43_ASP_TX_CH5_EN_MASK				0x00000010
#define CS42L43_ASP_TX_CH5_EN_SHIFT				4
#define CS42L43_ASP_TX_CH4_EN_MASK				0x00000008
#define CS42L43_ASP_TX_CH4_EN_SHIFT				3
#define CS42L43_ASP_TX_CH3_EN_MASK				0x00000004
#define CS42L43_ASP_TX_CH3_EN_SHIFT				2
#define CS42L43_ASP_TX_CH2_EN_MASK				0x00000002
#define CS42L43_ASP_TX_CH2_EN_SHIFT				1
#define CS42L43_ASP_TX_CH1_EN_MASK				0x00000001
#define CS42L43_ASP_TX_CH1_EN_SHIFT				0


#define CS42L43_ASP_CH_WIDTH_MASK				0x001F0000
#define CS42L43_ASP_CH_WIDTH_SHIFT				16
#define CS42L43_ASP_CH_SLOT_MASK				0x00001FFE
#define CS42L43_ASP_CH_SLOT_SHIFT				1
#define CS42L43_ASP_CH_SLOT_PHASE_MASK				0x00000001
#define CS42L43_ASP_CH_SLOT_PHASE_SHIFT				0


#define CS42L43_MIXER_VOL_MASK					0x00FE0000
#define CS42L43_MIXER_VOL_SHIFT					17
#define CS42L43_MIXER_SRC_MASK					0x000001FF
#define CS42L43_MIXER_SRC_SHIFT					0


#define CS42L43_ASRC_INT4_EN_MASK				0x00000008
#define CS42L43_ASRC_INT4_EN_SHIFT				3
#define CS42L43_ASRC_INT3_EN_MASK				0x00000004
#define CS42L43_ASRC_INT3_EN_SHIFT				2
#define CS42L43_ASRC_INT2_EN_MASK				0x00000002
#define CS42L43_ASRC_INT2_EN_SHIFT				1
#define CS42L43_ASRC_INT1_EN_MASK				0x00000001
#define CS42L43_ASRC_INT1_EN_SHIFT				0


#define CS42L43_ASRC_DEC4_EN_MASK				0x00000008
#define CS42L43_ASRC_DEC4_EN_SHIFT				3
#define CS42L43_ASRC_DEC3_EN_MASK				0x00000004
#define CS42L43_ASRC_DEC3_EN_SHIFT				2
#define CS42L43_ASRC_DEC2_EN_MASK				0x00000002
#define CS42L43_ASRC_DEC2_EN_SHIFT				1
#define CS42L43_ASRC_DEC1_EN_MASK				0x00000001
#define CS42L43_ASRC_DEC1_EN_SHIFT				0


#define CS42L43_RING_SENSE_EN_MASK				0x00000002
#define CS42L43_RING_SENSE_EN_SHIFT				1


#define CS42L43_RINGSENSE_INV_MASK				0x00000080
#define CS42L43_RINGSENSE_INV_SHIFT				7
#define CS42L43_RINGSENSE_PULLUP_PDNB_MASK			0x00000040
#define CS42L43_RINGSENSE_PULLUP_PDNB_SHIFT			6
#define CS42L43_RINGSENSE_FALLING_DB_TIME_MASK			0x00000038
#define CS42L43_RINGSENSE_FALLING_DB_TIME_SHIFT			3
#define CS42L43_RINGSENSE_RISING_DB_TIME_MASK			0x00000007
#define CS42L43_RINGSENSE_RISING_DB_TIME_SHIFT			0


#define CS42L43_TIPSENSE_INV_MASK				0x00000080
#define CS42L43_TIPSENSE_INV_SHIFT				7
#define CS42L43_TIPSENSE_FALLING_DB_TIME_MASK			0x00000038
#define CS42L43_TIPSENSE_FALLING_DB_TIME_SHIFT			3
#define CS42L43_TIPSENSE_RISING_DB_TIME_MASK			0x00000007
#define CS42L43_TIPSENSE_RISING_DB_TIME_SHIFT			0


#define CS42L43_TIPSENSE_UNPLUG_DB_STS_MASK			0x00000008
#define CS42L43_TIPSENSE_UNPLUG_DB_STS_SHIFT			3
#define CS42L43_TIPSENSE_PLUG_DB_STS_MASK			0x00000004
#define CS42L43_TIPSENSE_PLUG_DB_STS_SHIFT			2
#define CS42L43_RINGSENSE_UNPLUG_DB_STS_MASK			0x00000002
#define CS42L43_RINGSENSE_UNPLUG_DB_STS_SHIFT			1
#define CS42L43_RINGSENSE_PLUG_DB_STS_MASK			0x00000001
#define CS42L43_RINGSENSE_PLUG_DB_STS_SHIFT			0


#define CS42L43_HS_CLAMP_DISABLE_MASK				0x10000000
#define CS42L43_HS_CLAMP_DISABLE_SHIFT				28
#define CS42L43_HSBIAS_RAMP_MASK				0x0C000000
#define CS42L43_HSBIAS_RAMP_SHIFT				26
#define CS42L43_HSDET_MODE_MASK					0x00018000
#define CS42L43_HSDET_MODE_SHIFT				15
#define CS42L43_HSDET_MANUAL_MODE_MASK				0x00006000
#define CS42L43_HSDET_MANUAL_MODE_SHIFT				13
#define CS42L43_AUTO_HSDET_TIME_MASK				0x00000700
#define CS42L43_AUTO_HSDET_TIME_SHIFT				8
#define CS42L43_AMP3_4_GNDREF_HS3_SEL_MASK			0x00000080
#define CS42L43_AMP3_4_GNDREF_HS3_SEL_SHIFT			7
#define CS42L43_AMP3_4_GNDREF_HS4_SEL_MASK			0x00000040
#define CS42L43_AMP3_4_GNDREF_HS4_SEL_SHIFT			6
#define CS42L43_HSBIAS_GNDREF_HS3_SEL_MASK			0x00000020
#define CS42L43_HSBIAS_GNDREF_HS3_SEL_SHIFT			5
#define CS42L43_HSBIAS_GNDREF_HS4_SEL_MASK			0x00000010
#define CS42L43_HSBIAS_GNDREF_HS4_SEL_SHIFT			4
#define CS42L43_HSBIAS_OUT_HS3_SEL_MASK				0x00000008
#define CS42L43_HSBIAS_OUT_HS3_SEL_SHIFT			3
#define CS42L43_HSBIAS_OUT_HS4_SEL_MASK				0x00000004
#define CS42L43_HSBIAS_OUT_HS4_SEL_SHIFT			2
#define CS42L43_HSGND_HS3_SEL_MASK				0x00000002
#define CS42L43_HSGND_HS3_SEL_SHIFT				1
#define CS42L43_HSGND_HS4_SEL_MASK				0x00000001
#define CS42L43_HSGND_HS4_SEL_SHIFT				0


#define CS42L43_HSDET_TYPE_STS_MASK				0x00000007
#define CS42L43_HSDET_TYPE_STS_SHIFT				0


#define CS42L43_CONTROL_IND_MASK				0x00000004
#define CS42L43_CONTROL_IND_SHIFT				2
#define CS42L43_CONFIGS_IND_MASK				0x00000002
#define CS42L43_CONFIGS_IND_SHIFT				1
#define CS42L43_PATCH_IND_MASK					0x00000001
#define CS42L43_PATCH_IND_SHIFT					0


#define CS42L43_HS2_BIAS_SENSE_EN_MASK				0x00000020
#define CS42L43_HS2_BIAS_SENSE_EN_SHIFT				5
#define CS42L43_HS1_BIAS_SENSE_EN_MASK				0x00000010
#define CS42L43_HS1_BIAS_SENSE_EN_SHIFT				4
#define CS42L43_HS2_BIAS_EN_MASK				0x00000008
#define CS42L43_HS2_BIAS_EN_SHIFT				3
#define CS42L43_HS1_BIAS_EN_MASK				0x00000004
#define CS42L43_HS1_BIAS_EN_SHIFT				2
#define CS42L43_JACK_STEREO_CONFIG_MASK				0x00000003
#define CS42L43_JACK_STEREO_CONFIG_SHIFT			0


#define CS42L43_SMIC_HPAMP_CLAMP_DIS_FRC_VAL_MASK		0x00000002
#define CS42L43_SMIC_HPAMP_CLAMP_DIS_FRC_VAL_SHIFT		1
#define CS42L43_SMIC_HPAMP_CLAMP_DIS_FRC_MASK			0x00000001
#define CS42L43_SMIC_HPAMP_CLAMP_DIS_FRC_SHIFT			0


#define CS42L43_SPI_MSTR_EN_MASK				0x00000001
#define CS42L43_SPI_MSTR_EN_SHIFT				0


#define CS42L43_PDM2_DIN_R_EN_MASK				0x00000020
#define CS42L43_PDM2_DIN_R_EN_SHIFT				5
#define CS42L43_PDM2_DIN_L_EN_MASK				0x00000010
#define CS42L43_PDM2_DIN_L_EN_SHIFT				4
#define CS42L43_PDM1_DIN_R_EN_MASK				0x00000008
#define CS42L43_PDM1_DIN_R_EN_SHIFT				3
#define CS42L43_PDM1_DIN_L_EN_MASK				0x00000004
#define CS42L43_PDM1_DIN_L_EN_SHIFT				2
#define CS42L43_ADC2_EN_MASK					0x00000002
#define CS42L43_ADC2_EN_SHIFT					1
#define CS42L43_ADC1_EN_MASK					0x00000001
#define CS42L43_ADC1_EN_SHIFT					0


#define CS42L43_ASRC_DEC_BANK_EN_MASK				0x00000002
#define CS42L43_ASRC_DEC_BANK_EN_SHIFT				1
#define CS42L43_ASRC_INT_BANK_EN_MASK				0x00000001
#define CS42L43_ASRC_INT_BANK_EN_SHIFT				0


#define CS42L43_ISRC2_BANK_EN_MASK				0x00000002
#define CS42L43_ISRC2_BANK_EN_SHIFT				1
#define CS42L43_ISRC1_BANK_EN_MASK				0x00000001
#define CS42L43_ISRC1_BANK_EN_SHIFT				0


#define CS42L43_MIXER_EN_MASK					0x00000001
#define CS42L43_MIXER_EN_SHIFT					0


#define CS42L43_EQ_EN_MASK					0x00000001
#define CS42L43_EQ_EN_SHIFT					0


#define CS42L43_HP_EN_MASK					0x00000001
#define CS42L43_HP_EN_SHIFT					0


#define CS42L43_TONE_EN_MASK					0x00000001
#define CS42L43_TONE_EN_SHIFT					0


#define CS42L43_AMP2_EN_MASK					0x00000002
#define CS42L43_AMP2_EN_SHIFT					1
#define CS42L43_AMP1_EN_MASK					0x00000001
#define CS42L43_AMP1_EN_SHIFT					0


#define CS42L43_SPDIF_EN_MASK					0x00000001
#define CS42L43_SPDIF_EN_SHIFT					0


#define CS42L43_TONE_FREQ_MASK					0x00000070
#define CS42L43_TONE_FREQ_SHIFT					4
#define CS42L43_TONE_SEL_MASK					0x0000000F
#define CS42L43_TONE_SEL_SHIFT					0


#define CS42L43_BUTTON_DETECT_MODE_MASK				0x00000018
#define CS42L43_BUTTON_DETECT_MODE_SHIFT			3
#define CS42L43_HSBIAS_MODE_MASK				0x00000006
#define CS42L43_HSBIAS_MODE_SHIFT				1
#define CS42L43_MIC_LVL_DET_DISABLE_MASK			0x00000001
#define CS42L43_MIC_LVL_DET_DISABLE_SHIFT			0


#define CS42L43_HSDET_DC_STS_MASK				0x01FF0000
#define CS42L43_HSDET_DC_STS_SHIFT				16
#define CS42L43_JACKDET_STS_MASK				0x00000080
#define CS42L43_JACKDET_STS_SHIFT				7
#define CS42L43_HSBIAS_CLAMP_STS_MASK				0x00000040
#define CS42L43_HSBIAS_CLAMP_STS_SHIFT				6


#define CS42L43_JACKDET_MODE_MASK				0xC0000000
#define CS42L43_JACKDET_MODE_SHIFT				30
#define CS42L43_JACKDET_INV_MASK				0x20000000
#define CS42L43_JACKDET_INV_SHIFT				29
#define CS42L43_JACKDET_DB_TIME_MASK				0x03000000
#define CS42L43_JACKDET_DB_TIME_SHIFT				24
#define CS42L43_S0_AUTO_ADCMUTE_DISABLE_MASK			0x00800000
#define CS42L43_S0_AUTO_ADCMUTE_DISABLE_SHIFT			23
#define CS42L43_HSBIAS_SENSE_EN_MASK				0x00000080
#define CS42L43_HSBIAS_SENSE_EN_SHIFT				7
#define CS42L43_AUTO_HSBIAS_CLAMP_EN_MASK			0x00000040
#define CS42L43_AUTO_HSBIAS_CLAMP_EN_SHIFT			6
#define CS42L43_JACKDET_SENSE_EN_MASK				0x00000020
#define CS42L43_JACKDET_SENSE_EN_SHIFT				5
#define CS42L43_HSBIAS_SENSE_TRIP_MASK				0x00000007
#define CS42L43_HSBIAS_SENSE_TRIP_SHIFT				0


#define CS42L43_HSDET_LVL_COMBWIDTH_MASK			0xC0000000
#define CS42L43_HSDET_LVL_COMBWIDTH_SHIFT			30
#define CS42L43_HSDET_LVL2_THRESH_MASK				0x01FF0000
#define CS42L43_HSDET_LVL2_THRESH_SHIFT				16
#define CS42L43_HSDET_LVL1_THRESH_MASK				0x000001FF
#define CS42L43_HSDET_LVL1_THRESH_SHIFT				0


#define CS42L43_ISRC_INT2_EN_MASK				0x00000200
#define CS42L43_ISRC_INT2_EN_SHIFT				9
#define CS42L43_ISRC_INT1_EN_MASK				0x00000100
#define CS42L43_ISRC_INT1_EN_SHIFT				8
#define CS42L43_ISRC_DEC2_EN_MASK				0x00000002
#define CS42L43_ISRC_DEC2_EN_SHIFT				1
#define CS42L43_ISRC_DEC1_EN_MASK				0x00000001
#define CS42L43_ISRC_DEC1_EN_SHIFT				0


#define CS42L43_PLL_MODE_BYPASS_500_MASK			0x00000004
#define CS42L43_PLL_MODE_BYPASS_500_SHIFT			2
#define CS42L43_PLL_MODE_BYPASS_1029_MASK			0x00000002
#define CS42L43_PLL_MODE_BYPASS_1029_SHIFT			1
#define CS42L43_PLL_EN_MASK					0x00000001
#define CS42L43_PLL_EN_SHIFT					0


#define CS42L43_PLL_DIV_INT_MASK				0xFF000000
#define CS42L43_PLL_DIV_INT_SHIFT				24
#define CS42L43_PLL_DIV_FRAC_BYTE2_MASK				0x00FF0000
#define CS42L43_PLL_DIV_FRAC_BYTE2_SHIFT			16
#define CS42L43_PLL_DIV_FRAC_BYTE1_MASK				0x0000FF00
#define CS42L43_PLL_DIV_FRAC_BYTE1_SHIFT			8
#define CS42L43_PLL_DIV_FRAC_BYTE0_MASK				0x000000FF
#define CS42L43_PLL_DIV_FRAC_BYTE0_SHIFT			0


#define CS42L43_PLL_CAL_RATIO_MASK				0x000000FF
#define CS42L43_PLL_CAL_RATIO_SHIFT				0


#define CS42L43_SCLK_DIV_MASK					0x0000000F
#define CS42L43_SCLK_DIV_SHIFT					0


#define CS42L43_SPI_SS_IDLE_DUR_MASK				0x0F000000
#define CS42L43_SPI_SS_IDLE_DUR_SHIFT				24
#define CS42L43_SPI_SS_DELAY_DUR_MASK				0x000F0000
#define CS42L43_SPI_SS_DELAY_DUR_SHIFT				16
#define CS42L43_SPI_THREE_WIRE_MASK				0x00000100
#define CS42L43_SPI_THREE_WIRE_SHIFT				8
#define CS42L43_SPI_DPHA_MASK					0x00000040
#define CS42L43_SPI_DPHA_SHIFT					6
#define CS42L43_SPI_CPHA_MASK					0x00000020
#define CS42L43_SPI_CPHA_SHIFT					5
#define CS42L43_SPI_CPOL_MASK					0x00000010
#define CS42L43_SPI_CPOL_SHIFT					4
#define CS42L43_SPI_SS_SEL_MASK					0x00000007
#define CS42L43_SPI_SS_SEL_SHIFT				0


#define CS42L43_SPI_SS_FRC_MASK					0x00000001
#define CS42L43_SPI_SS_FRC_SHIFT				0


#define CS42L43_SPI_WDT_ENA_MASK				0x00000001
#define CS42L43_SPI_WDT_ENA_SHIFT				0


#define CS42L43_SPI_STALL_ENA_MASK				0x00010000
#define CS42L43_SPI_STALL_ENA_SHIFT				16


#define CS42L43_SPI_ABORT_STS_MASK				0x00000002
#define CS42L43_SPI_ABORT_STS_SHIFT				1
#define CS42L43_SPI_DONE_STS_MASK				0x00000001
#define CS42L43_SPI_DONE_STS_SHIFT				0


#define CS42L43_SPI_RX_DONE_STS_MASK				0x00000010
#define CS42L43_SPI_RX_DONE_STS_SHIFT				4
#define CS42L43_SPI_TX_DONE_STS_MASK				0x00000001
#define CS42L43_SPI_TX_DONE_STS_SHIFT				0


#define CS42L43_SPI_START_MASK					0x00000001
#define CS42L43_SPI_START_SHIFT					0


#define CS42L43_SPI_ABORT_MASK					0x00000001
#define CS42L43_SPI_ABORT_SHIFT					0


#define CS42L43_SPI_WORD_SIZE_MASK				0x00070000
#define CS42L43_SPI_WORD_SIZE_SHIFT				16
#define CS42L43_SPI_CMD_MASK					0x00000003
#define CS42L43_SPI_CMD_SHIFT					0


#define CS42L43_SPI_TX_LENGTH_MASK				0x0000FFFF
#define CS42L43_SPI_TX_LENGTH_SHIFT				0


#define CS42L43_SPI_RX_LENGTH_MASK				0x0000FFFF
#define CS42L43_SPI_RX_LENGTH_SHIFT				0


#define CS42L43_SPI_TX_BLOCK_LENGTH_MASK			0x0000000F
#define CS42L43_SPI_TX_BLOCK_LENGTH_SHIFT			0


#define CS42L43_SPI_RX_BLOCK_LENGTH_MASK			0x0000000F
#define CS42L43_SPI_RX_BLOCK_LENGTH_SHIFT			0


#define CS42L43_SPI_RX_DONE_MASK				0x00000010
#define CS42L43_SPI_RX_DONE_SHIFT				4
#define CS42L43_SPI_TX_DONE_MASK				0x00000001
#define CS42L43_SPI_TX_DONE_SHIFT				0


#define CS42L43_SPI_BUSY_STS_MASK				0x00000100
#define CS42L43_SPI_BUSY_STS_SHIFT				8
#define CS42L43_SPI_RX_REQUEST_MASK				0x00000010
#define CS42L43_SPI_RX_REQUEST_SHIFT				4
#define CS42L43_SPI_TX_REQUEST_MASK				0x00000001
#define CS42L43_SPI_TX_REQUEST_SHIFT				0


#define CS42L43_SPI_TX_BYTE_COUNT_MASK				0x0000FFFF
#define CS42L43_SPI_TX_BYTE_COUNT_SHIFT				0


#define CS42L43_SPI_RX_BYTE_COUNT_MASK				0x0000FFFF
#define CS42L43_SPI_RX_BYTE_COUNT_SHIFT				0


#define CS42L43_SPI_TX_DATA_MASK				0xFFFFFFFF
#define CS42L43_SPI_TX_DATA_SHIFT				0


#define CS42L43_SPI_RX_DATA_MASK				0xFFFFFFFF
#define CS42L43_SPI_RX_DATA_SHIFT				0


#define CS42L43_HP_MSTR_VOL_CTRL_EN_MASK			0x00000008
#define CS42L43_HP_MSTR_VOL_CTRL_EN_SHIFT			3
#define CS42L43_AMP4_INV_MASK					0x00000002
#define CS42L43_AMP4_INV_SHIFT					1
#define CS42L43_AMP3_INV_MASK					0x00000001
#define CS42L43_AMP3_INV_SHIFT					0


#define CS42L43_HP_AUTO_CLAMP_DISABLE_MASK			0x00000002
#define CS42L43_HP_AUTO_CLAMP_DISABLE_SHIFT			1
#define CS42L43_HP_HPF_EN_MASK					0x00000001
#define CS42L43_HP_HPF_EN_SHIFT					0


#define CS42L43_AMP4_PATH_VOL_MASK				0x01FF0000
#define CS42L43_AMP4_PATH_VOL_SHIFT				16
#define CS42L43_AMP3_PATH_VOL_MASK				0x000001FF
#define CS42L43_AMP3_PATH_VOL_SHIFT				0


#define CS42L43_HP_PATH_VOL_RAMP_MASK				0x0003C000
#define CS42L43_HP_PATH_VOL_RAMP_SHIFT				14
#define CS42L43_HP_PATH_VOL_ZC_MASK				0x00002000
#define CS42L43_HP_PATH_VOL_ZC_SHIFT				13
#define CS42L43_HP_PATH_VOL_SFT_MASK				0x00001000
#define CS42L43_HP_PATH_VOL_SFT_SHIFT				12
#define CS42L43_HP_DIG_VOL_RAMP_MASK				0x00000F00
#define CS42L43_HP_DIG_VOL_RAMP_SHIFT				8
#define CS42L43_HP_ANA_VOL_RAMP_MASK				0x0000000F
#define CS42L43_HP_ANA_VOL_RAMP_SHIFT				0


#define CS42L43_AMP3_RES_DET_MASK				0x00000003
#define CS42L43_AMP3_RES_DET_SHIFT				0


#define CS42L43_HPLOAD_DET_EN_MASK				0x00000001
#define CS42L43_HPLOAD_DET_EN_SHIFT				0


#define CS42L43_ADPTPWR_MODE_MASK				0x00000007
#define CS42L43_ADPTPWR_MODE_SHIFT				0


#define CS42L43_WRITE_MODE_MASK					0x00000002
#define CS42L43_WRITE_MODE_SHIFT				1


#define CS42L43_INITIALIZE_DONE_MASK				0x00000001
#define CS42L43_INITIALIZE_DONE_SHIFT				0


#define CS42L43_START_FILTER_MASK				0x00000001
#define CS42L43_START_FILTER_SHIFT				0


#define CS42L43_MUTE_EQ_CH2_MASK				0x00000002
#define CS42L43_MUTE_EQ_CH2_SHIFT				1
#define CS42L43_MUTE_EQ_CH1_MASK				0x00000001
#define CS42L43_MUTE_EQ_CH1_SHIFT				0


#define CS42L43_PLL_LOST_LOCK_INT_MASK				0x00000002
#define CS42L43_PLL_LOST_LOCK_INT_SHIFT				1
#define CS42L43_PLL_READY_INT_MASK				0x00000001
#define CS42L43_PLL_READY_INT_SHIFT				0


#define CS42L43_CONTROL_APPLIED_INT_MASK			0x00000010
#define CS42L43_CONTROL_APPLIED_INT_SHIFT			4
#define CS42L43_CONTROL_WARN_INT_MASK				0x00000008
#define CS42L43_CONTROL_WARN_INT_SHIFT				3
#define CS42L43_PATCH_WARN_INT_MASK				0x00000002
#define CS42L43_PATCH_WARN_INT_SHIFT				1
#define CS42L43_PATCH_APPLIED_INT_MASK				0x00000001
#define CS42L43_PATCH_APPLIED_INT_SHIFT				0


#define CS42L43_HP_STARTUP_DONE_INT_MASK			0x00000800
#define CS42L43_HP_STARTUP_DONE_INT_SHIFT			11
#define CS42L43_HP_SHUTDOWN_DONE_INT_MASK			0x00000400
#define CS42L43_HP_SHUTDOWN_DONE_INT_SHIFT			10
#define CS42L43_HSDET_DONE_INT_MASK				0x00000200
#define CS42L43_HSDET_DONE_INT_SHIFT				9
#define CS42L43_TIPSENSE_UNPLUG_DB_INT_MASK			0x00000080
#define CS42L43_TIPSENSE_UNPLUG_DB_INT_SHIFT			7
#define CS42L43_TIPSENSE_PLUG_DB_INT_MASK			0x00000040
#define CS42L43_TIPSENSE_PLUG_DB_INT_SHIFT			6
#define CS42L43_RINGSENSE_UNPLUG_DB_INT_MASK			0x00000020
#define CS42L43_RINGSENSE_UNPLUG_DB_INT_SHIFT			5
#define CS42L43_RINGSENSE_PLUG_DB_INT_MASK			0x00000010
#define CS42L43_RINGSENSE_PLUG_DB_INT_SHIFT			4
#define CS42L43_TIPSENSE_UNPLUG_PDET_INT_MASK			0x00000008
#define CS42L43_TIPSENSE_UNPLUG_PDET_INT_SHIFT			3
#define CS42L43_TIPSENSE_PLUG_PDET_INT_MASK			0x00000004
#define CS42L43_TIPSENSE_PLUG_PDET_INT_SHIFT			2
#define CS42L43_RINGSENSE_UNPLUG_PDET_INT_MASK			0x00000002
#define CS42L43_RINGSENSE_UNPLUG_PDET_INT_SHIFT			1
#define CS42L43_RINGSENSE_PLUG_PDET_INT_MASK			0x00000001
#define CS42L43_RINGSENSE_PLUG_PDET_INT_SHIFT			0


#define CS42L43_HS2_BIAS_SENSE_INT_MASK				0x00000800
#define CS42L43_HS2_BIAS_SENSE_INT_SHIFT			11
#define CS42L43_HS1_BIAS_SENSE_INT_MASK				0x00000400
#define CS42L43_HS1_BIAS_SENSE_INT_SHIFT			10
#define CS42L43_DC_DETECT1_FALSE_INT_MASK			0x00000080
#define CS42L43_DC_DETECT1_FALSE_INT_SHIFT			7
#define CS42L43_DC_DETECT1_TRUE_INT_MASK			0x00000040
#define CS42L43_DC_DETECT1_TRUE_INT_SHIFT			6
#define CS42L43_HSBIAS_CLAMPED_INT_MASK				0x00000008
#define CS42L43_HSBIAS_CLAMPED_INT_SHIFT			3
#define CS42L43_HS3_4_BIAS_SENSE_INT_MASK			0x00000001
#define CS42L43_HS3_4_BIAS_SENSE_INT_SHIFT			0


#define CS42L43_IRQ_SPI_STALLING_INT_MASK			0x00000004
#define CS42L43_IRQ_SPI_STALLING_INT_SHIFT			2
#define CS42L43_IRQ_SPI_STS_INT_MASK				0x00000002
#define CS42L43_IRQ_SPI_STS_INT_SHIFT				1
#define CS42L43_IRQ_SPI_BLOCK_INT_MASK				0x00000001
#define CS42L43_IRQ_SPI_BLOCK_INT_SHIFT				0


#define CS42L43_SW2SPI_BUF_OVF_UDF_INT_MASK			0x00000001
#define CS42L43_SW2SPI_BUF_OVF_UDF_INT_SHIFT			0


#define CS42L43_AMP2_CLK_STOP_FAULT_INT_MASK			0x00002000
#define CS42L43_AMP2_CLK_STOP_FAULT_INT_SHIFT			13
#define CS42L43_AMP1_CLK_STOP_FAULT_INT_MASK			0x00001000
#define CS42L43_AMP1_CLK_STOP_FAULT_INT_SHIFT			12
#define CS42L43_AMP2_VDDSPK_FAULT_INT_MASK			0x00000800
#define CS42L43_AMP2_VDDSPK_FAULT_INT_SHIFT			11
#define CS42L43_AMP1_VDDSPK_FAULT_INT_MASK			0x00000400
#define CS42L43_AMP1_VDDSPK_FAULT_INT_SHIFT			10
#define CS42L43_AMP2_SHUTDOWN_DONE_INT_MASK			0x00000200
#define CS42L43_AMP2_SHUTDOWN_DONE_INT_SHIFT			9
#define CS42L43_AMP1_SHUTDOWN_DONE_INT_MASK			0x00000100
#define CS42L43_AMP1_SHUTDOWN_DONE_INT_SHIFT			8
#define CS42L43_AMP2_STARTUP_DONE_INT_MASK			0x00000080
#define CS42L43_AMP2_STARTUP_DONE_INT_SHIFT			7
#define CS42L43_AMP1_STARTUP_DONE_INT_MASK			0x00000040
#define CS42L43_AMP1_STARTUP_DONE_INT_SHIFT			6
#define CS42L43_AMP2_THERM_SHDN_INT_MASK			0x00000020
#define CS42L43_AMP2_THERM_SHDN_INT_SHIFT			5
#define CS42L43_AMP1_THERM_SHDN_INT_MASK			0x00000010
#define CS42L43_AMP1_THERM_SHDN_INT_SHIFT			4
#define CS42L43_AMP2_THERM_WARN_INT_MASK			0x00000008
#define CS42L43_AMP2_THERM_WARN_INT_SHIFT			3
#define CS42L43_AMP1_THERM_WARN_INT_MASK			0x00000004
#define CS42L43_AMP1_THERM_WARN_INT_SHIFT			2
#define CS42L43_AMP2_SCDET_INT_MASK				0x00000002
#define CS42L43_AMP2_SCDET_INT_SHIFT				1
#define CS42L43_AMP1_SCDET_INT_MASK				0x00000001
#define CS42L43_AMP1_SCDET_INT_SHIFT				0


#define CS42L43_GPIO3_FALL_INT_MASK				0x00000020
#define CS42L43_GPIO3_FALL_INT_SHIFT				5
#define CS42L43_GPIO3_RISE_INT_MASK				0x00000010
#define CS42L43_GPIO3_RISE_INT_SHIFT				4
#define CS42L43_GPIO2_FALL_INT_MASK				0x00000008
#define CS42L43_GPIO2_FALL_INT_SHIFT				3
#define CS42L43_GPIO2_RISE_INT_MASK				0x00000004
#define CS42L43_GPIO2_RISE_INT_SHIFT				2
#define CS42L43_GPIO1_FALL_INT_MASK				0x00000002
#define CS42L43_GPIO1_FALL_INT_SHIFT				1
#define CS42L43_GPIO1_RISE_INT_MASK				0x00000001
#define CS42L43_GPIO1_RISE_INT_SHIFT				0


#define CS42L43_HP_ILIMIT_INT_MASK				0x00000002
#define CS42L43_HP_ILIMIT_INT_SHIFT				1
#define CS42L43_HP_LOADDET_DONE_INT_MASK			0x00000001
#define CS42L43_HP_LOADDET_DONE_INT_SHIFT			0


#define CS42L43_LOCK_HW_STS_MASK				0x00000002
#define CS42L43_LOCK_HW_STS_SHIFT				1


#define CS42L43_MCU_EN_MASK					0x00000001
#define CS42L43_MCU_EN_SHIFT					0


#define CS42L43_STATUS_SPK_SHUTTER_MUTE_MASK			0x00008000
#define CS42L43_STATUS_SPK_SHUTTER_MUTE_SHIFT			15
#define CS42L43_SPK_SHUTTER_CFG_MASK				0x00000F00
#define CS42L43_SPK_SHUTTER_CFG_SHIFT				8
#define CS42L43_STATUS_MIC_SHUTTER_MUTE_MASK			0x00000080
#define CS42L43_STATUS_MIC_SHUTTER_MUTE_SHIFT			7
#define CS42L43_MIC_SHUTTER_CFG_MASK				0x0000000F
#define CS42L43_MIC_SHUTTER_CFG_SHIFT				0


#define CS42L43_BIOS_SUBMINOR_REV_MASK				0xFF000000
#define CS42L43_BIOS_SUBMINOR_REV_SHIFT				24
#define CS42L43_BIOS_MINOR_REV_MASK				0x00F00000
#define CS42L43_BIOS_MINOR_REV_SHIFT				20
#define CS42L43_BIOS_MAJOR_REV_MASK				0x000F0000
#define CS42L43_BIOS_MAJOR_REV_SHIFT				16
#define CS42L43_FW_SUBMINOR_REV_MASK				0x0000FF00
#define CS42L43_FW_SUBMINOR_REV_SHIFT				8
#define CS42L43_FW_MINOR_REV_MASK				0x000000F0
#define CS42L43_FW_MINOR_REV_SHIFT				4
#define CS42L43_FW_MAJOR_REV_MASK				0x0000000F
#define CS42L43_FW_MAJOR_REV_SHIFT				0


#define CS42L43_FW_PATCH_NEED_CFG_MASK				0x80000000
#define CS42L43_FW_PATCH_NEED_CFG_SHIFT				31


#define CS42L43_FW_MM_CTRL_MCU_SEL_MASK				0x00000001
#define CS42L43_FW_MM_CTRL_MCU_SEL_SHIFT			0


#define CS42L43_FW_MISSION_CTRL_MM_MCU_CFG_DISABLE_VAL		0xF05AA50F

#endif 
