/* SPDX-License-Identifier: GPL-2.0 */


#ifndef MFD_KHADAS_MCU_H
#define MFD_KHADAS_MCU_H

#define KHADAS_MCU_PASSWD_VEN_0_REG		0x00 
#define KHADAS_MCU_PASSWD_VEN_1_REG		0x01 
#define KHADAS_MCU_PASSWD_VEN_2_REG		0x02 
#define KHADAS_MCU_PASSWD_VEN_3_REG		0x03 
#define KHADAS_MCU_PASSWD_VEN_4_REG		0x04 
#define KHADAS_MCU_PASSWD_VEN_5_REG		0x05 
#define KHADAS_MCU_MAC_0_REG			0x06 
#define KHADAS_MCU_MAC_1_REG			0x07 
#define KHADAS_MCU_MAC_2_REG			0x08 
#define KHADAS_MCU_MAC_3_REG			0x09 
#define KHADAS_MCU_MAC_4_REG			0x0a 
#define KHADAS_MCU_MAC_5_REG			0x0b 
#define KHADAS_MCU_USID_0_REG			0x0c 
#define KHADAS_MCU_USID_1_REG			0x0d 
#define KHADAS_MCU_USID_2_REG			0x0e 
#define KHADAS_MCU_USID_3_REG			0x0f 
#define KHADAS_MCU_USID_4_REG			0x10 
#define KHADAS_MCU_USID_5_REG			0x11 
#define KHADAS_MCU_VERSION_0_REG		0x12 
#define KHADAS_MCU_VERSION_1_REG		0x13 
#define KHADAS_MCU_DEVICE_NO_0_REG		0x14 
#define KHADAS_MCU_DEVICE_NO_1_REG		0x15 
#define KHADAS_MCU_FACTORY_TEST_REG		0x16 
#define KHADAS_MCU_BOOT_MODE_REG		0x20 
#define KHADAS_MCU_BOOT_EN_WOL_REG		0x21 
#define KHADAS_MCU_BOOT_EN_RTC_REG		0x22 
#define KHADAS_MCU_BOOT_EN_EXP_REG		0x23 
#define KHADAS_MCU_BOOT_EN_IR_REG		0x24 
#define KHADAS_MCU_BOOT_EN_DCIN_REG		0x25 
#define KHADAS_MCU_BOOT_EN_KEY_REG		0x26 
#define KHADAS_MCU_KEY_MODE_REG			0x27 
#define KHADAS_MCU_LED_MODE_ON_REG		0x28 
#define KHADAS_MCU_LED_MODE_OFF_REG		0x29 
#define KHADAS_MCU_SHUTDOWN_NORMAL_REG		0x2c 
#define KHADAS_MCU_MAC_SWITCH_REG		0x2d 
#define KHADAS_MCU_MCU_SLEEP_MODE_REG		0x2e 
#define KHADAS_MCU_IR_CODE1_0_REG		0x2f 
#define KHADAS_MCU_IR_CODE1_1_REG		0x30 
#define KHADAS_MCU_IR_CODE1_2_REG		0x31 
#define KHADAS_MCU_IR_CODE1_3_REG		0x32 
#define KHADAS_MCU_USB_PCIE_SWITCH_REG		0x33 
#define KHADAS_MCU_IR_CODE2_0_REG		0x34 
#define KHADAS_MCU_IR_CODE2_1_REG		0x35 
#define KHADAS_MCU_IR_CODE2_2_REG		0x36 
#define KHADAS_MCU_IR_CODE2_3_REG		0x37 
#define KHADAS_MCU_PASSWD_USER_0_REG		0x40 
#define KHADAS_MCU_PASSWD_USER_1_REG		0x41 
#define KHADAS_MCU_PASSWD_USER_2_REG		0x42 
#define KHADAS_MCU_PASSWD_USER_3_REG		0x43 
#define KHADAS_MCU_PASSWD_USER_4_REG		0x44 
#define KHADAS_MCU_PASSWD_USER_5_REG		0x45 
#define KHADAS_MCU_USER_DATA_0_REG		0x46 
#define KHADAS_MCU_PWR_OFF_CMD_REG		0x80 
#define KHADAS_MCU_PASSWD_START_REG		0x81 
#define KHADAS_MCU_CHECK_VEN_PASSWD_REG		0x82 
#define KHADAS_MCU_CHECK_USER_PASSWD_REG	0x83 
#define KHADAS_MCU_SHUTDOWN_NORMAL_STATUS_REG	0x86 
#define KHADAS_MCU_WOL_INIT_START_REG		0x87 
#define KHADAS_MCU_CMD_FAN_STATUS_CTRL_REG	0x88 

enum {
	KHADAS_BOARD_VIM1 = 0x1,
	KHADAS_BOARD_VIM2,
	KHADAS_BOARD_VIM3,
	KHADAS_BOARD_EDGE = 0x11,
	KHADAS_BOARD_EDGE_V,
};


struct khadas_mcu {
	struct device *dev;
	struct regmap *regmap;
};

#endif 
