/* SPDX-License-Identifier: GPL-2.0 */


#ifndef __MFD_MT6359P_REGISTERS_H__
#define __MFD_MT6359P_REGISTERS_H__

#define MT6359P_CHIP_VER 0x5930


#define MT6359P_HWCID                         0x8
#define MT6359P_TOP_TRAP                      0x50
#define MT6359P_TOP_TMA_KEY                   0x3a8
#define MT6359P_BUCK_VCORE_ELR_NUM            0x152a
#define MT6359P_BUCK_VCORE_ELR0               0x152c
#define MT6359P_BUCK_VGPU11_SSHUB_CON0        0x15aa
#define MT6359P_BUCK_VGPU11_ELR0              0x15b4
#define MT6359P_LDO_VSRAM_PROC1_ELR           0x1b44
#define MT6359P_LDO_VSRAM_PROC2_ELR           0x1b46
#define MT6359P_LDO_VSRAM_OTHERS_ELR          0x1b48
#define MT6359P_LDO_VSRAM_MD_ELR              0x1b4a
#define MT6359P_LDO_VEMC_ELR_0                0x1b4c
#define MT6359P_LDO_VFE28_CON0                0x1b88
#define MT6359P_LDO_VFE28_MON                 0x1b8c
#define MT6359P_LDO_VXO22_CON0                0x1b9a
#define MT6359P_LDO_VXO22_MON                 0x1b9e
#define MT6359P_LDO_VRF18_CON0                0x1bac
#define MT6359P_LDO_VRF18_MON                 0x1bb0
#define MT6359P_LDO_VRF12_CON0                0x1bbe
#define MT6359P_LDO_VRF12_MON                 0x1bc2
#define MT6359P_LDO_VEFUSE_CON0               0x1bd0
#define MT6359P_LDO_VEFUSE_MON                0x1bd4
#define MT6359P_LDO_VCN33_1_CON0              0x1be2
#define MT6359P_LDO_VCN33_1_MON               0x1be6
#define MT6359P_LDO_VCN33_1_MULTI_SW          0x1bf4
#define MT6359P_LDO_VCN33_2_CON0              0x1c08
#define MT6359P_LDO_VCN33_2_MON               0x1c0c
#define MT6359P_LDO_VCN33_2_MULTI_SW          0x1c1a
#define MT6359P_LDO_VCN13_CON0                0x1c1c
#define MT6359P_LDO_VCN13_MON                 0x1c20
#define MT6359P_LDO_VCN18_CON0                0x1c2e
#define MT6359P_LDO_VCN18_MON                 0x1c32
#define MT6359P_LDO_VA09_CON0                 0x1c40
#define MT6359P_LDO_VA09_MON                  0x1c44
#define MT6359P_LDO_VCAMIO_CON0               0x1c52
#define MT6359P_LDO_VCAMIO_MON                0x1c56
#define MT6359P_LDO_VA12_CON0                 0x1c64
#define MT6359P_LDO_VA12_MON                  0x1c68
#define MT6359P_LDO_VAUX18_CON0               0x1c88
#define MT6359P_LDO_VAUX18_MON                0x1c8c
#define MT6359P_LDO_VAUD18_CON0               0x1c9a
#define MT6359P_LDO_VAUD18_MON                0x1c9e
#define MT6359P_LDO_VIO18_CON0                0x1cac
#define MT6359P_LDO_VIO18_MON                 0x1cb0
#define MT6359P_LDO_VEMC_CON0                 0x1cbe
#define MT6359P_LDO_VEMC_MON                  0x1cc2
#define MT6359P_LDO_VSIM1_CON0                0x1cd0
#define MT6359P_LDO_VSIM1_MON                 0x1cd4
#define MT6359P_LDO_VSIM2_CON0                0x1ce2
#define MT6359P_LDO_VSIM2_MON                 0x1ce6
#define MT6359P_LDO_VUSB_CON0                 0x1d08
#define MT6359P_LDO_VUSB_MON                  0x1d0c
#define MT6359P_LDO_VUSB_MULTI_SW             0x1d1a
#define MT6359P_LDO_VRFCK_CON0                0x1d1c
#define MT6359P_LDO_VRFCK_MON                 0x1d20
#define MT6359P_LDO_VBBCK_CON0                0x1d2e
#define MT6359P_LDO_VBBCK_MON                 0x1d32
#define MT6359P_LDO_VBIF28_CON0               0x1d40
#define MT6359P_LDO_VBIF28_MON                0x1d44
#define MT6359P_LDO_VIBR_CON0                 0x1d52
#define MT6359P_LDO_VIBR_MON                  0x1d56
#define MT6359P_LDO_VIO28_CON0                0x1d64
#define MT6359P_LDO_VIO28_MON                 0x1d68
#define MT6359P_LDO_VM18_CON0                 0x1d88
#define MT6359P_LDO_VM18_MON                  0x1d8c
#define MT6359P_LDO_VUFS_CON0                 0x1d9a
#define MT6359P_LDO_VUFS_MON                  0x1d9e
#define MT6359P_LDO_VSRAM_PROC1_CON0          0x1e88
#define MT6359P_LDO_VSRAM_PROC1_MON           0x1e8c
#define MT6359P_LDO_VSRAM_PROC1_VOSEL1        0x1e90
#define MT6359P_LDO_VSRAM_PROC2_CON0          0x1ea8
#define MT6359P_LDO_VSRAM_PROC2_MON           0x1eac
#define MT6359P_LDO_VSRAM_PROC2_VOSEL1        0x1eb0
#define MT6359P_LDO_VSRAM_OTHERS_CON0         0x1f08
#define MT6359P_LDO_VSRAM_OTHERS_MON          0x1f0c
#define MT6359P_LDO_VSRAM_OTHERS_VOSEL1       0x1f10
#define MT6359P_LDO_VSRAM_OTHERS_SSHUB        0x1f28
#define MT6359P_LDO_VSRAM_MD_CON0             0x1f2e
#define MT6359P_LDO_VSRAM_MD_MON              0x1f32
#define MT6359P_LDO_VSRAM_MD_VOSEL1           0x1f36
#define MT6359P_VFE28_ANA_CON0                0x1f88
#define MT6359P_VAUX18_ANA_CON0               0x1f8c
#define MT6359P_VUSB_ANA_CON0                 0x1f90
#define MT6359P_VBIF28_ANA_CON0               0x1f94
#define MT6359P_VCN33_1_ANA_CON0              0x1f98
#define MT6359P_VCN33_2_ANA_CON0              0x1f9c
#define MT6359P_VEMC_ANA_CON0                 0x1fa0
#define MT6359P_VSIM1_ANA_CON0                0x1fa2
#define MT6359P_VSIM2_ANA_CON0                0x1fa6
#define MT6359P_VIO28_ANA_CON0                0x1faa
#define MT6359P_VIBR_ANA_CON0                 0x1fae
#define MT6359P_VFE28_ELR_4                   0x1fc0
#define MT6359P_VRF18_ANA_CON0                0x2008
#define MT6359P_VEFUSE_ANA_CON0               0x200c
#define MT6359P_VCN18_ANA_CON0                0x2010
#define MT6359P_VCAMIO_ANA_CON0               0x2014
#define MT6359P_VAUD18_ANA_CON0               0x2018
#define MT6359P_VIO18_ANA_CON0                0x201c
#define MT6359P_VM18_ANA_CON0                 0x2020
#define MT6359P_VUFS_ANA_CON0                 0x2024
#define MT6359P_VRF12_ANA_CON0                0x202a
#define MT6359P_VCN13_ANA_CON0                0x202e
#define MT6359P_VA09_ANA_CON0                 0x2032
#define MT6359P_VRF18_ELR_3                   0x204e
#define MT6359P_VXO22_ANA_CON0                0x2088
#define MT6359P_VRFCK_ANA_CON0                0x208c
#define MT6359P_VBBCK_ANA_CON0                0x2096

#define MT6359P_RG_BUCK_VCORE_VOSEL_ADDR         MT6359P_BUCK_VCORE_ELR0
#define MT6359P_RG_BUCK_VGPU11_SSHUB_EN_ADDR     MT6359P_BUCK_VGPU11_SSHUB_CON0
#define MT6359P_RG_BUCK_VGPU11_VOSEL_ADDR        MT6359P_BUCK_VGPU11_ELR0
#define MT6359P_RG_BUCK_VGPU11_SSHUB_VOSEL_ADDR  MT6359P_BUCK_VGPU11_SSHUB_CON0
#define MT6359P_RG_BUCK_VGPU11_SSHUB_VOSEL_MASK  0x7F
#define MT6359P_RG_BUCK_VGPU11_SSHUB_VOSEL_SHIFT 4
#define MT6359P_RG_LDO_VSRAM_PROC1_VOSEL_ADDR    MT6359P_LDO_VSRAM_PROC1_ELR
#define MT6359P_RG_LDO_VSRAM_PROC2_VOSEL_ADDR    MT6359P_LDO_VSRAM_PROC2_ELR
#define MT6359P_RG_LDO_VSRAM_OTHERS_VOSEL_ADDR   MT6359P_LDO_VSRAM_OTHERS_ELR
#define MT6359P_RG_LDO_VSRAM_MD_VOSEL_ADDR       MT6359P_LDO_VSRAM_MD_ELR
#define MT6359P_RG_LDO_VEMC_VOSEL_0_ADDR         MT6359P_LDO_VEMC_ELR_0
#define MT6359P_RG_LDO_VEMC_VOSEL_0_MASK         0xF
#define MT6359P_RG_LDO_VEMC_VOSEL_0_SHIFT        0
#define MT6359P_RG_LDO_VFE28_EN_ADDR             MT6359P_LDO_VFE28_CON0
#define MT6359P_DA_VFE28_B_EN_ADDR               MT6359P_LDO_VFE28_MON
#define MT6359P_RG_LDO_VXO22_EN_ADDR             MT6359P_LDO_VXO22_CON0
#define MT6359P_RG_LDO_VXO22_EN_SHIFT            0
#define MT6359P_DA_VXO22_B_EN_ADDR               MT6359P_LDO_VXO22_MON
#define MT6359P_RG_LDO_VRF18_EN_ADDR             MT6359P_LDO_VRF18_CON0
#define MT6359P_RG_LDO_VRF18_EN_SHIFT            0
#define MT6359P_DA_VRF18_B_EN_ADDR               MT6359P_LDO_VRF18_MON
#define MT6359P_RG_LDO_VRF12_EN_ADDR             MT6359P_LDO_VRF12_CON0
#define MT6359P_RG_LDO_VRF12_EN_SHIFT            0
#define MT6359P_DA_VRF12_B_EN_ADDR               MT6359P_LDO_VRF12_MON
#define MT6359P_RG_LDO_VEFUSE_EN_ADDR            MT6359P_LDO_VEFUSE_CON0
#define MT6359P_RG_LDO_VEFUSE_EN_SHIFT           0
#define MT6359P_DA_VEFUSE_B_EN_ADDR              MT6359P_LDO_VEFUSE_MON
#define MT6359P_RG_LDO_VCN33_1_EN_0_ADDR         MT6359P_LDO_VCN33_1_CON0
#define MT6359P_DA_VCN33_1_B_EN_ADDR             MT6359P_LDO_VCN33_1_MON
#define MT6359P_RG_LDO_VCN33_1_EN_1_ADDR         MT6359P_LDO_VCN33_1_MULTI_SW
#define MT6359P_RG_LDO_VCN33_1_EN_1_SHIFT        15
#define MT6359P_RG_LDO_VCN33_2_EN_0_ADDR         MT6359P_LDO_VCN33_2_CON0
#define MT6359P_RG_LDO_VCN33_2_EN_0_SHIFT        0
#define MT6359P_DA_VCN33_2_B_EN_ADDR             MT6359P_LDO_VCN33_2_MON
#define MT6359P_RG_LDO_VCN33_2_EN_1_ADDR         MT6359P_LDO_VCN33_2_MULTI_SW
#define MT6359P_RG_LDO_VCN13_EN_ADDR             MT6359P_LDO_VCN13_CON0
#define MT6359P_RG_LDO_VCN13_EN_SHIFT            0
#define MT6359P_DA_VCN13_B_EN_ADDR               MT6359P_LDO_VCN13_MON
#define MT6359P_RG_LDO_VCN18_EN_ADDR             MT6359P_LDO_VCN18_CON0
#define MT6359P_DA_VCN18_B_EN_ADDR               MT6359P_LDO_VCN18_MON
#define MT6359P_RG_LDO_VA09_EN_ADDR              MT6359P_LDO_VA09_CON0
#define MT6359P_RG_LDO_VA09_EN_SHIFT             0
#define MT6359P_DA_VA09_B_EN_ADDR                MT6359P_LDO_VA09_MON
#define MT6359P_RG_LDO_VCAMIO_EN_ADDR            MT6359P_LDO_VCAMIO_CON0
#define MT6359P_RG_LDO_VCAMIO_EN_SHIFT           0
#define MT6359P_DA_VCAMIO_B_EN_ADDR              MT6359P_LDO_VCAMIO_MON
#define MT6359P_RG_LDO_VA12_EN_ADDR              MT6359P_LDO_VA12_CON0
#define MT6359P_RG_LDO_VA12_EN_SHIFT             0
#define MT6359P_DA_VA12_B_EN_ADDR                MT6359P_LDO_VA12_MON
#define MT6359P_RG_LDO_VAUX18_EN_ADDR            MT6359P_LDO_VAUX18_CON0
#define MT6359P_DA_VAUX18_B_EN_ADDR              MT6359P_LDO_VAUX18_MON
#define MT6359P_RG_LDO_VAUD18_EN_ADDR            MT6359P_LDO_VAUD18_CON0
#define MT6359P_DA_VAUD18_B_EN_ADDR              MT6359P_LDO_VAUD18_MON
#define MT6359P_RG_LDO_VIO18_EN_ADDR             MT6359P_LDO_VIO18_CON0
#define MT6359P_RG_LDO_VIO18_EN_SHIFT            0
#define MT6359P_DA_VIO18_B_EN_ADDR               MT6359P_LDO_VIO18_MON
#define MT6359P_RG_LDO_VEMC_EN_ADDR              MT6359P_LDO_VEMC_CON0
#define MT6359P_RG_LDO_VEMC_EN_SHIFT             0
#define MT6359P_DA_VEMC_B_EN_ADDR                MT6359P_LDO_VEMC_MON
#define MT6359P_RG_LDO_VSIM1_EN_ADDR             MT6359P_LDO_VSIM1_CON0
#define MT6359P_RG_LDO_VSIM1_EN_SHIFT            0
#define MT6359P_DA_VSIM1_B_EN_ADDR               MT6359P_LDO_VSIM1_MON
#define MT6359P_RG_LDO_VSIM2_EN_ADDR             MT6359P_LDO_VSIM2_CON0
#define MT6359P_RG_LDO_VSIM2_EN_SHIFT            0
#define MT6359P_DA_VSIM2_B_EN_ADDR               MT6359P_LDO_VSIM2_MON
#define MT6359P_RG_LDO_VUSB_EN_0_ADDR            MT6359P_LDO_VUSB_CON0
#define MT6359P_DA_VUSB_B_EN_ADDR                MT6359P_LDO_VUSB_MON
#define MT6359P_RG_LDO_VUSB_EN_1_ADDR            MT6359P_LDO_VUSB_MULTI_SW
#define MT6359P_RG_LDO_VRFCK_EN_ADDR             MT6359P_LDO_VRFCK_CON0
#define MT6359P_RG_LDO_VRFCK_EN_SHIFT            0
#define MT6359P_DA_VRFCK_B_EN_ADDR               MT6359P_LDO_VRFCK_MON
#define MT6359P_RG_LDO_VBBCK_EN_ADDR             MT6359P_LDO_VBBCK_CON0
#define MT6359P_RG_LDO_VBBCK_EN_SHIFT            0
#define MT6359P_DA_VBBCK_B_EN_ADDR               MT6359P_LDO_VBBCK_MON
#define MT6359P_RG_LDO_VBIF28_EN_ADDR            MT6359P_LDO_VBIF28_CON0
#define MT6359P_DA_VBIF28_B_EN_ADDR              MT6359P_LDO_VBIF28_MON
#define MT6359P_RG_LDO_VIBR_EN_ADDR              MT6359P_LDO_VIBR_CON0
#define MT6359P_RG_LDO_VIBR_EN_SHIFT             0
#define MT6359P_DA_VIBR_B_EN_ADDR                MT6359P_LDO_VIBR_MON
#define MT6359P_RG_LDO_VIO28_EN_ADDR             MT6359P_LDO_VIO28_CON0
#define MT6359P_RG_LDO_VIO28_EN_SHIFT            0
#define MT6359P_DA_VIO28_B_EN_ADDR               MT6359P_LDO_VIO28_MON
#define MT6359P_RG_LDO_VM18_EN_ADDR              MT6359P_LDO_VM18_CON0
#define MT6359P_RG_LDO_VM18_EN_SHIFT             0
#define MT6359P_DA_VM18_B_EN_ADDR                MT6359P_LDO_VM18_MON
#define MT6359P_RG_LDO_VUFS_EN_ADDR              MT6359P_LDO_VUFS_CON0
#define MT6359P_RG_LDO_VUFS_EN_SHIFT             0
#define MT6359P_DA_VUFS_B_EN_ADDR                MT6359P_LDO_VUFS_MON
#define MT6359P_RG_LDO_VSRAM_PROC1_EN_ADDR       MT6359P_LDO_VSRAM_PROC1_CON0
#define MT6359P_DA_VSRAM_PROC1_B_EN_ADDR         MT6359P_LDO_VSRAM_PROC1_MON
#define MT6359P_DA_VSRAM_PROC1_VOSEL_ADDR        MT6359P_LDO_VSRAM_PROC1_VOSEL1
#define MT6359P_RG_LDO_VSRAM_PROC2_EN_ADDR       MT6359P_LDO_VSRAM_PROC2_CON0
#define MT6359P_DA_VSRAM_PROC2_B_EN_ADDR         MT6359P_LDO_VSRAM_PROC2_MON
#define MT6359P_DA_VSRAM_PROC2_VOSEL_ADDR        MT6359P_LDO_VSRAM_PROC2_VOSEL1
#define MT6359P_RG_LDO_VSRAM_OTHERS_EN_ADDR      MT6359P_LDO_VSRAM_OTHERS_CON0
#define MT6359P_DA_VSRAM_OTHERS_B_EN_ADDR        MT6359P_LDO_VSRAM_OTHERS_MON
#define MT6359P_DA_VSRAM_OTHERS_VOSEL_ADDR       MT6359P_LDO_VSRAM_OTHERS_VOSEL1
#define MT6359P_RG_LDO_VSRAM_OTHERS_SSHUB_EN_ADDR    MT6359P_LDO_VSRAM_OTHERS_SSHUB
#define MT6359P_RG_LDO_VSRAM_OTHERS_SSHUB_VOSEL_ADDR MT6359P_LDO_VSRAM_OTHERS_SSHUB
#define MT6359P_RG_LDO_VSRAM_MD_EN_ADDR          MT6359P_LDO_VSRAM_MD_CON0
#define MT6359P_DA_VSRAM_MD_B_EN_ADDR            MT6359P_LDO_VSRAM_MD_MON
#define MT6359P_DA_VSRAM_MD_VOSEL_ADDR           MT6359P_LDO_VSRAM_MD_VOSEL1
#define MT6359P_RG_VCN33_1_VOSEL_ADDR            MT6359P_VCN33_1_ANA_CON0
#define MT6359P_RG_VCN33_2_VOSEL_ADDR            MT6359P_VCN33_2_ANA_CON0
#define MT6359P_RG_VEMC_VOSEL_ADDR               MT6359P_VEMC_ANA_CON0
#define MT6359P_RG_VSIM1_VOSEL_ADDR              MT6359P_VSIM1_ANA_CON0
#define MT6359P_RG_VSIM2_VOSEL_ADDR              MT6359P_VSIM2_ANA_CON0
#define MT6359P_RG_VIO28_VOSEL_ADDR              MT6359P_VIO28_ANA_CON0
#define MT6359P_RG_VIBR_VOSEL_ADDR               MT6359P_VIBR_ANA_CON0
#define MT6359P_RG_VRF18_VOSEL_ADDR              MT6359P_VRF18_ANA_CON0
#define MT6359P_RG_VEFUSE_VOSEL_ADDR             MT6359P_VEFUSE_ANA_CON0
#define MT6359P_RG_VCAMIO_VOSEL_ADDR             MT6359P_VCAMIO_ANA_CON0
#define MT6359P_RG_VIO18_VOSEL_ADDR              MT6359P_VIO18_ANA_CON0
#define MT6359P_RG_VM18_VOSEL_ADDR               MT6359P_VM18_ANA_CON0
#define MT6359P_RG_VUFS_VOSEL_ADDR               MT6359P_VUFS_ANA_CON0
#define MT6359P_RG_VRF12_VOSEL_ADDR              MT6359P_VRF12_ANA_CON0
#define MT6359P_RG_VCN13_VOSEL_ADDR              MT6359P_VCN13_ANA_CON0
#define MT6359P_RG_VA09_VOSEL_ADDR               MT6359P_VRF18_ELR_3
#define MT6359P_RG_VA12_VOSEL_ADDR               MT6359P_VFE28_ELR_4
#define MT6359P_RG_VXO22_VOSEL_ADDR              MT6359P_VXO22_ANA_CON0
#define MT6359P_RG_VRFCK_VOSEL_ADDR              MT6359P_VRFCK_ANA_CON0
#define MT6359P_RG_VBBCK_VOSEL_ADDR              MT6359P_VBBCK_ANA_CON0
#define MT6359P_RG_VBBCK_VOSEL_MASK              0xF
#define MT6359P_RG_VBBCK_VOSEL_SHIFT             4
#define MT6359P_VM_MODE_ADDR                     MT6359P_TOP_TRAP
#define MT6359P_TMA_KEY_ADDR                     MT6359P_TOP_TMA_KEY

#define TMA_KEY 0x9CA6

#endif 
