/* SPDX-License-Identifier: GPL-2.0-or-later */


#ifndef __MFD_BD96801_H__
#define __MFD_BD96801_H__

#define BD96801_REG_SSCG_CTRL		0x09
#define BD96801_REG_SHD_INTB            0x20
#define BD96801_LDO5_VOL_LVL_REG	0x2c
#define BD96801_LDO6_VOL_LVL_REG	0x2d
#define BD96801_LDO7_VOL_LVL_REG	0x2e
#define BD96801_REG_BUCK_OVP		0x30
#define BD96801_REG_BUCK_OVD		0x35
#define BD96801_REG_LDO_OVP		0x31
#define BD96801_REG_LDO_OVD		0x36
#define BD96801_REG_BOOT_OVERTIME	0x3a
#define BD96801_REG_WD_TMO		0x40
#define BD96801_REG_WD_CONF		0x41
#define BD96801_REG_WD_FEED		0x42
#define BD96801_REG_WD_FAILCOUNT	0x43
#define BD96801_REG_WD_ASK		0x46
#define BD96801_REG_WD_STATUS		0x4a
#define BD96801_REG_PMIC_STATE		0x4f
#define BD96801_REG_EXT_STATE		0x50

#define BD96801_STATE_STBY		0x09

#define BD96801_LOCK_REG		0x04
#define BD96801_UNLOCK			0x9d
#define BD96801_LOCK			0x00


#define BD96801_REG_INT_MAIN		0x51


#define BD96801_REG_INT_SYS_ERRB1	0x52
#define BD96801_REG_INT_SYS_INTB	0x5c
#define BD96801_REG_INT_LDO7_INTB	0x63


#define BD96801_REG_MASK_SYS_INTB	0x73
#define BD96801_REG_MASK_SYS_ERRB	0x69

#define BD96801_MAX_REGISTER		0x7a

#define BD96801_OTP_ERR_MASK		BIT(0)
#define BD96801_DBIST_ERR_MASK		BIT(1)
#define BD96801_EEP_ERR_MASK		BIT(2)
#define BD96801_ABIST_ERR_MASK		BIT(3)
#define BD96801_PRSTB_ERR_MASK		BIT(4)
#define BD96801_DRMOS1_ERR_MASK		BIT(5)
#define BD96801_DRMOS2_ERR_MASK		BIT(6)
#define BD96801_SLAVE_ERR_MASK		BIT(7)
#define BD96801_VREF_ERR_MASK		BIT(0)
#define BD96801_TSD_ERR_MASK		BIT(1)
#define BD96801_UVLO_ERR_MASK		BIT(2)
#define BD96801_OVLO_ERR_MASK		BIT(3)
#define BD96801_OSC_ERR_MASK		BIT(4)
#define BD96801_PON_ERR_MASK		BIT(5)
#define BD96801_POFF_ERR_MASK		BIT(6)
#define BD96801_CMD_SHDN_ERR_MASK	BIT(7)
#define BD96801_INT_PRSTB_WDT_ERR_MASK	BIT(0)
#define BD96801_INT_CHIP_IF_ERR_MASK	BIT(3)
#define BD96801_INT_SHDN_ERR_MASK	BIT(7)
#define BD96801_OUT_PVIN_ERR_MASK	BIT(0)
#define BD96801_OUT_OVP_ERR_MASK	BIT(1)
#define BD96801_OUT_UVP_ERR_MASK	BIT(2)
#define BD96801_OUT_SHDN_ERR_MASK	BIT(7)


enum {
	
	BD96801_OTP_ERR_STAT,
	BD96801_DBIST_ERR_STAT,
	BD96801_EEP_ERR_STAT,
	BD96801_ABIST_ERR_STAT,
	BD96801_PRSTB_ERR_STAT,
	BD96801_DRMOS1_ERR_STAT,
	BD96801_DRMOS2_ERR_STAT,
	BD96801_SLAVE_ERR_STAT,
	BD96801_VREF_ERR_STAT,
	BD96801_TSD_ERR_STAT,
	BD96801_UVLO_ERR_STAT,
	BD96801_OVLO_ERR_STAT,
	BD96801_OSC_ERR_STAT,
	BD96801_PON_ERR_STAT,
	BD96801_POFF_ERR_STAT,
	BD96801_CMD_SHDN_ERR_STAT,
	BD96801_INT_PRSTB_WDT_ERR,
	BD96801_INT_CHIP_IF_ERR,
	BD96801_INT_SHDN_ERR_STAT,

	
	BD96801_BUCK1_PVIN_ERR_STAT,
	BD96801_BUCK1_OVP_ERR_STAT,
	BD96801_BUCK1_UVP_ERR_STAT,
	BD96801_BUCK1_SHDN_ERR_STAT,

	
	BD96801_BUCK2_PVIN_ERR_STAT,
	BD96801_BUCK2_OVP_ERR_STAT,
	BD96801_BUCK2_UVP_ERR_STAT,
	BD96801_BUCK2_SHDN_ERR_STAT,

	
	BD96801_BUCK3_PVIN_ERR_STAT,
	BD96801_BUCK3_OVP_ERR_STAT,
	BD96801_BUCK3_UVP_ERR_STAT,
	BD96801_BUCK3_SHDN_ERR_STAT,

	
	BD96801_BUCK4_PVIN_ERR_STAT,
	BD96801_BUCK4_OVP_ERR_STAT,
	BD96801_BUCK4_UVP_ERR_STAT,
	BD96801_BUCK4_SHDN_ERR_STAT,

	
	BD96801_LDO5_PVIN_ERR_STAT,
	BD96801_LDO5_OVP_ERR_STAT,
	BD96801_LDO5_UVP_ERR_STAT,
	BD96801_LDO5_SHDN_ERR_STAT,

	
	BD96801_LDO6_PVIN_ERR_STAT,
	BD96801_LDO6_OVP_ERR_STAT,
	BD96801_LDO6_UVP_ERR_STAT,
	BD96801_LDO6_SHDN_ERR_STAT,

	
	BD96801_LDO7_PVIN_ERR_STAT,
	BD96801_LDO7_OVP_ERR_STAT,
	BD96801_LDO7_UVP_ERR_STAT,
	BD96801_LDO7_SHDN_ERR_STAT,
};


enum {
	
	BD96801_TW_STAT,
	BD96801_WDT_ERR_STAT,
	BD96801_I2C_ERR_STAT,
	BD96801_CHIP_IF_ERR_STAT,

	
	BD96801_BUCK1_OCPH_STAT,
	BD96801_BUCK1_OCPL_STAT,
	BD96801_BUCK1_OCPN_STAT,
	BD96801_BUCK1_OVD_STAT,
	BD96801_BUCK1_UVD_STAT,
	BD96801_BUCK1_TW_CH_STAT,

	
	BD96801_BUCK2_OCPH_STAT,
	BD96801_BUCK2_OCPL_STAT,
	BD96801_BUCK2_OCPN_STAT,
	BD96801_BUCK2_OVD_STAT,
	BD96801_BUCK2_UVD_STAT,
	BD96801_BUCK2_TW_CH_STAT,

	
	BD96801_BUCK3_OCPH_STAT,
	BD96801_BUCK3_OCPL_STAT,
	BD96801_BUCK3_OCPN_STAT,
	BD96801_BUCK3_OVD_STAT,
	BD96801_BUCK3_UVD_STAT,
	BD96801_BUCK3_TW_CH_STAT,

	
	BD96801_BUCK4_OCPH_STAT,
	BD96801_BUCK4_OCPL_STAT,
	BD96801_BUCK4_OCPN_STAT,
	BD96801_BUCK4_OVD_STAT,
	BD96801_BUCK4_UVD_STAT,
	BD96801_BUCK4_TW_CH_STAT,

	
	BD96801_LDO5_OCPH_STAT, 
	BD96801_LDO5_OVD_STAT,	
	BD96801_LDO5_UVD_STAT,  

	
	BD96801_LDO6_OCPH_STAT, 
	BD96801_LDO6_OVD_STAT,	
	BD96801_LDO6_UVD_STAT,  

	
	BD96801_LDO7_OCPH_STAT, 
	BD96801_LDO7_OVD_STAT,	
	BD96801_LDO7_UVD_STAT,  
};


#define BD96801_TW_STAT_MASK		BIT(0)
#define BD96801_WDT_ERR_STAT_MASK	BIT(1)
#define BD96801_I2C_ERR_STAT_MASK	BIT(2)
#define BD96801_CHIP_IF_ERR_STAT_MASK	BIT(3)

#define BD96801_BUCK_OCPH_STAT_MASK	BIT(0)
#define BD96801_BUCK_OCPL_STAT_MASK	BIT(1)
#define BD96801_BUCK_OCPN_STAT_MASK	BIT(2)
#define BD96801_BUCK_OVD_STAT_MASK	BIT(3)
#define BD96801_BUCK_UVD_STAT_MASK	BIT(4)
#define BD96801_BUCK_TW_CH_STAT_MASK	BIT(5)

#define BD96801_LDO_OCPH_STAT_MASK	BIT(0)
#define BD96801_LDO_OVD_STAT_MASK	BIT(3)
#define BD96801_LDO_UVD_STAT_MASK	BIT(4)

#endif
