/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef __RT5033_PRIVATE_H__
#define __RT5033_PRIVATE_H__

enum rt5033_reg {
	RT5033_REG_CHG_STAT		= 0x00,
	RT5033_REG_CHG_CTRL1		= 0x01,
	RT5033_REG_CHG_CTRL2		= 0x02,
	RT5033_REG_DEVICE_ID		= 0x03,
	RT5033_REG_CHG_CTRL3		= 0x04,
	RT5033_REG_CHG_CTRL4		= 0x05,
	RT5033_REG_CHG_CTRL5		= 0x06,
	RT5033_REG_RT_CTRL0		= 0x07,
	RT5033_REG_CHG_RESET		= 0x08,
	
	RT5033_REG_RT_CTRL1		= 0x19,
	
	RT5033_REG_FLED_FUNCTION1	= 0x21,
	RT5033_REG_FLED_FUNCTION2	= 0x22,
	RT5033_REG_FLED_STROBE_CTRL1	= 0x23,
	RT5033_REG_FLED_STROBE_CTRL2	= 0x24,
	RT5033_REG_FLED_CTRL1		= 0x25,
	RT5033_REG_FLED_CTRL2		= 0x26,
	RT5033_REG_FLED_CTRL3		= 0x27,
	RT5033_REG_FLED_CTRL4		= 0x28,
	RT5033_REG_FLED_CTRL5		= 0x29,
	
	RT5033_REG_CTRL			= 0x41,
	RT5033_REG_BUCK_CTRL		= 0x42,
	RT5033_REG_LDO_CTRL		= 0x43,
	
	RT5033_REG_MANUAL_RESET_CTRL	= 0x47,
	
	RT5033_REG_CHG_IRQ1		= 0x60,
	RT5033_REG_CHG_IRQ2		= 0x61,
	RT5033_REG_CHG_IRQ3		= 0x62,
	RT5033_REG_CHG_IRQ1_CTRL	= 0x63,
	RT5033_REG_CHG_IRQ2_CTRL	= 0x64,
	RT5033_REG_CHG_IRQ3_CTRL	= 0x65,
	RT5033_REG_LED_IRQ_STAT		= 0x66,
	RT5033_REG_LED_IRQ_CTRL		= 0x67,
	RT5033_REG_PMIC_IRQ_STAT	= 0x68,
	RT5033_REG_PMIC_IRQ_CTRL	= 0x69,
	RT5033_REG_SHDN_CTRL		= 0x6A,
	RT5033_REG_OFF_EVENT		= 0x6B,

	RT5033_REG_END,
};


#define RT5033_CHG_STAT_TYPE_MASK	0x60
#define RT5033_CHG_STAT_TYPE_PRE	0x20
#define RT5033_CHG_STAT_TYPE_FAST	0x60
#define RT5033_CHG_STAT_MASK		0x30
#define RT5033_CHG_STAT_DISCHARGING	0x00
#define RT5033_CHG_STAT_FULL		0x10
#define RT5033_CHG_STAT_CHARGING	0x20
#define RT5033_CHG_STAT_NOT_CHARGING	0x30


#define RT5033_CHGCTRL1_IAICR_MASK	0xe0
#define RT5033_CHGCTRL1_TE_EN_MASK	0x08
#define RT5033_CHGCTRL1_HZ_MASK		0x02
#define RT5033_CHGCTRL1_MODE_MASK	0x01


#define RT5033_CHGCTRL2_CV_MASK		0xfc
#define RT5033_CHGCTRL2_CV_SHIFT	0x02


#define RT5033_VENDOR_ID_MASK		0xf0
#define RT5033_CHIP_REV_MASK		0x0f


#define RT5033_CHGCTRL3_CFO_EN_MASK	0x40
#define RT5033_CHGCTRL3_TIMER_MASK	0x38
#define RT5033_CHGCTRL3_TIMER_EN_MASK	0x01


#define RT5033_CHGCTRL4_MIVR_MASK	0xe0
#define RT5033_CHGCTRL4_IPREC_MASK	0x18
#define RT5033_CHGCTRL4_IPREC_SHIFT	0x03
#define RT5033_CHGCTRL4_EOC_MASK	0x07


#define RT5033_CHGCTRL5_ICHG_MASK	0xf0
#define RT5033_CHGCTRL5_ICHG_SHIFT	0x04
#define RT5033_CHGCTRL5_VPREC_MASK	0x0f


#define RT5033_RT_CTRL1_UUG_MASK	0x02


#define RT5033_CTRL_FCCM_BUCK_MASK		BIT(0)
#define RT5033_CTRL_BUCKOMS_MASK		BIT(1)
#define RT5033_CTRL_LDOOMS_MASK			BIT(2)
#define RT5033_CTRL_SLDOOMS_MASK		BIT(3)
#define RT5033_CTRL_EN_BUCK_MASK		BIT(4)
#define RT5033_CTRL_EN_LDO_MASK			BIT(5)
#define RT5033_CTRL_EN_SAFE_LDO_MASK		BIT(6)
#define RT5033_CTRL_LDO_SLEEP_MASK		BIT(7)


#define RT5033_BUCK_CTRL_MASK			0x1f


#define RT5033_LDO_CTRL_MASK			0x1f


#define RT5033_CHARGER_MODEL	"RT5033WSC Charger"
#define RT5033_MANUFACTURER	"Richtek Technology Corporation"


#define RT5033_AICR_DISABLE			0x00
#define RT5033_AICR_100_MODE			0x20
#define RT5033_AICR_500_MODE			0x40
#define RT5033_AICR_700_MODE			0x60
#define RT5033_AICR_900_MODE			0x80
#define RT5033_AICR_1000_MODE			0xa0
#define RT5033_AICR_1500_MODE			0xc0
#define RT5033_AICR_2000_MODE			0xe0


#define RT5033_CHARGER_MIVR_DISABLE		0x00
#define RT5033_CHARGER_MIVR_4200MV		0x20
#define RT5033_CHARGER_MIVR_4300MV		0x40
#define RT5033_CHARGER_MIVR_4400MV		0x60
#define RT5033_CHARGER_MIVR_4500MV		0x80
#define RT5033_CHARGER_MIVR_4600MV		0xa0
#define RT5033_CHARGER_MIVR_4700MV		0xc0
#define RT5033_CHARGER_MIVR_4800MV		0xe0


#define RT5033_FAST_CHARGE_TIMER4		0x00 
#define RT5033_FAST_CHARGE_TIMER6		0x08 
#define RT5033_FAST_CHARGE_TIMER8		0x10 
#define RT5033_FAST_CHARGE_TIMER10		0x18 
#define RT5033_FAST_CHARGE_TIMER12		0x20 
#define RT5033_FAST_CHARGE_TIMER14		0x28 
#define RT5033_FAST_CHARGE_TIMER16		0x30 

#define RT5033_INT_TIMER_DISABLE		0x00
#define RT5033_INT_TIMER_ENABLE			0x01


#define RT5033_CHARGER_MODE			0x00
#define RT5033_BOOST_MODE			0x01


#define RT5033_TE_DISABLE			0x00
#define RT5033_TE_ENABLE			0x08


#define RT5033_CFO_DISABLE			0x00
#define RT5033_CFO_ENABLE			0x40


#define RT5033_CHARGER_CONST_VOLTAGE_LIMIT_MIN	3650000U
#define RT5033_CHARGER_CONST_VOLTAGE_STEP_NUM   25000U
#define RT5033_CHARGER_CONST_VOLTAGE_LIMIT_MAX	4400000U
#define RT5033_CV_MAX_VOLTAGE			0x1e


#define RT5033_CHARGER_PRE_CURRENT_LIMIT_MIN	350000U
#define RT5033_CHARGER_PRE_CURRENT_STEP_NUM	100000U
#define RT5033_CHARGER_PRE_CURRENT_LIMIT_MAX	650000U
#define RT5033_CHG_MAX_PRE_CURRENT		0x03


#define RT5033_CHARGER_FAST_CURRENT_MIN		700000U
#define RT5033_CHARGER_FAST_CURRENT_STEP_NUM	100000U
#define RT5033_CHARGER_FAST_CURRENT_MAX		2000000U
#define RT5033_CHG_MAX_CURRENT			0x0d


#define RT5033_CHARGER_EOC_MIN			150000U
#define RT5033_CHARGER_EOC_REF			300000U
#define RT5033_CHARGER_EOC_STEP_NUM1		50000U
#define RT5033_CHARGER_EOC_STEP_NUM2		100000U
#define RT5033_CHARGER_EOC_MAX			600000U


#define RT5033_CHARGER_PRE_THRESHOLD_LIMIT_MIN	2300000U
#define RT5033_CHARGER_PRE_THRESHOLD_STEP_NUM	100000U
#define RT5033_CHARGER_PRE_THRESHOLD_LIMIT_MAX	3800000U


#define RT5033_CHARGER_UUG_DISABLE		0x00
#define RT5033_CHARGER_UUG_ENABLE		0x02


#define RT5033_CHARGER_HZ_DISABLE		0x00
#define RT5033_CHARGER_HZ_ENABLE		0x02


#define RT5033_REGULATOR_BUCK_VOLTAGE_MIN		1000000U
#define RT5033_REGULATOR_BUCK_VOLTAGE_MAX		3000000U
#define RT5033_REGULATOR_BUCK_VOLTAGE_STEP		100000U
#define RT5033_REGULATOR_BUCK_VOLTAGE_STEP_NUM		32


#define RT5033_REGULATOR_LDO_VOLTAGE_MIN		1200000U
#define RT5033_REGULATOR_LDO_VOLTAGE_MAX		3000000U
#define RT5033_REGULATOR_LDO_VOLTAGE_STEP		100000U
#define RT5033_REGULATOR_LDO_VOLTAGE_STEP_NUM		32


#define RT5033_REGULATOR_SAFE_LDO_VOLTAGE		4900000U

enum rt5033_fuel_reg {
	RT5033_FUEL_REG_OCV_H		= 0x00,
	RT5033_FUEL_REG_OCV_L		= 0x01,
	RT5033_FUEL_REG_VBAT_H		= 0x02,
	RT5033_FUEL_REG_VBAT_L		= 0x03,
	RT5033_FUEL_REG_SOC_H		= 0x04,
	RT5033_FUEL_REG_SOC_L		= 0x05,
	RT5033_FUEL_REG_CTRL_H		= 0x06,
	RT5033_FUEL_REG_CTRL_L		= 0x07,
	RT5033_FUEL_REG_CRATE		= 0x08,
	RT5033_FUEL_REG_DEVICE_ID	= 0x09,
	RT5033_FUEL_REG_AVG_VOLT_H	= 0x0A,
	RT5033_FUEL_REG_AVG_VOLT_L	= 0x0B,
	RT5033_FUEL_REG_CONFIG_H	= 0x0C,
	RT5033_FUEL_REG_CONFIG_L	= 0x0D,
	
	RT5033_FUEL_REG_IRQ_CTRL	= 0x10,
	RT5033_FUEL_REG_IRQ_FLAG	= 0x11,
	RT5033_FUEL_VMIN		= 0x12,
	RT5033_FUEL_SMIN		= 0x13,
	
	RT5033_FUEL_VGCOMP1		= 0x20,
	RT5033_FUEL_VGCOMP2		= 0x21,
	RT5033_FUEL_VGCOMP3		= 0x22,
	RT5033_FUEL_VGCOMP4		= 0x23,
	
	RT5033_FUEL_MFA_H		= 0xFE,
	RT5033_FUEL_MFA_L		= 0xFF,

	RT5033_FUEL_REG_END,
};


#define RT5033_FUEL_BAT_PRESENT		0x02


#define RT5033_PMIC_IRQ_BUCKOCP		BIT(2)
#define RT5033_PMIC_IRQ_BUCKLV		BIT(3)
#define RT5033_PMIC_IRQ_SAFELDOLV	BIT(4)
#define RT5033_PMIC_IRQ_LDOLV		BIT(5)
#define RT5033_PMIC_IRQ_OT		BIT(6)
#define RT5033_PMIC_IRQ_VDDA_UV		BIT(7)

#endif 
