/* SPDX-License-Identifier: GPL-2.0+ */


#ifndef __LINUX_MFD_S2MPS13_H
#define __LINUX_MFD_S2MPS13_H


enum s2mps13_reg {
	S2MPS13_REG_ID,
	S2MPS13_REG_INT1,
	S2MPS13_REG_INT2,
	S2MPS13_REG_INT3,
	S2MPS13_REG_INT1M,
	S2MPS13_REG_INT2M,
	S2MPS13_REG_INT3M,
	S2MPS13_REG_ST1,
	S2MPS13_REG_ST2,
	S2MPS13_REG_PWRONSRC,
	S2MPS13_REG_OFFSRC,
	S2MPS13_REG_BU_CHG,
	S2MPS13_REG_RTCCTRL,
	S2MPS13_REG_CTRL1,
	S2MPS13_REG_CTRL2,
	S2MPS13_REG_RSVD1,
	S2MPS13_REG_RSVD2,
	S2MPS13_REG_RSVD3,
	S2MPS13_REG_RSVD4,
	S2MPS13_REG_RSVD5,
	S2MPS13_REG_RSVD6,
	S2MPS13_REG_CTRL3,
	S2MPS13_REG_RSVD7,
	S2MPS13_REG_RSVD8,
	S2MPS13_REG_WRSTBI,
	S2MPS13_REG_B1CTRL,
	S2MPS13_REG_B1OUT,
	S2MPS13_REG_B2CTRL,
	S2MPS13_REG_B2OUT,
	S2MPS13_REG_B3CTRL,
	S2MPS13_REG_B3OUT,
	S2MPS13_REG_B4CTRL,
	S2MPS13_REG_B4OUT,
	S2MPS13_REG_B5CTRL,
	S2MPS13_REG_B5OUT,
	S2MPS13_REG_B6CTRL,
	S2MPS13_REG_B6OUT,
	S2MPS13_REG_B7CTRL,
	S2MPS13_REG_B7SW,
	S2MPS13_REG_B7OUT,
	S2MPS13_REG_B8CTRL,
	S2MPS13_REG_B8OUT,
	S2MPS13_REG_B9CTRL,
	S2MPS13_REG_B9OUT,
	S2MPS13_REG_B10CTRL,
	S2MPS13_REG_B10OUT,
	S2MPS13_REG_BB1CTRL,
	S2MPS13_REG_BB1OUT,
	S2MPS13_REG_BUCK_RAMP1,
	S2MPS13_REG_BUCK_RAMP2,
	S2MPS13_REG_LDO_DVS1,
	S2MPS13_REG_LDO_DVS2,
	S2MPS13_REG_LDO_DVS3,
	S2MPS13_REG_B6OUT2,
	S2MPS13_REG_L1CTRL,
	S2MPS13_REG_L2CTRL,
	S2MPS13_REG_L3CTRL,
	S2MPS13_REG_L4CTRL,
	S2MPS13_REG_L5CTRL,
	S2MPS13_REG_L6CTRL,
	S2MPS13_REG_L7CTRL,
	S2MPS13_REG_L8CTRL,
	S2MPS13_REG_L9CTRL,
	S2MPS13_REG_L10CTRL,
	S2MPS13_REG_L11CTRL,
	S2MPS13_REG_L12CTRL,
	S2MPS13_REG_L13CTRL,
	S2MPS13_REG_L14CTRL,
	S2MPS13_REG_L15CTRL,
	S2MPS13_REG_L16CTRL,
	S2MPS13_REG_L17CTRL,
	S2MPS13_REG_L18CTRL,
	S2MPS13_REG_L19CTRL,
	S2MPS13_REG_L20CTRL,
	S2MPS13_REG_L21CTRL,
	S2MPS13_REG_L22CTRL,
	S2MPS13_REG_L23CTRL,
	S2MPS13_REG_L24CTRL,
	S2MPS13_REG_L25CTRL,
	S2MPS13_REG_L26CTRL,
	S2MPS13_REG_L27CTRL,
	S2MPS13_REG_L28CTRL,
	S2MPS13_REG_L29CTRL,
	S2MPS13_REG_L30CTRL,
	S2MPS13_REG_L31CTRL,
	S2MPS13_REG_L32CTRL,
	S2MPS13_REG_L33CTRL,
	S2MPS13_REG_L34CTRL,
	S2MPS13_REG_L35CTRL,
	S2MPS13_REG_L36CTRL,
	S2MPS13_REG_L37CTRL,
	S2MPS13_REG_L38CTRL,
	S2MPS13_REG_L39CTRL,
	S2MPS13_REG_L40CTRL,
	S2MPS13_REG_LDODSCH1,
	S2MPS13_REG_LDODSCH2,
	S2MPS13_REG_LDODSCH3,
	S2MPS13_REG_LDODSCH4,
	S2MPS13_REG_LDODSCH5,
};


enum s2mps13_regulators {
	S2MPS13_LDO1,
	S2MPS13_LDO2,
	S2MPS13_LDO3,
	S2MPS13_LDO4,
	S2MPS13_LDO5,
	S2MPS13_LDO6,
	S2MPS13_LDO7,
	S2MPS13_LDO8,
	S2MPS13_LDO9,
	S2MPS13_LDO10,
	S2MPS13_LDO11,
	S2MPS13_LDO12,
	S2MPS13_LDO13,
	S2MPS13_LDO14,
	S2MPS13_LDO15,
	S2MPS13_LDO16,
	S2MPS13_LDO17,
	S2MPS13_LDO18,
	S2MPS13_LDO19,
	S2MPS13_LDO20,
	S2MPS13_LDO21,
	S2MPS13_LDO22,
	S2MPS13_LDO23,
	S2MPS13_LDO24,
	S2MPS13_LDO25,
	S2MPS13_LDO26,
	S2MPS13_LDO27,
	S2MPS13_LDO28,
	S2MPS13_LDO29,
	S2MPS13_LDO30,
	S2MPS13_LDO31,
	S2MPS13_LDO32,
	S2MPS13_LDO33,
	S2MPS13_LDO34,
	S2MPS13_LDO35,
	S2MPS13_LDO36,
	S2MPS13_LDO37,
	S2MPS13_LDO38,
	S2MPS13_LDO39,
	S2MPS13_LDO40,
	S2MPS13_BUCK1,
	S2MPS13_BUCK2,
	S2MPS13_BUCK3,
	S2MPS13_BUCK4,
	S2MPS13_BUCK5,
	S2MPS13_BUCK6,
	S2MPS13_BUCK7,
	S2MPS13_BUCK8,
	S2MPS13_BUCK9,
	S2MPS13_BUCK10,

	S2MPS13_REGULATOR_MAX,
};


#define S2MPS13_BUCK_RAMP_DELAY		12500
#define S2MPS13_REG_WRSTBI_MASK		BIT(5)

#endif 
