/* SPDX-License-Identifier: GPL-2.0+ */


#ifndef __LINUX_MFD_S2MPS15_H
#define __LINUX_MFD_S2MPS15_H


enum s2mps15_reg {
	S2MPS15_REG_ID,
	S2MPS15_REG_INT1,
	S2MPS15_REG_INT2,
	S2MPS15_REG_INT3,
	S2MPS15_REG_INT1M,
	S2MPS15_REG_INT2M,
	S2MPS15_REG_INT3M,
	S2MPS15_REG_ST1,
	S2MPS15_REG_ST2,
	S2MPS15_REG_PWRONSRC,
	S2MPS15_REG_OFFSRC,
	S2MPS15_REG_BU_CHG,
	S2MPS15_REG_RTC_BUF,
	S2MPS15_REG_CTRL1,
	S2MPS15_REG_CTRL2,
	S2MPS15_REG_RSVD1,
	S2MPS15_REG_RSVD2,
	S2MPS15_REG_RSVD3,
	S2MPS15_REG_RSVD4,
	S2MPS15_REG_RSVD5,
	S2MPS15_REG_RSVD6,
	S2MPS15_REG_CTRL3,
	S2MPS15_REG_RSVD7,
	S2MPS15_REG_RSVD8,
	S2MPS15_REG_RSVD9,
	S2MPS15_REG_B1CTRL1,
	S2MPS15_REG_B1CTRL2,
	S2MPS15_REG_B2CTRL1,
	S2MPS15_REG_B2CTRL2,
	S2MPS15_REG_B3CTRL1,
	S2MPS15_REG_B3CTRL2,
	S2MPS15_REG_B4CTRL1,
	S2MPS15_REG_B4CTRL2,
	S2MPS15_REG_B5CTRL1,
	S2MPS15_REG_B5CTRL2,
	S2MPS15_REG_B6CTRL1,
	S2MPS15_REG_B6CTRL2,
	S2MPS15_REG_B7CTRL1,
	S2MPS15_REG_B7CTRL2,
	S2MPS15_REG_B8CTRL1,
	S2MPS15_REG_B8CTRL2,
	S2MPS15_REG_B9CTRL1,
	S2MPS15_REG_B9CTRL2,
	S2MPS15_REG_B10CTRL1,
	S2MPS15_REG_B10CTRL2,
	S2MPS15_REG_BBCTRL1,
	S2MPS15_REG_BBCTRL2,
	S2MPS15_REG_BRAMP,
	S2MPS15_REG_LDODVS1,
	S2MPS15_REG_LDODVS2,
	S2MPS15_REG_LDODVS3,
	S2MPS15_REG_LDODVS4,
	S2MPS15_REG_L1CTRL,
	S2MPS15_REG_L2CTRL,
	S2MPS15_REG_L3CTRL,
	S2MPS15_REG_L4CTRL,
	S2MPS15_REG_L5CTRL,
	S2MPS15_REG_L6CTRL,
	S2MPS15_REG_L7CTRL,
	S2MPS15_REG_L8CTRL,
	S2MPS15_REG_L9CTRL,
	S2MPS15_REG_L10CTRL,
	S2MPS15_REG_L11CTRL,
	S2MPS15_REG_L12CTRL,
	S2MPS15_REG_L13CTRL,
	S2MPS15_REG_L14CTRL,
	S2MPS15_REG_L15CTRL,
	S2MPS15_REG_L16CTRL,
	S2MPS15_REG_L17CTRL,
	S2MPS15_REG_L18CTRL,
	S2MPS15_REG_L19CTRL,
	S2MPS15_REG_L20CTRL,
	S2MPS15_REG_L21CTRL,
	S2MPS15_REG_L22CTRL,
	S2MPS15_REG_L23CTRL,
	S2MPS15_REG_L24CTRL,
	S2MPS15_REG_L25CTRL,
	S2MPS15_REG_L26CTRL,
	S2MPS15_REG_L27CTRL,
	S2MPS15_REG_LDODSCH1,
	S2MPS15_REG_LDODSCH2,
	S2MPS15_REG_LDODSCH3,
	S2MPS15_REG_LDODSCH4,
};


enum s2mps15_regulators {
	S2MPS15_LDO1,
	S2MPS15_LDO2,
	S2MPS15_LDO3,
	S2MPS15_LDO4,
	S2MPS15_LDO5,
	S2MPS15_LDO6,
	S2MPS15_LDO7,
	S2MPS15_LDO8,
	S2MPS15_LDO9,
	S2MPS15_LDO10,
	S2MPS15_LDO11,
	S2MPS15_LDO12,
	S2MPS15_LDO13,
	S2MPS15_LDO14,
	S2MPS15_LDO15,
	S2MPS15_LDO16,
	S2MPS15_LDO17,
	S2MPS15_LDO18,
	S2MPS15_LDO19,
	S2MPS15_LDO20,
	S2MPS15_LDO21,
	S2MPS15_LDO22,
	S2MPS15_LDO23,
	S2MPS15_LDO24,
	S2MPS15_LDO25,
	S2MPS15_LDO26,
	S2MPS15_LDO27,
	S2MPS15_BUCK1,
	S2MPS15_BUCK2,
	S2MPS15_BUCK3,
	S2MPS15_BUCK4,
	S2MPS15_BUCK5,
	S2MPS15_BUCK6,
	S2MPS15_BUCK7,
	S2MPS15_BUCK8,
	S2MPS15_BUCK9,
	S2MPS15_BUCK10,
	S2MPS15_BUCK11,
	S2MPS15_REGULATOR_MAX,
};

#define S2MPS15_LDO_VSEL_MASK		(0x3F)
#define S2MPS15_BUCK_VSEL_MASK		(0xFF)

#define S2MPS15_ENABLE_SHIFT		(0x06)
#define S2MPS15_ENABLE_MASK		(0x03 << S2MPS15_ENABLE_SHIFT)

#define S2MPS15_LDO_N_VOLTAGES		(S2MPS15_LDO_VSEL_MASK + 1)
#define S2MPS15_BUCK_N_VOLTAGES	(S2MPS15_BUCK_VSEL_MASK + 1)

#endif 
