/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef LINUX_MMC_CORE_H
#define LINUX_MMC_CORE_H

#include <linux/completion.h>
#include <linux/types.h>

struct mmc_data;
struct mmc_request;

#define UHS2_MAX_PAYLOAD_LEN 2
#define UHS2_MAX_RESP_LEN 20

struct uhs2_command {
	u16	header;
	u16	arg;
	__be32	payload[UHS2_MAX_PAYLOAD_LEN];
	u8	payload_len;
	u8	packet_len;
	u8	tmode_half_duplex;
	u8	uhs2_resp[UHS2_MAX_RESP_LEN];	
	u8	uhs2_resp_len;			
};

struct mmc_command {
	u32			opcode;
	u32			arg;
#define MMC_CMD23_ARG_REL_WR	(1 << 31)
#define MMC_CMD23_ARG_TAG_REQ	(1 << 29)
	u32			resp[4];
	unsigned int		flags;		
#define MMC_RSP_PRESENT	(1 << 0)
#define MMC_RSP_136	(1 << 1)		
#define MMC_RSP_CRC	(1 << 2)		
#define MMC_RSP_BUSY	(1 << 3)		
#define MMC_RSP_OPCODE	(1 << 4)		

#define MMC_CMD_MASK	(3 << 5)		
#define MMC_CMD_AC	(0 << 5)
#define MMC_CMD_ADTC	(1 << 5)
#define MMC_CMD_BC	(2 << 5)
#define MMC_CMD_BCR	(3 << 5)

#define MMC_RSP_SPI_S1	(1 << 7)		
#define MMC_RSP_SPI_S2	(1 << 8)		
#define MMC_RSP_SPI_B4	(1 << 9)		
#define MMC_RSP_SPI_BUSY (1 << 10)		


#define MMC_RSP_NONE	(0)
#define MMC_RSP_R1	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R1B	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE|MMC_RSP_BUSY)
#define MMC_RSP_R2	(MMC_RSP_PRESENT|MMC_RSP_136|MMC_RSP_CRC)
#define MMC_RSP_R3	(MMC_RSP_PRESENT)
#define MMC_RSP_R4	(MMC_RSP_PRESENT)
#define MMC_RSP_R5	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R6	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R7	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)


#define MMC_RSP_R1_NO_CRC	(MMC_RSP_PRESENT|MMC_RSP_OPCODE)

#define mmc_resp_type(cmd)	((cmd)->flags & (MMC_RSP_PRESENT|MMC_RSP_136|MMC_RSP_CRC|MMC_RSP_BUSY|MMC_RSP_OPCODE))


#define MMC_RSP_SPI_R1	(MMC_RSP_SPI_S1)
#define MMC_RSP_SPI_R1B	(MMC_RSP_SPI_S1|MMC_RSP_SPI_BUSY)
#define MMC_RSP_SPI_R2	(MMC_RSP_SPI_S1|MMC_RSP_SPI_S2)
#define MMC_RSP_SPI_R3	(MMC_RSP_SPI_S1|MMC_RSP_SPI_B4)
#define MMC_RSP_SPI_R4	(MMC_RSP_SPI_S1|MMC_RSP_SPI_B4)
#define MMC_RSP_SPI_R5	(MMC_RSP_SPI_S1|MMC_RSP_SPI_S2)
#define MMC_RSP_SPI_R7	(MMC_RSP_SPI_S1|MMC_RSP_SPI_B4)

#define mmc_spi_resp_type(cmd)	((cmd)->flags & \
		(MMC_RSP_SPI_S1|MMC_RSP_SPI_BUSY|MMC_RSP_SPI_S2|MMC_RSP_SPI_B4))


#define mmc_cmd_type(cmd)	((cmd)->flags & MMC_CMD_MASK)

	unsigned int		retries;	
	int			error;		



	unsigned int		busy_timeout;	
	struct mmc_data		*data;		
	struct mmc_request	*mrq;		

	struct uhs2_command	*uhs2_cmd;	

	
	bool has_ext_addr;
	u8 ext_addr;
};

struct mmc_data {
	unsigned int		timeout_ns;	
	unsigned int		timeout_clks;	
	unsigned int		blksz;		
	unsigned int		blocks;		
	unsigned int		blk_addr;	
	int			error;		
	unsigned int		flags;

#define MMC_DATA_WRITE		BIT(8)
#define MMC_DATA_READ		BIT(9)

#define MMC_DATA_QBR		BIT(10)		
#define MMC_DATA_PRIO		BIT(11)		
#define MMC_DATA_REL_WR		BIT(12)		
#define MMC_DATA_DAT_TAG	BIT(13)		
#define MMC_DATA_FORCED_PRG	BIT(14)		

	unsigned int		bytes_xfered;

	struct mmc_command	*stop;		
	struct mmc_request	*mrq;		

	unsigned int		sg_len;		
	int			sg_count;	
	struct scatterlist	*sg;		
	s32			host_cookie;	
};

struct mmc_host;
struct mmc_request {
	struct mmc_command	*sbc;		
	struct mmc_command	*cmd;
	struct mmc_data		*data;
	struct mmc_command	*stop;

	struct completion	completion;
	struct completion	cmd_completion;
	void			(*done)(struct mmc_request *);
	
	void			(*recovery_notifier)(struct mmc_request *);
	struct mmc_host		*host;

	
	bool			cap_cmd_during_tfr;

	int			tag;

#ifdef CONFIG_MMC_CRYPTO
	const struct bio_crypt_ctx *crypto_ctx;
	int			crypto_key_slot;
#endif
	struct uhs2_command	uhs2_cmd;
};

struct mmc_card;

void mmc_wait_for_req(struct mmc_host *host, struct mmc_request *mrq);
int mmc_wait_for_cmd(struct mmc_host *host, struct mmc_command *cmd,
		int retries);

int mmc_hw_reset(struct mmc_card *card);
int mmc_sw_reset(struct mmc_card *card);
void mmc_set_data_timeout(struct mmc_data *data, const struct mmc_card *card);

#endif 
