/* SPDX-License-Identifier: GPL-2.0 */

#ifndef LINUX_PCI_TPH_H
#define LINUX_PCI_TPH_H


enum tph_mem_type {
	TPH_MEM_TYPE_VM,	
	TPH_MEM_TYPE_PM		
};

#ifdef CONFIG_PCIE_TPH
int pcie_tph_set_st_entry(struct pci_dev *pdev,
			  unsigned int index, u16 tag);
int pcie_tph_get_cpu_st(struct pci_dev *dev,
			enum tph_mem_type mem_type,
			unsigned int cpu_uid, u16 *tag);
void pcie_disable_tph(struct pci_dev *pdev);
int pcie_enable_tph(struct pci_dev *pdev, int mode);
#else
static inline int pcie_tph_set_st_entry(struct pci_dev *pdev,
					unsigned int index, u16 tag)
{ return -EINVAL; }
static inline int pcie_tph_get_cpu_st(struct pci_dev *dev,
				      enum tph_mem_type mem_type,
				      unsigned int cpu_uid, u16 *tag)
{ return -EINVAL; }
static inline void pcie_disable_tph(struct pci_dev *pdev) { }
static inline int pcie_enable_tph(struct pci_dev *pdev, int mode)
{ return -EINVAL; }
#endif

#endif 
