/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef __PLATFORM_DATA_X86_NVIDIA_WMI_EC_BACKLIGHT_H
#define __PLATFORM_DATA_X86_NVIDIA_WMI_EC_BACKLIGHT_H

#define WMI_BRIGHTNESS_GUID "603E9613-EF25-4338-A3D0-C46177516DB7"


enum wmi_brightness_method {
	WMI_BRIGHTNESS_METHOD_LEVEL = 1,
	WMI_BRIGHTNESS_METHOD_SOURCE = 2,
	WMI_BRIGHTNESS_METHOD_MAX
};


enum wmi_brightness_mode {
	WMI_BRIGHTNESS_MODE_GET = 0,
	WMI_BRIGHTNESS_MODE_SET = 1,
	WMI_BRIGHTNESS_MODE_GET_MAX_LEVEL = 2,
	WMI_BRIGHTNESS_MODE_MAX
};


enum wmi_brightness_source {
	WMI_BRIGHTNESS_SOURCE_GPU = 1,
	WMI_BRIGHTNESS_SOURCE_EC = 2,
	WMI_BRIGHTNESS_SOURCE_AUX = 3,
	WMI_BRIGHTNESS_SOURCE_MAX
};


struct wmi_brightness_args {
	u32 mode;
	u32 val;
	u32 ret;
	u32 ignored[3];
};

#endif
