/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_POISON_H
#define _LINUX_POISON_H




#ifdef CONFIG_ILLEGAL_POINTER_VALUE
# define POISON_POINTER_DELTA _AC(CONFIG_ILLEGAL_POINTER_VALUE, UL)
#else
# define POISON_POINTER_DELTA 0
#endif


#define LIST_POISON1  ((void *) 0x100 + POISON_POINTER_DELTA)
#define LIST_POISON2  ((void *) 0x122 + POISON_POINTER_DELTA)


#define TIMER_ENTRY_STATIC	((void *) 0x300 + POISON_POINTER_DELTA)


#define PAGE_POISON 0xaa



#define TAIL_MAPPING	((void *) 0x400 + POISON_POINTER_DELTA)



#define SLUB_RED_INACTIVE	0xbb	
#define SLUB_RED_ACTIVE		0xcc	


#define	POISON_INUSE	0x5a	
#define POISON_FREE	0x6b	
#define	POISON_END	0xa5	


#define POISON_FREE_INITMEM	0xcc


#define JBD_POISON_FREE		0x5b
#define JBD2_POISON_FREE	0x5c


#define	POOL_POISON_FREED	0xa7	
#define	POOL_POISON_ALLOCATED	0xa9	


#define ATM_POISON_FREE		0x12
#define ATM_POISON		0xdeadbeef


#define MUTEX_DEBUG_INIT	0x11
#define MUTEX_DEBUG_FREE	0x22
#define MUTEX_POISON_WW_CTX	((void *) 0x500 + POISON_POINTER_DELTA)


#define KEY_DESTROY		0xbd


#define PP_SIGNATURE		(0x40 + POISON_POINTER_DELTA)


#define SKB_LIST_POISON_NEXT	((void *)(0x800 + POISON_POINTER_DELTA))

#define NET_PTR_POISON		((void *)(0x801 + POISON_POINTER_DELTA))


#define BPF_PTR_POISON ((void *)(0xeB9FUL + POISON_POINTER_DELTA))


#define VFS_PTR_POISON ((void *)(0xF5 + POISON_POINTER_DELTA))


#define STACK_DEPOT_POISON ((void *)(0xD390 + POISON_POINTER_DELTA))

#endif
