/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _PPP_DEFS_H_
#define _PPP_DEFS_H_

#include <linux/crc-ccitt.h>
#include <uapi/linux/ppp_defs.h>

#define PPP_FCS(fcs, c) crc_ccitt_byte(fcs, c)


static inline bool ppp_proto_is_valid(u16 proto)
{
	return !!((proto & 0x0101) == 0x0001);
}

#endif 
