/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __PSP_H
#define __PSP_H

#ifdef CONFIG_X86
#include <linux/mem_encrypt.h>

#define __psp_pa(x)	__sme_pa(x)
#else
#define __psp_pa(x)	__pa(x)
#endif


#define PSP_CMDRESP_STS		GENMASK(15, 0)
#define PSP_CMDRESP_CMD		GENMASK(23, 16)
#define PSP_CMDRESP_RESERVED	GENMASK(29, 24)
#define PSP_CMDRESP_RECOVERY	BIT(30)
#define PSP_CMDRESP_RESP	BIT(31)

#define PSP_DRBL_MSG		PSP_CMDRESP_CMD
#define PSP_DRBL_RING		BIT(0)

#endif 
