/* SPDX-License-Identifier: GPL-2.0-or-later */


#ifndef __LINUX_REGULATOR_MAX8973_H
#define __LINUX_REGULATOR_MAX8973_H


#define MAX8973_CONTROL_REMOTE_SENSE_ENABLE			0x00000001
#define MAX8973_CONTROL_FALLING_SLEW_RATE_ENABLE		0x00000002
#define MAX8973_CONTROL_OUTPUT_ACTIVE_DISCH_ENABLE		0x00000004
#define MAX8973_CONTROL_BIAS_ENABLE				0x00000008
#define MAX8973_CONTROL_PULL_DOWN_ENABLE			0x00000010
#define MAX8973_CONTROL_FREQ_SHIFT_9PER_ENABLE			0x00000020

#define MAX8973_CONTROL_CLKADV_TRIP_DISABLED			0x00000000
#define MAX8973_CONTROL_CLKADV_TRIP_75mV_PER_US			0x00010000
#define MAX8973_CONTROL_CLKADV_TRIP_150mV_PER_US		0x00020000
#define MAX8973_CONTROL_CLKADV_TRIP_75mV_PER_US_HIST_DIS	0x00030000

#define MAX8973_CONTROL_INDUCTOR_VALUE_NOMINAL			0x00000000
#define MAX8973_CONTROL_INDUCTOR_VALUE_MINUS_30_PER		0x00100000
#define MAX8973_CONTROL_INDUCTOR_VALUE_PLUS_30_PER		0x00200000
#define MAX8973_CONTROL_INDUCTOR_VALUE_PLUS_60_PER		0x00300000


struct max8973_regulator_platform_data {
	struct regulator_init_data *reg_init_data;
	unsigned long control_flags;
	unsigned long junction_temp_warning;
	bool enable_ext_control;
	unsigned dvs_def_state:1;
};

#endif 
