/* SPDX-License-Identifier: GPL-2.0 */


#ifndef SD_FLAG
# error "Incorrect import of SD flags definitions"
#endif


#define SDF_SHARED_CHILD       0x1
#define SDF_SHARED_PARENT      0x2


#define SDF_NEEDS_GROUPS       0x4


SD_FLAG(SD_BALANCE_NEWIDLE, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_BALANCE_EXEC, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_BALANCE_FORK, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_BALANCE_WAKE, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_WAKE_AFFINE, SDF_SHARED_CHILD)


SD_FLAG(SD_ASYM_CPUCAPACITY, SDF_SHARED_PARENT | SDF_NEEDS_GROUPS)


SD_FLAG(SD_ASYM_CPUCAPACITY_FULL, SDF_SHARED_PARENT | SDF_NEEDS_GROUPS)


SD_FLAG(SD_SHARE_CPUCAPACITY, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_CLUSTER, SDF_NEEDS_GROUPS)


SD_FLAG(SD_SHARE_LLC, SDF_SHARED_CHILD | SDF_NEEDS_GROUPS)


SD_FLAG(SD_SERIALIZE, SDF_SHARED_PARENT | SDF_NEEDS_GROUPS)


SD_FLAG(SD_ASYM_PACKING, SDF_NEEDS_GROUPS)


SD_FLAG(SD_PREFER_SIBLING, SDF_NEEDS_GROUPS)


SD_FLAG(SD_OVERLAP, SDF_SHARED_PARENT | SDF_NEEDS_GROUPS)


SD_FLAG(SD_NUMA, SDF_SHARED_PARENT | SDF_NEEDS_GROUPS)
