/* SPDX-License-Identifier: GPL-2.0 */

#ifndef SPLICE_H
#define SPLICE_H

#include <linux/pipe_fs_i.h>


#define SPLICE_F_MOVE	(0x01)	
#define SPLICE_F_NONBLOCK (0x02) 
				 
				 
#define SPLICE_F_MORE	(0x04)	
#define SPLICE_F_GIFT	(0x08)	

#define SPLICE_F_ALL (SPLICE_F_MOVE|SPLICE_F_NONBLOCK|SPLICE_F_MORE|SPLICE_F_GIFT)


struct splice_desc {
	size_t total_len;		
	unsigned int len;		
	unsigned int flags;		
	
	union {
		void __user *userptr;	
		struct file *file;	
		void *data;		
	} u;
	void (*splice_eof)(struct splice_desc *sd); 
	loff_t pos;			
	loff_t *opos;			
	size_t num_spliced;		
	bool need_wakeup;		
};

struct partial_page {
	unsigned int offset;
	unsigned int len;
	unsigned long private;
};


struct splice_pipe_desc {
	struct page **pages;		
	struct partial_page *partial;	
	int nr_pages;			
	unsigned int nr_pages_max;	
	const struct pipe_buf_operations *ops;
	void (*spd_release)(struct splice_pipe_desc *, unsigned int);
};

typedef int (splice_actor)(struct pipe_inode_info *, struct pipe_buffer *,
			   struct splice_desc *);
typedef int (splice_direct_actor)(struct pipe_inode_info *,
				  struct splice_desc *);

ssize_t splice_from_pipe(struct pipe_inode_info *pipe, struct file *out,
			 loff_t *ppos, size_t len, unsigned int flags,
			 splice_actor *actor);
ssize_t __splice_from_pipe(struct pipe_inode_info *pipe,
			   struct splice_desc *sd, splice_actor *actor);
ssize_t splice_to_pipe(struct pipe_inode_info *pipe,
			      struct splice_pipe_desc *spd);
ssize_t add_to_pipe(struct pipe_inode_info *pipe, struct pipe_buffer *buf);
ssize_t vfs_splice_read(struct file *in, loff_t *ppos,
			struct pipe_inode_info *pipe, size_t len,
			unsigned int flags);
ssize_t splice_direct_to_actor(struct file *file, struct splice_desc *sd,
			       splice_direct_actor *actor);
ssize_t do_splice(struct file *in, loff_t *off_in, struct file *out,
		  loff_t *off_out, size_t len, unsigned int flags);
ssize_t do_splice_direct(struct file *in, loff_t *ppos, struct file *out,
			 loff_t *opos, size_t len, unsigned int flags);
ssize_t splice_file_range(struct file *in, loff_t *ppos, struct file *out,
			  loff_t *opos, size_t len);

static inline long splice_copy_file_range(struct file *in, loff_t pos_in,
					  struct file *out, loff_t pos_out,
					  size_t len)
{
	return splice_file_range(in, &pos_in, out, &pos_out, len);
}

ssize_t do_tee(struct file *in, struct file *out, size_t len,
	       unsigned int flags);
ssize_t splice_to_socket(struct pipe_inode_info *pipe, struct file *out,
			 loff_t *ppos, size_t len, unsigned int flags);


extern int splice_grow_spd(const struct pipe_inode_info *, struct splice_pipe_desc *);
extern void splice_shrink_spd(struct splice_pipe_desc *);

extern const struct pipe_buf_operations page_cache_pipe_buf_ops;
extern const struct pipe_buf_operations default_pipe_buf_ops;
#endif
