/* SPDX-License-Identifier: GPL-2.0 */
#ifndef TRACEPOINT_DEFS_H
#define TRACEPOINT_DEFS_H 1



#include <linux/atomic.h>
#include <linux/static_key.h>

struct static_call_key;

struct trace_print_flags {
	unsigned long		mask;
	const char		*name;
};

struct trace_print_flags_u64 {
	unsigned long long	mask;
	const char		*name;
};

struct tracepoint_func {
	void *func;
	void *data;
	int prio;
};

struct tracepoint_ext {
	int (*regfunc)(void);
	void (*unregfunc)(void);
	
	unsigned int faultable:1;
};

struct tracepoint {
	const char *name;		
	struct static_key_false key;
	struct static_call_key *static_call_key;
	void *static_call_tramp;
	void *iterator;
	void *probestub;
	struct tracepoint_func __rcu *funcs;
	struct tracepoint_ext *ext;
};

#ifdef CONFIG_HAVE_ARCH_PREL32_RELOCATIONS
typedef const int tracepoint_ptr_t;
#else
typedef struct tracepoint * const tracepoint_ptr_t;
#endif

struct bpf_raw_event_map {
	struct tracepoint	*tp;
	void			*bpf_func;
	u32			num_args;
	u32			writable_size;
} __aligned(32);


#define DECLARE_TRACEPOINT(tp) \
	extern struct tracepoint __tracepoint_##tp

#ifdef CONFIG_TRACEPOINTS
# define tracepoint_enabled(tp) \
	static_branch_unlikely(&(__tracepoint_##tp).key)
#else
# define tracepoint_enabled(tracepoint) false
#endif

#endif
