/* SPDX-License-Identifier: GPL-2.0-or-later */


#ifndef _M52790_H_
#define _M52790_H_



#define M52790_SW1_IN_MASK	0x0003
#define M52790_SW1_IN_TUNER	0x0000
#define M52790_SW1_IN_V2	0x0001
#define M52790_SW1_IN_V3	0x0002
#define M52790_SW1_IN_V4	0x0003


#define M52790_SW1_YCMIX	0x0004




#define M52790_SW2_IN_MASK	0x0300
#define M52790_SW2_IN_TUNER	0x0000
#define M52790_SW2_IN_V2	0x0100
#define M52790_SW2_IN_V3	0x0200
#define M52790_SW2_IN_V4	0x0300


#define M52790_SW2_YCMIX	0x0400





#define M52790_SW1_V_AMP	0x0008


#define M52790_SW1_YC_AMP	0x0010


#define M52790_SW1_AUDIO_MASK	0x00c0
#define M52790_SW1_AUDIO_MUTE	0x0000
#define M52790_SW1_AUDIO_R	0x0040
#define M52790_SW1_AUDIO_L	0x0080
#define M52790_SW1_AUDIO_STEREO 0x00c0





#define M52790_SW2_V_AMP	0x0800


#define M52790_SW2_YC_AMP	0x1000


#define M52790_SW2_AUDIO_MASK	0xc000
#define M52790_SW2_AUDIO_MUTE	0x0000
#define M52790_SW2_AUDIO_R	0x4000
#define M52790_SW2_AUDIO_L	0x8000
#define M52790_SW2_AUDIO_STEREO 0xc000



#define M52790_IN_TUNER (M52790_SW1_IN_TUNER | M52790_SW2_IN_TUNER)
#define M52790_IN_V2    (M52790_SW1_IN_V2 | M52790_SW2_IN_V2)
#define M52790_IN_V3    (M52790_SW1_IN_V3 | M52790_SW2_IN_V3)
#define M52790_IN_V4    (M52790_SW1_IN_V4 | M52790_SW2_IN_V4)

#define M52790_OUT_STEREO	(M52790_SW1_AUDIO_STEREO | \
				 M52790_SW2_AUDIO_STEREO)
#define M52790_OUT_AMP_STEREO	(M52790_SW1_AUDIO_STEREO | \
				 M52790_SW1_V_AMP | \
				 M52790_SW2_AUDIO_STEREO | \
				 M52790_SW2_V_AMP)

#endif
