/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef __V4L2_DV_TIMINGS_H
#define __V4L2_DV_TIMINGS_H

#include <linux/debugfs.h>
#include <linux/videodev2.h>


struct v4l2_fract v4l2_calc_timeperframe(const struct v4l2_dv_timings *t);


extern const struct v4l2_dv_timings v4l2_dv_timings_presets[];


typedef bool v4l2_check_dv_timings_fnc(const struct v4l2_dv_timings *t, void *handle);


bool v4l2_valid_dv_timings(const struct v4l2_dv_timings *t,
			   const struct v4l2_dv_timings_cap *cap,
			   v4l2_check_dv_timings_fnc fnc,
			   void *fnc_handle);


int v4l2_enum_dv_timings_cap(struct v4l2_enum_dv_timings *t,
			     const struct v4l2_dv_timings_cap *cap,
			     v4l2_check_dv_timings_fnc fnc,
			     void *fnc_handle);


bool v4l2_find_dv_timings_cap(struct v4l2_dv_timings *t,
			      const struct v4l2_dv_timings_cap *cap,
			      unsigned pclock_delta,
			      v4l2_check_dv_timings_fnc fnc,
			      void *fnc_handle);


bool v4l2_find_dv_timings_cea861_vic(struct v4l2_dv_timings *t, u8 vic);


bool v4l2_match_dv_timings(const struct v4l2_dv_timings *measured,
			   const struct v4l2_dv_timings *standard,
			   unsigned pclock_delta, bool match_reduced_fps);


void v4l2_print_dv_timings(const char *dev_prefix, const char *prefix,
			   const struct v4l2_dv_timings *t, bool detailed);


bool v4l2_detect_cvt(unsigned int frame_height, unsigned int hfreq,
		     unsigned int vsync, unsigned int active_width,
		     u32 polarities, bool interlaced,
		     const struct v4l2_dv_timings_cap *cap,
		     struct v4l2_dv_timings *fmt);


bool v4l2_detect_gtf(unsigned int frame_height, unsigned int hfreq,
		     unsigned int vsync, u32 polarities, bool interlaced,
		     struct v4l2_fract aspect,
		     const struct v4l2_dv_timings_cap *cap,
		     struct v4l2_dv_timings *fmt);


struct v4l2_fract v4l2_calc_aspect_ratio(u8 hor_landscape, u8 vert_portrait);


struct v4l2_fract v4l2_dv_timings_aspect_ratio(const struct v4l2_dv_timings *t);


static inline  bool can_reduce_fps(struct v4l2_bt_timings *bt)
{
	if ((bt->standards & V4L2_DV_BT_STD_CVT) && (bt->vsync == 8))
		return true;

	if ((bt->standards & V4L2_DV_BT_STD_CEA861) &&
	    (bt->flags & V4L2_DV_FL_CAN_REDUCE_FPS))
		return true;

	return false;
}


struct v4l2_hdmi_colorimetry {
	enum v4l2_colorspace colorspace;
	enum v4l2_ycbcr_encoding ycbcr_enc;
	enum v4l2_quantization quantization;
	enum v4l2_xfer_func xfer_func;
};

struct hdmi_avi_infoframe;
struct hdmi_vendor_infoframe;

struct v4l2_hdmi_colorimetry
v4l2_hdmi_rx_colorimetry(const struct hdmi_avi_infoframe *avi,
			 const struct hdmi_vendor_infoframe *hdmi,
			 unsigned int height);

u16 v4l2_get_edid_phys_addr(const u8 *edid, unsigned int size,
			    unsigned int *offset);
void v4l2_set_edid_phys_addr(u8 *edid, unsigned int size, u16 phys_addr);
u16 v4l2_phys_addr_for_input(u16 phys_addr, u8 input);
int v4l2_phys_addr_validate(u16 phys_addr, u16 *parent, u16 *port);




#define V4L2_DEBUGFS_IF_MAX_LEN (35)

#define V4L2_DEBUGFS_IF_AVI	BIT(0)
#define V4L2_DEBUGFS_IF_AUDIO	BIT(1)
#define V4L2_DEBUGFS_IF_SPD	BIT(2)
#define V4L2_DEBUGFS_IF_HDMI	BIT(3)

typedef ssize_t (*v4l2_debugfs_if_read_t)(u32 type, void *priv,
					  struct file *filp, char __user *ubuf,
					  size_t count, loff_t *ppos);

struct v4l2_debugfs_if {
	struct dentry *if_dir;
	void *priv;

	v4l2_debugfs_if_read_t if_read;
};

#ifdef CONFIG_DEBUG_FS
struct v4l2_debugfs_if *v4l2_debugfs_if_alloc(struct dentry *root, u32 if_types,
					      void *priv,
					      v4l2_debugfs_if_read_t if_read);
void v4l2_debugfs_if_free(struct v4l2_debugfs_if *infoframes);
#else
static inline
struct v4l2_debugfs_if *v4l2_debugfs_if_alloc(struct dentry *root, u32 if_types,
					      void *priv,
					      v4l2_debugfs_if_read_t if_read)
{
	return NULL;
}

static inline void v4l2_debugfs_if_free(struct v4l2_debugfs_if *infoframes)
{
}
#endif

#endif
