/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef _LINUX_DROPREASON_CORE_H
#define _LINUX_DROPREASON_CORE_H

#define DEFINE_DROP_REASON(FN, FNe)	\
	FN(NOT_SPECIFIED)		\
	FN(NO_SOCKET)			\
	FN(PKT_TOO_SMALL)		\
	FN(TCP_CSUM)			\
	FN(SOCKET_FILTER)		\
	FN(UDP_CSUM)			\
	FN(NETFILTER_DROP)		\
	FN(OTHERHOST)			\
	FN(IP_CSUM)			\
	FN(IP_INHDR)			\
	FN(IP_RPFILTER)			\
	FN(UNICAST_IN_L2_MULTICAST)	\
	FN(XFRM_POLICY)			\
	FN(IP_NOPROTO)			\
	FN(SOCKET_RCVBUFF)		\
	FN(PROTO_MEM)			\
	FN(TCP_AUTH_HDR)		\
	FN(TCP_MD5NOTFOUND)		\
	FN(TCP_MD5UNEXPECTED)		\
	FN(TCP_MD5FAILURE)		\
	FN(TCP_AONOTFOUND)		\
	FN(TCP_AOUNEXPECTED)		\
	FN(TCP_AOKEYNOTFOUND)		\
	FN(TCP_AOFAILURE)		\
	FN(SOCKET_BACKLOG)		\
	FN(TCP_FLAGS)			\
	FN(TCP_ABORT_ON_DATA)		\
	FN(TCP_ZEROWINDOW)		\
	FN(TCP_OLD_DATA)		\
	FN(TCP_OVERWINDOW)		\
	FN(TCP_OFOMERGE)		\
	FN(TCP_RFC7323_PAWS)		\
	FN(TCP_OLD_SEQUENCE)		\
	FN(TCP_INVALID_SEQUENCE)	\
	FN(TCP_INVALID_ACK_SEQUENCE)	\
	FN(TCP_RESET)			\
	FN(TCP_INVALID_SYN)		\
	FN(TCP_CLOSE)			\
	FN(TCP_FASTOPEN)		\
	FN(TCP_OLD_ACK)			\
	FN(TCP_TOO_OLD_ACK)		\
	FN(TCP_ACK_UNSENT_DATA)		\
	FN(TCP_OFO_QUEUE_PRUNE)		\
	FN(TCP_OFO_DROP)		\
	FN(IP_OUTNOROUTES)		\
	FN(BPF_CGROUP_EGRESS)		\
	FN(IPV6DISABLED)		\
	FN(NEIGH_CREATEFAIL)		\
	FN(NEIGH_FAILED)		\
	FN(NEIGH_QUEUEFULL)		\
	FN(NEIGH_DEAD)			\
	FN(TC_EGRESS)			\
	FN(SECURITY_HOOK)		\
	FN(QDISC_DROP)			\
	FN(CPU_BACKLOG)			\
	FN(XDP)				\
	FN(TC_INGRESS)			\
	FN(UNHANDLED_PROTO)		\
	FN(SKB_CSUM)			\
	FN(SKB_GSO_SEG)			\
	FN(SKB_UCOPY_FAULT)		\
	FN(DEV_HDR)			\
	FN(DEV_READY)			\
	FN(FULL_RING)			\
	FN(NOMEM)			\
	FN(HDR_TRUNC)			\
	FN(TAP_FILTER)			\
	FN(TAP_TXFILTER)		\
	FN(ICMP_CSUM)			\
	FN(INVALID_PROTO)		\
	FN(IP_INADDRERRORS)		\
	FN(IP_INNOROUTES)		\
	FN(IP_LOCAL_SOURCE)		\
	FN(IP_INVALID_SOURCE)		\
	FN(IP_LOCALNET)			\
	FN(IP_INVALID_DEST)		\
	FN(PKT_TOO_BIG)			\
	FN(DUP_FRAG)			\
	FN(FRAG_REASM_TIMEOUT)		\
	FN(FRAG_TOO_FAR)		\
	FN(TCP_MINTTL)			\
	FN(IPV6_BAD_EXTHDR)		\
	FN(IPV6_NDISC_FRAG)		\
	FN(IPV6_NDISC_HOP_LIMIT)	\
	FN(IPV6_NDISC_BAD_CODE)		\
	FN(IPV6_NDISC_BAD_OPTIONS)	\
	FN(IPV6_NDISC_NS_OTHERHOST)	\
	FN(QUEUE_PURGE)			\
	FN(TC_COOKIE_ERROR)		\
	FN(PACKET_SOCK_ERROR)		\
	FN(TC_CHAIN_NOTFOUND)		\
	FN(TC_RECLASSIFY_LOOP)		\
	FN(VXLAN_INVALID_HDR)		\
	FN(VXLAN_VNI_NOT_FOUND)		\
	FN(MAC_INVALID_SOURCE)		\
	FN(VXLAN_ENTRY_EXISTS)		\
	FN(VXLAN_NO_REMOTE)		\
	FN(IP_TUNNEL_ECN)		\
	FN(TUNNEL_TXINFO)		\
	FN(LOCAL_MAC)			\
	FN(ARP_PVLAN_DISABLE)		\
	FNe(MAX)


enum skb_drop_reason {
	
	SKB_NOT_DROPPED_YET = 0,
	
	SKB_CONSUMED,
	
	SKB_DROP_REASON_NOT_SPECIFIED,
	
	SKB_DROP_REASON_NO_SOCKET,
	
	SKB_DROP_REASON_PKT_TOO_SMALL,
	
	SKB_DROP_REASON_TCP_CSUM,
	
	SKB_DROP_REASON_SOCKET_FILTER,
	
	SKB_DROP_REASON_UDP_CSUM,
	
	SKB_DROP_REASON_NETFILTER_DROP,
	
	SKB_DROP_REASON_OTHERHOST,
	
	SKB_DROP_REASON_IP_CSUM,
	
	SKB_DROP_REASON_IP_INHDR,
	
	SKB_DROP_REASON_IP_RPFILTER,
	
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST,
	
	SKB_DROP_REASON_XFRM_POLICY,
	
	SKB_DROP_REASON_IP_NOPROTO,
	
	SKB_DROP_REASON_SOCKET_RCVBUFF,
	
	SKB_DROP_REASON_PROTO_MEM,
	
	SKB_DROP_REASON_TCP_AUTH_HDR,
	
	SKB_DROP_REASON_TCP_MD5NOTFOUND,
	
	SKB_DROP_REASON_TCP_MD5UNEXPECTED,
	
	SKB_DROP_REASON_TCP_MD5FAILURE,
	
	SKB_DROP_REASON_TCP_AONOTFOUND,
	
	SKB_DROP_REASON_TCP_AOUNEXPECTED,
	
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND,
	
	SKB_DROP_REASON_TCP_AOFAILURE,
	
	SKB_DROP_REASON_SOCKET_BACKLOG,
	
	SKB_DROP_REASON_TCP_FLAGS,
	
	SKB_DROP_REASON_TCP_ABORT_ON_DATA,
	
	SKB_DROP_REASON_TCP_ZEROWINDOW,
	
	SKB_DROP_REASON_TCP_OLD_DATA,
	
	SKB_DROP_REASON_TCP_OVERWINDOW,
	
	SKB_DROP_REASON_TCP_OFOMERGE,
	
	SKB_DROP_REASON_TCP_RFC7323_PAWS,
	
	SKB_DROP_REASON_TCP_OLD_SEQUENCE,
	
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE,
	
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE,
	
	SKB_DROP_REASON_TCP_RESET,
	
	SKB_DROP_REASON_TCP_INVALID_SYN,
	
	SKB_DROP_REASON_TCP_CLOSE,
	
	SKB_DROP_REASON_TCP_FASTOPEN,
	
	SKB_DROP_REASON_TCP_OLD_ACK,
	
	SKB_DROP_REASON_TCP_TOO_OLD_ACK,
	
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA,
	
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE,
	
	SKB_DROP_REASON_TCP_OFO_DROP,
	
	SKB_DROP_REASON_IP_OUTNOROUTES,
	
	SKB_DROP_REASON_BPF_CGROUP_EGRESS,
	
	SKB_DROP_REASON_IPV6DISABLED,
	
	SKB_DROP_REASON_NEIGH_CREATEFAIL,
	
	SKB_DROP_REASON_NEIGH_FAILED,
	
	SKB_DROP_REASON_NEIGH_QUEUEFULL,
	
	SKB_DROP_REASON_NEIGH_DEAD,
	
	SKB_DROP_REASON_TC_EGRESS,
	
	SKB_DROP_REASON_SECURITY_HOOK,
	
	SKB_DROP_REASON_QDISC_DROP,
	
	SKB_DROP_REASON_CPU_BACKLOG,
	
	SKB_DROP_REASON_XDP,
	
	SKB_DROP_REASON_TC_INGRESS,
	
	SKB_DROP_REASON_UNHANDLED_PROTO,
	
	SKB_DROP_REASON_SKB_CSUM,
	
	SKB_DROP_REASON_SKB_GSO_SEG,
	
	SKB_DROP_REASON_SKB_UCOPY_FAULT,
	
	SKB_DROP_REASON_DEV_HDR,
	
	SKB_DROP_REASON_DEV_READY,
	
	SKB_DROP_REASON_FULL_RING,
	
	SKB_DROP_REASON_NOMEM,
	
	SKB_DROP_REASON_HDR_TRUNC,
	
	SKB_DROP_REASON_TAP_FILTER,
	
	SKB_DROP_REASON_TAP_TXFILTER,
	
	SKB_DROP_REASON_ICMP_CSUM,
	
	SKB_DROP_REASON_INVALID_PROTO,
	
	SKB_DROP_REASON_IP_INADDRERRORS,
	
	SKB_DROP_REASON_IP_INNOROUTES,
	
	SKB_DROP_REASON_IP_LOCAL_SOURCE,
	
	SKB_DROP_REASON_IP_INVALID_SOURCE,
	
	SKB_DROP_REASON_IP_LOCALNET,
	
	SKB_DROP_REASON_IP_INVALID_DEST,
	
	SKB_DROP_REASON_PKT_TOO_BIG,
	
	SKB_DROP_REASON_DUP_FRAG,
	
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT,
	
	SKB_DROP_REASON_FRAG_TOO_FAR,
	
	SKB_DROP_REASON_TCP_MINTTL,
	
	SKB_DROP_REASON_IPV6_BAD_EXTHDR,
	
	SKB_DROP_REASON_IPV6_NDISC_FRAG,
	
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT,
	
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE,
	
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS,
	
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST,
	
	SKB_DROP_REASON_QUEUE_PURGE,
	
	SKB_DROP_REASON_TC_COOKIE_ERROR,
	
	SKB_DROP_REASON_PACKET_SOCK_ERROR,
	
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND,
	
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP,
	
	SKB_DROP_REASON_VXLAN_INVALID_HDR,
	
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND,
	
	SKB_DROP_REASON_MAC_INVALID_SOURCE,
	
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS,
	
	SKB_DROP_REASON_VXLAN_NO_REMOTE,
	
	SKB_DROP_REASON_IP_TUNNEL_ECN,
	
	SKB_DROP_REASON_TUNNEL_TXINFO,
	
	SKB_DROP_REASON_LOCAL_MAC,
	
	SKB_DROP_REASON_ARP_PVLAN_DISABLE,
	
	SKB_DROP_REASON_MAX,

	
	SKB_DROP_REASON_SUBSYS_MASK = 0xffff0000,
};

#define SKB_DROP_REASON_SUBSYS_SHIFT	16

#define SKB_DR_INIT(name, reason)				\
	enum skb_drop_reason name = SKB_DROP_REASON_##reason
#define SKB_DR(name)						\
	SKB_DR_INIT(name, NOT_SPECIFIED)
#define SKB_DR_SET(name, reason)				\
	(name = SKB_DROP_REASON_##reason)
#define SKB_DR_OR(name, reason)					\
	do {							\
		if (name == SKB_DROP_REASON_NOT_SPECIFIED ||	\
		    name == SKB_NOT_DROPPED_YET)		\
			SKB_DR_SET(name, reason);		\
	} while (0)

#endif
