/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef _NET_SHAPER_H_
#define _NET_SHAPER_H_

#include <linux/types.h>

#include <uapi/linux/net_shaper.h>

struct net_device;
struct devlink;
struct netlink_ext_ack;

enum net_shaper_binding_type {
	NET_SHAPER_BINDING_TYPE_NETDEV,
	
};

struct net_shaper_binding {
	enum net_shaper_binding_type type;
	union {
		struct net_device *netdev;
		struct devlink *devlink;
	};
};

struct net_shaper_handle {
	enum net_shaper_scope scope;
	u32 id;
};


struct net_shaper {
	struct net_shaper_handle parent;
	struct net_shaper_handle handle;
	enum net_shaper_metric metric;
	u64 bw_min;
	u64 bw_max;
	u64 burst;
	u32 priority;
	u32 weight;

	
	u32 leaves; 
	struct rcu_head rcu;
};


struct net_shaper_ops {
	
	int (*group)(struct net_shaper_binding *binding, int leaves_count,
		     const struct net_shaper *leaves,
		     const struct net_shaper *node,
		     struct netlink_ext_ack *extack);

	
	int (*set)(struct net_shaper_binding *binding,
		   const struct net_shaper *shaper,
		   struct netlink_ext_ack *extack);

	
	int (*delete)(struct net_shaper_binding *binding,
		      const struct net_shaper_handle *handle,
		      struct netlink_ext_ack *extack);

	
	void (*capabilities)(struct net_shaper_binding *binding,
			     enum net_shaper_scope scope, unsigned long *cap);
};

#endif
