/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef _LINUX_RSTREASON_H
#define _LINUX_RSTREASON_H
#include <net/dropreason-core.h>
#include <uapi/linux/mptcp.h>

#define DEFINE_RST_REASON(FN, FNe)	\
	FN(NOT_SPECIFIED)		\
	FN(NO_SOCKET)			\
	FN(TCP_INVALID_ACK_SEQUENCE)	\
	FN(TCP_RFC7323_PAWS)		\
	FN(TCP_TOO_OLD_ACK)		\
	FN(TCP_ACK_UNSENT_DATA)		\
	FN(TCP_FLAGS)			\
	FN(TCP_OLD_ACK)			\
	FN(TCP_ABORT_ON_DATA)		\
	FN(TCP_TIMEWAIT_SOCKET)		\
	FN(INVALID_SYN)			\
	FN(TCP_ABORT_ON_CLOSE)		\
	FN(TCP_ABORT_ON_LINGER)		\
	FN(TCP_ABORT_ON_MEMORY)		\
	FN(TCP_STATE)			\
	FN(TCP_KEEPALIVE_TIMEOUT)	\
	FN(TCP_DISCONNECT_WITH_DATA)	\
	FN(MPTCP_RST_EUNSPEC)		\
	FN(MPTCP_RST_EMPTCP)		\
	FN(MPTCP_RST_ERESOURCE)		\
	FN(MPTCP_RST_EPROHIBIT)		\
	FN(MPTCP_RST_EWQ2BIG)		\
	FN(MPTCP_RST_EBADPERF)		\
	FN(MPTCP_RST_EMIDDLEBOX)	\
	FN(ERROR)			\
	FNe(MAX)


enum sk_rst_reason {
	
	
	SK_RST_REASON_NOT_SPECIFIED,
	
	SK_RST_REASON_NO_SOCKET,
	
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE,
	
	SK_RST_REASON_TCP_RFC7323_PAWS,
	
	SK_RST_REASON_TCP_TOO_OLD_ACK,
	
	SK_RST_REASON_TCP_ACK_UNSENT_DATA,
	
	SK_RST_REASON_TCP_FLAGS,
	
	SK_RST_REASON_TCP_OLD_ACK,
	
	SK_RST_REASON_TCP_ABORT_ON_DATA,

	
	
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET,
	
	SK_RST_REASON_INVALID_SYN,
	
	SK_RST_REASON_TCP_ABORT_ON_CLOSE,
	
	SK_RST_REASON_TCP_ABORT_ON_LINGER,
	
	SK_RST_REASON_TCP_ABORT_ON_MEMORY,
	
	SK_RST_REASON_TCP_STATE,
	
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT,
	
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA,

	
	
	SK_RST_REASON_MPTCP_RST_EUNSPEC,
	
	SK_RST_REASON_MPTCP_RST_EMPTCP,
	
	SK_RST_REASON_MPTCP_RST_ERESOURCE,
	
	SK_RST_REASON_MPTCP_RST_EPROHIBIT,
	
	SK_RST_REASON_MPTCP_RST_EWQ2BIG,
	
	SK_RST_REASON_MPTCP_RST_EBADPERF,
	
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX,

	
	SK_RST_REASON_ERROR,

	
	SK_RST_REASON_MAX,
};


static inline enum sk_rst_reason
sk_rst_convert_drop_reason(enum skb_drop_reason reason)
{
	switch (reason) {
	case SKB_DROP_REASON_NOT_SPECIFIED:
		return SK_RST_REASON_NOT_SPECIFIED;
	case SKB_DROP_REASON_NO_SOCKET:
		return SK_RST_REASON_NO_SOCKET;
	case SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE:
		return SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE;
	case SKB_DROP_REASON_TCP_RFC7323_PAWS:
		return SK_RST_REASON_TCP_RFC7323_PAWS;
	case SKB_DROP_REASON_TCP_TOO_OLD_ACK:
		return SK_RST_REASON_TCP_TOO_OLD_ACK;
	case SKB_DROP_REASON_TCP_ACK_UNSENT_DATA:
		return SK_RST_REASON_TCP_ACK_UNSENT_DATA;
	case SKB_DROP_REASON_TCP_FLAGS:
		return SK_RST_REASON_TCP_FLAGS;
	case SKB_DROP_REASON_TCP_OLD_ACK:
		return SK_RST_REASON_TCP_OLD_ACK;
	case SKB_DROP_REASON_TCP_ABORT_ON_DATA:
		return SK_RST_REASON_TCP_ABORT_ON_DATA;
	default:
		
		return SK_RST_REASON_NOT_SPECIFIED;
	}
}
#endif
