/* SPDX-License-Identifier: GPL-2.0 */

#ifndef _SCSI_SCSI_STATUS_H
#define _SCSI_SCSI_STATUS_H

#include <linux/types.h>
#include <scsi/scsi_proto.h>


enum scsi_msg_byte {
	COMMAND_COMPLETE	= 0x00,
	EXTENDED_MESSAGE	= 0x01,
	SAVE_POINTERS		= 0x02,
	RESTORE_POINTERS	= 0x03,
	DISCONNECT		= 0x04,
	INITIATOR_ERROR		= 0x05,
	ABORT_TASK_SET		= 0x06,
	MESSAGE_REJECT		= 0x07,
	NOP			= 0x08,
	MSG_PARITY_ERROR	= 0x09,
	LINKED_CMD_COMPLETE	= 0x0a,
	LINKED_FLG_CMD_COMPLETE	= 0x0b,
	TARGET_RESET		= 0x0c,
	ABORT_TASK		= 0x0d,
	CLEAR_TASK_SET		= 0x0e,
	INITIATE_RECOVERY	= 0x0f,            
	RELEASE_RECOVERY	= 0x10,            
	TERMINATE_IO_PROC	= 0x11,            
	CLEAR_ACA		= 0x16,
	LOGICAL_UNIT_RESET	= 0x17,
	SIMPLE_QUEUE_TAG	= 0x20,
	HEAD_OF_QUEUE_TAG	= 0x21,
	ORDERED_QUEUE_TAG	= 0x22,
	IGNORE_WIDE_RESIDUE	= 0x23,
	ACA			= 0x24,
	QAS_REQUEST		= 0x55,

	
	BUS_DEVICE_RESET	= TARGET_RESET,
	ABORT			= ABORT_TASK_SET,
};


enum scsi_host_status {
	DID_OK		= 0x00,	
	DID_NO_CONNECT	= 0x01,	
	DID_BUS_BUSY	= 0x02,	
	DID_TIME_OUT	= 0x03,	
	DID_BAD_TARGET	= 0x04,	
	DID_ABORT	= 0x05,	
	DID_PARITY	= 0x06,	
	DID_ERROR	= 0x07,	
	DID_RESET	= 0x08,	
	DID_BAD_INTR	= 0x09,	
	DID_PASSTHROUGH	= 0x0a,	
	DID_SOFT_ERROR	= 0x0b,	
	DID_IMM_RETRY	= 0x0c,	
	DID_REQUEUE	= 0x0d,	
	DID_TRANSPORT_DISRUPTED = 0x0e, 
	DID_TRANSPORT_FAILFAST = 0x0f, 
	
	DID_TRANSPORT_MARGINAL = 0x14, 
};

#endif 
