/* SPDX-License-Identifier: GPL-2.0-only */


#ifndef _DA7213_PDATA_H
#define _DA7213_PDATA_H

enum da7213_micbias_voltage {
	DA7213_MICBIAS_1_6V = 0,
	DA7213_MICBIAS_2_2V = 1,
	DA7213_MICBIAS_2_5V = 2,
	DA7213_MICBIAS_3_0V = 3,
};

enum da7213_dmic_data_sel {
	DA7213_DMIC_DATA_LRISE_RFALL = 0,
	DA7213_DMIC_DATA_LFALL_RRISE = 1,
};

enum da7213_dmic_samplephase {
	DA7213_DMIC_SAMPLE_ON_CLKEDGE = 0,
	DA7213_DMIC_SAMPLE_BETWEEN_CLKEDGE = 1,
};

enum da7213_dmic_clk_rate {
	DA7213_DMIC_CLK_3_0MHZ = 0,
	DA7213_DMIC_CLK_1_5MHZ = 1,
};

struct da7213_platform_data {
	
	enum da7213_micbias_voltage micbias1_lvl;
	enum da7213_micbias_voltage micbias2_lvl;

	
	enum da7213_dmic_data_sel dmic_data_sel;
	enum da7213_dmic_samplephase dmic_samplephase;
	enum da7213_dmic_clk_rate dmic_clk_rate;
};

#endif 
