/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-3-Clause) */


#ifndef __SDCA_H__
#define __SDCA_H__

struct sdw_slave;

#define SDCA_MAX_FUNCTION_COUNT 8


struct sdca_function_desc {
	u64 adr;
	u32 type;
	const char *name;
};


struct sdca_device_data {
	u32 interface_revision;
	int num_functions;
	struct sdca_function_desc sdca_func[SDCA_MAX_FUNCTION_COUNT];
};

enum sdca_quirk {
	SDCA_QUIRKS_RT712_VB,
};

#if IS_ENABLED(CONFIG_ACPI) && IS_ENABLED(CONFIG_SND_SOC_SDCA)

void sdca_lookup_functions(struct sdw_slave *slave);
void sdca_lookup_interface_revision(struct sdw_slave *slave);
bool sdca_device_quirk_match(struct sdw_slave *slave, enum sdca_quirk quirk);

#else

static inline void sdca_lookup_functions(struct sdw_slave *slave) {}
static inline void sdca_lookup_interface_revision(struct sdw_slave *slave) {}
static inline bool sdca_device_quirk_match(struct sdw_slave *slave, enum sdca_quirk quirk)
{
	return false;
}
#endif

#endif
