/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-3-Clause) */


#ifndef __INCLUDE_SOUND_SOF_IPC4_HEADER_H__
#define __INCLUDE_SOUND_SOF_IPC4_HEADER_H__

#include <linux/types.h>
#include <uapi/sound/sof/abi.h>


#define SOF_IPC4_MSG_MAX_SIZE			4096




struct sof_ipc4_msg {
	union {
		u64 header_u64;
		struct {
			u32 primary;
			u32 extension;
		};
	};

	size_t data_size;
	void *data_ptr;
};


struct sof_ipc4_tuple {
	uint32_t type;
	uint32_t size;
	uint32_t value[];
} __packed;






enum sof_ipc4_msg_target {
	
	SOF_IPC4_FW_GEN_MSG,

	
	SOF_IPC4_MODULE_MSG
};


enum sof_ipc4_global_msg {
	SOF_IPC4_GLB_BOOT_CONFIG,
	SOF_IPC4_GLB_ROM_CONTROL,
	SOF_IPC4_GLB_IPCGATEWAY_CMD,

	

	SOF_IPC4_GLB_PERF_MEASUREMENTS_CMD = 13,
	SOF_IPC4_GLB_CHAIN_DMA,

	SOF_IPC4_GLB_LOAD_MULTIPLE_MODULES,
	SOF_IPC4_GLB_UNLOAD_MULTIPLE_MODULES,

	
	SOF_IPC4_GLB_CREATE_PIPELINE,
	SOF_IPC4_GLB_DELETE_PIPELINE,
	SOF_IPC4_GLB_SET_PIPELINE_STATE,
	SOF_IPC4_GLB_GET_PIPELINE_STATE,
	SOF_IPC4_GLB_GET_PIPELINE_CONTEXT_SIZE,
	SOF_IPC4_GLB_SAVE_PIPELINE,
	SOF_IPC4_GLB_RESTORE_PIPELINE,

	
	SOF_IPC4_GLB_LOAD_LIBRARY,
	
	SOF_IPC4_GLB_LOAD_LIBRARY_PREPARE,

	SOF_IPC4_GLB_INTERNAL_MESSAGE,

	
	SOF_IPC4_GLB_NOTIFICATION,

	

	SOF_IPC4_GLB_TYPE_LAST,
};


enum sof_ipc4_msg_dir {
	SOF_IPC4_MSG_REQUEST,
	SOF_IPC4_MSG_REPLY,
};

enum sof_ipc4_pipeline_state {
	SOF_IPC4_PIPE_INVALID_STATE,
	SOF_IPC4_PIPE_UNINITIALIZED,
	SOF_IPC4_PIPE_RESET,
	SOF_IPC4_PIPE_PAUSED,
	SOF_IPC4_PIPE_RUNNING,
	SOF_IPC4_PIPE_EOS
};




#define SOF_IPC4_MSG_TARGET_SHIFT		30
#define SOF_IPC4_MSG_TARGET_MASK		BIT(30)
#define SOF_IPC4_MSG_TARGET(x)			((x) << SOF_IPC4_MSG_TARGET_SHIFT)
#define SOF_IPC4_MSG_IS_MODULE_MSG(x)		((x) & SOF_IPC4_MSG_TARGET_MASK ? 1 : 0)


#define SOF_IPC4_MSG_DIR_SHIFT			29
#define SOF_IPC4_MSG_DIR_MASK			BIT(29)
#define SOF_IPC4_MSG_DIR(x)			((x) << SOF_IPC4_MSG_DIR_SHIFT)


#define SOF_IPC4_MSG_TYPE_SHIFT			24
#define SOF_IPC4_MSG_TYPE_MASK			GENMASK(28, 24)
#define SOF_IPC4_MSG_TYPE_SET(x)		(((x) << SOF_IPC4_MSG_TYPE_SHIFT) & \
						 SOF_IPC4_MSG_TYPE_MASK)
#define SOF_IPC4_MSG_TYPE_GET(x)		(((x) & SOF_IPC4_MSG_TYPE_MASK) >> \
						 SOF_IPC4_MSG_TYPE_SHIFT)




#define SOF_IPC4_GLB_PIPE_INSTANCE_SHIFT	16
#define SOF_IPC4_GLB_PIPE_INSTANCE_MASK		GENMASK(23, 16)
#define SOF_IPC4_GLB_PIPE_INSTANCE_ID(x)	((x) << SOF_IPC4_GLB_PIPE_INSTANCE_SHIFT)

#define SOF_IPC4_GLB_PIPE_PRIORITY_SHIFT	11
#define SOF_IPC4_GLB_PIPE_PRIORITY_MASK		GENMASK(15, 11)
#define SOF_IPC4_GLB_PIPE_PRIORITY(x)		((x) << SOF_IPC4_GLB_PIPE_PRIORITY_SHIFT)

#define SOF_IPC4_GLB_PIPE_MEM_SIZE_SHIFT	0
#define SOF_IPC4_GLB_PIPE_MEM_SIZE_MASK		GENMASK(10, 0)
#define SOF_IPC4_GLB_PIPE_MEM_SIZE(x)		((x) << SOF_IPC4_GLB_PIPE_MEM_SIZE_SHIFT)

#define SOF_IPC4_GLB_PIPE_EXT_LP_SHIFT		0
#define SOF_IPC4_GLB_PIPE_EXT_LP_MASK		BIT(0)
#define SOF_IPC4_GLB_PIPE_EXT_LP(x)		((x) << SOF_IPC4_GLB_PIPE_EXT_LP_SHIFT)

#define SOF_IPC4_GLB_PIPE_EXT_CORE_ID_SHIFT	20
#define SOF_IPC4_GLB_PIPE_EXT_CORE_ID_MASK	GENMASK(23, 20)
#define SOF_IPC4_GLB_PIPE_EXT_CORE_ID(x)	((x) << SOF_IPC4_GLB_PIPE_EXT_CORE_ID_SHIFT)


#define SOF_IPC4_GLB_PIPE_STATE_ID_SHIFT		16
#define SOF_IPC4_GLB_PIPE_STATE_ID_MASK		GENMASK(23, 16)
#define SOF_IPC4_GLB_PIPE_STATE_ID(x)		((x) << SOF_IPC4_GLB_PIPE_STATE_ID_SHIFT)

#define SOF_IPC4_GLB_PIPE_STATE_SHIFT		0
#define SOF_IPC4_GLB_PIPE_STATE_MASK		GENMASK(15, 0)
#define SOF_IPC4_GLB_PIPE_STATE(x)		((x) << SOF_IPC4_GLB_PIPE_STATE_SHIFT)


#define SOF_IPC4_GLB_PIPE_STATE_EXT_MULTI	BIT(0)


#define SOF_IPC4_GLB_LOAD_LIBRARY_LIB_ID_SHIFT	16
#define SOF_IPC4_GLB_LOAD_LIBRARY_LIB_ID(x)	((x) << SOF_IPC4_GLB_LOAD_LIBRARY_LIB_ID_SHIFT)


#define SOF_IPC4_GLB_CHAIN_DMA_HOST_ID_SHIFT	0
#define SOF_IPC4_GLB_CHAIN_DMA_HOST_ID_MASK	GENMASK(4, 0)
#define SOF_IPC4_GLB_CHAIN_DMA_HOST_ID(x)	(((x) << SOF_IPC4_GLB_CHAIN_DMA_HOST_ID_SHIFT) & \
						 SOF_IPC4_GLB_CHAIN_DMA_HOST_ID_MASK)

#define SOF_IPC4_GLB_CHAIN_DMA_LINK_ID_SHIFT	8
#define SOF_IPC4_GLB_CHAIN_DMA_LINK_ID_MASK	GENMASK(12, 8)
#define SOF_IPC4_GLB_CHAIN_DMA_LINK_ID(x)	(((x) << SOF_IPC4_GLB_CHAIN_DMA_LINK_ID_SHIFT) & \
						 SOF_IPC4_GLB_CHAIN_DMA_LINK_ID_MASK)

#define SOF_IPC4_GLB_CHAIN_DMA_ALLOCATE_SHIFT	16
#define SOF_IPC4_GLB_CHAIN_DMA_ALLOCATE_MASK	BIT(16)
#define SOF_IPC4_GLB_CHAIN_DMA_ALLOCATE(x)	(((x) & 1) << SOF_IPC4_GLB_CHAIN_DMA_ALLOCATE_SHIFT)

#define SOF_IPC4_GLB_CHAIN_DMA_ENABLE_SHIFT	17
#define SOF_IPC4_GLB_CHAIN_DMA_ENABLE_MASK	BIT(17)
#define SOF_IPC4_GLB_CHAIN_DMA_ENABLE(x)	(((x) & 1) << SOF_IPC4_GLB_CHAIN_DMA_ENABLE_SHIFT)

#define SOF_IPC4_GLB_CHAIN_DMA_SCS_SHIFT	18
#define SOF_IPC4_GLB_CHAIN_DMA_SCS_MASK		BIT(18)
#define SOF_IPC4_GLB_CHAIN_DMA_SCS(x)		(((x) & 1) << SOF_IPC4_GLB_CHAIN_DMA_SCS_SHIFT)

#define SOF_IPC4_GLB_EXT_CHAIN_DMA_FIFO_SIZE_SHIFT 0
#define SOF_IPC4_GLB_EXT_CHAIN_DMA_FIFO_SIZE_MASK  GENMASK(24, 0)
#define SOF_IPC4_GLB_EXT_CHAIN_DMA_FIFO_SIZE(x)	   (((x) << \
						     SOF_IPC4_GLB_EXT_CHAIN_DMA_FIFO_SIZE_SHIFT) & \
						    SOF_IPC4_GLB_EXT_CHAIN_DMA_FIFO_SIZE_MASK)

enum sof_ipc4_channel_config {
	
	SOF_IPC4_CHANNEL_CONFIG_MONO,
	
	SOF_IPC4_CHANNEL_CONFIG_STEREO,
	
	SOF_IPC4_CHANNEL_CONFIG_2_POINT_1,
	
	SOF_IPC4_CHANNEL_CONFIG_3_POINT_0,
	
	SOF_IPC4_CHANNEL_CONFIG_3_POINT_1,
	
	SOF_IPC4_CHANNEL_CONFIG_QUATRO,
	
	SOF_IPC4_CHANNEL_CONFIG_4_POINT_0,
	
	SOF_IPC4_CHANNEL_CONFIG_5_POINT_0,
	
	SOF_IPC4_CHANNEL_CONFIG_5_POINT_1,
	
	SOF_IPC4_CHANNEL_CONFIG_DUAL_MONO,
	
	SOF_IPC4_CHANNEL_CONFIG_I2S_DUAL_STEREO_0,
	
	SOF_IPC4_CHANNEL_CONFIG_I2S_DUAL_STEREO_1,
	
	SOF_IPC4_CHANNEL_CONFIG_7_POINT_1,
};

enum sof_ipc4_interleaved_style {
	SOF_IPC4_CHANNELS_INTERLEAVED,
	SOF_IPC4_CHANNELS_NONINTERLEAVED,
};

enum sof_ipc4_sample_type {
	SOF_IPC4_MSB_INTEGER, 
	SOF_IPC4_LSB_INTEGER, 
};

struct sof_ipc4_audio_format {
	uint32_t sampling_frequency;
	uint32_t bit_depth;
	uint32_t ch_map;
	uint32_t ch_cfg; 
	uint32_t interleaving_style;
	uint32_t fmt_cfg; 
} __packed __aligned(4);

#define SOF_IPC4_AUDIO_FORMAT_CFG_CHANNELS_COUNT_SHIFT	0
#define SOF_IPC4_AUDIO_FORMAT_CFG_CHANNELS_COUNT_MASK	GENMASK(7, 0)
#define SOF_IPC4_AUDIO_FORMAT_CFG_CHANNELS_COUNT(x)	\
	((x) & SOF_IPC4_AUDIO_FORMAT_CFG_CHANNELS_COUNT_MASK)
#define SOF_IPC4_AUDIO_FORMAT_CFG_V_BIT_DEPTH_SHIFT	8
#define SOF_IPC4_AUDIO_FORMAT_CFG_V_BIT_DEPTH_MASK	GENMASK(15, 8)
#define SOF_IPC4_AUDIO_FORMAT_CFG_V_BIT_DEPTH(x)	\
	(((x) & SOF_IPC4_AUDIO_FORMAT_CFG_V_BIT_DEPTH_MASK) >> \
	 SOF_IPC4_AUDIO_FORMAT_CFG_V_BIT_DEPTH_SHIFT)
#define SOF_IPC4_AUDIO_FORMAT_CFG_SAMPLE_TYPE_SHIFT	16
#define SOF_IPC4_AUDIO_FORMAT_CFG_SAMPLE_TYPE_MASK	GENMASK(23, 16)
#define SOF_IPC4_AUDIO_FORMAT_CFG_SAMPLE_TYPE(x)	\
	(((x) & SOF_IPC4_AUDIO_FORMAT_CFG_SAMPLE_TYPE_MASK) >>  \
	 SOF_IPC4_AUDIO_FORMAT_CFG_SAMPLE_TYPE_SHIFT)



enum sof_ipc4_module_type {
	SOF_IPC4_MOD_INIT_INSTANCE,
	SOF_IPC4_MOD_CONFIG_GET,
	SOF_IPC4_MOD_CONFIG_SET,
	SOF_IPC4_MOD_LARGE_CONFIG_GET,
	SOF_IPC4_MOD_LARGE_CONFIG_SET,
	SOF_IPC4_MOD_BIND,
	SOF_IPC4_MOD_UNBIND,
	SOF_IPC4_MOD_SET_DX,
	SOF_IPC4_MOD_SET_D0IX,
	SOF_IPC4_MOD_ENTER_MODULE_RESTORE,
	SOF_IPC4_MOD_EXIT_MODULE_RESTORE,
	SOF_IPC4_MOD_DELETE_INSTANCE,

	SOF_IPC4_MOD_TYPE_LAST,
};

struct sof_ipc4_base_module_cfg {
	uint32_t cpc; 
	uint32_t ibs; 
	uint32_t obs; 
	uint32_t is_pages; 
	struct sof_ipc4_audio_format audio_fmt;
} __packed __aligned(4);


#define SOF_IPC4_MOD_INSTANCE_SHIFT		16
#define SOF_IPC4_MOD_INSTANCE_MASK		GENMASK(23, 16)
#define SOF_IPC4_MOD_INSTANCE(x)		((x) << SOF_IPC4_MOD_INSTANCE_SHIFT)

#define SOF_IPC4_MOD_ID_SHIFT			0
#define SOF_IPC4_MOD_ID_MASK			GENMASK(15, 0)
#define SOF_IPC4_MOD_ID(x)			((x) << SOF_IPC4_MOD_ID_SHIFT)


#define SOF_IPC4_MOD_EXT_PARAM_SIZE_SHIFT	0
#define SOF_IPC4_MOD_EXT_PARAM_SIZE_MASK	GENMASK(15, 0)
#define SOF_IPC4_MOD_EXT_PARAM_SIZE(x)		((x) << SOF_IPC4_MOD_EXT_PARAM_SIZE_SHIFT)

#define SOF_IPC4_MOD_EXT_PPL_ID_SHIFT		16
#define SOF_IPC4_MOD_EXT_PPL_ID_MASK		GENMASK(23, 16)
#define SOF_IPC4_MOD_EXT_PPL_ID(x)		((x) << SOF_IPC4_MOD_EXT_PPL_ID_SHIFT)

#define SOF_IPC4_MOD_EXT_CORE_ID_SHIFT		24
#define SOF_IPC4_MOD_EXT_CORE_ID_MASK		GENMASK(27, 24)
#define SOF_IPC4_MOD_EXT_CORE_ID(x)		((x) << SOF_IPC4_MOD_EXT_CORE_ID_SHIFT)

#define SOF_IPC4_MOD_EXT_DOMAIN_SHIFT		28
#define SOF_IPC4_MOD_EXT_DOMAIN_MASK		BIT(28)
#define SOF_IPC4_MOD_EXT_DOMAIN(x)		((x) << SOF_IPC4_MOD_EXT_DOMAIN_SHIFT)


#define SOF_IPC4_MOD_EXT_DST_MOD_ID_SHIFT	0
#define SOF_IPC4_MOD_EXT_DST_MOD_ID_MASK	GENMASK(15, 0)
#define SOF_IPC4_MOD_EXT_DST_MOD_ID(x)		((x) << SOF_IPC4_MOD_EXT_DST_MOD_ID_SHIFT)

#define SOF_IPC4_MOD_EXT_DST_MOD_INSTANCE_SHIFT	16
#define SOF_IPC4_MOD_EXT_DST_MOD_INSTANCE_MASK	GENMASK(23, 16)
#define SOF_IPC4_MOD_EXT_DST_MOD_INSTANCE(x)	((x) << SOF_IPC4_MOD_EXT_DST_MOD_INSTANCE_SHIFT)

#define SOF_IPC4_MOD_EXT_DST_MOD_QUEUE_ID_SHIFT	24
#define SOF_IPC4_MOD_EXT_DST_MOD_QUEUE_ID_MASK	GENMASK(26, 24)
#define SOF_IPC4_MOD_EXT_DST_MOD_QUEUE_ID(x)	((x) << SOF_IPC4_MOD_EXT_DST_MOD_QUEUE_ID_SHIFT)

#define SOF_IPC4_MOD_EXT_SRC_MOD_QUEUE_ID_SHIFT	27
#define SOF_IPC4_MOD_EXT_SRC_MOD_QUEUE_ID_MASK	GENMASK(29, 27)
#define SOF_IPC4_MOD_EXT_SRC_MOD_QUEUE_ID(x)	((x) << SOF_IPC4_MOD_EXT_SRC_MOD_QUEUE_ID_SHIFT)

#define MOD_ENABLE_LOG	6
#define MOD_SYSTEM_TIME	20


#define SOF_IPC4_MOD_EXT_MSG_SIZE_SHIFT		0
#define SOF_IPC4_MOD_EXT_MSG_SIZE_MASK		GENMASK(19, 0)
#define SOF_IPC4_MOD_EXT_MSG_SIZE(x)		((x) << SOF_IPC4_MOD_EXT_MSG_SIZE_SHIFT)

#define SOF_IPC4_MOD_EXT_MSG_PARAM_ID_SHIFT	20
#define SOF_IPC4_MOD_EXT_MSG_PARAM_ID_MASK	GENMASK(27, 20)
#define SOF_IPC4_MOD_EXT_MSG_PARAM_ID(x)	((x) << SOF_IPC4_MOD_EXT_MSG_PARAM_ID_SHIFT)

#define SOF_IPC4_MOD_EXT_MSG_LAST_BLOCK_SHIFT	28
#define SOF_IPC4_MOD_EXT_MSG_LAST_BLOCK_MASK	BIT(28)
#define SOF_IPC4_MOD_EXT_MSG_LAST_BLOCK(x)	((x) << SOF_IPC4_MOD_EXT_MSG_LAST_BLOCK_SHIFT)

#define SOF_IPC4_MOD_EXT_MSG_FIRST_BLOCK_SHIFT	29
#define SOF_IPC4_MOD_EXT_MSG_FIRST_BLOCK_MASK	BIT(29)
#define SOF_IPC4_MOD_EXT_MSG_FIRST_BLOCK(x)	((x) << SOF_IPC4_MOD_EXT_MSG_FIRST_BLOCK_SHIFT)


#define SOF_IPC4_MOD_INIT_BASEFW_MOD_ID		0
#define SOF_IPC4_MOD_INIT_BASEFW_INSTANCE_ID	0

enum sof_ipc4_base_fw_params {
	SOF_IPC4_FW_PARAM_ENABLE_LOGS = 6,
	SOF_IPC4_FW_PARAM_FW_CONFIG,
	SOF_IPC4_FW_PARAM_HW_CONFIG_GET,
	SOF_IPC4_FW_PARAM_MODULES_INFO_GET,
	SOF_IPC4_FW_PARAM_LIBRARIES_INFO_GET = 16,
	SOF_IPC4_FW_PARAM_SYSTEM_TIME = 20,
};

enum sof_ipc4_fw_config_params {
	SOF_IPC4_FW_CFG_FW_VERSION,
	SOF_IPC4_FW_CFG_MEMORY_RECLAIMED,
	SOF_IPC4_FW_CFG_SLOW_CLOCK_FREQ_HZ,
	SOF_IPC4_FW_CFG_FAST_CLOCK_FREQ_HZ,
	SOF_IPC4_FW_CFG_DMA_BUFFER_CONFIG,
	SOF_IPC4_FW_CFG_ALH_SUPPORT_LEVEL,
	SOF_IPC4_FW_CFG_DL_MAILBOX_BYTES,
	SOF_IPC4_FW_CFG_UL_MAILBOX_BYTES,
	SOF_IPC4_FW_CFG_TRACE_LOG_BYTES,
	SOF_IPC4_FW_CFG_MAX_PPL_COUNT,
	SOF_IPC4_FW_CFG_MAX_ASTATE_COUNT,
	SOF_IPC4_FW_CFG_MAX_MODULE_PIN_COUNT,
	SOF_IPC4_FW_CFG_MODULES_COUNT,
	SOF_IPC4_FW_CFG_MAX_MOD_INST_COUNT,
	SOF_IPC4_FW_CFG_MAX_LL_TASKS_PER_PRI_COUNT,
	SOF_IPC4_FW_CFG_LL_PRI_COUNT,
	SOF_IPC4_FW_CFG_MAX_DP_TASKS_COUNT,
	SOF_IPC4_FW_CFG_MAX_LIBS_COUNT,
	SOF_IPC4_FW_CFG_SCHEDULER_CONFIG,
	SOF_IPC4_FW_CFG_XTAL_FREQ_HZ,
	SOF_IPC4_FW_CFG_CLOCKS_CONFIG,
	SOF_IPC4_FW_CFG_RESERVED,
	SOF_IPC4_FW_CFG_POWER_GATING_POLICY,
	SOF_IPC4_FW_CFG_ASSERT_MODE,
	SOF_IPC4_FW_RESERVED1,
	SOF_IPC4_FW_RESERVED2,
	SOF_IPC4_FW_RESERVED3,
	SOF_IPC4_FW_RESERVED4,
	SOF_IPC4_FW_RESERVED5,
	SOF_IPC4_FW_CONTEXT_SAVE
};

struct sof_ipc4_fw_version {
	uint16_t major;
	uint16_t minor;
	uint16_t hotfix;
	uint16_t build;
} __packed;


struct sof_ipc4_dx_state_info {
	
	uint32_t core_mask;
	
	uint32_t dx_mask;
} __packed __aligned(4);





#define SOF_IPC4_REPLY_STATUS			GENMASK(23, 0)





#define SOF_IPC4_MSG_IS_NOTIFICATION(x)		(SOF_IPC4_MSG_TYPE_GET(x) == \
						 SOF_IPC4_GLB_NOTIFICATION)

#define SOF_IPC4_NOTIFICATION_TYPE_SHIFT	16
#define SOF_IPC4_NOTIFICATION_TYPE_MASK		GENMASK(23, 16)
#define SOF_IPC4_NOTIFICATION_TYPE_GET(x)	(((x) & SOF_IPC4_NOTIFICATION_TYPE_MASK) >> \
						 SOF_IPC4_NOTIFICATION_TYPE_SHIFT)

#define SOF_IPC4_LOG_CORE_SHIFT			12
#define SOF_IPC4_LOG_CORE_MASK			GENMASK(15, 12)
#define SOF_IPC4_LOG_CORE_GET(x)		(((x) & SOF_IPC4_LOG_CORE_MASK) >> \
						 SOF_IPC4_LOG_CORE_SHIFT)


enum sof_ipc4_notification_type {
	
	SOF_IPC4_NOTIFY_PHRASE_DETECTED = 4,
	
	SOF_IPC4_NOTIFY_RESOURCE_EVENT,
	
	SOF_IPC4_NOTIFY_LOG_BUFFER_STATUS,
	
	SOF_IPC4_NOTIFY_TIMESTAMP_CAPTURED,
	
	SOF_IPC4_NOTIFY_FW_READY,
	
	SOF_IPC4_NOTIFY_FW_AUD_CLASS_RESULT,
	
	SOF_IPC4_NOTIFY_EXCEPTION_CAUGHT,
	
	
	SOF_IPC4_NOTIFY_MODULE_NOTIFICATION = 12,
	
	
	SOF_IPC4_NOTIFY_PROBE_DATA_AVAILABLE = 14,
	
	SOF_IPC4_NOTIFY_ASYNC_MSG_SRVC_MESSAGE,

	SOF_IPC4_NOTIFY_TYPE_LAST,
};

struct sof_ipc4_notify_resource_data {
	uint32_t resource_type;
	uint32_t resource_id;
	uint32_t event_type;
	uint32_t reserved;
	uint32_t data[6];
} __packed __aligned(4);

#define SOF_IPC4_DEBUG_DESCRIPTOR_SIZE		12 


#define SOF_IPC4_MAX_DEBUG_SLOTS		15
#define SOF_IPC4_DEBUG_SLOT_SIZE		0x1000


#define SOF_IPC4_DEBUG_SLOT_UNUSED		0x00000000
#define SOF_IPC4_DEBUG_SLOT_CRITICAL_LOG	0x54524300 
#define SOF_IPC4_DEBUG_SLOT_DEBUG_LOG		0x474f4c00 
#define SOF_IPC4_DEBUG_SLOT_GDB_STUB		0x42444700
#define SOF_IPC4_DEBUG_SLOT_TELEMETRY		0x4c455400
#define SOF_IPC4_DEBUG_SLOT_BROKEN		0x44414544


struct sof_ipc4_notify_module_data {
	uint16_t instance_id;
	uint16_t module_id;
	uint32_t event_id;
	uint32_t event_data_size;
	uint8_t event_data[];
} __packed __aligned(4);


#define SOF_IPC4_NOTIFY_MODULE_EVENTID_ALSA_MAGIC_MASK		GENMASK(31, 16)
#define SOF_IPC4_NOTIFY_MODULE_EVENTID_ALSA_MAGIC_VAL		0xA15A0000
#define SOF_IPC4_NOTIFY_MODULE_EVENTID_ALSA_PARAMID_MASK	GENMASK(15, 0)



#endif
