/* SPDX-License-Identifier: GPL-2.0 */
//
// ALSA SoC Texas Instruments TAS2563 Audio Smart Amplifier
//
// Copyright (C) 2022 - 2024 Texas Instruments Incorporated
// https://www.ti.com
//
// The TAS2563 driver implements a flexible and configurable
// algo coefficient setting for one, two, or even multiple
// TAS2563 chips.
//
// Author: Shenghao Ding <shenghao-ding@ti.com>
//

#ifndef __TAS2563_TLV_H__
#define __TAS2563_TLV_H__

static const __maybe_unused DECLARE_TLV_DB_SCALE(tas2563_dvc_tlv, -12150, 50, 1);


static const __maybe_unused unsigned char tas2563_dvc_table[][4] = {
	{ 0X00, 0X00, 0X00, 0X00 }, 
	{ 0X00, 0X00, 0X03, 0XBC }, 
	{ 0X00, 0X00, 0X03, 0XF5 }, 
	{ 0X00, 0X00, 0X04, 0X31 }, 
	{ 0X00, 0X00, 0X04, 0X71 }, 
	{ 0X00, 0X00, 0X04, 0XB4 }, 
	{ 0X00, 0X00, 0X04, 0XFC }, 
	{ 0X00, 0X00, 0X05, 0X47 }, 
	{ 0X00, 0X00, 0X05, 0X97 }, 
	{ 0X00, 0X00, 0X05, 0XEC }, 
	{ 0X00, 0X00, 0X06, 0X46 }, 
	{ 0X00, 0X00, 0X06, 0XA5 }, 
	{ 0X00, 0X00, 0X07, 0X0A }, 
	{ 0X00, 0X00, 0X07, 0X75 }, 
	{ 0X00, 0X00, 0X07, 0XE6 }, 
	{ 0X00, 0X00, 0X08, 0X5E }, 
	{ 0X00, 0X00, 0X08, 0XDD }, 
	{ 0X00, 0X00, 0X09, 0X63 }, 
	{ 0X00, 0X00, 0X09, 0XF2 }, 
	{ 0X00, 0X00, 0X0A, 0X89 }, 
	{ 0X00, 0X00, 0X0B, 0X28 }, 
	{ 0X00, 0X00, 0X0B, 0XD2 }, 
	{ 0X00, 0X00, 0X0C, 0X85 }, 
	{ 0X00, 0X00, 0X0D, 0X43 }, 
	{ 0X00, 0X00, 0X0E, 0X0C }, 
	{ 0X00, 0X00, 0X0E, 0XE1 }, 
	{ 0X00, 0X00, 0X0F, 0XC3 }, 
	{ 0X00, 0X00, 0X10, 0XB2 }, 
	{ 0X00, 0X00, 0X11, 0XAF }, 
	{ 0X00, 0X00, 0X12, 0XBC }, 
	{ 0X00, 0X00, 0X13, 0XD8 }, 
	{ 0X00, 0X00, 0X15, 0X05 }, 
	{ 0X00, 0X00, 0X16, 0X44 }, 
	{ 0X00, 0X00, 0X17, 0X96 }, 
	{ 0X00, 0X00, 0X18, 0XFB }, 
	{ 0X00, 0X00, 0X1A, 0X76 }, 
	{ 0X00, 0X00, 0X1C, 0X08 }, 
	{ 0X00, 0X00, 0X1D, 0XB1 }, 
	{ 0X00, 0X00, 0X1F, 0X73 }, 
	{ 0X00, 0X00, 0X21, 0X51 }, 
	{ 0X00, 0X00, 0X23, 0X4A }, 
	{ 0X00, 0X00, 0X25, 0X61 }, 
	{ 0X00, 0X00, 0X27, 0X98 }, 
	{ 0X00, 0X00, 0X29, 0XF1 }, 
	{ 0X00, 0X00, 0X2C, 0X6D }, 
	{ 0X00, 0X00, 0X2F, 0X0F }, 
	{ 0X00, 0X00, 0X31, 0XD9 }, 
	{ 0X00, 0X00, 0X34, 0XCD }, 
	{ 0X00, 0X00, 0X37, 0XEE }, 
	{ 0X00, 0X00, 0X3B, 0X3F }, 
	{ 0X00, 0X00, 0X3E, 0XC1 }, 
	{ 0X00, 0X00, 0X42, 0X79 }, 
	{ 0X00, 0X00, 0X46, 0X6A }, 
	{ 0X00, 0X00, 0X4A, 0X96 }, 
	{ 0X00, 0X00, 0X4F, 0X01 }, 
	{ 0X00, 0X00, 0X53, 0XAF }, 
	{ 0X00, 0X00, 0X58, 0XA5 }, 
	{ 0X00, 0X00, 0X5D, 0XE6 }, 
	{ 0X00, 0X00, 0X63, 0X76 }, 
	{ 0X00, 0X00, 0X69, 0X5B }, 
	{ 0X00, 0X00, 0X6F, 0X99 }, 
	{ 0X00, 0X00, 0X76, 0X36 }, 
	{ 0X00, 0X00, 0X7D, 0X37 }, 
	{ 0X00, 0X00, 0X84, 0XA2 }, 
	{ 0X00, 0X00, 0X8C, 0X7E }, 
	{ 0X00, 0X00, 0X94, 0XD1 }, 
	{ 0X00, 0X00, 0X9D, 0XA3 }, 
	{ 0X00, 0X00, 0XA6, 0XFA }, 
	{ 0X00, 0X00, 0XB0, 0XDF }, 
	{ 0X00, 0X00, 0XBB, 0X5A }, 
	{ 0X00, 0X00, 0XC6, 0X74 }, 
	{ 0X00, 0X00, 0XD2, 0X36 }, 
	{ 0X00, 0X00, 0XDE, 0XAB }, 
	{ 0X00, 0X00, 0XEB, 0XDC }, 
	{ 0X00, 0X00, 0XF9, 0XD6 }, 
	{ 0X00, 0X01, 0X08, 0XA4 }, 
	{ 0X00, 0X01, 0X18, 0X52 }, 
	{ 0X00, 0X01, 0X28, 0XEF }, 
	{ 0X00, 0X01, 0X3A, 0X87 }, 
	{ 0X00, 0X01, 0X4D, 0X2A }, 
	{ 0X00, 0X01, 0X60, 0XE8 }, 
	{ 0X00, 0X01, 0X75, 0XD1 }, 
	{ 0X00, 0X01, 0X8B, 0XF7 }, 
	{ 0X00, 0X01, 0XA3, 0X6E }, 
	{ 0X00, 0X01, 0XBC, 0X48 }, 
	{ 0X00, 0X01, 0XD6, 0X9B }, 
	{ 0X00, 0X01, 0XF2, 0X7E }, 
	{ 0X00, 0X02, 0X10, 0X08 }, 
	{ 0X00, 0X02, 0X2F, 0X51 }, 
	{ 0X00, 0X02, 0X50, 0X76 }, 
	{ 0X00, 0X02, 0X73, 0X91 }, 
	{ 0X00, 0X02, 0X98, 0XC0 }, 
	{ 0X00, 0X02, 0XC0, 0X24 }, 
	{ 0X00, 0X02, 0XE9, 0XDD }, 
	{ 0X00, 0X03, 0X16, 0X0F }, 
	{ 0X00, 0X03, 0X44, 0XDF }, 
	{ 0X00, 0X03, 0X76, 0X76 }, 
	{ 0X00, 0X03, 0XAA, 0XFC }, 
	{ 0X00, 0X03, 0XE2, 0XA0 }, 
	{ 0X00, 0X04, 0X1D, 0X8F }, 
	{ 0X00, 0X04, 0X5B, 0XFD }, 
	{ 0X00, 0X04, 0X9E, 0X1D }, 
	{ 0X00, 0X04, 0XE4, 0X29 }, 
	{ 0X00, 0X05, 0X2E, 0X5A }, 
	{ 0X00, 0X05, 0X7C, 0XF2 }, 
	{ 0X00, 0X05, 0XD0, 0X31 }, 
	{ 0X00, 0X06, 0X28, 0X60 }, 
	{ 0X00, 0X06, 0X85, 0XC8 }, 
	{ 0X00, 0X06, 0XE8, 0XB9 }, 
	{ 0X00, 0X07, 0X51, 0X86 }, 
	{ 0X00, 0X07, 0XC0, 0X8A }, 
	{ 0X00, 0X08, 0X36, 0X21 }, 
	{ 0X00, 0X08, 0XB2, 0XB0 }, 
	{ 0X00, 0X09, 0X36, 0XA1 }, 
	{ 0X00, 0X09, 0XC2, 0X63 }, 
	{ 0X00, 0X0A, 0X56, 0X6D }, 
	{ 0X00, 0X0A, 0XF3, 0X3C }, 
	{ 0X00, 0X0B, 0X99, 0X56 }, 
	{ 0X00, 0X0C, 0X49, 0X48 }, 
	{ 0X00, 0X0D, 0X03, 0XA7 }, 
	{ 0X00, 0X0D, 0XC9, 0X11 }, 
	{ 0X00, 0X0E, 0X9A, 0X2D }, 
	{ 0X00, 0X0F, 0X77, 0XAD }, 
	{ 0X00, 0X10, 0X62, 0X4D }, 
	{ 0X00, 0X11, 0X5A, 0XD5 }, 
	{ 0X00, 0X12, 0X62, 0X16 }, 
	{ 0X00, 0X13, 0X78, 0XF0 }, 
	{ 0X00, 0X14, 0XA0, 0X50 }, 
	{ 0X00, 0X15, 0XD9, 0X31 }, 
	{ 0X00, 0X17, 0X24, 0X9C }, 
	{ 0X00, 0X18, 0X83, 0XAA }, 
	{ 0X00, 0X19, 0XF7, 0X86 }, 
	{ 0X00, 0X1B, 0X81, 0X6A }, 
	{ 0X00, 0X1D, 0X22, 0XA4 }, 
	{ 0X00, 0X1E, 0XDC, 0X98 }, 
	{ 0X00, 0X20, 0XB0, 0XBC }, 
	{ 0X00, 0X22, 0XA0, 0X9D }, 
	{ 0X00, 0X24, 0XAD, 0XE0 }, 
	{ 0X00, 0X26, 0XDA, 0X43 }, 
	{ 0X00, 0X29, 0X27, 0X9D }, 
	{ 0X00, 0X2B, 0X97, 0XE3 }, 
	{ 0X00, 0X2E, 0X2D, 0X27 }, 
	{ 0X00, 0X30, 0XE9, 0X9A }, 
	{ 0X00, 0X33, 0XCF, 0X8D }, 
	{ 0X00, 0X36, 0XE1, 0X78 }, 
	{ 0X00, 0X3A, 0X21, 0XF3 }, 
	{ 0X00, 0X3D, 0X93, 0XC3 }, 
	{ 0X00, 0X41, 0X39, 0XD3 }, 
	{ 0X00, 0X45, 0X17, 0X3B }, 
	{ 0X00, 0X49, 0X2F, 0X44 }, 
	{ 0X00, 0X4D, 0X85, 0X66 }, 
	{ 0X00, 0X52, 0X1D, 0X50 }, 
	{ 0X00, 0X56, 0XFA, 0XE8 }, 
	{ 0X00, 0X5C, 0X22, 0X4E }, 
	{ 0X00, 0X61, 0X97, 0XE1 }, 
	{ 0X00, 0X67, 0X60, 0X44 }, 
	{ 0X00, 0X6D, 0X80, 0X60 }, 
	{ 0X00, 0X73, 0XFD, 0X65 }, 
	{ 0X00, 0X7A, 0XDC, 0XD7 }, 
	{ 0X00, 0X82, 0X24, 0X8A }, 
	{ 0X00, 0X89, 0XDA, 0XAB }, 
	{ 0X00, 0X92, 0X05, 0XC6 }, 
	{ 0X00, 0X9A, 0XAC, 0XC8 }, 
	{ 0X00, 0XA3, 0XD7, 0X0A }, 
	{ 0X00, 0XAD, 0X8C, 0X52 }, 
	{ 0X00, 0XB7, 0XD4, 0XDD }, 
	{ 0X00, 0XC2, 0XB9, 0X65 }, 
	{ 0X00, 0XCE, 0X43, 0X28 }, 
	{ 0X00, 0XDA, 0X7B, 0XF1 }, 
	{ 0X00, 0XE7, 0X6E, 0X1E }, 
	{ 0X00, 0XF5, 0X24, 0XAC }, 
	{ 0X01, 0X03, 0XAB, 0X3D }, 
	{ 0X01, 0X13, 0X0E, 0X24 }, 
	{ 0X01, 0X23, 0X5A, 0X71 }, 
	{ 0X01, 0X34, 0X9D, 0XF8 }, 
	{ 0X01, 0X46, 0XE7, 0X5D }, 
	{ 0X01, 0X5A, 0X46, 0X27 }, 
	{ 0X01, 0X6E, 0XCA, 0XC5 }, 
	{ 0X01, 0X84, 0X86, 0X9F }, 
	{ 0X01, 0X9B, 0X8C, 0X27 }, 
	{ 0X01, 0XB3, 0XEE, 0XE5 }, 
	{ 0X01, 0XCD, 0XC3, 0X8C }, 
	{ 0X01, 0XE9, 0X20, 0X05 }, 
	{ 0X02, 0X06, 0X1B, 0X89 }, 
	{ 0X02, 0X24, 0XCE, 0XB0 }, 
	{ 0X02, 0X45, 0X53, 0X85 }, 
	{ 0X02, 0X67, 0XC5, 0XA2 }, 
	{ 0X02, 0X8C, 0X42, 0X3F }, 
	{ 0X02, 0XB2, 0XE8, 0X55 }, 
	{ 0X02, 0XDB, 0XD8, 0XAD }, 
	{ 0X03, 0X07, 0X36, 0X05 }, 
	{ 0X03, 0X35, 0X25, 0X29 }, 
	{ 0X03, 0X65, 0XCD, 0X13 }, 
	{ 0X03, 0X99, 0X57, 0X0C }, 
	{ 0X03, 0XCF, 0XEE, 0XCF }, 
	{ 0X04, 0X09, 0XC2, 0XB0 }, 
	{ 0X04, 0X47, 0X03, 0XC1 }, 
	{ 0X04, 0X87, 0XE5, 0XFB }, 
	{ 0X04, 0XCC, 0XA0, 0X6D }, 
	{ 0X05, 0X15, 0X6D, 0X68 }, 
	{ 0X05, 0X62, 0X8A, 0XB3 }, 
	{ 0X05, 0XB4, 0X39, 0XBC }, 
	{ 0X06, 0X0A, 0XBF, 0XD4 }, 
	{ 0X06, 0X66, 0X66, 0X66 }, 
	{ 0X06, 0XC7, 0X7B, 0X36 }, 
	{ 0X07, 0X2E, 0X50, 0XA6 }, 
	{ 0X07, 0X9B, 0X3D, 0XF6 }, 
	{ 0X08, 0X0E, 0X9F, 0X96 }, 
	{ 0X08, 0X88, 0XD7, 0X6D }, 
	{ 0X09, 0X0A, 0X4D, 0X2F }, 
	{ 0X09, 0X93, 0X6E, 0XB8 }, 
	{ 0X0A, 0X24, 0XB0, 0X62 }, 
	{ 0X0A, 0XBE, 0X8D, 0X70 }, 
	{ 0X0B, 0X61, 0X88, 0X71 }, 
	{ 0X0C, 0X0E, 0X2B, 0XB0 }, 
	{ 0X0C, 0XC5, 0X09, 0XAB }, 
	{ 0X0D, 0X86, 0XBD, 0X8D }, 
	{ 0X0E, 0X53, 0XEB, 0XB3 }, 
	{ 0X0F, 0X2D, 0X42, 0X38 }, 
	{ 0X10, 0X13, 0X79, 0X87 }, 
	{ 0X11, 0X07, 0X54, 0XF9 }, 
	{ 0X12, 0X09, 0XA3, 0X7A }, 
	{ 0X13, 0X1B, 0X40, 0X39 }, 
	{ 0X14, 0X3D, 0X13, 0X62 }, 
	{ 0X15, 0X70, 0X12, 0XE1 }, 
	{ 0X16, 0XB5, 0X43, 0X37 }, 
	{ 0X18, 0X0D, 0XB8, 0X54 }, 
	{ 0X19, 0X7A, 0X96, 0X7F }, 
	{ 0X1A, 0XFD, 0X13, 0X54 }, 
	{ 0X1C, 0X96, 0X76, 0XC6 }, 
	{ 0X1E, 0X48, 0X1C, 0X37 }, 
	{ 0X20, 0X13, 0X73, 0X9E }, 
	{ 0X21, 0XFA, 0X02, 0XBF }, 
	{ 0X23, 0XFD, 0X66, 0X78 }, 
	{ 0X26, 0X1F, 0X54, 0X1C }, 
	{ 0X28, 0X61, 0X9A, 0XE9 }, 
	{ 0X2A, 0XC6, 0X25, 0X91 }, 
	{ 0X2D, 0X4E, 0XFB, 0XD5 }, 
	{ 0X2F, 0XFE, 0X44, 0X48 }, 
	{ 0X32, 0XD6, 0X46, 0X17 }, 
	{ 0X35, 0XD9, 0X6B, 0X02 }, 
	{ 0X39, 0X0A, 0X41, 0X5F }, 
	{ 0X3C, 0X6B, 0X7E, 0X4F }, 
	{ 0X40, 0X00, 0X00, 0X00 }, 
	{ 0X43, 0XCA, 0XD0, 0X22 }, 
	{ 0X47, 0XCF, 0X26, 0X7D }, 
	{ 0X4C, 0X10, 0X6B, 0XA5 }, 
	{ 0X50, 0X92, 0X3B, 0XE3 }, 
	{ 0X55, 0X58, 0X6A, 0X46 }, 
	{ 0X5A, 0X67, 0X03, 0XDF }, 
	{ 0X5F, 0XC2, 0X53, 0X32 }, 
	{ 0X65, 0X6E, 0XE3, 0XDB }, 
	{ 0X6B, 0X71, 0X86, 0X68 }, 
	{ 0X71, 0XCF, 0X54, 0X71 }, 
	{ 0X78, 0X8D, 0XB4, 0XE9 }, 
	{ 0X7F, 0XFF, 0XFF, 0XFF }, 
};
#endif
