

#ifndef _XEN_ACPI_H
#define _XEN_ACPI_H

#include <linux/types.h>

typedef int (*get_gsi_from_sbdf_t)(u32 sbdf);

#ifdef CONFIG_XEN_DOM0
#include <asm/xen/hypervisor.h>
#include <xen/xen.h>
#include <linux/acpi.h>

int xen_acpi_notify_hypervisor_sleep(u8 sleep_state,
				     u32 pm1a_cnt, u32 pm1b_cnd);
int xen_acpi_notify_hypervisor_extended_sleep(u8 sleep_state,
				     u32 val_a, u32 val_b);

static inline int xen_acpi_suspend_lowlevel(void)
{
	
	acpi_enter_sleep_state(ACPI_STATE_S3);
	return 0;
}

static inline void xen_acpi_sleep_register(void)
{
	if (xen_initial_domain()) {
		acpi_os_set_prepare_sleep(
			&xen_acpi_notify_hypervisor_sleep);
		acpi_os_set_prepare_extended_sleep(
			&xen_acpi_notify_hypervisor_extended_sleep);

		acpi_suspend_lowlevel = xen_acpi_suspend_lowlevel;
	}
}
int xen_pvh_setup_gsi(int gsi, int trigger, int polarity);
int xen_acpi_get_gsi_info(struct pci_dev *dev,
						  int *gsi_out,
						  int *trigger_out,
						  int *polarity_out);
void xen_acpi_register_get_gsi_func(get_gsi_from_sbdf_t func);
int xen_acpi_get_gsi_from_sbdf(u32 sbdf);
#else
static inline void xen_acpi_sleep_register(void)
{
}

static inline int xen_pvh_setup_gsi(int gsi, int trigger, int polarity)
{
	return -1;
}

static inline int xen_acpi_get_gsi_info(struct pci_dev *dev,
						  int *gsi_out,
						  int *trigger_out,
						  int *polarity_out)
{
	return -1;
}

static inline void xen_acpi_register_get_gsi_func(get_gsi_from_sbdf_t func)
{
}

static inline int xen_acpi_get_gsi_from_sbdf(u32 sbdf)
{
	return -1;
}
#endif

#endif	
