/* SPDX-License-Identifier: MIT */


#ifndef __XEN_PUBLIC_ELFNOTE_H__
#define __XEN_PUBLIC_ELFNOTE_H__




#define XEN_ELFNOTE_INFO           0


#define XEN_ELFNOTE_ENTRY          1


#define XEN_ELFNOTE_HYPERCALL_PAGE 2


#define XEN_ELFNOTE_VIRT_BASE      3


#define XEN_ELFNOTE_PADDR_OFFSET   4


#define XEN_ELFNOTE_XEN_VERSION    5


#define XEN_ELFNOTE_GUEST_OS       6


#define XEN_ELFNOTE_GUEST_VERSION  7


#define XEN_ELFNOTE_LOADER         8


#define XEN_ELFNOTE_PAE_MODE       9


#define XEN_ELFNOTE_FEATURES      10


#define XEN_ELFNOTE_BSD_SYMTAB    11


#define XEN_ELFNOTE_HV_START_LOW  12


#define XEN_ELFNOTE_L1_MFN_VALID  13


#define XEN_ELFNOTE_SUSPEND_CANCEL 14


#define XEN_ELFNOTE_INIT_P2M      15


#define XEN_ELFNOTE_MOD_START_PFN 16


#define XEN_ELFNOTE_SUPPORTED_FEATURES 17


#define XEN_ELFNOTE_PHYS32_ENTRY 18


#define XEN_ELFNOTE_PHYS32_RELOC 19


#define XEN_ELFNOTE_MAX XEN_ELFNOTE_PHYS32_RELOC


#define XEN_ELFNOTE_CRASH_INFO 0x1000001


#define XEN_ELFNOTE_CRASH_REGS 0x1000002



#define XEN_ELFNOTE_DUMPCORE_NONE               0x2000000


#define XEN_ELFNOTE_DUMPCORE_HEADER             0x2000001


#define XEN_ELFNOTE_DUMPCORE_XEN_VERSION        0x2000002


#define XEN_ELFNOTE_DUMPCORE_FORMAT_VERSION     0x2000003

#endif 
