// SPDX-License-Identifier: MIT

// "Register" offsets for sending data to the RTG.
enum pi_regs {
  RTG_COMMAND   = 0x00,
  RTG_X1        = 0x02,
  RTG_X2        = 0x04,
  RTG_X3        = 0x06,
  RTG_Y1        = 0x08,
  RTG_Y2        = 0x0A,
  RTG_Y3        = 0x0C,
  RTG_FORMAT    = 0x0E,
  RTG_RGB1      = 0x10,
  RTG_RGB2      = 0x14,
  RTG_ADDR1     = 0x18,
  RTG_ADDR2     = 0x1C,
  RTG_U81       = 0x20,
  RTG_U82       = 0x21,
  RTG_U83       = 0x22,
  RTG_U84       = 0x23,
  RTG_X4        = 0x24,
  RTG_X5        = 0x26,
  RTG_Y4        = 0x28,
  RTG_Y5        = 0x2A,
  RTG_U1        = 0x2C,
  RTG_U2        = 0x2E,
  RTG_ADDR3     = 0x30,
  RTG_ADDR4     = 0x34,
  RTG_DEBUGME   = 0x50,
  RTG_WAITVSYNC = 0x60,
  RTG_INVBLANK  = 0x62,
  IRTG_COMMAND  = 0x60,
};

enum rtg_cmds {
  RTGCMD_SETGC,
  RTGCMD_SETPAN,
  RTGCMD_SETCLUT,
  RTGCMD_ENABLE,
  RTGCMD_SETDISPLAY,
  RTGCMD_SETSWITCH,
  RTGCMD_FILLRECT,
  RTGCMD_BLITRECT,
  RTGCMD_BLITRECT_NOMASK_COMPLETE,
  RTGCMD_BLITPATTERN,
  RTGCMD_BLITTEMPLATE,
  RTGCMD_INVERTRECT,
  RTGCMD_DRAWLINE,
  RTGCMD_P2C,
  RTGCMD_P2D,
  RTGCMD_SETSPRITE,
  RTGCMD_SETSPRITEPOS,
  RTGCMD_SETSPRITECOLOR,
  RTGCMD_SETSPRITEIMAGE,
  RTGCMD_DEBUGME,
};

enum rtg_formats {
  RTGFMT_4BIT_PLANAR,
  RTGFMT_8BIT_CLUT,
  RTGFMT_RGB565_BE,
  RTGFMT_RGB565_LE,
  RTGFMT_BGR565_LE,
  RTGFMT_RGB24,
  RTGFMT_BGR24,
  RTGFMT_RGB32_ARGB,
  RTGFMT_RGB32_ABGR,
  RTGFMT_RGB32_RGBA,
  RTGFMT_RGB32_BGRA,
  RTGFMT_RGB555_BE,
  RTGFMT_RGB555_LE,
  RTGFMT_BGR555_LE,
  RTGFMT_NONE,
  RTGFMT_NUM,
};

enum gfx_minterm_modes {
	MINTERM_FALSE,
	MINTERM_NOR,
	MINTERM_ONLYDST,
	MINTERM_NOTSRC,
	MINTERM_ONLYSRC,
	MINTERM_INVERT,
	MINTERM_EOR,
	MINTERM_NAND,
	MINTERM_AND,
	MINTERM_NEOR,
	MINTERM_DST,
	MINTERM_NOTONLYSRC,
	MINTERM_SRC,
	MINTERM_NOTONLYDST,
	MINTERM_OR,
	MINTERM_TRUE,
};

enum gfx_draw_modes {
    DRAWMODE_JAM1 = 0,
    DRAWMODE_JAM2 = 1,
    DRAWMODE_COMPLEMENT = 2,
    DRAWMODE_INVERSVID = 4,
};

static const unsigned short rgbf_to_rtg[32] = {
  RTGFMT_4BIT_PLANAR, // 0x00
  RTGFMT_8BIT_CLUT,   // 0x01
  RTGFMT_RGB24,       // 0x02 
  RTGFMT_BGR24,       // 0x03
  RTGFMT_RGB565_LE,   // 0x04
  RTGFMT_RGB555_LE,   // 0x05
  RTGFMT_RGB32_ARGB,  // 0x08
  RTGFMT_RGB32_ABGR,  // 0x09
  RTGFMT_RGB32_RGBA,  // 0x06
  RTGFMT_RGB32_BGRA,  // 0x07
  RTGFMT_RGB565_BE,   // 0x0A
  RTGFMT_RGB555_BE,   // 0x0B
  RTGFMT_BGR565_LE,   // 0x0C
  RTGFMT_BGR555_LE,   // 0x0D
  RTGFMT_NONE,        // 0x0E
  RTGFMT_NONE,        // 0x0F
  RTGFMT_NONE,        // 0x10
  RTGFMT_NONE,        // 0x11
  RTGFMT_NONE,        // 0x12
  RTGFMT_NONE,        // 0x13
  RTGFMT_NONE,        // 0x14
  RTGFMT_NONE,        // 0x15
  RTGFMT_NONE,        // 0x16
  RTGFMT_NONE,        // 0x17
  RTGFMT_NONE,        // 0x18
  RTGFMT_NONE,        // 0x19
  RTGFMT_NONE,        // 0x1A
  RTGFMT_NONE,        // 0x1B
  RTGFMT_NONE,        // 0x1C
  RTGFMT_NONE,        // 0x1D
  RTGFMT_NONE,        // 0x1E
  RTGFMT_NONE,        // 0x1F
};

static const unsigned int rtg_pixel_size[RTGFMT_NUM] = {
    1,  // 4BIT_PLANAR, (actually 0.5)
    1,  // 8BIT_CLUT,
    2,  // RGB565_BE,
    2,  // RGB565_LE,
    2,  // BGR565_LE,
    3,  // RGB24,
    3,  // BGR24,
    4,  // RGB32_ARGB,
    4,  // RGB32_ABGR,
    4,  // RGB32_RGBA,
    4,  // RGB32_BGRA,
    2,  // RGB555_BE,
    2,  // RGB555_LE,
    2,  // BGR555_LE,
    1,  // NONE,
};
