/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import org.apache.commons.exec.TimeoutObserver;
import org.apache.commons.exec.Watchdog;
import org.apache.commons.exec.util.DebugUtils;

public class ExecuteWatchdog
implements TimeoutObserver {
    public static final long INFINITE_TIMEOUT = -1L;
    private Process process;
    private final boolean hasWatchdog;
    private boolean watch = false;
    private Exception caught;
    private boolean killedProcess = false;
    private final Watchdog watchdog;
    private volatile boolean processStarted;

    public ExecuteWatchdog(long timeout) {
        this.hasWatchdog = timeout != -1L;
        this.processStarted = false;
        if (this.hasWatchdog) {
            this.watchdog = new Watchdog(timeout);
            this.watchdog.addTimeoutObserver(this);
        } else {
            this.watchdog = null;
        }
    }

    public synchronized void start(Process processToMonitor) {
        if (processToMonitor == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = processToMonitor;
        this.processStarted = true;
        this.notifyAll();
        if (this.hasWatchdog) {
            this.watchdog.start();
        }
    }

    public synchronized void stop() {
        if (this.hasWatchdog) {
            this.watchdog.stop();
        }
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.ensureStarted();
        this.timeoutOccured(null);
        this.stop();
    }

    @Override
    public synchronized void timeoutOccured(Watchdog w) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
            DebugUtils.handleException("Getting the exit value of the process failed", e);
        }
        finally {
            this.cleanUp();
        }
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    public synchronized boolean isWatching() {
        this.ensureStarted();
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    void setProcessNotStarted() {
        this.processStarted = false;
    }

    private void ensureStarted() {
        while (!this.processStarted) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

