/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.awt.font.GlyphVector;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName pdfName, PdfIndirectReference pdfIndirectReference, BaseFont baseFont) {
        this.fontName = pdfName;
        this.indirectReference = pdfIndirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String string) {
        byte[] byArray = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(string);
            }
            case 0: 
            case 1: {
                byArray = this.baseFont.convertToBytes(string);
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    this.shortTag[byArray[i] & 0xFF] = 1;
                }
                break;
            }
            case 2: {
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    this.cjkTag.put(this.cjkFont.getCidCode(string.charAt(i)), 0);
                }
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 4: {
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 3: {
                try {
                    int n;
                    int n2 = string.length();
                    int[] nArray = null;
                    char[] cArray = new char[n2];
                    int n3 = 0;
                    if (this.symbolic) {
                        byArray = PdfEncodings.convertToBytes(string, "symboltt");
                        n2 = byArray.length;
                        for (n = 0; n < n2; ++n) {
                            nArray = this.ttu.getMetricsTT(byArray[n] & 0xFF);
                            if (nArray == null) continue;
                            this.longTag.put(nArray[0], new int[]{nArray[0], nArray[1], this.ttu.getUnicodeDifferences(byArray[n] & 0xFF)});
                            cArray[n3++] = (char)nArray[0];
                        }
                    } else {
                        for (n = 0; n < n2; ++n) {
                            int n4;
                            if (Utilities.isSurrogatePair(string, n)) {
                                n4 = Utilities.convertToUtf32(string, n);
                                ++n;
                            } else {
                                n4 = string.charAt(n);
                            }
                            nArray = this.ttu.getMetricsTT(n4);
                            if (nArray == null) continue;
                            int n5 = nArray[0];
                            Integer n6 = n5;
                            if (!this.longTag.containsKey(n6)) {
                                this.longTag.put(n6, new int[]{n5, nArray[1], n4});
                            }
                            cArray[n3++] = (char)n5;
                        }
                    }
                    String string2 = new String(cArray, 0, n3);
                    byArray = string2.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExceptionConverter(unsupportedEncodingException);
                }
            }
        }
        return byArray;
    }

    byte[] convertToBytes(GlyphVector glyphVector) {
        if (this.fontType != 3 || this.symbolic) {
            throw new UnsupportedOperationException("Only supported for True Type Unicode fonts");
        }
        char[] cArray = new char[glyphVector.getNumGlyphs()];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int[] nArray;
            int n2 = glyphVector.getGlyphCode(i);
            if (n2 == 65534 || n2 == 65535) continue;
            cArray[n++] = (char)n2;
            Integer n3 = new Integer(n2);
            if (this.longTag.containsKey(n3)) continue;
            int n4 = this.ttu.getGlyphWidth(n2);
            Integer n5 = this.ttu.getCharacterCode(n2);
            if (n5 != null) {
                int[] nArray2 = new int[3];
                nArray2[0] = n2;
                nArray2[1] = n4;
                nArray = nArray2;
                nArray2[2] = n5;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = n2;
                nArray = nArray3;
                nArray3[1] = n4;
            }
            int[] nArray4 = nArray;
            this.longTag.put(n3, nArray4);
        }
        String string = new String(cArray, 0, n);
        try {
            byte[] byArray = string.getBytes("UnicodeBigUnmarked");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionConverter(unsupportedEncodingException);
        }
    }

    void writeFont(PdfWriter pdfWriter) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int n;
                    int n2;
                    for (n2 = 0; n2 < 256 && this.shortTag[n2] == 0; ++n2) {
                    }
                    for (n = 255; n >= n2 && this.shortTag[n] == 0; --n) {
                    }
                    if (n2 > 255) {
                        n2 = 255;
                        n = 255;
                    }
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{n2, n, this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.longTag, this.subset});
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }
}

