/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.ContentOperator;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public abstract class PdfContentStreamProcessor {
    private Map operators;
    private PdfDictionary resources;
    private Stack gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;

    public PdfContentStreamProcessor() {
        this.populateOperators();
        this.reset();
    }

    private void populateOperators() {
        this.operators = new HashMap();
        this.operators.put("q", new PushGraphicsState());
        this.operators.put("Q", new PopGraphicsState());
        this.operators.put("cm", new ModifyCurrentTransformationMatrix());
        this.operators.put("gs", new ProcessGraphicsStateResource());
        this.operators.put("Tc", new SetTextCharacterSpacing());
        this.operators.put("Tw", new SetTextWordSpacing());
        this.operators.put("Tz", new SetTextHorizontalScaling());
        this.operators.put("TL", new SetTextLeading());
        this.operators.put("Tf", new SetTextFont());
        this.operators.put("Tr", new SetTextRenderMode());
        this.operators.put("Ts", new SetTextRise());
        this.operators.put("BT", new BeginText());
        this.operators.put("ET", new EndText());
        this.operators.put("Td", new TextMoveStartNextLine());
        this.operators.put("TD", new TextMoveStartNextLineWithLeading());
        this.operators.put("Tm", new TextSetTextMatrix());
        this.operators.put("T*", new TextMoveNextLine());
        this.operators.put("Tj", new ShowText());
        this.operators.put("'", new MoveNextLineAndShowText());
        this.operators.put("\"", new MoveNextLineAndShowTextWithSpacing());
        this.operators.put("TJ", new ShowTextArray());
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = null;
    }

    public GraphicsState gs() {
        return (GraphicsState)this.gsStack.peek();
    }

    public Matrix getCurrentTextMatrix() {
        return this.textMatrix;
    }

    public Matrix getCurrentTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void invokeOperator(PdfLiteral pdfLiteral, ArrayList arrayList) {
        ContentOperator contentOperator = (ContentOperator)this.operators.get(pdfLiteral.toString());
        if (contentOperator == null) {
            return;
        }
        contentOperator.invoke(this, pdfLiteral, arrayList);
    }

    private String decode(PdfString pdfString) {
        byte[] byArray = pdfString.getBytes();
        return this.gs().font.decode(byArray, 0, byArray.length);
    }

    public abstract void displayText(String var1, Matrix var2);

    public float getStringWidth(String string, float f) {
        CMapAwareDocumentFont cMapAwareDocumentFont = this.gs().font;
        char[] cArray = string.toCharArray();
        float f2 = 0.0f;
        for (int i = 0; i < cArray.length; ++i) {
            float f3 = (float)((DocumentFont)cMapAwareDocumentFont).getWidth(cArray[i]) / 1000.0f;
            float f4 = cArray[i] == ' ' ? this.gs().wordSpacing : 0.0f;
            f2 += ((f3 - f / 1000.0f) * this.gs().fontSize + this.gs().characterSpacing + f4) * this.gs().horizontalScaling;
        }
        return f2;
    }

    public void displayPdfString(PdfString pdfString, float f) {
        String string = this.decode(pdfString);
        float f2 = this.getStringWidth(string, f);
        Matrix matrix = new Matrix(f2, 0.0f).multiply(this.textMatrix);
        this.displayText(string, matrix);
        this.textMatrix = matrix;
    }

    public void processContent(byte[] byArray, PdfDictionary pdfDictionary) {
        this.reset();
        this.resources = pdfDictionary;
        try {
            PdfContentParser pdfContentParser = new PdfContentParser(new PRTokeniser(byArray));
            ArrayList arrayList = new ArrayList();
            while (pdfContentParser.parse(arrayList).size() > 0) {
                PdfLiteral pdfLiteral = (PdfLiteral)arrayList.get(arrayList.size() - 1);
                this.invokeOperator(pdfLiteral, arrayList);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            GraphicsState graphicsState = (GraphicsState)pdfContentStreamProcessor.gsStack.peek();
            GraphicsState graphicsState2 = new GraphicsState(graphicsState);
            pdfContentStreamProcessor.gsStack.push(graphicsState2);
        }
    }

    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.gsStack.pop();
        }
    }

    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            Matrix matrix = new Matrix(f, f2, f3, f4, f5, f6);
            GraphicsState graphicsState = (GraphicsState)pdfContentStreamProcessor.gsStack.peek();
            graphicsState.ctm = graphicsState.ctm.multiply(matrix);
        }
    }

    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfName pdfName = (PdfName)arrayList.get(0);
            PdfDictionary pdfDictionary = pdfContentStreamProcessor.resources.getAsDict(PdfName.EXTGSTATE);
            if (pdfDictionary == null) {
                throw new IllegalArgumentException("Resources do not contain ExtGState entry. Unable to process operator " + pdfLiteral);
            }
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(pdfName);
            if (pdfDictionary2 == null) {
                throw new IllegalArgumentException(pdfName + " is an unknown graphics state dictionary");
            }
            PdfArray pdfArray = pdfDictionary2.getAsArray(PdfName.FONT);
            if (pdfArray != null) {
                CMapAwareDocumentFont cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfArray.getPdfObject(0));
                float f = pdfArray.getAsNumber(1).floatValue();
                pdfContentStreamProcessor.gs().font = cMapAwareDocumentFont;
                pdfContentStreamProcessor.gs().fontSize = f;
            }
        }
    }

    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().characterSpacing = pdfNumber.floatValue();
        }
    }

    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().wordSpacing = pdfNumber.floatValue();
        }
    }

    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().horizontalScaling = pdfNumber.floatValue();
        }
    }

    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().leading = pdfNumber.floatValue();
        }
    }

    private static class SetTextFont
    implements ContentOperator {
        private SetTextFont() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            CMapAwareDocumentFont cMapAwareDocumentFont;
            PdfName pdfName = (PdfName)arrayList.get(0);
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            PdfDictionary pdfDictionary = pdfContentStreamProcessor.resources.getAsDict(PdfName.FONT);
            pdfContentStreamProcessor.gs().font = cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfDictionary.get(pdfName));
            pdfContentStreamProcessor.gs().fontSize = f;
        }
    }

    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().renderMode = pdfNumber.intValue();
        }
    }

    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamProcessor.gs().rise = pdfNumber.floatValue();
        }
    }

    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.textMatrix = new Matrix();
            pdfContentStreamProcessor.textLineMatrix = pdfContentStreamProcessor.textMatrix;
        }
    }

    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.textMatrix = null;
            pdfContentStreamProcessor.textLineMatrix = null;
        }
    }

    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            Matrix matrix = new Matrix(f, f2);
            pdfContentStreamProcessor.textMatrix = matrix.multiply(pdfContentStreamProcessor.textLineMatrix);
            pdfContentStreamProcessor.textLineMatrix = pdfContentStreamProcessor.textMatrix;
        }
    }

    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private TextMoveStartNextLineWithLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(1);
            arrayList2.add(0, new PdfNumber(-f));
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("TL"), arrayList2);
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("Td"), arrayList);
        }
    }

    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            pdfContentStreamProcessor.textLineMatrix = new Matrix(f, f2, f3, f4, f5, f6);
            pdfContentStreamProcessor.textMatrix = pdfContentStreamProcessor.textLineMatrix;
        }
    }

    private static class TextMoveNextLine
    implements ContentOperator {
        private TextMoveNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(2);
            arrayList2.add(0, new PdfNumber(0));
            arrayList2.add(1, new PdfNumber(pdfContentStreamProcessor.gs().leading));
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("Td"), arrayList2);
        }
    }

    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfString pdfString = (PdfString)arrayList.get(0);
            pdfContentStreamProcessor.displayPdfString(pdfString, 0.0f);
        }
    }

    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private MoveNextLineAndShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("T*"), new ArrayList(0));
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("Tj"), arrayList);
        }
    }

    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private MoveNextLineAndShowTextWithSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            PdfNumber pdfNumber2 = (PdfNumber)arrayList.get(1);
            PdfString pdfString = (PdfString)arrayList.get(2);
            ArrayList<PdfNumber> arrayList2 = new ArrayList<PdfNumber>(1);
            arrayList2.add(0, pdfNumber);
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("Tw"), arrayList2);
            ArrayList<PdfNumber> arrayList3 = new ArrayList<PdfNumber>(1);
            arrayList3.add(0, pdfNumber2);
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("Tc"), arrayList3);
            ArrayList<PdfString> arrayList4 = new ArrayList<PdfString>(1);
            arrayList4.add(0, pdfString);
            pdfContentStreamProcessor.invokeOperator(new PdfLiteral("'"), arrayList4);
        }
    }

    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral pdfLiteral, ArrayList arrayList) {
            PdfArray pdfArray = (PdfArray)arrayList.get(0);
            float f = 0.0f;
            ListIterator listIterator = pdfArray.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (e instanceof PdfString) {
                    pdfContentStreamProcessor.displayPdfString((PdfString)e, f);
                    f = 0.0f;
                    continue;
                }
                f = ((PdfNumber)e).floatValue();
            }
        }
    }
}

