/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalFileEntity
extends AbstractHttpEntity
implements Cloneable {
    private final File file;

    public InternalFileEntity(File file, ContentType contentType) {
        this.file = (File)Args.notNull((Object)file, (String)"File");
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull((Object)outStream, (String)"Output stream");
        try (FileInputStream inStream = new FileInputStream(this.file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)inStream).read(tmp)) != -1) {
                outStream.write(tmp, 0, l);
            }
            outStream.flush();
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

