/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class PropertiesUtils {
    private static final Map<Class<?>, PropertyConverter<?>> CONVERTERS_REGISTRY = new HashMap();

    private static void register(PropertyConverter<?> converter, Class<?> ... targetTypes) {
        for (Class<?> targetType : targetTypes) {
            CONVERTERS_REGISTRY.put(targetType, converter);
        }
    }

    public static <T> T to(Object propValue, Class<T> targetType, T defaultValue) {
        Object v = propValue;
        if (v == null) {
            return defaultValue;
        }
        if (!targetType.isArray()) {
            v = PropertiesUtils.toObject(v);
        }
        if (targetType.isInstance(v)) {
            return targetType.cast(v);
        }
        if (CONVERTERS_REGISTRY.containsKey(targetType)) {
            PropertyConverter<?> converter = CONVERTERS_REGISTRY.get(targetType);
            try {
                return (T)converter.to(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static Object toObject(Object propValue) {
        if (propValue.getClass().isArray()) {
            Object[] prop = (Object[])propValue;
            return prop.length > 0 ? prop[0] : null;
        }
        if (propValue instanceof Collection) {
            Collection prop = (Collection)propValue;
            return prop.isEmpty() ? null : prop.iterator().next();
        }
        return propValue;
    }

    private PropertiesUtils() {
    }

    static {
        PropertiesUtils.register(new BooleanPropertyConverter(), Boolean.TYPE, Boolean.class);
        PropertiesUtils.register(new StringPropertyConverter(), String.class);
        PropertiesUtils.register(new StringArrayPropertyConverter(), String[].class);
        PropertiesUtils.register(new IntegerPropertyConverter(), Integer.TYPE, Integer.class);
        PropertiesUtils.register(new LongPropertyConverter(), Long.TYPE, Long.class);
        PropertiesUtils.register(new DoublePropertyConverter(), Double.TYPE, Double.class);
    }

    private static interface PropertyConverter<T> {
        public T to(Object var1);
    }

    private static class BooleanPropertyConverter
    implements PropertyConverter<Boolean> {
        private BooleanPropertyConverter() {
        }

        @Override
        public Boolean to(Object propValue) {
            return Boolean.valueOf(String.valueOf(propValue));
        }
    }

    private static class StringPropertyConverter
    implements PropertyConverter<String> {
        private StringPropertyConverter() {
        }

        @Override
        public String to(Object propValue) {
            return String.valueOf(propValue);
        }
    }

    private static class StringArrayPropertyConverter
    implements PropertyConverter<String[]> {
        private StringArrayPropertyConverter() {
        }

        @Override
        public String[] to(Object propValue) {
            if (propValue instanceof String) {
                return new String[]{(String)propValue};
            }
            if (propValue.getClass().isArray()) {
                Object[] valueArray = (Object[])propValue;
                ArrayList<String> values = new ArrayList<String>(valueArray.length);
                for (Object value : valueArray) {
                    if (value == null) continue;
                    values.add(value.toString());
                }
                return values.toArray(new String[values.size()]);
            }
            if (propValue instanceof Collection) {
                Collection valueCollection = (Collection)propValue;
                ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
                for (Object value : valueCollection) {
                    if (value == null) continue;
                    valueList.add(value.toString());
                }
                return valueList.toArray(new String[valueList.size()]);
            }
            throw new IllegalArgumentException();
        }
    }

    private static class IntegerPropertyConverter
    implements PropertyConverter<Integer> {
        private IntegerPropertyConverter() {
        }

        @Override
        public Integer to(Object propValue) {
            return Integer.valueOf(String.valueOf(propValue));
        }
    }

    private static class LongPropertyConverter
    implements PropertyConverter<Long> {
        private LongPropertyConverter() {
        }

        @Override
        public Long to(Object propValue) {
            return Long.valueOf(String.valueOf(propValue));
        }
    }

    private static class DoublePropertyConverter
    implements PropertyConverter<Double> {
        private DoublePropertyConverter() {
        }

        @Override
        public Double to(Object propValue) {
            return Double.valueOf(String.valueOf(propValue));
        }
    }
}

